/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XDecimal;
import com.ibm.xml.xlxp.internal.s1.datatype.XLong;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.Pattern;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSIntegerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UnsignedIntDV
extends TypeValidator {
    private final int totalDigits;
    private final long[] enumeration;
    private final long maxInclusive;
    private final long maxExclusive;
    private final long minInclusive;
    private final long minExclusive;

    public UnsignedIntDV(String string2, String string3, String string4, String[] stringArray, long[] lArray, long l, long l2, long l3, long l4, int n2, int n3) {
        super(string2, string3, string4, 39, 4, stringArray, UnsignedIntDV.computeDefinedFacets(n3, l, l2, l3, l4), false);
        this.totalDigits = n2;
        this.enumeration = lArray;
        this.maxInclusive = l3;
        this.maxExclusive = l4;
        this.minInclusive = l;
        this.minExclusive = l2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XLong xLong = new XLong(UnsignedIntDV.parse(xMLString));
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xLong;
            validatedInfo.errorCode = 0;
        }
        return xLong;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        long l = XSIntegerUtil.parseUInt(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            Object object2 = validatedInfo.actualValue;
            validatedInfo2.errorCode = object2 instanceof XLong ? (l == ((XLong)object2).value ? 0 : 1) : (object2 instanceof XDecimal ? (((XDecimal)object2).equals(l) ? 0 : 1) : 1);
            validatedInfo2.actualValue = object2;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xMLString, l);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXLong(l);
    }

    private int checkFacets(XMLString xMLString, long l) {
        if ((this.definedFacets & 0x200) != 0 && XSIntegerUtil.getTotalDigits(xMLString) > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && l < this.minInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && l <= this.minExclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && l > this.maxInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && l >= this.maxExclusive) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (this.enumeration[i] != l) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private static int computeDefinedFacets(int n2, long l, long l2, long l3, long l4) {
        if ((n2 & 0x100) != 0 && l <= 0L) {
            n2 &= 0xFFFFFEFF;
        }
        if ((n2 & 0x20) != 0 && l3 >= 0xFFFFFFFFL) {
            n2 &= 0xFFFFFFDF;
        }
        if ((n2 & 0x80) != 0 && l2 < 0L) {
            n2 &= 0xFFFFFEFF;
        }
        if ((n2 & 0x40) != 0 && l4 > 0xFFFFFFFFL) {
            n2 &= 0xFFFFFFBF;
        }
        return n2;
    }

    protected Pattern createPattern(String[] stringArray, int n2) {
        int n3;
        if ((n2 & 8) == 0 || stringArray.length == 1 && "[\\-+]?[0-9]+".equals(stringArray[0])) {
            return null;
        }
        int n4 = n3 = stringArray != null ? stringArray.length : 0;
        if (n3 == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[\\-+]?[0-9]+")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static long parse(XMLString xMLString) {
        return XSIntegerUtil.parseUInt(xMLString, dummyOneElementArray);
    }
}

