/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSNormalizer;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class StringDV
extends TypeValidator {
    private final int length;
    private final int minLength;
    private final int maxLength;
    private final XMLString[] enumeration;
    private final byte whiteSpace;

    public StringDV(String string2, String string3, String string4, String[] stringArray, XMLString[] xMLStringArray, int n2, int n3, int n4, byte by2, int n5, int n6, boolean bl) {
        super(string2, string3, string4, n6, 2, stringArray, n5, bl);
        this.length = n2;
        this.minLength = n3;
        this.maxLength = n4;
        this.enumeration = xMLStringArray;
        this.whiteSpace = by2;
        if (n6 == 21 || n6 == 22) {
            this.fMultiBuffered = true;
        }
    }

    public final Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XMLString xMLString2 = StringDV.parse(xMLString, this.whiteSpace);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xMLString2;
            validatedInfo.errorCode = 0;
        }
        return xMLString2;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        if (this.whiteSpace != 0) {
            xMLString = this.whiteSpace == 1 ? validationContext.getXSNormalizer().replace(xMLString, validationContext) : validationContext.getXSNormalizer().collapse(xMLString, validationContext);
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = validatedInfo.actualValue.equals(xMLString) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xMLString;
    }

    protected final XMLString normalize(XMLString xMLString, XSNormalizer xSNormalizer) {
        if (this.whiteSpace != 0) {
            if (this.whiteSpace == 1) {
                return xSNormalizer.replace(xMLString, null);
            }
            return xSNormalizer.collapse(xMLString, null);
        }
        return xMLString;
    }

    protected final void checkAdditionalConstraints(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = validatedInfo.actualValue.equals(xMLString) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xMLString;
    }

    public int preCheckFacets(XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xMLString);
        }
        return 0;
    }

    private final int checkFacets(XMLString xMLString) {
        int n2 = -1;
        if ((this.definedFacets & 1) != 0 && (n2 = XMLStringUtil.getUnicodeCharLength(xMLString)) != this.length) {
            return 1;
        }
        if ((this.definedFacets & 2) != 0) {
            if (n2 == -1) {
                n2 = XMLStringUtil.getUnicodeCharLength(xMLString);
            }
            if (n2 < this.minLength) {
                return 1;
            }
        }
        if ((this.definedFacets & 4) != 0) {
            if (n2 == -1) {
                n2 = XMLStringUtil.getUnicodeCharLength(xMLString);
            }
            if (n2 > this.maxLength) {
                return 1;
            }
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equalsXMLString(xMLString)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    public static XMLString parse(XMLString xMLString, int n2) {
        XMLString xMLString2 = new XMLString(xMLString);
        XMLString xMLString3 = null;
        if (n2 == 0) {
            xMLString3 = xMLString2;
        } else {
            XSNormalizer xSNormalizer = new XSNormalizer();
            xMLString3 = n2 == 1 ? xSNormalizer.replace(xMLString2, null) : xSNormalizer.collapse(xMLString2, null);
        }
        return xMLString3;
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        if (this.builtInKind != 21 && this.builtInKind != 22) {
            return null;
        }
        int n2 = this.whiteSpace == 1 ? vMContext.dvContext.getXSNormalizer().replace(parsedEntity, vMContext.dvContext, validatedInfo, this.fNormalized, 60) : vMContext.dvContext.getXSNormalizer().collapse(parsedEntity, vMContext.dvContext, validatedInfo, this.fNormalized, 60);
        if (n2 == -1) {
            return null;
        }
        parsedEntity.offset = n2;
        return validatedInfo.actualValue;
    }

    protected int preCheckFacets(Object object2, XMLString xMLString) {
        return this.preCheckFacets((XMLString)object2);
    }
}

