/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XQName;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class QNameDV
extends TypeValidator {
    private final XQName[] enumeration;

    public QNameDV(String string2, String string3) {
        this(string2, string3, null, null, null, 0, 19);
    }

    public QNameDV(String string2, String string3, String string4, String[] stringArray, XQName[] xQNameArray, int n2, int n3) {
        super(string2, string3, string4, n3, n3, stringArray, n2, false);
        this.enumeration = xQNameArray;
        this.fMultiBuffered = true;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        throw new RuntimeException("Should never be called.");
    }

    public Object getActualValue(String string2, String[] stringArray, String string3, ValidatedInfo validatedInfo) {
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
        }
        return QNameDV.parse(string2, stringArray, string3, validatedInfo);
    }

    public static XQName parse(String string2, String[] stringArray, String string3, ValidatedInfo validatedInfo) {
        XQName xQName = new XQName();
        int n2 = string2.indexOf(58);
        if (n2 > 0) {
            String string4 = string2.substring(0, n2).intern();
            xQName.localName = string2.substring(n2 + 1).intern();
            for (int i = 0; i < stringArray.length; i += 2) {
                if (string4 != stringArray[i]) continue;
                xQName.nsURI = stringArray[i + 1];
                break;
            }
        } else {
            xQName.localName = string2.intern();
            xQName.nsURI = string3;
        }
        if (validatedInfo != null) {
            validatedInfo.actualValue = xQName;
        }
        return xQName;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        XQName xQName = this.parse(xMLString, validationContext, nArray);
        validatedInfo2.actualValue = xQName;
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = xQName.equals(validatedInfo.actualValue) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xQName, xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
    }

    private XQName parse(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return null;
        }
        nArray[0] = 0;
        if (xMLString.bytes != null) {
            return this.parseQNameUnbuffered(xMLString, validationContext, nArray);
        }
        return this.parseQNameBuffered(xMLString, validationContext, nArray);
    }

    private XQName parseQNameBuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = 0;
        int[] nArray2 = ArrayAllocator.newIntArray(2);
        byte[] byArray = ArrayAllocator.newByteArray(4);
        XMLString xMLString2 = validationContext.getXMLString();
        xMLString2.setValues(xMLString);
        XQName xQName = validationContext.getXQName();
        xQName.nsURI = "";
        String string2 = "";
        while (true) {
            if (n2 < n3) break;
            if (dataBuffer == dataBuffer2) {
                nArray[0] = 1;
                return null;
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset - 1;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        by2 = dataBuffer.bytes[n2];
        if (!XMLCharacterProperties.nameStartChar10(by2)) {
            nArray[0] = 1;
            return null;
        }
        ++n2;
        while (true) {
            if (n2 < n3) {
                by2 = dataBuffer.bytes[n2];
                if (by2 >= 0) {
                    if (by2 == 58) {
                        if (string2 != "" || n2 + 1 == n3 && dataBuffer == dataBuffer2 || xMLString.startOffset == n2 && dataBuffer == xMLString.firstBuffer) {
                            nArray[0] = 1;
                            return null;
                        }
                        xMLString2.setEndPos(dataBuffer, n2);
                        string2 = validationContext.getSymbol(xMLString2);
                        xMLString2.setStartPos(dataBuffer, n2 + 1);
                        xMLString2.length = n3 - (n2 + 1);
                    } else if (!XMLCharacterProperties.nameChar10(by2)) {
                        nArray[0] = 1;
                        return null;
                    }
                    ++n2;
                    continue;
                }
                byArray[0] = by2;
                int n4 = 1;
                while (true) {
                    if (n4 < 4 && n2 + n4 < n3) {
                        byArray[n4++] = dataBuffer.bytes[n2 + n4 - 1];
                        continue;
                    }
                    if (dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - n4;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                UTF8Support.decodeCharacter(byArray, 0, n4, nArray2);
                if (!XMLCharacterProperties.nameChar10(nArray2[0])) {
                    nArray[0] = 1;
                    return null;
                }
                n2 += nArray2[1];
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        xQName.nsURI = validationContext.prefixMapping(string2);
        if (xQName.nsURI == null && string2 != "") {
            nArray[0] = 1;
            return null;
        }
        xMLString2.setEndPos(dataBuffer, n2);
        xQName.localName = validationContext.getSymbol(xMLString2);
        xMLString2.unregister();
        nArray[0] = 0;
        return xQName;
    }

    private XQName parseQNameUnbuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        String string2;
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        byte by2 = 0;
        int[] nArray2 = ArrayAllocator.newIntArray(2);
        byte[] byArray = ArrayAllocator.newByteArray(4);
        XMLString xMLString2 = validationContext.getXMLString();
        xMLString2.setValues(xMLString);
        XQName xQName = validationContext.getXQName();
        xQName.nsURI = "";
        String string3 = "";
        if (n2 < n3) {
            by2 = xMLString.bytes[n2];
            if (!XMLCharacterProperties.nameStartChar10(by2)) {
                nArray[0] = 1;
                return null;
            }
            ++n2;
            while (n2 < n3) {
                by2 = xMLString.bytes[n2];
                if (by2 >= 0) {
                    if (by2 == 58) {
                        if (string3 != "" || n2 + 1 == n3 || xMLString.startOffset == n2) {
                            nArray[0] = 1;
                            return null;
                        }
                        xMLString2.endOffset = n2;
                        xMLString2.length = xMLString2.endOffset - xMLString.startOffset;
                        string3 = validationContext.getSymbol(xMLString2);
                        xMLString2.startOffset = n2 + 1;
                        xMLString2.length = n3 - (n2 + 1);
                        xMLString2.endOffset = n3;
                        xMLString2.hashcode = 0;
                    } else if (!XMLCharacterProperties.nameChar10(by2)) {
                        nArray[0] = 1;
                        return null;
                    }
                    ++n2;
                    continue;
                }
                byArray[0] = by2;
                int n4 = 1;
                while (n4 < 4 && n2 + n4 < n3) {
                    byArray[n4++] = xMLString.bytes[n2 + n4 - 1];
                }
                UTF8Support.decodeCharacter(byArray, 0, n4, nArray2);
                if (!XMLCharacterProperties.nameChar10(nArray2[0])) {
                    nArray[0] = 1;
                    return null;
                }
                n2 += nArray2[1];
            }
        }
        if ((string2 = validationContext.prefixMapping(string3)) != null) {
            xQName.nsURI = string2;
        } else if (string3 != "") {
            nArray[0] = 1;
            return null;
        }
        xQName.localName = validationContext.getSymbol(xMLString2);
        xMLString2.unregister();
        nArray[0] = 0;
        return xQName;
    }

    private static int parseQNameUnbuffered(ParsedEntity parsedEntity, XQName xQName, ValidationContext validationContext, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes == null ? parsedEntity.buffer.bytes : parsedEntity.bytes;
        int n2 = parsedEntity.offset;
        int n3 = parsedEntity.endOffset;
        byte by2 = 0;
        int[] nArray = ArrayAllocator.newIntArray(2);
        byte[] byArray2 = ArrayAllocator.newByteArray(4);
        XMLString xMLString = validationContext.getXMLString();
        xQName.nsURI = "";
        String string2 = "";
        if ((n2 = QNameDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3 || !XMLCharacterProperties.nameStartChar10(byArray[n2])) {
            return -1;
        }
        xMLString.setValues(parsedEntity.buffer, n2, n3);
        xMLString.flags = (short)(xMLString.flags | 1);
        ++n2;
        while (n2 < n3) {
            by2 = byArray[n2];
            if (by2 >= 0) {
                if (by2 == 58) {
                    if (string2 != "" || n2 + 1 >= n3) {
                        return -1;
                    }
                    xMLString.length = n2 - xMLString.startOffset;
                    xMLString.endOffset = n2;
                    string2 = validationContext.getSymbol(xMLString);
                    xMLString.startOffset = n2 + 1;
                } else if (!XMLCharacterProperties.nameChar10(by2)) break;
                ++n2;
                continue;
            }
            byArray2[0] = by2;
            int n4 = 1;
            while (n4 < 4 && n2 + n4 < n3) {
                byArray2[n4++] = byArray[n2 + n4 - 1];
            }
            UTF8Support.decodeCharacter(byArray2, 0, n4, nArray);
            if (!XMLCharacterProperties.nameChar10(nArray[0])) {
                return -1;
            }
            n2 += nArray[1];
        }
        xQName.nsURI = validationContext.prefixMapping(string2);
        xMLString.length = n2 - xMLString.startOffset;
        xMLString.endOffset = n2;
        if ((n2 = QNameDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3 || xQName.nsURI == null && string2 != "") {
            return -1;
        }
        xQName.localName = validationContext.getSymbol(xMLString);
        return n2;
    }

    public int preCheckFacets(XQName xQName, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xQName, xMLString);
        }
        return 0;
    }

    private int checkFacets(XQName xQName, XMLString xMLString) {
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (this.enumeration[i].nsURI != xQName.nsURI || this.enumeration[i].localName != xQName.localName) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        return null;
    }

    protected int preCheckFacets(Object object2, XMLString xMLString) {
        return this.preCheckFacets((XQName)object2, xMLString);
    }
}

