/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeUtil;
import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XList;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.QNameDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.UnionDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.util.ArrayList;
import java.util.StringTokenizer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ListDV
extends TypeValidator {
    private final int length;
    private final int minLength;
    private final int maxLength;
    private XList[] enumeration;
    private int[][] enumerationType;
    private final TypeValidator itemTypeValidator;

    public ListDV(String string2, String string3, String string4, String[] stringArray, int n2, int n3, int n4, int n5, int n6, TypeValidator typeValidator) {
        super(string2, string3, string4, n6, 45, stringArray, n5, false);
        this.itemTypeValidator = typeValidator;
        this.length = n2;
        this.minLength = n3;
        this.maxLength = n4;
    }

    public void setEnumeration(ValidatedInfo[] validatedInfoArray) {
        this.createEnumeration(validatedInfoArray);
    }

    private void createEnumeration(ValidatedInfo[] validatedInfoArray) {
        if (validatedInfoArray != null) {
            this.enumeration = ArrayAllocator.newObjectArray(XList.class, validatedInfoArray.length);
            this.enumerationType = ArrayAllocator.newIntArray2(validatedInfoArray.length);
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (validatedInfoArray[i] == null) continue;
                this.enumeration[i] = (XList)validatedInfoArray[i].actualValue;
                this.enumerationType[i] = validatedInfoArray[i].itemBuiltinKinds;
            }
        }
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        throw new RuntimeException("Should never be called.");
    }

    public Object getActualValue(String string2, int[] nArray, String[] stringArray, String string3, ValidatedInfo validatedInfo, TypeUtil typeUtil) {
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
        }
        return ListDV.getActualValue(this.itemTypeValidator, string2, nArray, stringArray, string3, validatedInfo, typeUtil);
    }

    public static Object getActualValue(TypeValidator typeValidator, String string2, int[] nArray, String[] stringArray, String string3, ValidatedInfo validatedInfo, TypeUtil typeUtil) {
        if (validatedInfo != null) {
            validatedInfo.itemBuiltinKinds = nArray;
        }
        int n2 = typeValidator.builtInKind;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n3 = stringTokenizer.countTokens();
        Object[] objectArray = ArrayAllocator.newObjectArray(n3);
        XMLString xMLString = new XMLString();
        for (int i = 0; i < n3; ++i) {
            String string4 = stringTokenizer.nextToken();
            if (n2 == 19 || n2 == 20) {
                objectArray[i] = ((QNameDV)typeValidator).getActualValue(string4, stringArray, string3, null);
                continue;
            }
            if (n2 == 45) {
                objectArray[i] = ((UnionDV)typeValidator).getActualValue(string4, nArray[i], null, stringArray, string3, null, typeUtil);
                continue;
            }
            typeUtil.addString(string4, xMLString);
            objectArray[i] = typeValidator.getActualValue(xMLString, null);
        }
        xMLString.unregister();
        validatedInfo.actualValue = new XList(objectArray);
        validatedInfo.errorCode = validatedInfo.actualValue != null ? 0 : 1;
        return validatedInfo.actualValue;
    }

    public static ValidatedInfo parse(TypeValidator typeValidator, String string2, int[] nArray, String[] stringArray, String string3, TypeUtil typeUtil) {
        ValidatedInfo validatedInfo = new ValidatedInfo();
        ListDV.getActualValue(typeValidator, string2, nArray, stringArray, string3, validatedInfo, typeUtil);
        return validatedInfo;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        XList xList = this.parseWithContext(xMLString, validationContext, validatedInfo2, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = xList.isEqual((XList)validatedInfo.actualValue, validatedInfo.itemBuiltinKinds, validatedInfo2.itemBuiltinKinds) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xList, xMLString, validatedInfo2.itemBuiltinKinds);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xList;
    }

    private XList parseWithContext(XMLString xMLString, ValidationContext validationContext, ValidatedInfo validatedInfo, int[] nArray) {
        if (xMLString.length == 0) {
            return XList.EMPTY_LIST;
        }
        if (xMLString.bytes != null) {
            return this.parseListUnbufferedWithContext(xMLString, validationContext, validatedInfo, nArray);
        }
        return this.parseListBufferedWithContext(xMLString, validationContext, validatedInfo, nArray);
    }

    private XList parseListBufferedWithContext(XMLString xMLString, ValidationContext validationContext, ValidatedInfo validatedInfo, int[] nArray) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = dataBuffer.bytes[n2];
        if (by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                    by2 = dataBuffer.bytes[n2];
                    continue;
                }
                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2];
            }
        }
        if (n2 == n3) {
            nArray[0] = 1;
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<TypeValidator> arrayList3 = new ArrayList<TypeValidator>();
        XMLString xMLString2 = validationContext.getXMLString();
        xMLString2.setValues(xMLString);
        ValidatedInfo validatedInfo2 = new ValidatedInfo();
        block1: while (true) {
            if (n2 < n3) {
                by2 = dataBuffer.bytes[n2];
                if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                    while (true) {
                        if (n2 + 1 < n3) break;
                        if (dataBuffer == dataBuffer2) break block1;
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset - 1;
                        n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by2 = dataBuffer.bytes[n2 + 1];
                    if (by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13) {
                        xMLString2.setStartPos(dataBuffer, n2 + 1);
                    }
                } else {
                    XMLString xMLString3;
                    while (true) {
                        if (n2 + 1 < n3) break;
                        if (dataBuffer == dataBuffer2) {
                            xMLString2.setEndPos(dataBuffer, n2 + 1);
                            validatedInfo2.errorCode = 0;
                            this.itemTypeValidator.validate(xMLString2, null, validationContext, validatedInfo2);
                            if (validatedInfo2.errorCode == 1) {
                                nArray[0] = 1;
                                xMLString2.unregister();
                                return null;
                            }
                            if (xMLString2 == validatedInfo2.actualValue) {
                                xMLString3 = validationContext.getXMLString();
                                xMLString3.setValues(xMLString2);
                                validatedInfo2.actualValue = xMLString3;
                            }
                            arrayList.add(validatedInfo2.actualValue);
                            arrayList2.add(validatedInfo2.typeValidator.builtInKind);
                            arrayList3.add(validatedInfo2.typeValidator);
                            break block1;
                        }
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset - 1;
                        n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by2 = dataBuffer.bytes[n2 + 1];
                    if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        xMLString2.setEndPos(dataBuffer, n2 + 1);
                        validatedInfo2.errorCode = 0;
                        this.itemTypeValidator.validate(xMLString2, null, validationContext, validatedInfo2);
                        if (validatedInfo2.errorCode == 1) {
                            nArray[0] = 1;
                            xMLString2.unregister();
                            return null;
                        }
                        if (xMLString2 == validatedInfo2.actualValue) {
                            xMLString3 = validationContext.getXMLString();
                            xMLString3.setValues(xMLString2);
                            validatedInfo2.actualValue = xMLString3;
                        }
                        arrayList.add(validatedInfo2.actualValue);
                        arrayList2.add(validatedInfo2.typeValidator.builtInKind);
                        arrayList3.add(validatedInfo2.typeValidator);
                    }
                }
                ++n2;
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset - 1;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        xMLString2.unregister();
        validatedInfo.itemBuiltinKinds = ArrayAllocator.newIntArray(arrayList2.size());
        validatedInfo.itemBuiltinTypeValidators = ArrayAllocator.newObjectArray(TypeValidator.class, arrayList3.size());
        for (int i = 0; i < arrayList2.size(); ++i) {
            validatedInfo.itemBuiltinKinds[i] = (Integer)arrayList2.get(i);
            validatedInfo.itemBuiltinTypeValidators[i] = (TypeValidator)arrayList3.get(i);
        }
        return new XList(arrayList.toArray());
    }

    private XList parseListUnbufferedWithContext(XMLString xMLString, ValidationContext validationContext, ValidatedInfo validatedInfo, int[] nArray) {
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        ValidatedInfo validatedInfo2 = new ValidatedInfo();
        if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) == n3) {
            nArray[0] = 1;
            return null;
        }
        byte by2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<TypeValidator> arrayList3 = new ArrayList<TypeValidator>();
        XMLString xMLString2 = validationContext.getXMLString();
        xMLString2.setValues(xMLString);
        xMLString2.startOffset = n2;
        while (n2 < n3) {
            XMLString xMLString3;
            by2 = xMLString.bytes[n2];
            if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n2 + 1 < n3 && (by2 = xMLString.bytes[n2 + 1]) != 32 && by2 != 10 && by2 != 9 && by2 != 13) {
                    xMLString2.startOffset = n2 + 1;
                }
            } else if (n2 + 1 < n3) {
                by2 = xMLString.bytes[n2 + 1];
                if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                    xMLString2.endOffset = n2 + 1;
                    xMLString2.length = xMLString2.endOffset - xMLString2.startOffset;
                    xMLString2.hashcode = 0;
                    validatedInfo2.errorCode = 0;
                    this.itemTypeValidator.validate(xMLString2, null, validationContext, validatedInfo2);
                    if (validatedInfo2.errorCode == 1) {
                        nArray[0] = 1;
                        xMLString2.unregister();
                        return null;
                    }
                    if (xMLString2 == validatedInfo2.actualValue) {
                        xMLString3 = validationContext.getXMLString();
                        xMLString3.setValues(xMLString2);
                        validatedInfo2.actualValue = xMLString3;
                    }
                    arrayList.add(validatedInfo2.actualValue);
                    arrayList2.add(validatedInfo2.typeValidator.builtInKind);
                    arrayList3.add(validatedInfo2.typeValidator);
                }
            } else {
                xMLString2.endOffset = n2 + 1;
                xMLString2.length = xMLString2.endOffset - xMLString2.startOffset;
                xMLString2.hashcode = 0;
                validatedInfo2.errorCode = 0;
                this.itemTypeValidator.validate(xMLString2, null, validationContext, validatedInfo2);
                if (validatedInfo2.errorCode == 1) {
                    nArray[0] = 1;
                    xMLString2.unregister();
                    return null;
                }
                if (xMLString2 == validatedInfo2.actualValue) {
                    xMLString3 = validationContext.getXMLString();
                    xMLString3.setValues(xMLString2);
                    validatedInfo2.actualValue = xMLString3;
                }
                arrayList.add(validatedInfo2.actualValue);
                arrayList2.add(validatedInfo2.typeValidator.builtInKind);
                arrayList3.add(validatedInfo2.typeValidator);
                break;
            }
            ++n2;
        }
        xMLString2.unregister();
        validatedInfo.itemBuiltinKinds = ArrayAllocator.newIntArray(arrayList2.size());
        validatedInfo.itemBuiltinTypeValidators = ArrayAllocator.newObjectArray(TypeValidator.class, arrayList3.size());
        for (int i = 0; i < arrayList2.size(); ++i) {
            validatedInfo.itemBuiltinKinds[i] = (Integer)arrayList2.get(i);
            validatedInfo.itemBuiltinTypeValidators[i] = (TypeValidator)arrayList3.get(i);
        }
        return new XList(arrayList.toArray());
    }

    private int checkFacets(XList xList, XMLString xMLString, int[] nArray) {
        if ((this.definedFacets & 2) != 0 && xList.length < this.minLength) {
            return 1;
        }
        if ((this.definedFacets & 4) != 0 && xList.length > this.maxLength) {
            return 1;
        }
        if ((this.definedFacets & 1) != 0 && xList.length != this.length) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].isEqual(xList, nArray, this.enumerationType[i])) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public int checkIdrefAndEntity(Object object2, ValidationContext validationContext) {
        if (object2 instanceof XList) {
            XList xList = (XList)object2;
            for (int i = 0; i < xList.length; ++i) {
                if (this.itemTypeValidator.checkIdrefAndEntity(xList.value[i], validationContext) == 0) continue;
                return 1;
            }
        }
        return 0;
    }

    public TypeValidator getItemTypeValidator() {
        return this.itemTypeValidator;
    }
}

