/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.Pattern;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSAnyURIUtil;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLStringBuffer;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class LanguageDV
extends TypeValidator {
    private final int length;
    private final int minLength;
    private final int maxLength;
    private final XMLString[] enumeration;

    public LanguageDV(String string2, String string3, String string4, String[] stringArray, XMLString[] xMLStringArray, int n2, int n3, int n4, int n5) {
        super(string2, string3, string4, 23, 2, stringArray, n5, false);
        this.length = n2;
        this.minLength = n3;
        this.maxLength = n4;
        this.enumeration = xMLStringArray;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XMLString xMLString2 = LanguageDV.parse(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xMLString2;
            validatedInfo.errorCode = validatedInfo.actualValue != null ? 0 : 1;
        }
        return xMLString2;
    }

    public int preCheckFacets(XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xMLString);
        }
        return 0;
    }

    private int checkFacets(XMLString xMLString) {
        int n2 = -1;
        if ((this.definedFacets & 2) != 0 && (n2 = XMLStringUtil.getUnicodeCharLength(xMLString)) < this.minLength) {
            return 1;
        }
        if ((this.definedFacets & 4) != 0) {
            if (n2 == -1) {
                n2 = XMLStringUtil.getUnicodeCharLength(xMLString);
            }
            if (n2 > this.maxLength) {
                return 1;
            }
        }
        if ((this.definedFacets & 1) != 0) {
            if (n2 == -1) {
                n2 = XMLStringUtil.getUnicodeCharLength(xMLString);
            }
            if (n2 != this.length) {
                return 1;
            }
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equalsXMLString(xMLString)) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        XMLString xMLString2 = LanguageDV.parse(xMLString, validationContext, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = xMLString2.equals(validatedInfo.actualValue) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xMLString2);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xMLString2;
    }

    private static XMLString parse(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return null;
        }
        if (xMLString.bytes != null) {
            return LanguageDV.parseLanguageUnbuffered(xMLString, validationContext, nArray);
        }
        return LanguageDV.parseLanguageBuffered(xMLString, validationContext, nArray);
    }

    private static XMLString parseLanguageBuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = dataBuffer.bytes[n2];
        if (by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                    by2 = dataBuffer.bytes[n2];
                    continue;
                }
                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2];
            }
        }
        if (n2 == n3) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            NullDataBufferFactory.setEmptyStringValues(xMLString2);
            return xMLString2;
        }
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        int n4 = xMLStringBuffer.getOffset();
        int n5 = 0;
        while (true) {
            if (n2 < n3) {
                by2 = dataBuffer.bytes[n2];
                xMLStringBuffer.appendChar(by2);
                if (!XSAnyURIUtil.isAlpha(by2)) break;
                if (n5 == 8) {
                    nArray[0] = 1;
                    return null;
                }
                ++n5;
                ++n2;
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        if (n5 == 0) {
            nArray[0] = 1;
            return null;
        }
        if (n2 < n3) {
            if (by2 != 45) {
                nArray[0] = 1;
                return null;
            }
            block2: do {
                n5 = 0;
                while (true) {
                    if (++n2 < n3) {
                        by2 = dataBuffer.bytes[n2];
                        xMLStringBuffer.appendChar(by2);
                        if (!XSAnyURIUtil.isAlpha(by2) && (by2 < 48 || by2 > 57)) break;
                        if (n5 == 8) {
                            nArray[0] = 1;
                            return null;
                        }
                        ++n5;
                        continue;
                    }
                    if (dataBuffer == dataBuffer2) break block2;
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                if (n5 != 0) continue;
                nArray[0] = 1;
                return null;
            } while (by2 == 45);
        }
        if (n2 < n3 && by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                    by2 = dataBuffer.bytes[n2];
                    continue;
                }
                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2];
            }
        }
        if (n2 < n3) {
            nArray[0] = 1;
            return null;
        }
        XMLString xMLString3 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        xMLStringBuffer.setStringValues(n4, xMLStringBuffer.getOffset(), xMLString3);
        return xMLString3;
    }

    private static XMLString parseLanguageUnbuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) == n3) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            NullDataBufferFactory.setEmptyStringValues(xMLString2);
            return xMLString2;
        }
        byte by2 = 0;
        int n4 = 0;
        int n5 = n2;
        while (n2 < n3 && XSAnyURIUtil.isAlpha(by2 = xMLString.bytes[n2])) {
            if (n4 == 8) {
                nArray[0] = 1;
                return null;
            }
            ++n4;
            ++n2;
        }
        if (n4 == 0) {
            nArray[0] = 1;
            return null;
        }
        if (n2 < n3) {
            if (by2 != 45) {
                nArray[0] = 1;
                return null;
            }
            do {
                n4 = 0;
                while (++n2 < n3 && (XSAnyURIUtil.isAlpha(by2 = xMLString.bytes[n2]) || by2 >= 48 && by2 <= 57)) {
                    if (n4 == 8) {
                        nArray[0] = 1;
                        return null;
                    }
                    ++n4;
                }
                if (n4 != 0) continue;
                nArray[0] = 1;
                return null;
            } while (n2 < n3 && by2 == 45);
        }
        int n6 = n2;
        if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
            nArray[0] = 1;
            return null;
        }
        XMLString xMLString3 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        xMLString3.setValues(xMLString);
        xMLString3.startOffset = n5;
        xMLString3.endOffset = n6;
        return xMLString3;
    }

    private int parseLanguageUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n2 = parsedEntity.offset;
        int n3 = parsedEntity.endOffset;
        if ((n2 = LanguageDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
            return -1;
        }
        byte by2 = 0;
        int n4 = 0;
        int n5 = n2;
        while (n2 < n3 && XSAnyURIUtil.isAlpha(by2 = byArray[n2])) {
            ++n2;
            ++n4;
        }
        if (n2 >= n3 || n4 == 0 || n4 >= 8) {
            return -1;
        }
        while (by2 == 45) {
            n4 = 0;
            while (++n2 < n3 && (XSAnyURIUtil.isAlpha(by2 = byArray[n2]) || by2 >= 48 && by2 <= 57)) {
                ++n4;
            }
            if (n2 < n3 && n4 != 0 && n4 < 8) continue;
            return -1;
        }
        int n6 = n2;
        if ((n2 = LanguageDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
            return -1;
        }
        xMLString.setValues(parsedEntity.buffer, n5, n6);
        xMLString.flags = 1;
        return n2;
    }

    protected Pattern createPattern(String[] stringArray, int n2) {
        if ((n2 & 8) == 0 || stringArray.length == 1 && "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*".equals(stringArray[0])) {
            return null;
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static XMLString parse(XMLString xMLString) {
        return LanguageDV.parse(xMLString, null, dummyOneElementArray);
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XMLString xMLString = vMContext.dvContext.getXMLString();
        int n2 = this.parseLanguageUnbuffered(parsedEntity, xMLString, this.fNormalized);
        if (n2 == -1) {
            return null;
        }
        parsedEntity.offset = n2;
        return xMLString;
    }

    protected int preCheckFacets(Object object2, XMLString xMLString) {
        return this.preCheckFacets((XMLString)object2);
    }
}

