/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XDecimal;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.Pattern;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class IntegerDV
extends TypeValidator {
    private final int totalDigits;
    private final XDecimal[] enumeration;
    private final XDecimal maxInclusive;
    private final XDecimal maxExclusive;
    private final XDecimal minInclusive;
    private final XDecimal minExclusive;

    public IntegerDV(String string2, String string3, String string4, String[] stringArray, XDecimal[] xDecimalArray, XDecimal xDecimal, XDecimal xDecimal2, XDecimal xDecimal3, XDecimal xDecimal4, int n2, int n3, int n4) {
        super(string2, string3, string4, n4, 4, stringArray, n3, false);
        this.totalDigits = n2;
        this.enumeration = xDecimalArray;
        this.maxInclusive = xDecimal3;
        this.maxExclusive = xDecimal4;
        this.minInclusive = xDecimal;
        this.minExclusive = xDecimal2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XDecimal xDecimal = IntegerDV.parse(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xDecimal;
            validatedInfo.errorCode = 0;
        }
        return xDecimal;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        XDecimal xDecimal = null;
        if (xMLString.length != 0) {
            XDecimal xDecimal2 = xDecimal = xMLString.bytes != null ? IntegerDV.parseIntegerUnbuffered(xMLString, validationContext.getXDecimal()) : IntegerDV.parseIntegerBuffered(xMLString, validationContext.getXDecimal());
        }
        if (xDecimal == null) {
            validatedInfo2.errorCode = 1;
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = validatedInfo.actualValue.equals(xDecimal) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        validatedInfo2.errorCode = this.preCheckFacets(xDecimal, xMLString);
        if (validatedInfo2.errorCode != 0) {
            return;
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xDecimal;
    }

    public int preCheckFacets(XDecimal xDecimal, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xDecimal, xMLString);
        }
        return 0;
    }

    private final int checkFacets(XDecimal xDecimal, XMLString xMLString) {
        if ((this.definedFacets & 0x200) != 0 && xDecimal.totalDigits > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && xDecimal.compareTo(this.minInclusive) == -1) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && xDecimal.compareTo(this.minExclusive) != 1) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && xDecimal.compareTo(this.maxInclusive) == 1) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && xDecimal.compareTo(this.maxExclusive) != -1) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equals(xDecimal)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private int parseIntegerUnbuffered(ParsedEntity parsedEntity, XDecimal xDecimal, boolean[] blArray) {
        int n2;
        int n3;
        byte[] byArray = parsedEntity.bytes;
        int n4 = parsedEntity.offset;
        int n5 = parsedEntity.endOffset;
        int n6 = 1;
        int n7 = IntegerDV.removeWhitespace(byArray, n4, n5, blArray);
        if (n7 >= n5) {
            return 0;
        }
        if (byArray[n7] == 43) {
            ++n7;
        } else if (byArray[n7] == 45) {
            ++n7;
            n6 = -1;
        }
        for (n3 = n7; n3 < n5 && byArray[n3] == 48; ++n3) {
        }
        for (n2 = n3; n2 < n5 && byArray[n2] >= 48 && byArray[n2] <= 57; ++n2) {
        }
        n4 = IntegerDV.removeWhitespace(byArray, n2, n5, blArray);
        if (n4 >= n5) {
            return 0;
        }
        if (n3 == n2) {
            if (n7 == n3) {
                return 0;
            }
            return -n4;
        }
        xDecimal.setValues(parsedEntity.buffer, n3, parsedEntity.buffer, n2, n2 - n3, 0, n6);
        return n4;
    }

    private static XDecimal parseIntegerUnbuffered(XMLString xMLString, XDecimal xDecimal) {
        int n2;
        byte[] byArray = xMLString.bytes;
        int n3 = xMLString.startOffset;
        int n4 = xMLString.endOffset;
        int n5 = 1;
        if (byArray[n3 = XMLStringUtil.removeWhitespace(byArray, n3, n4)] == 43) {
            ++n3;
        } else if (byArray[n3] == 45) {
            ++n3;
            n5 = -1;
        }
        int n6 = n3;
        while (n3 < n4 && byArray[n3] == 48) {
            ++n3;
        }
        for (n2 = n3; n2 < n4 && byArray[n2] >= 48 && byArray[n2] <= 57; ++n2) {
        }
        int n7 = XMLStringUtil.removeWhitespace(byArray, n2, n4);
        if (n7 < n4) {
            return null;
        }
        if (n3 == n4) {
            if (n6 == n3) {
                return null;
            }
            return XDecimal.ZERO;
        }
        xDecimal.setValues(xMLString.firstBuffer, n3, xMLString.firstBuffer, n2, n2 - n3, 0, n5);
        return xDecimal;
    }

    private static XDecimal parseIntegerBuffered(XMLString xMLString, XDecimal xDecimal) {
        int n2;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n3 = 1;
        int n4 = xMLString.startOffset;
        int n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte[] byArray = dataBuffer.bytes;
        byte by2 = byArray[n4];
        if (by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n4 < n5) {
                    by2 = byArray[n4];
                    continue;
                }
                if (n4 != n5 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n4 = dataBuffer.startOffset;
                n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = byArray[n4];
            }
        }
        if (n4 == n5) {
            return null;
        }
        if (by2 == 43) {
            ++n4;
        } else if (by2 == 45) {
            ++n4;
            n3 = -1;
        }
        if (n4 == n5 && dataBuffer == dataBuffer2) {
            return null;
        }
        while (true) {
            n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            n2 = n4;
            while (n4 < n5 && byArray[n4] == 48) {
                ++n4;
            }
            if (n4 != n5) break;
            if (dataBuffer == dataBuffer2) {
                return XDecimal.ZERO;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n4 = dataBuffer.startOffset;
        }
        n2 = n4;
        DataBuffer dataBuffer3 = dataBuffer;
        int n6 = 0;
        while (true) {
            if (n4 < n5) {
                if (byArray[n4] < 48 || byArray[n4] > 57) break;
                ++n6;
                ++n4;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                xDecimal.setValues(dataBuffer3, n2, dataBuffer2, n5, n6, 0, n3);
                return xDecimal;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n4 = dataBuffer.startOffset;
            n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        DataBuffer dataBuffer4 = dataBuffer;
        int n7 = n4;
        by2 = byArray[n4];
        if (by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n4 < n5) {
                    by2 = byArray[n4];
                    continue;
                }
                if (n4 != n5 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n4 = dataBuffer.startOffset;
                n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = byArray[n4];
            }
        }
        if (n4 != n5) {
            return null;
        }
        xDecimal.setValues(dataBuffer3, n2, dataBuffer4, n7, n6, 0, n3);
        return xDecimal;
    }

    protected Pattern createPattern(String[] stringArray, int n2) {
        int n3;
        if ((n2 & 8) == 0 || stringArray.length == 1 && "[\\-+]?[0-9]+".equals(stringArray[0])) {
            return null;
        }
        int n4 = n3 = stringArray != null ? stringArray.length : 0;
        if (n3 == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[\\-+]?[0-9]+")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static XDecimal parse(XMLString xMLString) {
        XDecimal xDecimal = null;
        if (xMLString.length != 0) {
            xDecimal = xMLString.bytes != null ? IntegerDV.parseIntegerUnbuffered(xMLString, new XDecimal()) : IntegerDV.parseIntegerBuffered(xMLString, new XDecimal());
        }
        return xDecimal;
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XDecimal xDecimal = vMContext.dvContext.getXDecimal();
        int n2 = this.parseIntegerUnbuffered(parsedEntity, xDecimal, this.fNormalized);
        if (n2 == 0) {
            return null;
        }
        if (n2 < 0) {
            xDecimal = XDecimal.ZERO;
            parsedEntity.offset = -n2;
        } else {
            parsedEntity.offset = n2;
        }
        return xDecimal;
    }

    protected int preCheckFacets(Object object2, XMLString xMLString) {
        return this.preCheckFacets((XDecimal)object2, xMLString);
    }
}

