/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XFloat;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.io.UnsupportedEncodingException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class FloatDV
extends TypeValidator {
    private final float[] enumeration;
    private final float maxInclusive;
    private final float maxExclusive;
    private final float minInclusive;
    private final float minExclusive;

    public FloatDV(String string2, String string3, String string4, String[] stringArray, float[] fArray, float f2, float f3, float f4, float f5, int n2) {
        super(string2, string3, string4, 5, 5, stringArray, n2, false);
        this.enumeration = fArray;
        this.maxInclusive = f4;
        this.maxExclusive = f5;
        this.minInclusive = f2;
        this.minExclusive = f3;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        float f2 = FloatDV.parse(xMLString);
        XFloat xFloat = new XFloat(f2);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xFloat;
            validatedInfo.errorCode = 0;
        }
        return xFloat;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        float f2 = FloatDV.parse(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = ((XFloat)validatedInfo.actualValue).equals(f2) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(f2, xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXFloat(f2);
    }

    public int preCheckFacets(float f2, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(f2, xMLString);
        }
        return 0;
    }

    private int checkFacets(float f2, XMLString xMLString) {
        if ((this.definedFacets & 0x100) != 0 && !(f2 >= this.minInclusive) && !(f2 != f2 & this.minInclusive != this.minInclusive)) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && !(f2 > this.minExclusive)) {
            return 1;
        }
        if (!((this.definedFacets & 0x20) == 0 || f2 <= this.maxInclusive || f2 != f2 && this.maxInclusive != this.maxInclusive)) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && !(f2 < this.maxExclusive)) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!XFloat.equals(this.enumeration[i], f2)) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public static float parse(XMLString xMLString) {
        return FloatDV.parse(xMLString, dummyOneElementArray);
    }

    public static float parse(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0.0f;
        }
        if (xMLString.bytes != null) {
            return FloatDV.parseFloatUnbuffered(xMLString, nArray);
        }
        return FloatDV.parseFloatBuffered(xMLString, nArray);
    }

    private static float parseFloatBuffered(XMLString xMLString, int[] nArray) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = dataBuffer.bytes[n2];
        if (by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                    by2 = dataBuffer.bytes[n2];
                    continue;
                }
                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2];
            }
        }
        if (by2 == 78) {
            while (true) {
                if (++n2 < n3) break;
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0.0f;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset - 1;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            by2 = dataBuffer.bytes[n2];
            if (by2 == 97) {
                while (true) {
                    if (++n2 < n3) break;
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0f;
                    }
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                by2 = dataBuffer.bytes[n2];
                if (by2 == 78) {
                    while (true) {
                        if (++n2 < n3) {
                            by2 = dataBuffer.bytes[n2];
                            break;
                        }
                        if (dataBuffer == dataBuffer2) break;
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset - 1;
                        n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    if (by2 <= 32) {
                        while (true) {
                            if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                                by2 = dataBuffer.bytes[n2];
                                continue;
                            }
                            if (n2 != n3 || dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by2 = dataBuffer.bytes[n2];
                        }
                    }
                    if (n2 < n3) {
                        nArray[0] = 1;
                        return 0.0f;
                    }
                    return Float.NaN;
                }
            }
            nArray[0] = 1;
            return 0.0f;
        }
        boolean bl = false;
        if (by2 == 43 || by2 == 45 || by2 == 73) {
            boolean bl2 = bl = by2 == 45;
            if (bl || by2 == 43) {
                while (true) {
                    if (++n2 < n3) {
                        by2 = dataBuffer.bytes[n2];
                        break;
                    }
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0f;
                    }
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
            }
            if (by2 == 73) {
                while (true) {
                    if (++n2 < n3) break;
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0f;
                    }
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                by2 = dataBuffer.bytes[n2];
                if (by2 == 78) {
                    while (true) {
                        if (++n2 < n3) break;
                        if (dataBuffer == dataBuffer2) {
                            nArray[0] = 1;
                            return 0.0f;
                        }
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset - 1;
                        n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by2 = dataBuffer.bytes[n2];
                    if (by2 == 70) {
                        while (true) {
                            if (++n2 < n3) {
                                by2 = dataBuffer.bytes[n2];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset - 1;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        if (by2 <= 32) {
                            while (true) {
                                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                                    by2 = dataBuffer.bytes[n2];
                                    continue;
                                }
                                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                                dataBuffer = dataBuffer.next;
                                n2 = dataBuffer.startOffset;
                                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                                by2 = dataBuffer.bytes[n2];
                            }
                        }
                        if (n2 < n3) {
                            nArray[0] = 1;
                            return 0.0f;
                        }
                        return bl ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
                    }
                }
                nArray[0] = 1;
                return 0.0f;
            }
        }
        StringBuilder stringBuilder = new StringBuilder((n3 - n2) * 2);
        if (by2 >= 48 && by2 <= 57 || by2 == 46) {
            stringBuilder.append((char)by2);
            while (true) {
                if (++n2 < n3) {
                    by2 = dataBuffer.bytes[n2];
                    if ((by2 >= 48 && by2 <= 57 || by2 == 46 || by2 == 69 || by2 == 101 || by2 == 43 || by2 == 45) && by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13) {
                        stringBuilder.append((char)by2);
                        continue;
                    }
                    if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) break;
                    nArray[0] = 1;
                    return 0.0f;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset - 1;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (by2 <= 32) {
                while (true) {
                    if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                        by2 = dataBuffer.bytes[n2];
                        continue;
                    }
                    if (n2 != n3 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by2 = dataBuffer.bytes[n2];
                }
            }
            if (n2 < n3) {
                nArray[0] = 1;
                return 0.0f;
            }
            try {
                float f2 = Float.parseFloat(stringBuilder.toString());
                return bl ? -f2 : f2;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[0] = 1;
                return 0.0f;
            }
        }
        nArray[0] = 1;
        return 0.0f;
    }

    private static float parseFloatUnbuffered(XMLString xMLString, int[] nArray) {
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        int n4 = n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3);
        byte by2 = xMLString.bytes[n4];
        if (by2 == 78 && n2 + 2 <= n3 && xMLString.bytes[++n2] == 97 && xMLString.bytes[++n2] == 78) {
            if (++n2 < n3 && (n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                nArray[0] = 1;
                return 0.0f;
            }
            return Float.NaN;
        }
        if (by2 == 73 && n2 + 2 <= n3 && xMLString.bytes[++n2] == 78 && xMLString.bytes[++n2] == 70) {
            if (++n2 < n3 && (n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                nArray[0] = 1;
                return 0.0f;
            }
            return Float.POSITIVE_INFINITY;
        }
        if ((by2 == 45 || by2 == 43) && xMLString.bytes[n2 + 1] == 73 && ++n2 + 2 <= n3 && xMLString.bytes[++n2] == 78 && xMLString.bytes[++n2] == 70) {
            if (++n2 < n3 && (n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                nArray[0] = 1;
                return 0.0f;
            }
            return by2 == 45 ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        while (n2 < n3) {
            by2 = xMLString.bytes[n2];
            if ((by2 < 48 || by2 > 57) && by2 != 46 && by2 != 69 && by2 != 101 && by2 != 43 && by2 != 45 && by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13) {
                nArray[0] = 1;
                return 0.0f;
            }
            if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) break;
            ++n2;
        }
        int n5 = n2;
        if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
            nArray[0] = 1;
            return 0.0f;
        }
        try {
            float f2 = Float.parseFloat(new String(xMLString.bytes, n4, n5 - n4, "UTF-8"));
            return f2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Broken VM: UTF-8 not supported.");
        }
        catch (NumberFormatException numberFormatException) {
            nArray[0] = 1;
            return 0.0f;
        }
    }

    private int parseFloatUnbuffered(ParsedEntity parsedEntity, XFloat xFloat, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes == null ? parsedEntity.buffer.bytes : parsedEntity.bytes;
        int n2 = parsedEntity.offset;
        int n3 = parsedEntity.endOffset;
        if ((n2 = FloatDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
            return -1;
        }
        byte by2 = byArray[n2];
        if (by2 == 78 && n2 + 2 < n3 && byArray[++n2] == 97 && byArray[++n2] == 78) {
            ++n2;
            if ((n2 = FloatDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
                return -1;
            }
            xFloat.value = Float.NaN;
            return n2;
        }
        if (by2 == 73 && n2 + 2 < n3 && byArray[++n2] == 78 && byArray[++n2] == 70) {
            ++n2;
            if ((n2 = FloatDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
                return -1;
            }
            xFloat.value = Float.POSITIVE_INFINITY;
            return n2;
        }
        if (by2 == 45 && n2 + 3 < n3 && byArray[n2 + 1] == 73 && byArray[n2 += 2] == 78 && byArray[++n2] == 70) {
            ++n2;
            if ((n2 = FloatDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
                return -1;
            }
            xFloat.value = Float.NEGATIVE_INFINITY;
            return n2;
        }
        int n4 = n2;
        while ((by2 >= 48 && by2 <= 57 || by2 == 46 || by2 == 69 || by2 == 101 || by2 == 43 || by2 == 45) && ++n2 < n3) {
            by2 = byArray[n2];
        }
        int n5 = n2;
        if ((n2 = FloatDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
            return -1;
        }
        try {
            xFloat.value = Float.parseFloat(new String(byArray, n4, n5 - n4, "UTF-8"));
            return n2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Broken VM: UTF-8 not supported.");
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XFloat xFloat = vMContext.dvContext.getXFloat(0.0f);
        int n2 = this.parseFloatUnbuffered(parsedEntity, xFloat, this.fNormalized);
        if (n2 == -1) {
            return null;
        }
        parsedEntity.offset = n2;
        return xFloat;
    }

    protected int preCheckFacets(Object object2, XMLString xMLString) {
        return this.preCheckFacets(((XFloat)object2).value, xMLString);
    }
}

