/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XDouble;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.io.UnsupportedEncodingException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class DoubleDV
extends TypeValidator {
    private final double[] enumeration;
    private final double maxInclusive;
    private final double maxExclusive;
    private final double minInclusive;
    private final double minExclusive;

    public DoubleDV(String string2, String string3, String string4, String[] stringArray, double[] dArray, double d, double d2, double d3, double d4, int n2) {
        super(string2, string3, string4, 6, 6, stringArray, n2, false);
        this.enumeration = dArray;
        this.maxInclusive = d3;
        this.maxExclusive = d4;
        this.minInclusive = d;
        this.minExclusive = d2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        double d = DoubleDV.parse(xMLString);
        XDouble xDouble = new XDouble(d);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xDouble;
            validatedInfo.errorCode = 0;
        }
        return xDouble;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        double d = DoubleDV.parse(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = ((XDouble)validatedInfo.actualValue).equals(d) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(d, xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXDouble(d);
    }

    public int preCheckFacets(double d, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(d, xMLString);
        }
        return 0;
    }

    private int checkFacets(double d, XMLString xMLString) {
        if ((this.definedFacets & 0x100) != 0 && !(d >= this.minInclusive) && !(d != d & this.minInclusive != this.minInclusive)) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && !(d > this.minExclusive)) {
            return 1;
        }
        if (!((this.definedFacets & 0x20) == 0 || d <= this.maxInclusive || d != d && this.maxInclusive != this.maxInclusive)) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && !(d < this.maxExclusive)) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!XDouble.equals(this.enumeration[i], d)) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public static double parse(XMLString xMLString) {
        return DoubleDV.parse(xMLString, dummyOneElementArray);
    }

    public static double parse(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0.0;
        }
        if (xMLString.bytes != null) {
            return DoubleDV.parseDoubleUnbuffered(xMLString, nArray);
        }
        return DoubleDV.parseDoubleBuffered(xMLString, nArray);
    }

    private static double parseDoubleBuffered(XMLString xMLString, int[] nArray) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = dataBuffer.bytes[n2];
        if (by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                    by2 = dataBuffer.bytes[n2];
                    continue;
                }
                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2];
            }
        }
        if (by2 == 78) {
            while (true) {
                if (++n2 < n3) break;
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0.0;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset - 1;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            by2 = dataBuffer.bytes[n2];
            if (by2 == 97) {
                while (true) {
                    if (++n2 < n3) break;
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                by2 = dataBuffer.bytes[n2];
                if (by2 == 78) {
                    while (true) {
                        if (++n2 < n3) {
                            by2 = dataBuffer.bytes[n2];
                            break;
                        }
                        if (dataBuffer == dataBuffer2) break;
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset - 1;
                        n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    if (by2 <= 32) {
                        while (true) {
                            if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                                by2 = dataBuffer.bytes[n2];
                                continue;
                            }
                            if (n2 != n3 || dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by2 = dataBuffer.bytes[n2];
                        }
                    }
                    if (n2 < n3) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    return Double.NaN;
                }
            }
            nArray[0] = 1;
            return 0.0;
        }
        boolean bl = false;
        if (by2 == 43 || by2 == 45 || by2 == 73) {
            boolean bl2 = bl = by2 == 45;
            if (bl || by2 == 43) {
                while (true) {
                    if (++n2 < n3) {
                        by2 = dataBuffer.bytes[n2];
                        break;
                    }
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
            }
            if (by2 == 73) {
                while (true) {
                    if (++n2 < n3) break;
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                by2 = dataBuffer.bytes[n2];
                if (by2 == 78) {
                    while (true) {
                        if (++n2 < n3) break;
                        if (dataBuffer == dataBuffer2) {
                            nArray[0] = 1;
                            return 0.0;
                        }
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset - 1;
                        n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by2 = dataBuffer.bytes[n2];
                    if (by2 == 70) {
                        while (true) {
                            if (++n2 < n3) {
                                by2 = dataBuffer.bytes[n2];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset - 1;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        if (by2 <= 32) {
                            while (true) {
                                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                                    by2 = dataBuffer.bytes[n2];
                                    continue;
                                }
                                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                                dataBuffer = dataBuffer.next;
                                n2 = dataBuffer.startOffset;
                                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                                by2 = dataBuffer.bytes[n2];
                            }
                        }
                        if (n2 < n3) {
                            nArray[0] = 1;
                            return 0.0;
                        }
                        return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                }
                nArray[0] = 1;
                return 0.0;
            }
        }
        StringBuilder stringBuilder = new StringBuilder((n3 - n2) * 2);
        if (by2 >= 48 && by2 <= 57 || by2 == 46) {
            stringBuilder.append((char)by2);
            while (true) {
                if (++n2 < n3) {
                    by2 = dataBuffer.bytes[n2];
                    if ((by2 >= 48 && by2 <= 57 || by2 == 46 || by2 == 69 || by2 == 101 || by2 == 43 || by2 == 45) && by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13) {
                        stringBuilder.append((char)by2);
                        continue;
                    }
                    if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) break;
                    nArray[0] = 1;
                    return 0.0;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset - 1;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (by2 <= 32) {
                while (true) {
                    if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                        by2 = dataBuffer.bytes[n2];
                        continue;
                    }
                    if (n2 != n3 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by2 = dataBuffer.bytes[n2];
                }
            }
            if (n2 < n3) {
                nArray[0] = 1;
                return 0.0;
            }
            try {
                double d = Double.parseDouble(stringBuilder.toString());
                return bl ? -d : d;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[0] = 1;
                return 0.0;
            }
        }
        nArray[0] = 1;
        return 0.0;
    }

    private static double parseDoubleUnbuffered(XMLString xMLString, int[] nArray) {
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        int n4 = n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3);
        byte by2 = xMLString.bytes[n4];
        if (by2 == 78 && n2 + 2 <= n3 && xMLString.bytes[++n2] == 97 && xMLString.bytes[++n2] == 78) {
            if (++n2 < n3 && (n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                nArray[0] = 1;
                return 0.0;
            }
            return Double.NaN;
        }
        if (by2 == 73 && n2 + 2 <= n3 && xMLString.bytes[++n2] == 78 && xMLString.bytes[++n2] == 70) {
            if (++n2 < n3 && (n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                nArray[0] = 1;
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if ((by2 == 45 || by2 == 43) && xMLString.bytes[n2 + 1] == 73 && ++n2 + 2 <= n3 && xMLString.bytes[++n2] == 78 && xMLString.bytes[++n2] == 70) {
            if (++n2 < n3) {
                by2 = xMLString.bytes[n2];
                if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                    nArray[0] = 1;
                    return 0.0;
                }
            }
            return by2 == 45 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        while (n2 < n3) {
            if (((by2 = xMLString.bytes[n2++]) < 48 || by2 > 57) && by2 != 46 && by2 != 69 && by2 != 101 && by2 != 43 && by2 != 45 && by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13) {
                nArray[0] = 1;
                return 0.0;
            }
            if (by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13) continue;
        }
        int n5 = n2;
        if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
            nArray[0] = 1;
            return 0.0;
        }
        try {
            double d = Double.parseDouble(new String(xMLString.bytes, n4, n5 - n4, "UTF-8"));
            return d;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Broken VM: UTF-8 not supported.");
        }
        catch (NumberFormatException numberFormatException) {
            nArray[0] = 1;
            return 0.0;
        }
    }

    private int parseDoubleUnbuffered(ParsedEntity parsedEntity, XDouble xDouble, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n2 = parsedEntity.offset;
        int n3 = parsedEntity.endOffset;
        if ((n2 = DoubleDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
            return -1;
        }
        byte by2 = byArray[n2];
        if (by2 == 78 && n2 + 2 < n3 && byArray[++n2] == 97 && byArray[++n2] == 78) {
            ++n2;
            if ((n2 = DoubleDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
                return -1;
            }
            xDouble.value = Double.NaN;
            return n2;
        }
        if (by2 == 73 && n2 + 2 < n3 && byArray[++n2] == 78 && byArray[++n2] == 70) {
            ++n2;
            if ((n2 = DoubleDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
                return -1;
            }
            xDouble.value = Double.POSITIVE_INFINITY;
            return n2;
        }
        if (by2 == 45 && n2 + 3 < n3 && byArray[n2 + 1] == 73 && byArray[n2 += 2] == 78 && byArray[++n2] == 70) {
            ++n2;
            if ((n2 = DoubleDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
                return -1;
            }
            xDouble.value = Double.NEGATIVE_INFINITY;
            return n2;
        }
        int n4 = n2;
        while ((by2 >= 48 && by2 <= 57 || by2 == 46 || by2 == 69 || by2 == 101 || by2 == 43 || by2 == 45) && ++n2 < n3) {
            by2 = byArray[n2];
        }
        int n5 = n2;
        if ((n2 = DoubleDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
            return -1;
        }
        try {
            xDouble.value = Double.parseDouble(new String(byArray, n4, n5 - n4, "UTF-8"));
            return n2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Broken VM: UTF-8 not supported.");
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XDouble xDouble = vMContext.dvContext.getXDouble(0.0);
        int n2 = this.parseDoubleUnbuffered(parsedEntity, xDouble, this.fNormalized);
        if (n2 == -1) {
            return null;
        }
        parsedEntity.offset = n2;
        return xDouble;
    }

    protected int preCheckFacets(Object object2, XMLString xMLString) {
        return this.preCheckFacets(((XDouble)object2).value, xMLString);
    }
}

