/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XDecimal;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class DecimalDV
extends TypeValidator {
    private final int totalDigits;
    private final int fractionDigits;
    private final XDecimal[] enumeration;
    private final XDecimal maxInclusive;
    private final XDecimal maxExclusive;
    private final XDecimal minInclusive;
    private final XDecimal minExclusive;

    public DecimalDV(String string2, String string3, String string4, String[] stringArray, XDecimal[] xDecimalArray, XDecimal xDecimal, XDecimal xDecimal2, XDecimal xDecimal3, XDecimal xDecimal4, int n2, int n3, int n4) {
        super(string2, string3, string4, 4, 4, stringArray, n4, false);
        this.totalDigits = n2;
        this.fractionDigits = n3;
        this.enumeration = xDecimalArray;
        this.maxInclusive = xDecimal3;
        this.maxExclusive = xDecimal4;
        this.minInclusive = xDecimal;
        this.minExclusive = xDecimal2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XDecimal xDecimal = DecimalDV.parse(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xDecimal;
            validatedInfo.errorCode = 0;
        }
        return xDecimal;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        XDecimal xDecimal = null;
        if (xMLString.length != 0) {
            XDecimal xDecimal2 = xDecimal = xMLString.bytes != null ? DecimalDV.parseDecimalUnbuffered(xMLString, validationContext.getXDecimal()) : DecimalDV.parseDecimalBuffered(xMLString, validationContext.getXDecimal());
        }
        if (xDecimal == null) {
            validatedInfo2.errorCode = 1;
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = validatedInfo.actualValue.equals(xDecimal) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        validatedInfo2.errorCode = this.preCheckFacets(xDecimal, xMLString);
        if (validatedInfo2.errorCode != 0) {
            return;
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xDecimal;
    }

    public int preCheckFacets(XDecimal xDecimal, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xDecimal, xMLString);
        }
        return 0;
    }

    private final int checkFacets(XDecimal xDecimal, XMLString xMLString) {
        if ((this.definedFacets & 0x200) != 0 && xDecimal.totalDigits > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x400) != 0 && xDecimal.fracDigits > this.fractionDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && xDecimal.compareTo(this.minInclusive) == -1) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && xDecimal.compareTo(this.minExclusive) != 1) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && xDecimal.compareTo(this.maxInclusive) == 1) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && xDecimal.compareTo(this.maxExclusive) != -1) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equals(xDecimal)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private int parseDecimalUnbuffered(ParsedEntity parsedEntity, XDecimal xDecimal, boolean[] blArray) {
        int n2;
        int n3;
        int n4;
        byte[] byArray = parsedEntity.bytes;
        int n5 = parsedEntity.offset;
        int n6 = parsedEntity.endOffset;
        int n7 = 1;
        int n8 = DecimalDV.removeWhitespace(byArray, n5, n6, blArray);
        if (n8 >= n6) {
            return 0;
        }
        if (byArray[n8] == 43) {
            ++n8;
        } else if (byArray[n8] == 45) {
            ++n8;
            n7 = -1;
        }
        for (n4 = n8; n4 < n6 && byArray[n4] == 48; ++n4) {
        }
        for (n3 = n4; n3 < n6 && byArray[n3] >= 48 && byArray[n3] <= 57; ++n3) {
        }
        int n9 = n2 = n3;
        int n10 = n2;
        if (n3 < n6 && byArray[n3] == 46) {
            n10 = n3 + 1;
            int n11 = 0;
            for (n2 = n10; n2 < n6 && byArray[n2] >= 48 && byArray[n2] <= 57; ++n2) {
                if (byArray[n2] == 48) {
                    ++n11;
                    continue;
                }
                if (byArray[n2] < 49 || byArray[n2] > 57) continue;
                n11 = 0;
            }
            n9 = n2 - n11;
        }
        if ((n5 = DecimalDV.removeWhitespace(byArray, n2, n6, blArray)) >= n6) {
            return 0;
        }
        if (n4 == n3 && n10 == n9) {
            if (n8 == n4 && n9 == n2) {
                return 0;
            }
            return -n5;
        }
        if (n9 == n3 + 1) {
            n9 = n10 = n3;
        }
        xDecimal.setValues(parsedEntity.buffer, n4, parsedEntity.buffer, n9, n3 - n4, n9 - n10, n7);
        return n5;
    }

    private static XDecimal parseDecimalUnbuffered(XMLString xMLString, XDecimal xDecimal) {
        int n2;
        int n3;
        byte[] byArray = xMLString.bytes;
        int n4 = xMLString.startOffset;
        int n5 = xMLString.endOffset;
        int n6 = 1;
        int n7 = n5;
        if (byArray[n4 = XMLStringUtil.removeWhitespace(xMLString.bytes, n4, n5)] == 43) {
            ++n4;
        } else if (byArray[n4] == 45) {
            n6 = -1;
            ++n4;
        }
        int n8 = n4;
        while (n4 < n5 && byArray[n4] == 48) {
            ++n4;
        }
        for (n3 = n4; n3 < n5 && byArray[n3] >= 48 && byArray[n3] <= 57; ++n3) {
        }
        int n9 = n3;
        int n10 = n3;
        if (n3 < n5 && byArray[n3] == 46) {
            n9 = n3 + 1;
            n2 = 0;
            for (n10 = n9; n10 < n5 && byArray[n10] >= 48 && byArray[n10] <= 57; ++n10) {
                if (byArray[n10] == 48) {
                    ++n2;
                    continue;
                }
                if (byArray[n10] < 49 || byArray[n10] > 57) continue;
                n2 = 0;
            }
            n7 = n2 > 0 ? n10 - n2 : n10;
        }
        if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n10, n5)) < n5) {
            return null;
        }
        if (n3 == n4 && n9 == n7) {
            if (n8 == n4) {
                return null;
            }
            return XDecimal.ZERO;
        }
        if (n7 == n3 + 1) {
            n7 = n9 = n3;
        }
        xDecimal.setValues(xMLString.firstBuffer, n4, xMLString.firstBuffer, n7, n3 - n4, n7 - n9, n6);
        return xDecimal;
    }

    private static XDecimal parseDecimalBuffered(XMLString xMLString, XDecimal xDecimal) {
        int n2;
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = xMLString.length;
        int n8 = xMLString.startOffset;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        DataBuffer dataBuffer3 = null;
        DataBuffer dataBuffer4 = null;
        byte[] byArray = dataBuffer.bytes;
        int n9 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        int n10 = 0;
        int n11 = 0;
        byte by2 = byArray[n8];
        if (by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n8 < n9) {
                    by2 = byArray[n8];
                    continue;
                }
                if (n8 != n9 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n8 = dataBuffer.startOffset;
                n9 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = byArray[n8];
            }
        }
        if (n8 == n9) {
            return null;
        }
        if (by2 == 43) {
            ++n8;
            --n7;
        } else if (by2 == 45) {
            ++n8;
            n4 = -1;
            --n7;
        }
        int n12 = n7;
        while (true) {
            n9 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            n2 = n8;
            while (n8 < n9 && byArray[n8] == 48) {
                ++n8;
            }
            n12 -= n8 - n2;
            if (n8 != n9) break;
            if (dataBuffer == dataBuffer2) {
                return XDecimal.ZERO;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n8 = dataBuffer.startOffset;
        }
        DataBuffer dataBuffer5 = dataBuffer;
        n2 = n8;
        while (true) {
            if (n8 < n9) {
                by2 = byArray[n8];
                if (by2 >= 48 && by2 <= 57) {
                    if (dataBuffer3 != null) {
                        if (by2 == 48) {
                            if (dataBuffer4 == null) {
                                dataBuffer4 = dataBuffer;
                                n11 = n8;
                                n6 = n3 - 1;
                            }
                        } else {
                            dataBuffer4 = null;
                        }
                    }
                } else {
                    if (by2 != 46 || dataBuffer3 != null) break;
                    dataBuffer3 = dataBuffer;
                    n10 = n8;
                    n5 = n3;
                }
                ++n8;
                ++n3;
                continue;
            }
            if (n3 == n12) {
                if (dataBuffer3 == null) {
                    n5 = n6 = n12;
                    break;
                }
                if (dataBuffer4 != null) break;
                n6 = n12 - 1;
                break;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n8 = dataBuffer.startOffset;
            n9 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        if (n8 < n9) {
            by2 = byArray[n8];
            if (by2 <= 32) {
                while (true) {
                    if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n8 < n9) {
                        by2 = byArray[n8];
                        continue;
                    }
                    if (n8 != n9 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n8 = dataBuffer.startOffset;
                    n9 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by2 = byArray[n8];
                }
            }
            if (n8 < n9) {
                return null;
            }
        }
        if (n6 == 0) {
            if (n12 == n7 && dataBuffer4 == null) {
                return null;
            }
            return XDecimal.ZERO;
        }
        if (dataBuffer4 != null) {
            dataBuffer2 = dataBuffer4;
            n9 = n11;
        }
        if (n6 == n5 && dataBuffer3 != null) {
            dataBuffer2 = dataBuffer3;
            n9 = n10;
        }
        if (dataBuffer2.startOffset == n9) {
            dataBuffer = dataBuffer5;
            while (dataBuffer.next != dataBuffer2) {
                dataBuffer = dataBuffer.next;
            }
            dataBuffer2 = dataBuffer;
            n9 = dataBuffer.endOffset;
        }
        xDecimal.setValues(dataBuffer5, n2, dataBuffer2, n9, n5, n6 - n5, n4);
        return xDecimal;
    }

    public static XDecimal parse(XMLString xMLString) {
        XDecimal xDecimal = null;
        if (xMLString.length != 0) {
            xDecimal = xMLString.bytes != null ? DecimalDV.parseDecimalUnbuffered(xMLString, new XDecimal()) : DecimalDV.parseDecimalBuffered(xMLString, new XDecimal());
        }
        return xDecimal;
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XDecimal xDecimal = vMContext.dvContext.getXDecimal();
        int n2 = this.parseDecimalUnbuffered(parsedEntity, xDecimal, this.fNormalized);
        if (n2 == 0) {
            return null;
        }
        if (n2 < 0) {
            xDecimal = XDecimal.ZERO;
            parsedEntity.offset = -n2;
        } else {
            parsedEntity.offset = n2;
        }
        return xDecimal;
    }

    protected int preCheckFacets(Object object2, XMLString xMLString) {
        return this.preCheckFacets((XDecimal)object2, xMLString);
    }
}

