/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XBinary;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSBase64BinaryUtil;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class Base64BinaryDV
extends TypeValidator {
    private final int length;
    private final int minLength;
    private final int maxLength;
    private final XBinary[] enumeration;

    public Base64BinaryDV(String string2, String string3, String string4, String[] stringArray, XBinary[] xBinaryArray, int n2, int n3, int n4, int n5) {
        super(string2, string3, string4, 17, 17, stringArray, n5, false);
        this.length = n2;
        this.minLength = n3;
        this.maxLength = n4;
        this.enumeration = xBinaryArray;
        this.fMultiBuffered = true;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XBinary xBinary = Base64BinaryDV.parse(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xBinary;
            validatedInfo.errorCode = 0;
        }
        return xBinary;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        XBinary xBinary = XSBase64BinaryUtil.parseBase64Binary(xMLString);
        if (xBinary == null) {
            validatedInfo2.errorCode = 1;
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = validatedInfo.actualValue.equals(xBinary) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xBinary, xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xBinary;
    }

    public int preCheckFacets(XBinary xBinary, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xBinary, xMLString);
        }
        return 0;
    }

    private final int checkFacets(XBinary xBinary, XMLString xMLString) {
        if ((this.definedFacets & 1) != 0 && xBinary.length != this.length) {
            return 1;
        }
        if ((this.definedFacets & 2) != 0 && xBinary.length < this.minLength) {
            return 1;
        }
        if ((this.definedFacets & 4) != 0 && xBinary.length > this.maxLength) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equals(xBinary)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    public static XBinary parse(XMLString xMLString) {
        return XSBase64BinaryUtil.parseBase64Binary(xMLString);
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XBinary xBinary = vMContext.dvContext.getXBinary();
        int n2 = XSBase64BinaryUtil.parseBase64BinaryBuffered(parsedEntity, xBinary, validatedInfo);
        if (n2 == -1) {
            return null;
        }
        parsedEntity.offset = n2;
        return xBinary;
    }

    protected int preCheckFacets(Object object2, XMLString xMLString) {
        return this.preCheckFacets((XBinary)object2, xMLString);
    }
}

