/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.XDateTime;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class AbstractDateTimeDV
extends TypeValidator {
    protected final XDateTime[] enumeration;
    protected final XDateTime maxInclusive;
    protected final XDateTime maxExclusive;
    protected final XDateTime minInclusive;
    protected final XDateTime minExclusive;
    private final int position;

    public AbstractDateTimeDV(String string2, String string3, String string4, String[] stringArray, XDateTime[] xDateTimeArray, XDateTime xDateTime, XDateTime xDateTime2, XDateTime xDateTime3, XDateTime xDateTime4, int n2, int n3) {
        super(string2, string3, string4, n2, n2, stringArray, n3, false);
        switch (n2) {
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                this.position = 0;
                break;
            }
            case 13: 
            case 15: {
                this.position = 1;
                break;
            }
            case 14: {
                this.position = 2;
                break;
            }
            default: {
                this.position = 3;
            }
        }
        this.enumeration = xDateTimeArray;
        this.maxInclusive = xDateTime3;
        this.maxExclusive = xDateTime4;
        this.minInclusive = xDateTime;
        this.minExclusive = xDateTime2;
    }

    public int preCheckFacets(XDateTime xDateTime, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xDateTime, xMLString);
        }
        return 0;
    }

    public int checkFacets(XDateTime xDateTime, XMLString xMLString) {
        short s;
        if ((this.definedFacets & 0x100) != 0 ? (s = xDateTime.compareDates(this.minInclusive, true)) != 0 && s != 1 : (this.definedFacets & 0x80) != 0 && (s = xDateTime.compareDates(this.minExclusive, true)) != 1) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 ? (s = xDateTime.compareDates(this.maxInclusive, true)) != 0 && s != -1 : (this.definedFacets & 0x40) != 0 && (s = xDateTime.compareDates(this.maxExclusive, true)) != -1) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!xDateTime.equals(this.enumeration[i])) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public static int parseUYear(byte[] byArray, XDateTime xDateTime, int n2, int n3) {
        if (n2 < n3) {
            byte by2 = byArray[n2];
            int n4 = 1;
            if (by2 == 45) {
                n4 = -1;
                if (++n2 < n3) {
                    by2 = byArray[n2];
                }
            }
            if (by2 >= 48 && by2 <= 57) {
                int n5;
                for (n5 = 0; by2 == 48 && ++n2 < n3 && n5 < 4; ++n5) {
                    by2 = byArray[n2];
                }
                if (n5 >= 4 || n2 == n3) {
                    return -1;
                }
                int n6 = by2 - 48;
                int n7 = 1;
                while (++n2 < n3 && (by2 = byArray[n2]) >= 48 && by2 <= 57) {
                    ++n7;
                    n6 = n6 * 10 + by2 - 48;
                }
                if (n2 >= n3 || n5 + n7 < 4 || n6 == 0 || n5 + n7 > 4 && n5 > 0) {
                    return -1;
                }
                xDateTime.year = n4 * n6;
                return n2;
            }
        }
        return -1;
    }

    public static int parseUMonth(byte[] byArray, XDateTime xDateTime, int n2, int n3) {
        byte by2;
        if (n2 < n3 && (by2 = byArray[n2]) >= 48 && by2 <= 57 && ++n2 < n3) {
            int n4 = by2 - 48;
            by2 = byArray[n2];
            if (by2 >= 48 && by2 <= 57 && ++n2 < n3) {
                xDateTime.month = n4 * 10 + by2 - 48;
                return n2;
            }
        }
        return -1;
    }

    public static int parseUDay(byte[] byArray, XDateTime xDateTime, int n2, int n3) {
        byte by2;
        if (n2 < n3 && (by2 = byArray[n2]) >= 48 && by2 <= 57 && ++n2 < n3) {
            int n4 = by2 - 48;
            by2 = byArray[n2];
            if (by2 >= 48 && by2 <= 57 && ++n2 < n3) {
                xDateTime.day = n4 * 10 + by2 - 48;
                return n2;
            }
        }
        return -1;
    }

    public static int parseUHour(byte[] byArray, XDateTime xDateTime, int n2, int n3) {
        byte by2;
        if (n2 < n3 && (by2 = byArray[n2]) >= 48 && by2 <= 57 && ++n2 < n3) {
            int n4 = by2 - 48;
            by2 = byArray[n2];
            if (by2 >= 48 && by2 <= 57 && ++n2 < n3) {
                xDateTime.hour = n4 * 10 + by2 - 48;
                return n2;
            }
        }
        return -1;
    }

    public static int parseUMinute(byte[] byArray, XDateTime xDateTime, int n2, int n3) {
        byte by2;
        if (n2 < n3 && (by2 = byArray[n2]) >= 48 && by2 <= 57 && ++n2 < n3) {
            int n4 = by2 - 48;
            by2 = byArray[n2];
            if (by2 >= 48 && by2 <= 57 && ++n2 < n3) {
                xDateTime.minute = n4 * 10 + by2 - 48;
                return n2;
            }
        }
        return -1;
    }

    public static int parseUSeconds(byte[] byArray, XDateTime xDateTime, int n2, int n3) {
        byte by2;
        if (n2 < n3 && (by2 = byArray[n2]) >= 48 && by2 <= 57 && ++n2 < n3) {
            double d = by2 - 48;
            by2 = byArray[n2];
            if (by2 >= 48 && by2 <= 57 && ++n2 < n3) {
                d = d * 10.0 + (double)by2 - 48.0;
                if (byArray[n2] == 46) {
                    if (++n2 < n3 && (by2 = byArray[n2]) >= 48 && by2 <= 57) {
                        d += (double)(by2 - 48) / 10.0;
                        double d2 = 10.0;
                        while (++n2 < n3) {
                            by2 = byArray[n2];
                            if (by2 < 48 || by2 > 57) {
                                xDateTime.second = d;
                                return n2;
                            }
                            d += (double)(by2 - 48) / (d2 *= 10.0);
                        }
                    }
                    return -1;
                }
                xDateTime.second = d;
                return n2;
            }
        }
        return -1;
    }

    public static int parseUTimeZone(byte[] byArray, XDateTime xDateTime, int n2, int n3) {
        if (n2 < n3) {
            int n4 = byArray[n2];
            if (n4 == 43 || n4 == 45) {
                xDateTime.utc = n4;
                int n5 = 1;
                if (n4 == 45) {
                    n5 = -1;
                }
                int n6 = 0;
                int n7 = 0;
                while (++n2 < n3) {
                    if (n7 > 2) {
                        return -1;
                    }
                    n4 = byArray[n2];
                    if (n4 >= 48 && n4 <= 57) {
                        n6 *= 10;
                        n6 += n4 - 48;
                    } else {
                        if (n4 == 58) break;
                        return -1;
                    }
                    ++n7;
                }
                if (n7 != 2 || n2 >= n3) {
                    return -1;
                }
                xDateTime.timezoneHr = n5 * n6;
                n6 = 0;
                n7 = 0;
                while (++n2 < n3) {
                    if (n7 > 2) {
                        return -1;
                    }
                    n4 = byArray[n2];
                    if (n4 < 48 || n4 > 57) break;
                    n6 *= 10;
                    n6 += n4 - 48;
                    ++n7;
                }
                if (n7 != 2 || n2 >= n3) {
                    return -1;
                }
                xDateTime.timezoneMin = n5 * n6;
                return n2;
            }
            if (n4 == 90) {
                if (++n2 >= n3) {
                    return -1;
                }
                xDateTime.utc = 90;
                return n2;
            }
        }
        return -1;
    }

    public static boolean validateDateTime(XDateTime xDateTime) {
        if (xDateTime.month < 1 || xDateTime.month > 12 || xDateTime.day > xDateTime.maxDayInMonthFor() || xDateTime.day < 1) {
            return false;
        }
        if (xDateTime.hour > 23 || xDateTime.hour < 0) {
            if (xDateTime.hour == 24 && xDateTime.minute == 0 && xDateTime.second == 0.0) {
                xDateTime.hour = 0;
                if (++xDateTime.day > xDateTime.maxDayInMonthFor()) {
                    xDateTime.day = 1;
                    if (++xDateTime.month > 12) {
                        xDateTime.month = 1;
                        if (++xDateTime.year == 0) {
                            xDateTime.year = 1;
                        }
                    }
                }
            } else {
                return false;
            }
        }
        if (xDateTime.minute > 59 || xDateTime.minute < 0 || xDateTime.second > 60.0 || xDateTime.second < 0.0 || xDateTime.timezoneHr > 14 || xDateTime.timezoneHr < -14) {
            return false;
        }
        if ((xDateTime.timezoneHr == 14 || xDateTime.timezoneHr == -14) && xDateTime.timezoneMin != 0) {
            return false;
        }
        return xDateTime.timezoneMin <= 59 && xDateTime.timezoneMin >= -59;
    }

    protected abstract int parseDateTimeUnbuffered(ParsedEntity var1, XDateTime var2, boolean[] var3);

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XDateTime xDateTime = vMContext.dvContext.getXDateTime(this.builtInKind, this.position);
        int n2 = this.parseDateTimeUnbuffered(parsedEntity, xDateTime, this.fNormalized);
        if (n2 == -1) {
            return null;
        }
        parsedEntity.offset = n2;
        return xDateTime;
    }

    protected int preCheckFacets(Object object2, XMLString xMLString) {
        return this.preCheckFacets((XDateTime)object2, xMLString);
    }
}

