/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype;

import com.ibm.xml.xlxp.internal.s1.datatype.XInt;
import com.ibm.xml.xlxp.internal.s1.datatype.XLong;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XDecimal {
    private static final long[] longRanges;
    private static final int[] intRanges;
    public static final XDecimal ZERO;
    public int sign;
    public int totalDigits;
    public int intDigits;
    public int fracDigits;
    public XMLString rawData;

    public XDecimal() {
        this.sign = 0;
        this.totalDigits = 0;
        this.intDigits = 0;
        this.fracDigits = 0;
        this.rawData = null;
    }

    public XDecimal(DataBuffer dataBuffer, int n2, DataBuffer dataBuffer2, int n3, int n4, int n5, int n6) {
        XMLString xMLString = new XMLString();
        if (dataBuffer == dataBuffer2) {
            xMLString.setValues(dataBuffer, n2, n3);
        } else {
            xMLString.setStartPos(dataBuffer, n2);
            xMLString.setEndPos(dataBuffer2, n3);
        }
        this.rawData = xMLString;
        this.intDigits = n4;
        this.fracDigits = n5;
        this.sign = n6;
        this.totalDigits = n4 + n5;
    }

    public void setValues(DataBuffer dataBuffer, int n2, DataBuffer dataBuffer2, int n3, int n4, int n5, int n6) {
        if (this.rawData == null) {
            this.rawData = new XMLString();
        }
        if (dataBuffer == dataBuffer2) {
            this.rawData.setValues(dataBuffer, n2, n3);
        } else {
            this.rawData.setValues(dataBuffer, dataBuffer2, n2, n3);
        }
        this.intDigits = n4;
        this.fracDigits = n5;
        this.sign = n6;
        this.totalDigits = n4 + n5;
    }

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof XDecimal) {
            XDecimal xDecimal = (XDecimal)object2;
            if (this.sign != xDecimal.sign) {
                return false;
            }
            if (this.sign == 0) {
                return true;
            }
            return this.intDigits == xDecimal.intDigits && this.fracDigits == xDecimal.fracDigits && this.rawData.equals(xDecimal.rawData);
        }
        if (object2 instanceof XInt) {
            return this.equals(((XInt)object2).value);
        }
        if (object2 instanceof XLong) {
            return this.equals(((XLong)object2).value);
        }
        return false;
    }

    public boolean equals(long l) {
        long l2;
        if (this.fracDigits > 0 || this.intDigits > 19) {
            return false;
        }
        if (this.sign == 0) {
            return l == 0L;
        }
        if (this.sign == 1 && l < 0L || this.sign == -1 && l > 0L) {
            return false;
        }
        long l3 = l2 = l > 0L ? -l : l;
        if (l2 < longRanges[this.intDigits] && l2 >= longRanges[this.intDigits + 1]) {
            return this.equals2(l);
        }
        return false;
    }

    private boolean equals2(long l) {
        boolean bl = this.sign == -1;
        long l2 = bl ? Long.MIN_VALUE : -9223372036854775807L;
        DataBuffer dataBuffer = this.rawData.firstBuffer;
        DataBuffer dataBuffer2 = this.rawData.lastBuffer == null ? dataBuffer : this.rawData.lastBuffer;
        int n2 = this.rawData.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? this.rawData.endOffset : dataBuffer.endOffset;
        byte by2 = dataBuffer.bytes[n2++];
        long l3 = 48 - by2;
        while (true) {
            if (n2 < n3) {
                by2 = dataBuffer.bytes[n2++];
                int n4 = by2 - 48;
                if (l3 >= -922337203685477580L && (l3 *= 10L) >= l2 + (long)n4) {
                    l3 -= (long)n4;
                    continue;
                }
                return false;
            }
            if (dataBuffer == dataBuffer2) {
                return (bl ? l3 : -l3) == l;
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? this.rawData.endOffset : dataBuffer.endOffset;
        }
    }

    public boolean equals(int n2) {
        int n3;
        if (this.fracDigits > 0 || this.intDigits > 10) {
            return false;
        }
        if (this.sign == 0) {
            return n2 == 0;
        }
        if (this.sign == 1 && n2 < 0 || this.sign == -1 && n2 > 0) {
            return false;
        }
        int n4 = n3 = n2 > 0 ? -n2 : n2;
        if (n3 < intRanges[this.intDigits] && n3 >= intRanges[this.intDigits + 1]) {
            return this.equals2(n2);
        }
        return false;
    }

    private boolean equals2(int n2) {
        boolean bl = this.sign == -1;
        int n3 = bl ? Integer.MIN_VALUE : -2147483647;
        DataBuffer dataBuffer = this.rawData.firstBuffer;
        DataBuffer dataBuffer2 = this.rawData.lastBuffer == null ? dataBuffer : this.rawData.lastBuffer;
        int n4 = this.rawData.startOffset;
        int n5 = dataBuffer == dataBuffer2 ? this.rawData.endOffset : dataBuffer.endOffset;
        byte by2 = dataBuffer.bytes[n4++];
        int n6 = 48 - by2;
        while (true) {
            if (n4 < n5) {
                by2 = dataBuffer.bytes[n4++];
                int n7 = by2 - 48;
                if (n6 >= -214748364 && (n6 *= 10) >= n3 + n7) {
                    n6 -= n7;
                    continue;
                }
                return false;
            }
            if (dataBuffer == dataBuffer2) {
                return (bl ? n6 : -n6) == n2;
            }
            dataBuffer = dataBuffer.next;
            n4 = dataBuffer.startOffset;
            n5 = dataBuffer == dataBuffer2 ? this.rawData.endOffset : dataBuffer.endOffset;
        }
    }

    public int compareTo(XDecimal xDecimal) {
        if (this.sign != xDecimal.sign) {
            return this.sign > xDecimal.sign ? 1 : -1;
        }
        if (this.sign == 0) {
            return 0;
        }
        if (this.intDigits != xDecimal.intDigits) {
            return this.intDigits > xDecimal.intDigits ? this.sign : -this.sign;
        }
        int n2 = this.rawData.compare(xDecimal.rawData);
        if (n2 != 0) {
            return n2 > 0 ? this.sign : -this.sign;
        }
        return 0;
    }

    public int hashCode() {
        if (this.sign == 0) {
            return 0;
        }
        long l = 0L;
        if (this.rawData.bytes != null) {
            byte[] byArray = this.rawData.bytes;
            int n2 = this.rawData.startOffset;
            int n3 = this.rawData.endOffset;
            for (int i = n2; i < n3; ++i) {
                l = l * 10L - (long)(byArray[i] - 48);
            }
            if (this.sign == 1) {
                l = -l;
            }
            return (int)(l ^ l >>> 32);
        }
        DataBuffer dataBuffer = this.rawData.firstBuffer;
        DataBuffer dataBuffer2 = this.rawData.lastBuffer != null ? this.rawData.lastBuffer : dataBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n4 = this.rawData.startOffset;
        int n5 = this.rawData.lastBuffer != null ? dataBuffer.endOffset : this.rawData.endOffset;
        while (true) {
            for (int i = n4; i < n5; ++i) {
                l = l * 10L - (long)(byArray[i] - 48);
            }
            if (dataBuffer == dataBuffer2) {
                if (this.sign == 1) {
                    l = -l;
                }
                return (int)(l ^ l >>> 32);
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n4 = dataBuffer.startOffset;
            n5 = dataBuffer != dataBuffer2 ? dataBuffer.endOffset : this.rawData.endOffset;
        }
    }

    public String toString() {
        if (this.sign == 0) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder(2 + this.rawData.length);
        if (this.sign == -1) {
            stringBuilder.append('-');
        }
        if (this.fracDigits == this.totalDigits) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.rawData.toString());
        return stringBuilder.toString();
    }

    static {
        int n2;
        longRanges = new long[21];
        XDecimal.longRanges[0] = 0L;
        XDecimal.longRanges[1] = 0L;
        XDecimal.longRanges[2] = -9L;
        for (n2 = 3; n2 < 20; ++n2) {
            XDecimal.longRanges[n2] = longRanges[n2 - 1] * 10L - 9L;
        }
        XDecimal.longRanges[20] = Long.MIN_VALUE;
        intRanges = new int[12];
        XDecimal.intRanges[0] = 0;
        XDecimal.intRanges[1] = 0;
        XDecimal.intRanges[2] = -9;
        for (n2 = 3; n2 < 11; ++n2) {
            XDecimal.intRanges[n2] = intRanges[n2 - 1] * 10 - 9;
        }
        XDecimal.intRanges[11] = Integer.MIN_VALUE;
        ZERO = new XDecimal();
    }
}

