/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XBinary {
    public static final int DEFAULT_BINARY_SIZE = 256;
    public static final int BINARY_SIZE_LIMIT = 4096;
    public byte[] value;
    public int length;

    public XBinary() {
    }

    public XBinary(byte[] byArray, int n2) {
        this.value = byArray;
        this.length = n2;
    }

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof XBinary) {
            XBinary xBinary = (XBinary)object2;
            if (xBinary.length == this.length) {
                byte[] byArray = xBinary.value;
                for (int i = 0; i < this.length; ++i) {
                    if (this.value[i] == byArray[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i = 0; i < this.length; ++i) {
            n2 = n2 * 31 + (this.value[i] & 0xFF);
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.length * 2);
        for (int i = 0; i < this.length; ++i) {
            byte by2 = this.value[i];
            int n2 = by2 >> 4 & 0xF;
            int n3 = by2 & 0xF;
            stringBuilder.append((char)(n2 < 10 ? n2 + 48 : n2 - 10 + 65));
            stringBuilder.append((char)(n3 < 10 ? n3 + 48 : n3 - 10 + 65));
        }
        return stringBuilder.toString();
    }
}

