/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.converter;

import com.ibm.xml.xlxp.internal.s1.converter.Converter;
import com.ibm.xml.xlxp.internal.s1.converter.DVFactory;
import com.ibm.xml.xlxp.internal.s1.converter.MergerContext;
import com.ibm.xml.xlxp.internal.s1.converter.NVMerger;
import com.ibm.xml.xlxp.internal.s1.converter.VMerger;
import com.ibm.xml.xlxp.internal.s1.grammar.Attribute;
import com.ibm.xml.xlxp.internal.s1.grammar.Element;
import com.ibm.xml.xlxp.internal.s1.grammar.ElementType;
import com.ibm.xml.xlxp.internal.s1.grammar.Grammar;
import com.ibm.xml.xlxp.internal.s1.grammar.NamedDeclaration;
import com.ibm.xml.xlxp.internal.s1.runtime.DynamicSchemaResolver;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.util.BitSet;
import com.ibm.xml.xml4j.api.s1.xs.StringList;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSModel;
import com.ibm.xml.xml4j.api.s1.xs.XSModelGroup;
import com.ibm.xml.xml4j.api.s1.xs.XSNamedMap;
import com.ibm.xml.xml4j.api.s1.xs.XSObject;
import com.ibm.xml.xml4j.api.s1.xs.XSObjectList;
import com.ibm.xml.xml4j.api.s1.xs.XSParticle;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTerm;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSWildcard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class Merger
extends Converter
implements DynamicSchemaResolver {
    public MergerContext mergerContext;
    public final Grammar grammar;
    protected HashMap fOrigWCDecls;
    protected HashSet<XSObject> fMerged = null;
    protected HashMap<XSElementDeclaration, XSObjectList> fSubstGroups = null;
    protected HashSet<String> fNewNamespaces = null;
    protected int fNumExistingCMs;
    protected int fNumOriginalGlobalTypes;
    protected boolean fInitialConversion = true;
    static int debugIDCounter = 0;
    final int debugID = debugIDCounter++;
    private ArrayList<Object> fXsiTypes;

    public static final Merger createMerger(boolean bl, MergerContext mergerContext) {
        NVMerger nVMerger = bl ? new VMerger() : new NVMerger();
        nVMerger.mergerContext = mergerContext;
        return nVMerger;
    }

    protected void convertGAttr(XSAttributeDeclaration xSAttributeDeclaration) {
        if (this.fInitialConversion || !this.fAtts.containsKey(xSAttributeDeclaration)) {
            super.convertGAttr(xSAttributeDeclaration);
        }
    }

    protected void finish() {
    }

    protected Element convertElem(XSElementDeclaration xSElementDeclaration) {
        if (this.fInitialConversion) {
            return super.convertElem(xSElementDeclaration);
        }
        Element element2 = (Element)this.fElems.get(xSElementDeclaration);
        if (element2 != null) {
            return element2;
        }
        element2 = super.convertElem(xSElementDeclaration);
        this.fMerged.add(xSElementDeclaration);
        return element2;
    }

    protected ElementType convertType(XSTypeDefinition xSTypeDefinition, int n2) {
        if (this.fInitialConversion) {
            return super.convertType(xSTypeDefinition, n2);
        }
        ElementType elementType = (ElementType)this.fCMs.get(xSTypeDefinition);
        if (elementType != null) {
            return elementType;
        }
        elementType = super.convertType(xSTypeDefinition, n2);
        this.fMerged.add(xSTypeDefinition);
        return elementType;
    }

    protected void convertParticle(XSParticle xSParticle) {
        super.convertParticle(xSParticle);
        if (!this.fInitialConversion) {
            this.fMerged.add(xSParticle);
            this.fMerged.add(xSParticle.getTerm());
        }
    }

    public Grammar convert(XSModel xSModel, DVFactory dVFactory, String string2, String string3) throws Converter.ConverterException {
        super.finish();
        this.fOrigWCDecls = null;
        this.fMerged = null;
        this.fSubstGroups = null;
        this.fNewNamespaces = null;
        this.fInitialConversion = true;
        return super.convert(xSModel, dVFactory, string2, string3, this.grammar);
    }

    protected BitSet getDerivedTypeBitset(XSTypeDefinition xSTypeDefinition, int n2) {
        if (this.fInitialConversion) {
            return super.getDerivedTypeBitset(xSTypeDefinition, n2);
        }
        BitSet bitSet = (BitSet)this.fDerivedTypeBitSets.get(xSTypeDefinition);
        if (bitSet == null) {
            return super.getDerivedTypeBitset(xSTypeDefinition, n2);
        }
        bitSet.growSize(n2);
        return bitSet;
    }

    public final boolean handleUnknownType(VMContext vMContext, String string2, String string3) {
        boolean bl = this.handleUnknownComponent(vMContext, string2, string3, (short)3);
        MergerContext.threadDebug("handleUnknownComponent", bl);
        return bl;
    }

    public final boolean handleUnknownQName(VMContext vMContext, String string2, String string3, boolean bl) {
        boolean bl2 = this.handleUnknownComponent(vMContext, string2, string3, bl ? (short)2 : 1);
        MergerContext.threadDebug("handleUnknownComponent", bl2);
        return bl2;
    }

    public final void waitUntilUpdateComplete() {
        this.mergerContext.waitUntilUpdateComplete();
    }

    protected final boolean handleUnknownComponent(VMContext vMContext, String string2, String string3, short s) {
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return this.mergerContext.handleUnknownComponent(vMContext, string2, string3, s);
    }

    public boolean merge(String string2, String string3, XSModel xSModel, DVFactory dVFactory, Grammar grammar) throws Converter.ConverterException {
        XSModel xSModel2 = grammar.xsModel;
        if (xSModel2 == xSModel) {
            return false;
        }
        this.fNumOriginalGlobalTypes = this.fGlobalTypes.size();
        this.fNumExistingCMs = this.fPendingCMs.size();
        if (this.fMerged == null) {
            this.fMerged = new HashSet(this.fElems.size() + this.fNumExistingCMs);
            this.fSubstGroups = new HashMap();
            this.fNewNamespaces = new HashSet();
            this.fXsiTypes = new ArrayList();
        } else {
            this.fMerged.clear();
            this.fSubstGroups.clear();
            this.fNewNamespaces.clear();
            this.fXsiTypes.clear();
        }
        this.fInitialConversion = false;
        this.fXSModel = xSModel;
        this.fOrigWCDecls = this.fWCDecls;
        this.fWCDecls = new HashMap();
        this.analyzeNewPartsOfSchema();
        this.convertGlobalSimpleTypes(this.fNumOriginalGlobalTypes);
        this.convertGlobalAttributes();
        this.convertGlobalElements();
        this.findSubstGroups(xSModel2);
        this.convertGlobalTypes(this.fNumOriginalGlobalTypes);
        this.mergeGlobalTypes();
        this.mergeCMs();
        this.processPendingCMs(this.fNumExistingCMs);
        this.fillInTypeHeirarchy();
        this.mergeGrammar(string2, string3, grammar);
        grammar.xsModel = this.fXSModel;
        return true;
    }

    protected Merger(boolean bl) {
        super(bl);
        this.grammar = new Grammar();
    }

    private void analyzeNewPartsOfSchema() {
        XSNamedMap xSNamedMap = this.fXSModel.getComponents((short)3);
        int n2 = xSNamedMap.getLength();
        if (n2 == this.fNumOriginalGlobalTypes) {
            return;
        }
        this.sortNewTypes(xSNamedMap);
        this.computeTypeHierarchy(this.fNumOriginalGlobalTypes);
        this.computeDerivedTypeBitsets();
    }

    private final void sortNewTypes(XSNamedMap xSNamedMap) {
        int n2 = xSNamedMap.getLength();
        int n3 = this.fGlobalTypes.size();
        for (int i = 0; i < n2; ++i) {
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)xSNamedMap.item(i);
            if (this.fCMs.containsKey(xSTypeDefinition)) continue;
            this.fGlobalTypes.add(xSTypeDefinition);
            this.fGlobalTypeIndices.put(xSTypeDefinition, n3++);
        }
    }

    private final void findSubstGroups(XSModel xSModel) {
        this.findNewNamespaces(xSModel);
        XSNamedMap xSNamedMap = this.fXSModel.getComponents((short)2);
        int n2 = xSNamedMap.getLength();
        block0: for (int i = 0; i < n2; ++i) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSNamedMap.item(i);
            if (this.fNewNamespaces.contains(xSElementDeclaration.getNamespace())) {
                this.fSubstGroups.put(xSElementDeclaration, null);
            }
            XSObjectList xSObjectList = this.getSubstitutionGroup(xSElementDeclaration);
            int n3 = xSObjectList.getLength();
            for (int j = 0; j < n3; ++j) {
                XSElementDeclaration xSElementDeclaration2 = (XSElementDeclaration)xSObjectList.item(j);
                if (!this.fNewNamespaces.contains(xSElementDeclaration2.getNamespace())) continue;
                this.fSubstGroups.put(xSElementDeclaration, xSObjectList);
                continue block0;
            }
        }
    }

    private final void findNewNamespaces(XSModel xSModel) {
        StringList stringList = xSModel.getNamespaces();
        int n2 = stringList.getLength();
        HashSet<String> hashSet = new HashSet<String>(n2 * 2);
        for (int i = 0; i < n2; ++i) {
            hashSet.add(stringList.item(i));
        }
        StringList stringList2 = this.fXSModel.getNamespaces();
        int n3 = stringList2.getLength();
        for (int i = 0; i < n3; ++i) {
            String string2 = stringList2.item(i);
            if (!hashSet.add(string2)) continue;
            this.fNewNamespaces.add(string2);
        }
    }

    private final void mergeGlobalTypes() throws Converter.ConverterException {
        XSNamedMap xSNamedMap = this.fXSModel.getComponents((short)3);
        this.handleTypeList(xSNamedMap, this.fGlobalTypes);
    }

    private final void handleTypeList(XSNamedMap xSNamedMap, ArrayList arrayList) throws Converter.ConverterException {
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)arrayList.get(i);
            this.mergeType(xSTypeDefinition);
        }
    }

    private final void mergeType(XSTypeDefinition xSTypeDefinition) throws Converter.ConverterException {
        if (!this.fCMs.containsKey(xSTypeDefinition)) {
            this.convertType(xSTypeDefinition, -1);
            this.fMerged.add(xSTypeDefinition);
            return;
        }
        if (xSTypeDefinition instanceof XSSimpleTypeDefinition) {
            return;
        }
        if (!this.fMerged.add(xSTypeDefinition)) {
            return;
        }
        ElementType elementType = (ElementType)this.fCMs.get(xSTypeDefinition);
        XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition;
        this.mergeAttributes(xSComplexTypeDefinition, elementType);
        short s = xSComplexTypeDefinition.getContentType();
        if (s == 1) {
            return;
        }
        XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
        if (xSParticle != null) {
            this.mergeParticle(xSParticle);
        }
    }

    private final void mergeAttributes(XSComplexTypeDefinition xSComplexTypeDefinition, ElementType elementType) throws Converter.ConverterException {
        int n2;
        XSWildcard xSWildcard = xSComplexTypeDefinition.getAttributeWildcard();
        ArrayList arrayList = this.getWCDecls(xSWildcard, true);
        int n3 = arrayList.size();
        if (n3 == 0) {
            return;
        }
        ArrayList arrayList2 = (ArrayList)this.fOrigWCDecls.get(xSWildcard);
        int n4 = n2 = arrayList2 != null ? arrayList2.size() : 0;
        if (n2 == n3) {
            return;
        }
        int n5 = 4 + xSComplexTypeDefinition.getAttributeUses().getLength();
        int n6 = n5 + n3;
        int n7 = n5 + n2;
        ElementType.AttributeInfo attributeInfo = elementType.extendOwnedChoicesArray(n6);
        Attribute[] attributeArray = attributeInfo.ownedChoices;
        HashSet hashSet = arrayList2 != null ? new HashSet(arrayList2) : null;
        for (XSAttributeDeclaration xSAttributeDeclaration : arrayList) {
            if (hashSet != null && hashSet.contains(xSAttributeDeclaration)) continue;
            attributeArray[n7++] = this.convertLAttr(xSAttributeDeclaration);
        }
        elementType.updateOwnedChoices(attributeInfo);
        this.mergeWildIds(xSComplexTypeDefinition, elementType, arrayList2, arrayList, n5, n6);
    }

    protected abstract void mergeWildIds(XSComplexTypeDefinition var1, ElementType var2, ArrayList var3, ArrayList var4, int var5, int var6) throws Converter.ConverterException;

    private final void mergeParticle(XSParticle xSParticle) throws Converter.ConverterException {
        if (!this.fMerged.add(xSParticle)) {
            return;
        }
        XSTerm xSTerm = xSParticle.getTerm();
        if (!this.fMerged.contains(xSTerm)) {
            return;
        }
        if (xSTerm.getType() == 2) {
            if (!((XSElementDeclaration)xSTerm).getAbstract()) {
                this.mergeElem((XSElementDeclaration)xSTerm);
            }
        } else if (xSTerm.getType() == 9) {
            XSWildcard xSWildcard = (XSWildcard)xSTerm;
            this.convertWC(xSWildcard, xSWildcard.getProcessContents());
        } else {
            XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
            XSObjectList xSObjectList = xSModelGroup.getParticles();
            for (int i = 0; i < xSObjectList.getLength(); ++i) {
                this.mergeParticle((XSParticle)xSObjectList.item(i));
            }
        }
    }

    protected final Element mergeElem(XSElementDeclaration xSElementDeclaration) throws Converter.ConverterException {
        if (this.fValidating && xSElementDeclaration.getAbstract()) {
            throw new Converter.ConverterException("merging abstract element");
        }
        Element element2 = (Element)this.fElems.get(xSElementDeclaration);
        if (element2 == null) {
            return this.convertElem(xSElementDeclaration);
        }
        if (!this.fMerged.add(xSElementDeclaration)) {
            return element2;
        }
        short s = xSElementDeclaration.getDisallowedSubstitutions();
        short s2 = xSElementDeclaration.getConstraintType();
        boolean bl = s2 != 0;
        XSTypeDefinition xSTypeDefinition = xSElementDeclaration.getTypeDefinition();
        Object object2 = bl ? xSElementDeclaration.getActualVC() : null;
        String string2 = bl ? xSElementDeclaration.getConstraintValue() : null;
        BitSet bitSet = this.getXsiTypes(xSTypeDefinition, s, object2);
        if (bitSet != null) {
            this.fXsiTypes.add(element2);
            this.fXsiTypes.add(bitSet);
            this.mergeVcSafeTypes(bitSet, element2, bl, object2, string2);
        }
        this.mergeType(xSTypeDefinition);
        return element2;
    }

    private void mergeVcSafeTypes(BitSet bitSet, Element element2, boolean bl, Object object2, String string2) {
        BitSet bitSet2 = this.getVcSafeTypes(bitSet, bl, object2, string2);
        if (element2.vcSafeTypes == null) {
            element2.vcSafeTypes = bitSet2;
        } else {
            bitSet2.copyTo(element2.vcSafeTypes);
        }
    }

    private final void mergeCMs() throws Converter.ConverterException {
        int n2 = this.fNumExistingCMs;
        for (int i = 0; i < n2; ++i) {
            ElementType elementType = (ElementType)this.fPendingCMs.get(i);
            XSTypeDefinition xSTypeDefinition = elementType.xsTypeDefinition;
            if (!(xSTypeDefinition instanceof XSComplexTypeDefinition)) continue;
            XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition;
            this.mergeCM(elementType, xSComplexTypeDefinition);
        }
    }

    protected abstract void mergeCM(ElementType var1, XSComplexTypeDefinition var2) throws Converter.ConverterException;

    protected void mergeGrammar(String string2, String string3, Grammar grammar) throws Converter.ConverterException {
        NamedDeclaration namedDeclaration;
        int n2;
        Element[] elementArray = this.rootElements(string2, string3);
        this.expandRootElements(grammar, elementArray);
        int n3 = this.fGlobalTypes.size();
        if (this.fNumOriginalGlobalTypes != n3) {
            Grammar.GlobalTypesInfo globalTypesInfo = grammar.extendGlobalTypesArray(n3);
            for (n2 = this.fNumOriginalGlobalTypes; n2 < n3; ++n2) {
                namedDeclaration = (ElementType)this.fCMs.get(this.fGlobalTypes.get(n2));
                globalTypesInfo.globalTypes[n2] = namedDeclaration;
            }
            grammar.setGlobalTypes(globalTypesInfo);
        }
        int n4 = this.fXsiTypes.size();
        n2 = 0;
        while (n2 < n4) {
            namedDeclaration = (Element)this.fXsiTypes.get(n2++);
            BitSet bitSet = (BitSet)this.fXsiTypes.get(n2++);
            if (namedDeclaration.xsiTypes == null) {
                namedDeclaration.xsiTypes = bitSet;
                continue;
            }
            bitSet.copyTo(namedDeclaration.xsiTypes);
        }
    }

    public final void expandRootElements(Grammar grammar, Element[] elementArray) {
        int n2;
        int n3;
        ElementType.DFAInfo dFAInfo = grammar.root;
        Element[] elementArray2 = dFAInfo.elementInfo.elements;
        int n4 = elementArray2 != null ? elementArray2.length : 0;
        int n5 = n3 = elementArray == null ? 0 : elementArray.length;
        if (n3 == n4) {
            return;
        }
        ElementType.DFAInfo.ElementInfo elementInfo = dFAInfo.extendElementArray(n3);
        HashSet<Element> hashSet = new HashSet<Element>(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            hashSet.add(elementArray2[n2]);
        }
        n2 = n4;
        for (int i = 0; i < n3; ++i) {
            if (hashSet.contains(elementArray[i])) continue;
            elementInfo.elements[n2++] = elementArray[i];
        }
        dFAInfo.setElements(elementInfo);
    }
}

