/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.converter;

import com.ibm.xml.xlxp.idc.IDCSymbol;
import com.ibm.xml.xlxp.idc.XPathAction;
import com.ibm.xml.xlxp.idc.XPathAttributeInfo;
import com.ibm.xml.xlxp.idc.XPathDFA;
import com.ibm.xml.xlxp.idc.impl.XPathActionFinalNilSelector;
import com.ibm.xml.xlxp.idc.impl.XPathActionImpl;
import com.ibm.xml.xlxp.idc.impl.XPathActionInvalid;
import com.ibm.xml.xlxp.idc.impl.XPathAttributeInfoImpl;
import com.ibm.xml.xlxp.internal.s1.converter.Converter;
import com.ibm.xml.xlxp.internal.s1.converter.IDCInstructionBuilder;
import com.ibm.xml.xlxp.internal.s1.grammar.Attribute;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.util.BitSet;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSModelGroup;
import com.ibm.xml.xml4j.api.s1.xs.XSNamedMap;
import com.ibm.xml.xml4j.api.s1.xs.XSObjectList;
import com.ibm.xml.xml4j.api.s1.xs.XSParticle;
import com.ibm.xml.xml4j.api.s1.xs.XSTerm;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSWildcard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class IDCMatcher {
    private final Converter fConverter;
    private final Stack<MatcherInfo> fInfoStack = new Stack();
    private final MatcherInfoPool fInfoPool = new MatcherInfoPool();
    private final AnnotatedMap fAnnotatedMap = new AnnotatedMap();

    public IDCMatcher(Converter converter) {
        this.fConverter = converter;
    }

    public void match(HashMap hashMap) {
        this.clear();
        this.startSelectors(hashMap);
        this.processInfoStack();
    }

    private void clear() {
        this.fAnnotatedMap.clear();
    }

    private void startSelectors(HashMap hashMap) {
        for (Map.Entry entry : hashMap.entrySet()) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)entry.getKey();
            ArrayList arrayList = (ArrayList)entry.getValue();
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                this.startSelector(xSElementDeclaration, (IDCSymbol)arrayList.get(i));
            }
        }
    }

    private void startSelector(XSElementDeclaration xSElementDeclaration, IDCSymbol iDCSymbol) {
        XPathDFA xPathDFA = iDCSymbol.getSelector();
        boolean bl = xPathDFA.isStateFinal(1);
        boolean bl2 = xPathDFA.allowMoreInput(1);
        int n2 = bl ? -1 : 1;
        IDCInstructionBuilder iDCInstructionBuilder = this.fConverter.getIDCInstructionBuilder(xSElementDeclaration);
        XPathActionImpl xPathActionImpl = new XPathActionImpl(iDCSymbol, 1, true, xPathDFA.id(), 0, n2, bl, bl2);
        xPathActionImpl.setFieldCount(iDCSymbol.getFieldCount());
        iDCInstructionBuilder.addAction((XPathAction)xPathActionImpl);
        this.addStartFieldActions(xPathDFA, iDCSymbol, xSElementDeclaration, bl);
        if (bl2) {
            MatcherInfo matcherInfo = this.fInfoPool.matcherInfo();
            matcherInfo.setValues(xSElementDeclaration, iDCSymbol, xPathDFA, n2, n2, -1);
            this.fInfoStack.push(matcherInfo);
        }
        if (bl) {
            this.endSelector(xSElementDeclaration, iDCSymbol, xPathActionImpl);
        }
    }

    private void endSelector(XSElementDeclaration xSElementDeclaration, IDCSymbol iDCSymbol, XPathActionImpl xPathActionImpl) {
        int n2 = iDCSymbol.getFieldCount();
        if (xSElementDeclaration.getNillable()) {
            this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addNilAction((XPathAction)new XPathActionFinalNilSelector(xPathActionImpl));
        }
        for (int i = 0; i < n2; ++i) {
            XPathDFA xPathDFA = iDCSymbol.getFieldAt(i);
            this.startField(xSElementDeclaration, iDCSymbol, xPathDFA, i, xPathActionImpl);
        }
    }

    private void startField(XSElementDeclaration xSElementDeclaration, IDCSymbol iDCSymbol, XPathDFA xPathDFA, int n2, XPathActionImpl xPathActionImpl) {
        boolean bl = xPathDFA.allowMoreInput(1);
        boolean bl2 = xPathDFA.isStateFinal(1);
        boolean bl3 = xPathDFA.isStateFinalA(1);
        int n3 = bl2 ? -1 : 1;
        XPathActionImpl xPathActionImpl2 = new XPathActionImpl(iDCSymbol, 1, false, xPathDFA.id(), 0, n3, bl2 || bl3, bl);
        xPathActionImpl2.setFieldIndex(n2);
        xPathActionImpl.addFieldAction((XPathAction)xPathActionImpl2);
        if (bl3) {
            this.setFieldAttributes(xSElementDeclaration, xPathActionImpl2, xPathDFA.attributes(1));
        }
        if (bl) {
            MatcherInfo matcherInfo = this.fInfoPool.matcherInfo();
            matcherInfo.setValues(xSElementDeclaration, iDCSymbol, xPathDFA, n3, n3, n2);
            this.fInfoStack.push(matcherInfo);
        }
    }

    private XPathAction createStartFieldAction(XSElementDeclaration xSElementDeclaration, IDCSymbol iDCSymbol, XPathDFA xPathDFA, int n2, boolean bl) {
        boolean bl2 = xPathDFA.allowMoreInput(1);
        boolean bl3 = xPathDFA.isStateFinal(1);
        boolean bl4 = xPathDFA.isStateFinalA(1);
        int n3 = bl3 ? -1 : 1;
        XPathActionImpl xPathActionImpl = new XPathActionImpl(iDCSymbol, 1, false, xPathDFA.id(), 0, n3, bl3 || bl4, bl2);
        xPathActionImpl.setFieldIndex(n2);
        if (bl4) {
            if (bl) {
                this.setFieldAttributes(xSElementDeclaration, xPathActionImpl, xPathDFA.attributes(1));
            } else {
                xPathActionImpl.setAttributes(xPathDFA.attributes(1));
            }
        }
        return xPathActionImpl;
    }

    private void addStartFieldActions(XPathDFA xPathDFA, IDCSymbol iDCSymbol, XSElementDeclaration xSElementDeclaration, boolean bl) {
        int n2 = iDCSymbol.getFieldCount();
        for (int i = 0; i < n2; ++i) {
            XPathDFA xPathDFA2 = iDCSymbol.getFieldAt(i);
            XPathAction xPathAction = this.createStartFieldAction(xSElementDeclaration, iDCSymbol, xPathDFA2, i, bl);
            xPathDFA.addStartFieldAction(xPathAction);
        }
    }

    private void processInfoStack() {
        while (!this.fInfoStack.isEmpty()) {
            MatcherInfo matcherInfo = this.fInfoStack.pop();
            this.processInfo(matcherInfo);
            this.fInfoPool.returnMatcherInfo(matcherInfo);
        }
    }

    private void processInfo(MatcherInfo matcherInfo) {
        XSTypeDefinition xSTypeDefinition = matcherInfo.fElement.getTypeDefinition();
        if (xSTypeDefinition.getTypeCategory() == 15) {
            XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition;
            if (xSComplexTypeDefinition.getBaseType() == xSComplexTypeDefinition) {
                this.fConverter.getIDCInstructionBuilder(matcherInfo.fElement).addAction((XPathAction)new XPathActionImpl(matcherInfo.fIDCSymbol, 2, matcherInfo.isSelector(), matcherInfo.fXPathDFA.id(), matcherInfo.fCurrentState, 0, false, true));
                return;
            }
            XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
            if (xSParticle != null) {
                this.matchParticle(matcherInfo, xSParticle, matcherInfo.isSelector());
            }
            this.matchDerivedTypes(matcherInfo, matcherInfo.isSelector());
        }
    }

    private void matchParticle(MatcherInfo matcherInfo, XSParticle xSParticle, boolean bl) {
        XSTerm xSTerm = xSParticle.getTerm();
        short s = xSTerm.getType();
        if (s == 2) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSTerm;
            this.matchTermElement(matcherInfo, xSElementDeclaration, bl);
            return;
        }
        if (s == 9) {
            XSWildcard xSWildcard = (XSWildcard)xSTerm;
            this.matchTermWildcard(matcherInfo, xSWildcard, bl);
            return;
        }
        XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
        XSObjectList xSObjectList = xSModelGroup.getParticles();
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            this.matchParticle(matcherInfo, (XSParticle)xSObjectList.item(i), bl);
        }
    }

    private void matchTermElement(MatcherInfo matcherInfo, XSElementDeclaration xSElementDeclaration, boolean bl) {
        this.matchElement(matcherInfo, xSElementDeclaration, bl);
        if (xSElementDeclaration.getScope() == 1) {
            XSObjectList xSObjectList = this.fConverter.getSubstitutionGroup(xSElementDeclaration);
            int n2 = xSObjectList.getLength();
            for (int i = 0; i < n2; ++i) {
                XSElementDeclaration xSElementDeclaration2 = (XSElementDeclaration)xSObjectList.item(i);
                if (xSElementDeclaration2 == xSElementDeclaration) continue;
                this.matchElement(matcherInfo, xSElementDeclaration2, bl);
            }
        }
    }

    private void matchElement(MatcherInfo matcherInfo, XSElementDeclaration xSElementDeclaration, boolean bl) {
        MatcherInfo matcherInfo2;
        int n2 = matcherInfo.fXPathDFA.transition(Math.abs(matcherInfo.fCurrentState), xSElementDeclaration.getName(), xSElementDeclaration.getNamespace());
        if (n2 == 0 || this.fAnnotatedMap.contains(xSElementDeclaration, matcherInfo.fXPathDFA, Math.abs(matcherInfo.fCurrentState))) {
            return;
        }
        this.fAnnotatedMap.put(xSElementDeclaration, matcherInfo.fXPathDFA, Math.abs(matcherInfo.fCurrentState));
        boolean bl2 = matcherInfo.fXPathDFA.isStateFinal(Math.abs(n2));
        boolean bl3 = matcherInfo.fXPathDFA.allowMoreInput(Math.abs(n2));
        boolean bl4 = matcherInfo.fXPathDFA.isStateFinalA(Math.abs(n2));
        if (bl3) {
            matcherInfo2 = this.fInfoPool.matcherInfo();
            matcherInfo2.setValues(xSElementDeclaration, matcherInfo.fIDCSymbol, matcherInfo.fXPathDFA, matcherInfo.fCurrentState, n2, matcherInfo.fFieldIndex);
            this.fInfoStack.push(matcherInfo2);
        }
        matcherInfo2 = new XPathActionImpl(matcherInfo.fIDCSymbol, 2, bl, matcherInfo.fXPathDFA.id(), matcherInfo.fCurrentState, n2, bl2 || bl4, bl3);
        if (bl) {
            this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addAction((XPathAction)matcherInfo2);
            if (bl2) {
                this.endSelector(xSElementDeclaration, matcherInfo.fIDCSymbol, (XPathActionImpl)matcherInfo2);
            }
            return;
        }
        matcherInfo2.setFieldIndex(matcherInfo.fFieldIndex);
        if (bl4) {
            this.setFieldAttributes(xSElementDeclaration, (XPathActionImpl)matcherInfo2, matcherInfo.fXPathDFA.attributes(Math.abs(n2)));
        }
        if (xSElementDeclaration.getNillable()) {
            MatcherInfo matcherInfo3 = matcherInfo2;
            if (n2 < 0) {
                matcherInfo3 = new XPathActionInvalid((XPathActionImpl)matcherInfo2);
                if (matcherInfo.fIDCSymbol.getCategory() == 1) {
                    this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addAction((XPathAction)matcherInfo3);
                } else {
                    this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addAction((XPathAction)matcherInfo2);
                }
            } else {
                this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addAction((XPathAction)matcherInfo2);
            }
            if (bl2 || bl4) {
                this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addNilAction((XPathAction)matcherInfo3);
            }
        } else {
            this.fConverter.getIDCInstructionBuilder(xSElementDeclaration).addAction((XPathAction)matcherInfo2);
        }
    }

    private void matchDerivedTypes(MatcherInfo matcherInfo, boolean bl) {
        BitSet bitSet = this.fConverter.getElement((XSElementDeclaration)matcherInfo.fElement).xsiTypes;
        if (bitSet == null || bitSet.isZero()) {
            return;
        }
        int n2 = bitSet.getLength();
        for (int i = 0; i < n2; ++i) {
            XSComplexTypeDefinition xSComplexTypeDefinition;
            XSParticle xSParticle;
            XSTypeDefinition xSTypeDefinition;
            if (!bitSet.getBit(i) || (xSTypeDefinition = this.fConverter.getGlobalTypeAtIndex(i)).getTypeCategory() != 15 || (xSParticle = (xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition).getParticle()) == null) continue;
            this.matchParticle(matcherInfo, xSParticle, bl);
        }
    }

    private void matchTermWildcard(MatcherInfo matcherInfo, XSWildcard xSWildcard, boolean bl) {
        if (xSWildcard.getProcessContents() == 2) {
            return;
        }
        XSNamedMap xSNamedMap = this.fConverter.getGlobalElementDeclarations();
        int n2 = xSNamedMap.getLength();
        for (int i = 0; i < n2; ++i) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSNamedMap.item(i);
            if (!Converter.wildcardAllows(xSWildcard, xSElementDeclaration.getNamespace(), xSElementDeclaration.getName()) || xSElementDeclaration.getAbstract()) continue;
            this.matchTermElement(matcherInfo, xSElementDeclaration, bl);
        }
        if (this.fAnnotatedMap.contains(xSWildcard, matcherInfo.fXPathDFA, Math.abs(matcherInfo.fCurrentState))) {
            return;
        }
        this.fAnnotatedMap.put(xSWildcard, matcherInfo.fXPathDFA, Math.abs(matcherInfo.fCurrentState));
        this.fConverter.getIDCInstructionBuilder(xSWildcard).addAction((XPathAction)new XPathActionImpl(matcherInfo.fIDCSymbol, 2, bl, matcherInfo.fXPathDFA.id(), matcherInfo.fCurrentState, 0, false, true));
    }

    private void setFieldAttributes(XSElementDeclaration xSElementDeclaration, XPathActionImpl xPathActionImpl, XPathAttributeInfo[] xPathAttributeInfoArray) {
        Attribute[] attributeArray = this.fConverter.getElement((XSElementDeclaration)xSElementDeclaration).type.attributeInfo.ownedChoices;
        if (attributeArray.length > 6) {
            block0: for (int i = 0; i < xPathAttributeInfoArray.length; ++i) {
                XPathAttributeInfoImpl xPathAttributeInfoImpl = (XPathAttributeInfoImpl)xPathAttributeInfoArray[i];
                if (xPathAttributeInfoImpl.name() == null) continue;
                for (int j = 6; j < attributeArray.length; ++j) {
                    String string2;
                    Attribute attribute2 = attributeArray[j];
                    String string3 = string2 = attribute2.nsURI == null ? "" : attribute2.nsURI;
                    if (!xPathAttributeInfoImpl.name().equals(attribute2.nsURI) || !xPathAttributeInfoImpl.namespace().equals(string2)) continue;
                    xPathAttributeInfoImpl.setIndex(j);
                    continue block0;
                }
            }
        }
        xPathActionImpl.setAttributes(xPathAttributeInfoArray);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class AnnotatedMap {
        private HashMap<Object, ArrayList<int[]>> fMap = new HashMap();

        private AnnotatedMap() {
        }

        public void put(Object object2, XPathDFA xPathDFA, int n2) {
            ArrayList<Object> arrayList = this.fMap.get(object2);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.fMap.put(object2, arrayList);
            }
            int[] nArray = new int[2];
            this.setValue(nArray, xPathDFA, n2);
            arrayList.add(nArray);
        }

        public boolean contains(Object object2, XPathDFA xPathDFA, int n2) {
            ArrayList<int[]> arrayList = this.fMap.get(object2);
            if (arrayList != null) {
                int[] nArray = new int[2];
                Iterator<int[]> iterator = arrayList.iterator();
                this.setValue(nArray, xPathDFA, n2);
                while (iterator.hasNext()) {
                    int[] nArray2 = iterator.next();
                    if (!this.equals(nArray, nArray2)) continue;
                    return true;
                }
            }
            return false;
        }

        public void clear() {
            this.fMap.clear();
        }

        private void setValue(int[] nArray, XPathDFA xPathDFA, int n2) {
            nArray[0] = xPathDFA.id();
            nArray[1] = n2;
        }

        private boolean equals(int[] nArray, int[] nArray2) {
            return nArray[0] == nArray2[0] && nArray[1] == nArray2[1];
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class MatcherInfoPool {
        private MatcherInfo head;

        private MatcherInfoPool() {
        }

        public MatcherInfo matcherInfo() {
            if (this.head == null) {
                return new MatcherInfo();
            }
            MatcherInfo matcherInfo = this.head;
            this.head = this.head.fNext;
            return matcherInfo;
        }

        public void returnMatcherInfo(MatcherInfo matcherInfo) {
            matcherInfo.fNext = this.head;
            this.head = matcherInfo;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class MatcherInfo {
        public XSElementDeclaration fElement;
        public IDCSymbol fIDCSymbol;
        public XPathDFA fXPathDFA;
        public int fOldState;
        public int fCurrentState;
        public int fFieldIndex = -1;
        public MatcherInfo fNext;

        private MatcherInfo() {
        }

        public void setValues(XSElementDeclaration xSElementDeclaration, IDCSymbol iDCSymbol, XPathDFA xPathDFA, int n2, int n3, int n4) {
            this.fElement = xSElementDeclaration;
            this.fIDCSymbol = iDCSymbol;
            this.fXPathDFA = xPathDFA;
            this.fOldState = n2;
            this.fCurrentState = n3;
            this.fFieldIndex = n4;
        }

        public boolean isSelector() {
            return this.fFieldIndex == -1;
        }
    }
}

