/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.converter;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.idc.IDCHandler;
import com.ibm.xml.xlxp.idc.IDCSymbol;
import com.ibm.xml.xlxp.internal.s1.converter.DVFactory;
import com.ibm.xml.xlxp.internal.s1.converter.IDCInstructionBuilder;
import com.ibm.xml.xlxp.internal.s1.converter.IDCMatcher;
import com.ibm.xml.xlxp.internal.s1.converter.SimpleTypeUtil;
import com.ibm.xml.xlxp.internal.s1.converter.ValueInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.grammar.Attribute;
import com.ibm.xml.xlxp.internal.s1.grammar.Element;
import com.ibm.xml.xlxp.internal.s1.grammar.ElementType;
import com.ibm.xml.xlxp.internal.s1.grammar.Grammar;
import com.ibm.xml.xlxp.internal.s1.grammar.NamedDeclaration;
import com.ibm.xml.xlxp.internal.s1.grammar.Wildcard;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.util.BitSet;
import com.ibm.xml.xlxp.internal.s1.validation.idc.StartIDC;
import com.ibm.xml.xml4j.api.s1.xs.ShortList;
import com.ibm.xml.xml4j.api.s1.xs.StringList;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeUse;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSIDCDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSModel;
import com.ibm.xml.xml4j.api.s1.xs.XSModelGroup;
import com.ibm.xml.xml4j.api.s1.xs.XSNamedMap;
import com.ibm.xml.xml4j.api.s1.xs.XSObject;
import com.ibm.xml.xml4j.api.s1.xs.XSObjectList;
import com.ibm.xml.xml4j.api.s1.xs.XSParticle;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTerm;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSWildcard;
import com.ibm.xml.xml4j.internal.s1.impl.dv.xs.XSSimpleTypeDecl;
import com.ibm.xml.xml4j.internal.s1.impl.xs.SchemaGrammar;
import com.ibm.xml.xml4j.internal.s1.impl.xs.util.XSObjectListImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class Converter {
    private static final Logger logger = LoggerUtil.getLogger(Converter.class);
    protected final boolean fValidating;
    private static final int UNBOUNDED = -1;
    protected static final String URI_XSD = "http://www.w3.org/2001/XMLSchema";
    protected static final String NAME_ANYTYPE = "anyType";
    private static final String NAME_ANYURI = "anyURI";
    private static final String NAME_BOOLEAN = "boolean";
    private static final String NAME_QNAME = "QName";
    private static final String NAME_ID = "ID";
    private static final String NAME_STRING = "string";
    private static final String URI_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String NAME_TYPE = "type";
    private static final String NAME_NIL = "nil";
    private static final String NAME_SL = "schemaLocation";
    private static final String NAME_NSL = "noNamespaceSchemaLocation";
    private static final XSAttributeDeclaration XSI_TYPE_DECL;
    private static final XSAttributeDeclaration XSI_NIL_DECL;
    private static final XSAttributeDeclaration XSI_NONAMESPACESCHEMALOCATION_DECL;
    private static final XSAttributeDeclaration XSI_SCHEMALOCATION_DECL;
    private static final ArrayList EMPTY_VECTOR;
    protected final HashMap fAtts = new HashMap();
    protected final HashMap fUses = new HashMap();
    protected final HashMap fElems = new HashMap();
    protected final HashMap fElemIDCs = new HashMap();
    protected final HashMap fIDCBuilders = new HashMap();
    protected final HashMap fElemCopies = new HashMap();
    protected final HashMap fCMs = new HashMap();
    protected final HashMap<XSTypeDefinition, TypeValidator> fSTs = new HashMap();
    protected final HashMap fWCs = new HashMap();
    protected final HashMap fWCCopies = new HashMap();
    protected final NodePool fNodes = new NodePool();
    protected final ArrayList fGlobalTypes = new ArrayList();
    protected final HashMap fSimpleTypes = new HashMap();
    protected final HashMap fBuiltInTypes = new HashMap();
    protected final HashMap fDerivedTypeSets = new HashMap();
    protected final HashMap fDerivedTypeBitSets = new HashMap();
    protected HashMap fWCDecls = new HashMap();
    protected final ArrayList fPendingCMs = new ArrayList();
    protected final HashMap fSeen = new HashMap();
    protected final ArrayList fAllElems = new ArrayList();
    protected final ArrayList fAllOpts = new ArrayList();
    protected final HashMap<XSTypeDefinition, Integer> fGlobalTypeIndices = new HashMap();
    protected XSModel fXSModel;
    public boolean collapsedDuplicateDeclaration;
    private DVFactory fDVFactory;
    protected SimpleTypeUtil fTypeUtil;
    protected Attribute[] fDefaultAttrs;
    protected int fCount;
    protected IDCHandler fIDCHandler;
    protected final HashMap<String, String> fInternedStrings = new HashMap();

    public Converter() {
        this(true);
    }

    public Converter(boolean bl) {
        this.fValidating = bl;
    }

    public Grammar convert(XSModel xSModel, DVFactory dVFactory, String string2, String string3) throws ConverterException {
        return this.convert(xSModel, dVFactory, string2, string3, new Grammar());
    }

    protected Grammar convert(XSModel xSModel, DVFactory dVFactory, String string2, String string3, Grammar grammar) throws ConverterException {
        SimpleTypeUtil simpleTypeUtil = new SimpleTypeUtil(this.fInternedStrings);
        this.prepare(xSModel, dVFactory, simpleTypeUtil);
        grammar.xsModel = xSModel;
        this.analyzeSchema();
        this.convertGlobalSimpleTypes(0);
        this.prepareDefaultAttributes();
        this.convertGlobalAttributes();
        this.convertGlobalElements();
        this.convertGlobalTypes(0);
        this.processPendingCMs(0);
        this.fillInTypeHeirarchy();
        this.fillGrammar(grammar, string2, string3);
        this.finish();
        return grammar;
    }

    protected void prepare(XSModel xSModel, DVFactory dVFactory, SimpleTypeUtil simpleTypeUtil) {
        this.fXSModel = xSModel;
        this.fDVFactory = dVFactory;
        this.fTypeUtil = simpleTypeUtil;
        if (this.fValidating) {
            this.fIDCHandler = new IDCHandler();
        }
    }

    protected void finish() {
        this.fAtts.clear();
        this.fUses.clear();
        this.fElems.clear();
        this.fElemIDCs.clear();
        this.fIDCBuilders.clear();
        this.fElemCopies.clear();
        this.fCMs.clear();
        this.fSTs.clear();
        this.fWCs.clear();
        this.fWCCopies.clear();
        this.fNodes.reset();
        this.fXSModel = null;
        this.fDefaultAttrs = null;
        this.fGlobalTypes.clear();
        this.fGlobalTypeIndices.clear();
        this.fSimpleTypes.clear();
        this.fBuiltInTypes.clear();
        this.fDerivedTypeSets.clear();
        this.fDerivedTypeBitSets.clear();
        this.fWCDecls.clear();
        this.fPendingCMs.clear();
        this.fSeen.clear();
        this.fTypeUtil = null;
        this.fIDCHandler = null;
    }

    protected static Integer getInteger(int n2) {
        return n2;
    }

    protected void analyzeSchema() {
        XSNamedMap xSNamedMap = this.fXSModel.getComponents((short)3);
        this.sortTypes(xSNamedMap);
        XSTypeDefinition xSTypeDefinition = this.fXSModel.getTypeDefinition(NAME_ANYTYPE, URI_XSD);
        this.fDerivedTypeSets.put(xSTypeDefinition, new HashSet());
        this.computeTypeHierarchy(0);
        this.computeDerivedTypeBitsets();
        this.fBuiltInTypes.put(Converter.getInteger(1), this.fXSModel.getTypeDefinition("anySimpleType", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(2), this.fXSModel.getTypeDefinition(NAME_STRING, URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(3), this.fXSModel.getTypeDefinition(NAME_BOOLEAN, URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(4), this.fXSModel.getTypeDefinition("decimal", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(5), this.fXSModel.getTypeDefinition("float", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(6), this.fXSModel.getTypeDefinition("double", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(7), this.fXSModel.getTypeDefinition("duration", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(8), this.fXSModel.getTypeDefinition("dateTime", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(9), this.fXSModel.getTypeDefinition("time", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(10), this.fXSModel.getTypeDefinition("date", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(11), this.fXSModel.getTypeDefinition("gYearMonth", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(12), this.fXSModel.getTypeDefinition("gYear", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(13), this.fXSModel.getTypeDefinition("gMonthDay", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(14), this.fXSModel.getTypeDefinition("gDay", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(15), this.fXSModel.getTypeDefinition("gMonth", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(16), this.fXSModel.getTypeDefinition("hexBinary", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(17), this.fXSModel.getTypeDefinition("base64Binary", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(18), this.fXSModel.getTypeDefinition(NAME_ANYURI, URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(19), this.fXSModel.getTypeDefinition(NAME_QNAME, URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(20), this.fXSModel.getTypeDefinition("NOTATION", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(21), this.fXSModel.getTypeDefinition("normalizedString", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(22), this.fXSModel.getTypeDefinition("token", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(23), this.fXSModel.getTypeDefinition("language", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(24), this.fXSModel.getTypeDefinition("NMTOKEN", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(25), this.fXSModel.getTypeDefinition("Name", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(26), this.fXSModel.getTypeDefinition("NCName", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(27), this.fXSModel.getTypeDefinition(NAME_ID, URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(28), this.fXSModel.getTypeDefinition("IDREF", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(29), this.fXSModel.getTypeDefinition("ENTITY", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(30), this.fXSModel.getTypeDefinition("integer", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(31), this.fXSModel.getTypeDefinition("nonPositiveInteger", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(32), this.fXSModel.getTypeDefinition("negativeInteger", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(33), this.fXSModel.getTypeDefinition("long", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(34), this.fXSModel.getTypeDefinition("int", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(35), this.fXSModel.getTypeDefinition("short", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(36), this.fXSModel.getTypeDefinition("byte", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(37), this.fXSModel.getTypeDefinition("nonNegativeInteger", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(38), this.fXSModel.getTypeDefinition("unsignedLong", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(39), this.fXSModel.getTypeDefinition("unsignedInt", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(40), this.fXSModel.getTypeDefinition("unsignedShort", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(41), this.fXSModel.getTypeDefinition("unsignedByte", URI_XSD));
        this.fBuiltInTypes.put(Converter.getInteger(42), this.fXSModel.getTypeDefinition("positiveInteger", URI_XSD));
    }

    protected void sortTypes(XSNamedMap xSNamedMap) {
        int n2 = xSNamedMap.getLength();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)xSNamedMap.item(i);
            this.fGlobalTypes.add(xSTypeDefinition);
            this.fGlobalTypeIndices.put(xSTypeDefinition, n3++);
        }
    }

    protected final void computeTypeHierarchy(int n2) {
        XSTypeDefinition xSTypeDefinition = this.fXSModel.getTypeDefinition(NAME_ANYTYPE, URI_XSD);
        HashSet hashSet = (HashSet)this.fDerivedTypeSets.get(xSTypeDefinition);
        int n3 = this.fGlobalTypes.size();
        for (int i = n2; i < n3; ++i) {
            XSTypeDefinition xSTypeDefinition2 = (XSTypeDefinition)this.fGlobalTypes.get(i);
            int n4 = 0;
            for (XSTypeDefinition xSTypeDefinition3 = xSTypeDefinition2.getBaseType(); xSTypeDefinition3 != null && xSTypeDefinition3 != xSTypeDefinition; xSTypeDefinition3 = xSTypeDefinition3.getBaseType()) {
                if (xSTypeDefinition3.getAnonymous() || !(xSTypeDefinition3 instanceof XSSimpleTypeDefinition) && (((XSComplexTypeDefinition)xSTypeDefinition3).getProhibitedSubstitutions() & (n4 |= xSTypeDefinition2 instanceof XSComplexTypeDefinition ? (int)((XSComplexTypeDefinition)xSTypeDefinition2).getDerivationMethod() : 2)) != 0) continue;
                HashSet<Integer> hashSet2 = (HashSet<Integer>)this.fDerivedTypeSets.get(xSTypeDefinition3);
                if (hashSet2 == null) {
                    hashSet2 = new HashSet<Integer>();
                    this.fDerivedTypeSets.put(xSTypeDefinition3, hashSet2);
                }
                hashSet2.add(Converter.getInteger(i));
            }
            hashSet.add(Converter.getInteger(i));
        }
    }

    protected final void computeDerivedTypeBitsets() {
        ArrayList arrayList = this.fGlobalTypes;
        int n2 = arrayList.size();
        int n3 = this.fGlobalTypes.size();
        for (int i = 0; i < n2; ++i) {
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)arrayList.get(i);
            HashSet hashSet = (HashSet)this.fDerivedTypeSets.get(xSTypeDefinition);
            this.createDerivedTypeBitset(hashSet, xSTypeDefinition, n3, i);
        }
    }

    protected final void createDerivedTypeBitset(HashSet hashSet, XSTypeDefinition xSTypeDefinition, int n2, int n3) {
        if (hashSet != null) {
            BitSet bitSet = this.getDerivedTypeBitset(xSTypeDefinition, n2);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                bitSet.setBit((Integer)iterator.next());
            }
            bitSet.setBit(n3);
        }
    }

    protected BitSet getDerivedTypeBitset(XSTypeDefinition xSTypeDefinition, int n2) {
        BitSet bitSet = new BitSet(n2);
        this.fDerivedTypeBitSets.put(xSTypeDefinition, bitSet);
        return bitSet;
    }

    private void prepareDefaultAttributes() {
        this.fDefaultAttrs = new Attribute[4];
        XSTypeDefinition xSTypeDefinition = this.fXSModel.getTypeDefinition(NAME_QNAME, URI_XSD);
        TypeValidator typeValidator = this.fSTs.get(xSTypeDefinition);
        this.fDefaultAttrs[2] = new Attribute(URI_XSI, NAME_TYPE, typeValidator, null, false, XSI_TYPE_DECL);
        xSTypeDefinition = this.fXSModel.getTypeDefinition(NAME_BOOLEAN, URI_XSD);
        typeValidator = this.fSTs.get(xSTypeDefinition);
        this.fDefaultAttrs[3] = new Attribute(URI_XSI, NAME_NIL, typeValidator, null, false, XSI_NIL_DECL);
        xSTypeDefinition = this.fXSModel.getTypeDefinition(NAME_ANYURI, URI_XSD);
        typeValidator = this.fSTs.get(xSTypeDefinition);
        this.fDefaultAttrs[0] = new Attribute(URI_XSI, NAME_NSL, typeValidator, null, false, XSI_NONAMESPACESCHEMALOCATION_DECL);
        typeValidator = this.fDVFactory.createListType(URI_XSI, NAME_SL, typeValidator, this.fTypeUtil);
        typeValidator.xsTypeDefinition = XSI_SCHEMALOCATION_DECL.getTypeDefinition();
        this.fDefaultAttrs[1] = new Attribute(URI_XSI, NAME_SL, typeValidator, null, false, XSI_SCHEMALOCATION_DECL);
    }

    protected void convertGlobalAttributes() {
        XSNamedMap xSNamedMap = this.fXSModel.getComponents((short)1);
        int n2 = xSNamedMap.getLength();
        for (int i = 0; i < n2; ++i) {
            XSAttributeDeclaration xSAttributeDeclaration = (XSAttributeDeclaration)xSNamedMap.item(i);
            this.convertGAttr(xSAttributeDeclaration);
        }
    }

    protected void convertGlobalElements() {
        XSNamedMap xSNamedMap = this.fXSModel.getComponents((short)2);
        int n2 = xSNamedMap.getLength();
        for (int i = 0; i < n2; ++i) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSNamedMap.item(i);
            this.convertElem(xSElementDeclaration);
        }
    }

    protected void convertGlobalSimpleTypes(int n2) {
        int n3 = this.fGlobalTypes.size();
        for (int i = n2; i < n3; ++i) {
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)this.fGlobalTypes.get(i);
            if (!(xSTypeDefinition instanceof XSSimpleTypeDefinition)) continue;
            this.convertSType((XSSimpleTypeDefinition)xSTypeDefinition);
        }
    }

    protected void convertGlobalTypes(int n2) {
        for (int i = n2; i < this.fGlobalTypes.size(); ++i) {
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)this.fGlobalTypes.get(i);
            this.convertType(xSTypeDefinition, i);
        }
    }

    protected void processPendingCMs(int n2) throws ConverterException {
        int n3 = this.fPendingCMs.size();
        for (int i = n2; i < n3; ++i) {
            ElementType elementType = (ElementType)this.fPendingCMs.get(i);
            XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)elementType.xsTypeDefinition;
            XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
            if (xSParticle.getTerm() instanceof XSModelGroup && ((XSModelGroup)xSParticle.getTerm()).getCompositor() == 3) {
                this.convertAll(elementType, xSComplexTypeDefinition);
                continue;
            }
            this.convertDFA(elementType, xSComplexTypeDefinition);
            if (this.fValidating) continue;
            this.convertNVAll(elementType, xSComplexTypeDefinition);
        }
    }

    protected void fillInTypeHeirarchy() {
        XSTypeDefinition xSTypeDefinition;
        NamedDeclaration namedDeclaration;
        XSTypeDefinition xSTypeDefinition2;
        Set set2 = this.fCMs.entrySet();
        for (Map.Entry entry : set2) {
            xSTypeDefinition2 = (XSTypeDefinition)entry.getKey();
            namedDeclaration = (ElementType)entry.getValue();
            if (namedDeclaration.baseType != null) continue;
            xSTypeDefinition = xSTypeDefinition2.getBaseType();
            namedDeclaration.baseType = xSTypeDefinition != null ? (ElementType)this.fCMs.get(xSTypeDefinition) : namedDeclaration;
        }
        set2 = this.fSimpleTypes.entrySet();
        for (Map.Entry entry : set2) {
            xSTypeDefinition2 = (XSSimpleTypeDefinition)entry.getKey();
            namedDeclaration = (TypeValidator)entry.getValue();
            if (((TypeValidator)namedDeclaration).baseType != null) continue;
            xSTypeDefinition = xSTypeDefinition2.getBaseType();
            TypeValidator typeValidator = xSTypeDefinition != null ? (TypeValidator)this.fSimpleTypes.get(xSTypeDefinition) : null;
            ((TypeValidator)namedDeclaration).baseType = typeValidator != null ? typeValidator : namedDeclaration;
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)this.fBuiltInTypes.get(Converter.getInteger(xSTypeDefinition2.getBuiltInKind()));
            ((TypeValidator)namedDeclaration).builtInType = xSSimpleTypeDefinition != null ? (TypeValidator)this.fSimpleTypes.get(xSSimpleTypeDefinition) : null;
        }
    }

    protected Element[] rootElements(String string2, String string3) throws ConverterException {
        Element[] elementArray = null;
        if (string3 != null) {
            XSElementDeclaration xSElementDeclaration = this.fXSModel.getElementDeclaration(string2, string3);
            if (xSElementDeclaration == null) {
                throw new ConverterException("Can't find the specified root element.");
            }
            elementArray = new Element[]{(Element)this.fElems.get(xSElementDeclaration)};
        } else {
            XSNamedMap xSNamedMap = this.fXSModel.getComponents((short)2);
            int n2 = xSNamedMap.getLength();
            for (int i = 0; i < n2; ++i) {
                XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSNamedMap.item(i);
                this.fAllElems.add(this.fElems.get(xSElementDeclaration));
            }
            n2 = this.fAllElems.size();
            if (n2 > 0) {
                elementArray = this.fAllElems.toArray(new Element[n2]);
            }
            this.fAllElems.clear();
        }
        return elementArray;
    }

    private Wildcard[] rootWildcards() {
        Wildcard[] wildcardArray = null;
        Wildcard wildcard = new Wildcard(1, true, null, null);
        wildcardArray = new Wildcard[]{wildcard};
        return wildcardArray;
    }

    private Grammar fillGrammar(Grammar grammar, String string2, String string3) throws ConverterException {
        Element[] elementArray = this.rootElements(string2, string3);
        Wildcard[] wildcardArray = this.rootWildcards();
        grammar.root = new ElementType.DFAState(false, elementArray, null, wildcardArray, null);
        int n2 = this.fGlobalTypes.size();
        Grammar.GlobalTypesInfo globalTypesInfo = new Grammar.GlobalTypesInfo();
        globalTypesInfo.globalTypes = new ElementType[n2];
        for (int i = 0; i < n2; ++i) {
            ElementType elementType;
            globalTypesInfo.globalTypes[elementType.index] = elementType = (ElementType)this.fCMs.get(this.fGlobalTypes.get(i));
        }
        grammar.setGlobalTypes(globalTypesInfo);
        this.handleIDC(grammar);
        return grammar;
    }

    protected void handleIDC(Grammar grammar) {
        if (this.fIDCHandler != null) {
            this.fIDCHandler.renumberXPathIds();
            new IDCMatcher(this).match(this.fElemIDCs);
            this.fillInIDCInstructions();
            List list = this.fIDCHandler.xpathDFAList();
            int n2 = this.fIDCHandler.idcCount();
            if (list != null && n2 > 0) {
                grammar.idcCount = n2;
                grammar.setXpathDFAs(IDCInstructionBuilder.createXPathDFAs(list, this.fTypeUtil, n2));
            }
        }
    }

    private void fillInIDCInstructions() {
        for (Map.Entry entry : this.fIDCBuilders.entrySet()) {
            Object k = entry.getKey();
            IDCInstructionBuilder iDCInstructionBuilder = (IDCInstructionBuilder)entry.getValue();
            if (k instanceof XSElementDeclaration) {
                this.fillInIDCInstructions(this.getElement((XSElementDeclaration)k), iDCInstructionBuilder);
                continue;
            }
            this.fillInIDCInstructions(this.getWildcard((XSWildcard)k), iDCInstructionBuilder);
        }
    }

    private void fillInIDCInstructions(Element element22, IDCInstructionBuilder iDCInstructionBuilder) {
        this.fillInIDCInstructions0(element22, iDCInstructionBuilder);
        HashSet hashSet = (HashSet)this.fElemCopies.get(element22);
        if (hashSet != null) {
            for (Element element22 : hashSet) {
                this.fillInIDCInstructions0(element22, iDCInstructionBuilder);
            }
        }
    }

    private void fillInIDCInstructions(Wildcard wildcard2, IDCInstructionBuilder iDCInstructionBuilder) {
        this.fillInIDCInstructions0(wildcard2, iDCInstructionBuilder);
        HashSet hashSet = (HashSet)this.fWCCopies.get(wildcard2);
        if (hashSet != null) {
            for (Wildcard wildcard2 : hashSet) {
                this.fillInIDCInstructions0(wildcard2, iDCInstructionBuilder);
            }
        }
    }

    private void fillInIDCInstructions0(Element element2, IDCInstructionBuilder iDCInstructionBuilder) {
        StartIDC startIDC;
        if (iDCInstructionBuilder.hasActions(false)) {
            startIDC = iDCInstructionBuilder.createStartIDCInstruction(this.fTypeUtil, false);
            if (element2.idcActions == null) {
                element2.idcActions = new ArrayList();
            }
            element2.idcActions.add(startIDC);
        }
        if (iDCInstructionBuilder.hasActions(true)) {
            startIDC = iDCInstructionBuilder.createStartIDCInstruction(this.fTypeUtil, true);
            if (element2.idcActionsNil == null) {
                element2.idcActionsNil = new ArrayList();
            }
            element2.idcActionsNil.add(startIDC);
        }
    }

    private void fillInIDCInstructions0(Wildcard wildcard, IDCInstructionBuilder iDCInstructionBuilder) {
        StartIDC startIDC = iDCInstructionBuilder.createStartIDCInstruction(this.fTypeUtil, false);
        if (wildcard.idcActions == null) {
            wildcard.idcActions = new ArrayList();
        }
        wildcard.idcActions.add(startIDC);
    }

    protected Wildcard convertWC(XSWildcard xSWildcard, XSComplexTypeDefinition xSComplexTypeDefinition) {
        return this.convertWC(xSWildcard, xSWildcard.getProcessContents());
    }

    protected void convertGAttr(XSAttributeDeclaration xSAttributeDeclaration) {
        Attribute attribute2 = this.convertLAttr(xSAttributeDeclaration);
        this.fAtts.put(xSAttributeDeclaration, attribute2);
    }

    protected Attribute convertLAttr(XSAttributeDeclaration xSAttributeDeclaration) {
        String string2 = xSAttributeDeclaration.getNamespace();
        String string3 = xSAttributeDeclaration.getName();
        string2 = string2 != null ? this.fTypeUtil.internString(string2) : "";
        string3 = string3 != null ? this.fTypeUtil.internString(string3) : "";
        XSSimpleTypeDefinition xSSimpleTypeDefinition = xSAttributeDeclaration.getTypeDefinition();
        TypeValidator typeValidator = this.convertSType(xSSimpleTypeDefinition);
        short s = xSAttributeDeclaration.getConstraintType();
        boolean bl = s != 0;
        boolean bl2 = s == 2;
        Object object2 = bl ? xSAttributeDeclaration.getActualVC() : null;
        String string4 = bl ? xSAttributeDeclaration.getConstraintValue() : null;
        ValidatedInfo validatedInfo = bl ? this.getActualValue(xSSimpleTypeDefinition, object2, string4, xSAttributeDeclaration.getActualVCType(), xSAttributeDeclaration.getItemValueTypes()) : null;
        Attribute attribute2 = new Attribute(string2, string3, typeValidator, validatedInfo, bl2, xSAttributeDeclaration);
        return attribute2;
    }

    protected Attribute convertAttrUse(XSAttributeUse xSAttributeUse) {
        ValidatedInfo validatedInfo;
        Attribute attribute2 = (Attribute)this.fUses.get(xSAttributeUse);
        if (attribute2 != null) {
            return attribute2;
        }
        XSAttributeDeclaration xSAttributeDeclaration = xSAttributeUse.getAttrDeclaration();
        XSSimpleTypeDefinition xSSimpleTypeDefinition = xSAttributeDeclaration.getTypeDefinition();
        short s = xSAttributeUse.getConstraintType();
        boolean bl = s != 0;
        boolean bl2 = s == 2;
        Object object2 = bl ? xSAttributeUse.getActualVC() : null;
        String string2 = bl ? xSAttributeUse.getConstraintValue() : null;
        ValidatedInfo validatedInfo2 = validatedInfo = bl ? this.getActualValue(xSSimpleTypeDefinition, object2, string2, xSAttributeUse.getActualVCType(), xSAttributeUse.getItemValueTypes()) : null;
        if (xSAttributeDeclaration.getScope() == 1) {
            Attribute attribute3 = (Attribute)this.fAtts.get(xSAttributeDeclaration);
            attribute2 = bl ? this.cloneAttribute(attribute3, validatedInfo, bl2) : attribute3;
        } else {
            String string3 = xSAttributeDeclaration.getNamespace();
            String string4 = xSAttributeDeclaration.getName();
            string3 = string3 != null ? this.fTypeUtil.internString(string3) : "";
            string4 = string4 != null ? this.fTypeUtil.internString(string4) : "";
            TypeValidator typeValidator = this.convertSType(xSSimpleTypeDefinition);
            if (!bl) {
                s = xSAttributeDeclaration.getConstraintType();
                bl = s != 0;
                bl2 = s == 2;
                object2 = bl ? xSAttributeDeclaration.getActualVC() : null;
                string2 = bl ? xSAttributeDeclaration.getConstraintValue() : null;
                validatedInfo = bl ? this.getActualValue(xSSimpleTypeDefinition, object2, string2, xSAttributeDeclaration.getActualVCType(), xSAttributeDeclaration.getItemValueTypes()) : null;
            }
            attribute2 = new Attribute(string3, string4, typeValidator, validatedInfo, bl2, xSAttributeDeclaration);
        }
        this.fUses.put(xSAttributeUse, attribute2);
        return attribute2;
    }

    protected Element convertElem(XSElementDeclaration xSElementDeclaration) {
        Object object2;
        Element element2 = (Element)this.fElems.get(xSElementDeclaration);
        if (element2 != null) {
            return element2;
        }
        String string2 = xSElementDeclaration.getNamespace();
        String string3 = xSElementDeclaration.getName();
        string2 = string2 != null ? this.fTypeUtil.internString(string2) : "";
        string3 = string3 != null ? this.fTypeUtil.internString(string3) : "";
        short s = xSElementDeclaration.getDisallowedSubstitutions();
        boolean bl = xSElementDeclaration.getNillable();
        boolean bl2 = xSElementDeclaration.getAbstract();
        short s2 = xSElementDeclaration.getConstraintType();
        boolean bl3 = s2 != 0;
        boolean bl4 = s2 == 2;
        XSTypeDefinition xSTypeDefinition = xSElementDeclaration.getTypeDefinition();
        Object object3 = bl3 ? xSElementDeclaration.getActualVC() : null;
        String string4 = bl3 ? xSElementDeclaration.getConstraintValue() : null;
        ValidatedInfo validatedInfo = null;
        if (bl3) {
            object2 = xSTypeDefinition instanceof XSSimpleTypeDefinition ? (XSSimpleTypeDefinition)xSTypeDefinition : ((XSComplexTypeDefinition)xSTypeDefinition).getSimpleType();
            validatedInfo = this.getActualValue((XSSimpleTypeDefinition)object2, object3, string4, xSElementDeclaration.getActualVCType(), xSElementDeclaration.getItemValueTypes());
        }
        object2 = this.getXsiTypes(xSTypeDefinition, s, object3);
        BitSet bitSet = this.getVcSafeTypes((BitSet)object2, bl3, object3, string4);
        element2 = new Element(string2, string3, null, validatedInfo, bl4, (BitSet)object2, bitSet, bl, bl2, xSElementDeclaration);
        if (this.fIDCHandler != null) {
            XSNamedMap xSNamedMap = xSElementDeclaration.getIdentityConstraints();
            for (int i = 0; i < xSNamedMap.getLength(); ++i) {
                XSIDCDefinition xSIDCDefinition = (XSIDCDefinition)xSNamedMap.item(i);
                ArrayList<IDCSymbol> arrayList = (ArrayList<IDCSymbol>)this.fElemIDCs.get(xSElementDeclaration);
                if (arrayList == null) {
                    arrayList = new ArrayList<IDCSymbol>();
                    this.fElemIDCs.put(xSElementDeclaration, arrayList);
                }
                arrayList.add(this.fIDCHandler.findOrCreate(xSIDCDefinition));
            }
        }
        this.fElems.put(xSElementDeclaration, element2);
        element2.type = this.convertType(xSTypeDefinition, -1);
        return element2;
    }

    protected BitSet getXsiTypes(XSTypeDefinition xSTypeDefinition, short s, Object object2) {
        int n2;
        BitSet bitSet = null;
        bitSet = xSTypeDefinition instanceof XSSimpleTypeDefinition && ((XSSimpleTypeDefinition)xSTypeDefinition).getVariety() == 3 ? this.processUnionSubtypes((XSSimpleTypeDefinition)xSTypeDefinition) : (BitSet)this.fDerivedTypeBitSets.get(xSTypeDefinition);
        if (bitSet != null && (n2 = this.moreBlock(s, xSTypeDefinition)) != 0) {
            bitSet = this.removeBlocked(bitSet, n2, xSTypeDefinition);
        }
        return bitSet;
    }

    protected BitSet getVcSafeTypes(BitSet bitSet, boolean bl, Object object2, String string2) {
        return bitSet != null && bl ? this.removeBadVCs(bitSet, object2, string2) : null;
    }

    protected BitSet processUnionSubtypes(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        BitSet bitSet = new BitSet(this.fGlobalTypes.size());
        this.processUnionSubtypes(xSSimpleTypeDefinition, bitSet);
        return bitSet;
    }

    protected void processUnionSubtypes(XSSimpleTypeDefinition xSSimpleTypeDefinition, BitSet bitSet) {
        XSObjectList xSObjectList = xSSimpleTypeDefinition.getMemberTypes();
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = null;
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            xSSimpleTypeDefinition2 = (XSSimpleTypeDefinition)xSObjectList.item(i);
            if (xSSimpleTypeDefinition2.getVariety() == 8) {
                this.processUnionSubtypes(xSSimpleTypeDefinition2, bitSet);
                continue;
            }
            BitSet bitSet2 = (BitSet)this.fDerivedTypeBitSets.get(xSSimpleTypeDefinition2);
            if (bitSet2 != null) {
                bitSet.setBits(bitSet2);
                continue;
            }
            Integer n2 = this.fGlobalTypeIndices.get(xSSimpleTypeDefinition2);
            if (n2 == null) continue;
            bitSet.setBit(n2);
        }
    }

    protected int moreBlock(int n2, XSTypeDefinition xSTypeDefinition) {
        int n3 = xSTypeDefinition instanceof XSComplexTypeDefinition ? ((XSComplexTypeDefinition)xSTypeDefinition).getProhibitedSubstitutions() : 0;
        int n4 = 3;
        return (n2 &= n4) & ~(n3 &= n4);
    }

    protected BitSet removeBlocked(BitSet bitSet, int n2, XSTypeDefinition xSTypeDefinition) {
        BitSet bitSet2 = null;
        boolean bl = false;
        int n3 = bitSet.getLength();
        for (int i = 0; i < n3; ++i) {
            if (!bitSet.getBit(i)) continue;
            boolean bl2 = true;
            for (XSTypeDefinition xSTypeDefinition2 = (XSTypeDefinition)this.fGlobalTypes.get(i); xSTypeDefinition2 != xSTypeDefinition && xSTypeDefinition2 != null && bl2; xSTypeDefinition2 = xSTypeDefinition2.getBaseType()) {
                if (xSTypeDefinition2 instanceof XSSimpleTypeDefinition) {
                    if ((n2 & 2) == 0) continue;
                    bl2 = false;
                    continue;
                }
                short s = ((XSComplexTypeDefinition)xSTypeDefinition2).getDerivationMethod();
                if ((n2 & s) == 0) continue;
                bl2 = false;
            }
            if (bl2) {
                if (bitSet2 == null) {
                    bitSet2 = new BitSet(n3);
                }
                bitSet2.setBit(i);
                continue;
            }
            bl = true;
        }
        return bl ? bitSet2 : bitSet;
    }

    protected BitSet removeBadVCs(BitSet bitSet, Object object2, String string2) {
        BitSet bitSet2 = null;
        boolean bl = false;
        int n2 = bitSet.getLength();
        for (int i = 0; i < n2; ++i) {
            if (!bitSet.getBit(i)) continue;
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)this.fGlobalTypes.get(i);
            XSSimpleTypeDecl xSSimpleTypeDecl = null;
            xSSimpleTypeDecl = xSTypeDefinition instanceof XSSimpleTypeDecl ? (XSSimpleTypeDecl)xSTypeDefinition : (XSSimpleTypeDecl)((XSComplexTypeDefinition)xSTypeDefinition).getSimpleType();
            boolean bl2 = true;
            try {
                if (xSSimpleTypeDecl != null) {
                    xSSimpleTypeDecl.validate(object2, null, null);
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
            if (bl2) {
                if (bitSet2 == null) {
                    bitSet2 = new BitSet(n2);
                }
                bitSet2.setBit(i);
                continue;
            }
            bl = true;
        }
        return bl ? bitSet2 : bitSet;
    }

    protected ElementType convertType(XSTypeDefinition xSTypeDefinition, int n2) {
        int n3;
        int n4;
        Attribute[] attributeArray;
        ElementType elementType = (ElementType)this.fCMs.get(xSTypeDefinition);
        if (elementType != null) {
            return elementType;
        }
        String string2 = xSTypeDefinition.getNamespace();
        String string3 = xSTypeDefinition.getName();
        string2 = string2 != null ? this.fTypeUtil.internString(string2) : "";
        String string4 = string3 = string3 != null ? this.fTypeUtil.internString(string3) : "";
        if (n2 == -1 && this.fGlobalTypeIndices.containsKey(xSTypeDefinition)) {
            n2 = this.fGlobalTypeIndices.get(xSTypeDefinition);
        }
        if (xSTypeDefinition instanceof XSSimpleTypeDefinition) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition;
            TypeValidator typeValidator = this.convertSType(xSSimpleTypeDefinition);
            boolean bl = this.allowEmpty(xSSimpleTypeDefinition);
            elementType = new ElementType(string2, string3, n2, this.fCMs.size(), this.fDefaultAttrs, null, null, null, null, 0, null, 0, typeValidator, null, null, bl, null, false, xSTypeDefinition);
            this.fCMs.put(xSTypeDefinition, elementType);
            return elementType;
        }
        XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition;
        XSWildcard xSWildcard = xSComplexTypeDefinition.getAttributeWildcard();
        Wildcard wildcard = xSWildcard != null ? this.convertWC(xSWildcard, xSWildcard.getProcessContents()) : null;
        XSObjectList xSObjectList = xSComplexTypeDefinition.getAttributeUses();
        int n5 = xSObjectList.getLength();
        ArrayList arrayList = this.getWCDecls(xSWildcard, true);
        int n6 = arrayList.size();
        BitSet bitSet = null;
        int[] nArray = null;
        BitSet bitSet2 = null;
        int[] nArray2 = null;
        int n7 = -1;
        int n8 = n5 + n6 + 4;
        BitSet bitSet3 = null;
        if (n5 + n6 > 0) {
            int[] nArray3;
            XSObject xSObject;
            attributeArray = new Attribute[n8];
            System.arraycopy(this.fDefaultAttrs, 0, attributeArray, 0, 4);
            int[] nArray4 = null;
            n4 = 0;
            n3 = 4;
            int n9 = 0;
            while (n9 < n5) {
                xSObject = (XSAttributeUse)xSObjectList.item(n9);
                attributeArray[n3] = this.convertAttrUse((XSAttributeUse)xSObject);
                if (xSObject.getConstraintType() != 0 || xSObject.getAttrDeclaration().getConstraintType() != 0) {
                    if (bitSet == null) {
                        bitSet = new BitSet(n8);
                    }
                    bitSet.setBit(n3);
                    if (nArray4 == null || nArray4.length == n4) {
                        nArray3 = new int[n4 + 10];
                        if (nArray4 != null) {
                            System.arraycopy(nArray4, 0, nArray3, 0, n4);
                        }
                        nArray4 = nArray3;
                    }
                    nArray4[n4++] = n3;
                }
                if (xSObject.getRequired()) {
                    if (bitSet3 == null) {
                        bitSet3 = new BitSet(n8);
                    }
                    bitSet3.setBit(n3);
                }
                if (this.isID(xSObject.getAttrDeclaration().getTypeDefinition())) {
                    n7 = n3;
                }
                ++n9;
                ++n3;
            }
            n8 = n4;
            if (n8 > 0) {
                nArray = new int[n8];
                System.arraycopy(nArray4, 0, nArray, 0, n8);
                n4 = 0;
            }
            n9 = 0;
            while (n9 < n6) {
                xSObject = (XSAttributeDeclaration)arrayList.get(n9);
                attributeArray[n3] = (Attribute)this.fAtts.get(xSObject);
                if (this.isID(xSObject.getTypeDefinition())) {
                    if (bitSet2 == null) {
                        bitSet2 = new BitSet(n8);
                    }
                    bitSet2.setBit(n3);
                    if (nArray4 == null || nArray4.length == n4) {
                        nArray3 = new int[n4 + 10];
                        if (nArray4 != null) {
                            System.arraycopy(nArray4, 0, nArray3, 0, n4);
                        }
                        nArray4 = nArray3;
                    }
                    nArray4[n4++] = n3;
                }
                ++n9;
                ++n3;
            }
            n8 = n4;
            if (n8 > 0) {
                nArray2 = new int[n8];
                System.arraycopy(nArray4, 0, nArray2, 0, n8);
            }
        } else {
            attributeArray = this.fDefaultAttrs;
        }
        short s = xSComplexTypeDefinition.getContentType();
        if (s == 1) {
            TypeValidator typeValidator = this.convertSType(xSComplexTypeDefinition.getSimpleType());
            n3 = this.allowEmpty(xSComplexTypeDefinition.getSimpleType()) ? 1 : 0;
            elementType = new ElementType(string2, string3, n2, this.fCMs.size(), attributeArray, bitSet, nArray, bitSet2, nArray2, n7, wildcard, 3, typeValidator, null, null, n3 != 0, bitSet3, xSComplexTypeDefinition.getAbstract(), xSTypeDefinition);
            this.fCMs.put(xSTypeDefinition, elementType);
            return elementType;
        }
        n4 = s == 2 ? 2 : (s == 0 ? 0 : 3);
        elementType = new ElementType(string2, string3, n2, this.fCMs.size(), attributeArray, bitSet, nArray, bitSet2, nArray2, n7, wildcard, n4, null, null, null, true, bitSet3, xSComplexTypeDefinition.getAbstract(), xSTypeDefinition);
        this.fCMs.put(xSTypeDefinition, elementType);
        XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
        if (xSParticle != null) {
            this.convertParticle(xSParticle);
            this.fPendingCMs.add(elementType);
        }
        return elementType;
    }

    protected ArrayList getWCDecls(XSWildcard xSWildcard, boolean bl) {
        if (xSWildcard == null || xSWildcard.getProcessContents() == 2) {
            return EMPTY_VECTOR;
        }
        ArrayList<XSObject> arrayList = (ArrayList<XSObject>)this.fWCDecls.get(xSWildcard);
        if (arrayList != null) {
            return arrayList;
        }
        XSNamedMap xSNamedMap = bl ? this.fXSModel.getComponents((short)1) : this.fXSModel.getComponents((short)2);
        int n2 = xSNamedMap.getLength();
        for (int i = 0; i < n2; ++i) {
            XSObject xSObject = xSNamedMap.item(i);
            if (!Converter.wildcardAllows(xSWildcard, xSObject.getNamespace(), xSObject.getName())) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<XSObject>();
            }
            arrayList.add(xSObject);
        }
        if (arrayList == null) {
            arrayList = EMPTY_VECTOR;
        }
        this.fWCDecls.put(xSWildcard, arrayList);
        return arrayList;
    }

    static boolean wildcardAllows(XSWildcard xSWildcard, String string2, String string3) {
        short s = xSWildcard.getConstraintType();
        if (s == 1) {
            return true;
        }
        StringList stringList = xSWildcard.getNsConstraintList();
        if (stringList.contains(string2)) {
            return s == 3;
        }
        return s == 2;
    }

    protected void convertParticle(XSParticle xSParticle) {
        if (this.fSeen.get(xSParticle) != null) {
            return;
        }
        this.fSeen.put(xSParticle, xSParticle);
        XSTerm xSTerm = xSParticle.getTerm();
        if (this.fSeen.get(xSTerm) != null) {
            return;
        }
        if (xSTerm.getType() == 2) {
            this.fSeen.put(xSTerm, this.convertElem((XSElementDeclaration)xSTerm));
        } else if (xSTerm.getType() == 9) {
            XSWildcard xSWildcard = (XSWildcard)xSTerm;
            this.fSeen.put(xSTerm, this.convertWC(xSWildcard, xSWildcard.getProcessContents()));
        } else {
            this.fSeen.put(xSTerm, xSTerm);
            XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
            XSObjectList xSObjectList = xSModelGroup.getParticles();
            for (int i = 0; i < xSObjectList.getLength(); ++i) {
                this.convertParticle((XSParticle)xSObjectList.item(i));
            }
        }
    }

    protected TypeValidator convertSType(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        TypeValidator typeValidator = (TypeValidator)this.fSimpleTypes.get(xSSimpleTypeDefinition);
        if (typeValidator != null) {
            return typeValidator;
        }
        String string2 = xSSimpleTypeDefinition.getNamespace();
        String string3 = xSSimpleTypeDefinition.getName();
        string2 = string2 != null ? this.fTypeUtil.internString(string2) : "";
        string3 = string3 != null ? this.fTypeUtil.internString(string3) : "";
        typeValidator = this.fDVFactory.createSimpleType(string2, string3, xSSimpleTypeDefinition, this.fSTs, this.fTypeUtil);
        this.fSimpleTypes.put(xSSimpleTypeDefinition, typeValidator);
        return typeValidator;
    }

    protected boolean isID(XSTypeDefinition xSTypeDefinition) {
        int n2 = 27;
        return xSTypeDefinition.derivedFrom(URI_XSD, NAME_ID, (short)n2);
    }

    private Attribute cloneAttribute(Attribute attribute2, ValidatedInfo validatedInfo, boolean bl) {
        return new Attribute(attribute2.nsURI, attribute2.localName, attribute2.type, validatedInfo, bl, attribute2.xsAttributeDeclaration);
    }

    protected Wildcard convertWC(XSWildcard xSWildcard, int n2) {
        Wildcard wildcard = (Wildcard)this.fWCs.get(xSWildcard);
        if (wildcard != null) {
            return wildcard;
        }
        short s = xSWildcard.getConstraintType();
        boolean bl = s != 3;
        String[] stringArray = null;
        if (s != 1) {
            StringList stringList = xSWildcard.getNsConstraintList();
            int n3 = stringList.getLength();
            stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                String string2 = stringList.item(i);
                stringArray[i] = string2 = string2 != null ? this.fTypeUtil.internString(string2) : "";
            }
        }
        wildcard = new Wildcard(n2, bl, stringArray, xSWildcard);
        this.fWCs.put(xSWildcard, wildcard);
        return wildcard;
    }

    private ValidatedInfo getActualValue(XSSimpleTypeDefinition xSSimpleTypeDefinition, Object object2, String string2, short s, ShortList shortList) {
        if (xSSimpleTypeDefinition == null) {
            xSSimpleTypeDefinition = (XSSimpleTypeDefinition)this.fXSModel.getTypeDefinition(NAME_STRING, URI_XSD);
        }
        TypeValidator typeValidator = this.convertSType(xSSimpleTypeDefinition);
        ValueInfo valueInfo = new ValueInfo(string2, object2, s, shortList);
        return this.fDVFactory.getActualValue(typeValidator, valueInfo, this.fTypeUtil);
    }

    private boolean allowEmpty(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        try {
            ((XSSimpleTypeDecl)xSSimpleTypeDefinition).validate("", null, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected void convertAll(ElementType elementType, XSComplexTypeDefinition xSComplexTypeDefinition) {
        Object object2;
        XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
        XSObjectList xSObjectList = ((XSModelGroup)xSParticle.getTerm()).getParticles();
        int n2 = xSObjectList.getLength();
        boolean bl = false;
        BitSet bitSet = new BitSet(n2);
        for (int i = 0; i < n2; ++i) {
            object2 = (XSParticle)xSObjectList.item(i);
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)object2.getTerm();
            if (object2.getMinOccurs() != 0) {
                bitSet.setBit(i);
                bl = true;
            }
            this.fAllElems.add(this.convertElem(xSElementDeclaration));
            this.fAllOpts.add(Converter.getInteger(i));
            if (xSElementDeclaration.getScope() != 1) continue;
            XSObjectList xSObjectList2 = this.getSubstitutionGroup(xSElementDeclaration);
            for (int j = 0; j < xSObjectList2.getLength(); ++j) {
                this.fAllElems.add(this.convertElem((XSElementDeclaration)xSObjectList2.item(j)));
                this.fAllOpts.add(Converter.getInteger(i));
            }
        }
        n2 = this.fAllElems.size();
        Element[] elementArray = new Element[n2];
        object2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            elementArray[i] = (Element)this.fAllElems.get(i);
            object2[i] = (Integer)this.fAllOpts.get(i);
        }
        elementType.allowEmpty = !bl || xSParticle.getMinOccurs() == 0;
        elementType.all = new ElementType.AllContent(elementArray, (int[])object2, bitSet);
        this.fAllElems.clear();
        this.fAllOpts.clear();
    }

    protected void convertNVAll(ElementType elementType, XSComplexTypeDefinition xSComplexTypeDefinition) {
        XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
        HashMap hashMap = new HashMap();
        this.collapsedDuplicateDeclaration = false;
        this.gatherLeaves(xSParticle, xSComplexTypeDefinition, hashMap, this.fAllElems);
        if (this.collapsedDuplicateDeclaration) {
            elementType.useDFA = true;
        }
        int n2 = hashMap.size();
        Element[] elementArray = new Element[n2];
        Iterator iterator = hashMap.values().iterator();
        for (int i = 0; i < n2; ++i) {
            elementArray[i] = (Element)iterator.next();
        }
        Wildcard[] wildcardArray = null;
        if (this.fAllElems.size() > 0) {
            wildcardArray = this.fAllElems.toArray(new Wildcard[this.fAllElems.size()]);
        }
        elementType.all = new ElementType.AllContent(elementArray, wildcardArray);
        this.fAllElems.clear();
    }

    protected void gatherLeaves(XSParticle xSParticle, XSComplexTypeDefinition xSComplexTypeDefinition, HashMap hashMap, ArrayList arrayList) {
        XSTerm xSTerm = xSParticle.getTerm();
        if (xSTerm.getType() == 2) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSTerm;
            XSObjectList xSObjectList = null;
            int n2 = 0;
            if (xSElementDeclaration.getScope() == 1) {
                short s = xSElementDeclaration.getDisallowedSubstitutions();
                if ((s & 4) == 4) {
                    n2 = 0;
                } else {
                    xSObjectList = this.getSubstitutionGroup(xSElementDeclaration);
                    n2 = xSObjectList.getLength();
                    this.collapsedDuplicateDeclaration = true;
                }
            }
            String string2 = xSElementDeclaration.getName();
            if (xSElementDeclaration.getNamespace() != null) {
                string2 = string2 + "," + xSElementDeclaration.getNamespace();
            }
            if (hashMap.get(string2) == null) {
                hashMap.put(string2, this.convertElem(xSElementDeclaration));
            } else {
                this.collapsedDuplicateDeclaration = true;
            }
            for (int i = 0; i < n2; ++i) {
                XSElementDeclaration xSElementDeclaration2 = (XSElementDeclaration)xSObjectList.item(i);
                string2 = xSElementDeclaration2.getName();
                if (xSElementDeclaration2.getNamespace() != null) {
                    string2 = string2 + "," + xSElementDeclaration2.getNamespace();
                }
                if (hashMap.get(string2) != null) continue;
                hashMap.put(string2, this.convertElem(xSElementDeclaration2));
            }
            return;
        }
        if (xSTerm.getType() == 9) {
            XSWildcard xSWildcard = (XSWildcard)xSTerm;
            arrayList.add(this.convertWC(xSWildcard, xSComplexTypeDefinition));
            if (xSWildcard != null && xSWildcard.getProcessContents() != 2) {
                this.collapsedDuplicateDeclaration = true;
            }
            ArrayList arrayList2 = this.getWCDecls(xSWildcard, false);
            int n3 = arrayList2.size();
            for (int i = 0; i < n3; ++i) {
                XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)arrayList2.get(i);
                String string3 = xSElementDeclaration.getName();
                if (xSElementDeclaration.getNamespace() != null) {
                    string3 = string3 + "," + xSElementDeclaration.getNamespace();
                }
                if (hashMap.get(string3) != null) continue;
                hashMap.put(string3, this.convertElem(xSElementDeclaration));
            }
            return;
        }
        XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
        XSObjectList xSObjectList = xSModelGroup.getParticles();
        int n4 = xSObjectList.getLength();
        for (int i = 0; i < n4; ++i) {
            this.gatherLeaves((XSParticle)xSObjectList.item(i), xSComplexTypeDefinition, hashMap, arrayList);
        }
    }

    protected void convertDFA(ElementType elementType, XSComplexTypeDefinition xSComplexTypeDefinition) throws ConverterException {
        XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
        this.fCount = 0;
        Node node2 = this.buildTree(xSParticle, xSComplexTypeDefinition);
        Node node3 = this.fNodes.leaf(1, null, this.fCount++);
        node2 = node2 == null ? node3 : this.fNodes.group(true, 1, new Node[]{node2, node3});
        this.fillDFA(elementType, node2);
        this.fNodes.returnNodes(node2);
    }

    protected Node buildTree(XSParticle xSParticle, XSComplexTypeDefinition xSComplexTypeDefinition) {
        int n2 = xSParticle.getMaxOccursUnbounded() ? -1 : xSParticle.getMaxOccurs();
        int n3 = xSParticle.getMinOccurs();
        XSTerm xSTerm = xSParticle.getTerm();
        if (xSTerm.getType() == 2) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSTerm;
            XSObjectList xSObjectList = null;
            int n4 = 1;
            int n5 = 0;
            if (xSElementDeclaration.getScope() == 1) {
                xSObjectList = this.getSubstitutionGroup(xSElementDeclaration);
                n5 = xSObjectList.getLength();
                n4 += n5;
            }
            if (n4 == 0) {
                return null;
            }
            Node[] nodeArray = n4 > 1 ? new Node[n4] : null;
            Node node2 = null;
            Element element2 = this.convertElem(xSElementDeclaration);
            node2 = this.fNodes.leaf(1, element2, this.fCount++);
            if (n4 == 1) {
                return this.expandNode(node2, n3, n2);
            }
            nodeArray[n4 - 1] = node2;
            for (int i = 0; i < n5; ++i) {
                element2 = this.convertElem((XSElementDeclaration)xSObjectList.item(i));
                node2 = this.fNodes.leaf(1, element2, this.fCount++);
                if (n4 == 1) {
                    return this.expandNode(node2, n3, n2);
                }
                nodeArray[i] = node2;
            }
            node2 = this.fNodes.group(false, 1, nodeArray);
            return this.expandNode(node2, n3, n2);
        }
        if (xSTerm.getType() == 9) {
            XSWildcard xSWildcard = (XSWildcard)xSTerm;
            Object object2 = this.convertWC(xSWildcard, xSComplexTypeDefinition);
            Node node3 = this.fNodes.leaf(1, object2, this.fCount++);
            ArrayList arrayList = this.getWCDecls(xSWildcard, false);
            int n6 = arrayList.size();
            if (n6 == 0) {
                return this.expandNode(node3, n3, n2);
            }
            Node[] nodeArray = new Node[n6 + 1];
            nodeArray[n6] = node3;
            for (int i = 0; i < n6; ++i) {
                object2 = this.convertElem((XSElementDeclaration)arrayList.get(i));
                nodeArray[i] = this.fNodes.leaf(1, object2, this.fCount++);
            }
            node3 = this.fNodes.group(false, 1, nodeArray);
            return this.expandNode(node3, n3, n2);
        }
        XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
        boolean bl = xSModelGroup.getCompositor() == 1;
        XSObjectList xSObjectList = xSModelGroup.getParticles();
        int n7 = xSObjectList.getLength();
        if (n7 == 0) {
            return null;
        }
        Node[] nodeArray = new Node[n7];
        int n8 = 0;
        for (int i = 0; i < n7; ++i) {
            Node node4 = this.buildTree((XSParticle)xSObjectList.item(i), xSComplexTypeDefinition);
            if (node4 == null) continue;
            nodeArray[n8++] = node4;
        }
        if (n8 == 0) {
            return null;
        }
        if (n8 < n7) {
            Node[] nodeArray2 = new Node[n8];
            System.arraycopy(nodeArray, 0, nodeArray2, 0, n8);
            nodeArray = nodeArray2;
        }
        Node node5 = this.fNodes.group(bl, 1, nodeArray);
        if (xSModelGroup.getCompositor() == 2 && n8 == 1 && n7 > 1) {
            node5.occurrence = 0;
            node5 = this.fNodes.group(true, 1, new Node[]{node5});
        }
        return this.expandNode(node5, n3, n2);
    }

    private Node expandNode(Node node2, int n2, int n3) {
        if (n2 == 0 && n3 == -1) {
            node2.occurrence = 2;
            return node2;
        }
        if (n3 == -1) {
            node2.occurrence = 3;
            if (n2 == 1) {
                return node2;
            }
            Node[] nodeArray = new Node[n2];
            nodeArray[n2 - 1] = node2;
            this.copyNode(node2, 1, nodeArray, 0, n2 - 1, true);
            return this.fNodes.group(true, 1, nodeArray);
        }
        Node[] nodeArray = new Node[n3];
        if (n2 > 0) {
            this.copyNode(node2, 1, nodeArray, 0, n2, false);
        }
        if (n3 > n2) {
            this.copyNode(node2, 0, nodeArray, n2, n3, n2 != 0);
        }
        return this.fNodes.group(true, 1, nodeArray);
    }

    private void copyNode(Node node2, int n2, Node[] nodeArray, int n3, int n4, boolean bl) {
        if (!bl) {
            node2.occurrence = n2;
            nodeArray[n3++] = node2;
        }
        while (n3 < n4) {
            nodeArray[n3] = this.copyNode(node2);
            nodeArray[n3].occurrence = n2;
            ++n3;
        }
    }

    private Node copyNode(Node node2) {
        if (node2.type == 0) {
            return this.fNodes.leaf(node2.occurrence, node2.leaf, this.fCount++);
        }
        int n2 = node2.children.length;
        Node[] nodeArray = new Node[n2];
        for (int i = 0; i < n2; ++i) {
            nodeArray[i] = this.copyNode(node2.children[i]);
        }
        return this.fNodes.group(node2.type == 1, node2.occurrence, nodeArray);
    }

    private void fillDFA(ElementType elementType, Node node2) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        this.buildDFA(node2, arrayList, arrayList2, arrayList3);
        elementType.extendDFA(arrayList2.size());
        ElementType.DFAState[] dFAStateArray = elementType.dfa;
        for (int i = 0; i < arrayList2.size(); ++i) {
            ElementType.DFAState dFAState = this.buildState((int[])arrayList3.get(i), arrayList, ((BitSet)arrayList2.get(i)).getBit(this.fCount - 1));
            if (dFAState.numElements() == 0 && dFAState.wc == null) continue;
            dFAStateArray[i] = dFAState;
        }
        elementType.setAllowEmpty();
    }

    private void buildDFA(Node node2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        Node[] nodeArray = new Node[this.fCount];
        BitSet[] bitSetArray = new BitSet[this.fCount];
        this.calcLabels(node2, arrayList, nodeArray, bitSetArray);
        int n2 = arrayList.size();
        int[] nArray = new int[this.fCount + n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Object e = arrayList.get(i);
            for (int j = 0; j < this.fCount; ++j) {
                if (e != nodeArray[j].leaf) continue;
                nArray[n3++] = j;
            }
            nArray[n3++] = -1;
        }
        arrayList2.add(node2.firstPos(this.fCount));
        arrayList3.add(Converter.makeDefStateList(n2));
        HashMap<BitSet, Integer> hashMap = new HashMap<BitSet, Integer>();
        hashMap.put(node2.firstPos(this.fCount), Converter.getInteger(0));
        for (int i = 0; i < arrayList2.size(); ++i) {
            BitSet bitSet = (BitSet)arrayList2.get(i);
            int[] nArray2 = (int[])arrayList3.get(i);
            BitSet bitSet2 = null;
            int n4 = 0;
            for (int j = 0; j < n2; ++j) {
                if (bitSet2 == null) {
                    bitSet2 = new BitSet(this.fCount);
                } else {
                    bitSet2.clearAll();
                }
                int n5 = nArray[n4++];
                while (n5 != -1) {
                    if (bitSet.getBit(n5)) {
                        bitSet2.setBits(bitSetArray[n5]);
                    }
                    n5 = nArray[n4++];
                }
                if (bitSet2.isZero()) continue;
                Integer n6 = (Integer)hashMap.get(bitSet2);
                int n7 = arrayList2.size();
                if (n6 == null) {
                    arrayList2.add(bitSet2);
                    arrayList3.add(Converter.makeDefStateList(n2));
                    hashMap.put(bitSet2, Converter.getInteger(n7));
                    bitSet2 = null;
                } else {
                    n7 = n6;
                }
                nArray2[j] = n7;
            }
        }
    }

    protected void calcLabels(Node node2, ArrayList arrayList, Node[] nodeArray, BitSet[] bitSetArray) {
        int n2;
        this.collectLeaves(node2, nodeArray);
        for (n2 = 0; n2 < this.fCount; ++n2) {
            bitSetArray[n2] = new BitSet(this.fCount);
        }
        this.calcFollowList(node2, bitSetArray, true);
        for (n2 = 0; n2 < this.fCount - 1; ++n2) {
            Object object2 = nodeArray[n2].leaf;
            if (arrayList.contains(object2)) continue;
            arrayList.add(object2);
        }
    }

    private void collectLeaves(Node node2, Object[] objectArray) {
        if (node2.type == 0) {
            objectArray[node2.position] = node2;
        } else {
            int n2 = node2.children.length;
            for (int i = 0; i < n2; ++i) {
                this.collectLeaves(node2.children[i], objectArray);
            }
        }
    }

    private void calcFollowList(Node node2, BitSet[] bitSetArray, boolean bl) {
        if (bl) {
            if (node2.occurrence == 2 || node2.occurrence == 3) {
                BitSet bitSet = node2.firstPos(this.fCount);
                BitSet bitSet2 = node2.lastPos(this.fCount);
                for (int i = 0; i < this.fCount; ++i) {
                    if (!bitSet2.getBit(i)) continue;
                    bitSetArray[i].setBits(bitSet);
                }
            }
            this.calcFollowList(node2, bitSetArray, false);
            return;
        }
        if (node2.type == 0) {
            return;
        }
        int n2 = node2.children.length;
        block1: for (int i = 0; i < n2 - 1; ++i) {
            this.calcFollowList(node2.children[i], bitSetArray, true);
            if (node2.type != 1) continue;
            BitSet bitSet = node2.children[i].lastPos(this.fCount);
            for (int j = i + 1; j < n2; ++j) {
                BitSet bitSet3 = node2.children[j].firstPos(this.fCount);
                for (int k = 0; k < this.fCount; ++k) {
                    if (!bitSet.getBit(k)) continue;
                    bitSetArray[k].setBits(bitSet3);
                }
                if (!node2.children[j].emptiable()) continue block1;
            }
        }
        this.calcFollowList(node2.children[n2 - 1], bitSetArray, true);
    }

    private static int[] makeDefStateList(int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    private ElementType.DFAState buildState(int[] nArray, ArrayList arrayList, boolean bl) {
        int n2 = arrayList.size();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == -1) continue;
            if (arrayList.get(i) instanceof Wildcard) {
                ++n4;
                continue;
            }
            ++n3;
        }
        int[] nArray2 = new int[n3];
        Element[] elementArray = new Element[n3];
        int[] nArray3 = new int[n4];
        Wildcard[] wildcardArray = new Wildcard[n4];
        n3 = 0;
        n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == -1) continue;
            if (arrayList.get(i) instanceof Wildcard) {
                nArray3[n4] = nArray[i];
                wildcardArray[n4++] = (Wildcard)arrayList.get(i);
                continue;
            }
            nArray2[n3] = nArray[i];
            elementArray[n3++] = (Element)arrayList.get(i);
        }
        if (n3 <= 0) {
            elementArray = null;
            nArray2 = null;
        }
        if (n4 <= 0) {
            wildcardArray = null;
            nArray3 = null;
        }
        return new ElementType.DFAState(bl, elementArray, nArray2, wildcardArray, nArray3);
    }

    Element getElement(XSElementDeclaration xSElementDeclaration) {
        return (Element)this.fElems.get(xSElementDeclaration);
    }

    Wildcard getWildcard(XSWildcard xSWildcard) {
        return (Wildcard)this.fWCs.get(xSWildcard);
    }

    XSObjectList getSubstitutionGroup(XSElementDeclaration xSElementDeclaration) {
        XSObjectList xSObjectList = this.fXSModel.getSubstitutionGroup(xSElementDeclaration);
        if (xSObjectList == null) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "getSubstitutionGroup", "*** Null substitution group. ***\n{" + xSElementDeclaration.getNamespace() + ',' + xSElementDeclaration.getName() + '}');
            }
            xSObjectList = XSObjectListImpl.EMPTY_LIST;
        }
        return xSObjectList;
    }

    XSNamedMap getGlobalElementDeclarations() {
        return this.fXSModel.getComponents((short)2);
    }

    XSTypeDefinition getGlobalTypeAtIndex(int n2) {
        return (XSTypeDefinition)this.fGlobalTypes.get(n2);
    }

    IDCInstructionBuilder getIDCInstructionBuilder(XSElementDeclaration xSElementDeclaration) {
        IDCInstructionBuilder iDCInstructionBuilder = (IDCInstructionBuilder)this.fIDCBuilders.get(xSElementDeclaration);
        if (iDCInstructionBuilder == null) {
            Attribute[] attributeArray = this.getElement((XSElementDeclaration)xSElementDeclaration).type.attributeInfo.ownedChoices;
            int n2 = attributeArray.length > 4 ? attributeArray.length : 0;
            iDCInstructionBuilder = new IDCInstructionBuilder(n2);
            this.fIDCBuilders.put(xSElementDeclaration, iDCInstructionBuilder);
        }
        return iDCInstructionBuilder;
    }

    IDCInstructionBuilder getIDCInstructionBuilder(XSWildcard xSWildcard) {
        IDCInstructionBuilder iDCInstructionBuilder = (IDCInstructionBuilder)this.fIDCBuilders.get(xSWildcard);
        if (iDCInstructionBuilder == null) {
            iDCInstructionBuilder = new IDCInstructionBuilder(0);
            this.fIDCBuilders.put(xSWildcard, iDCInstructionBuilder);
        }
        return iDCInstructionBuilder;
    }

    static {
        SchemaGrammar.BuiltinSchemaGrammar builtinSchemaGrammar = SchemaGrammar.SG_XSI;
        XSI_TYPE_DECL = builtinSchemaGrammar.getAttributeDeclaration(NAME_TYPE);
        XSI_NIL_DECL = builtinSchemaGrammar.getAttributeDeclaration(NAME_NIL);
        XSI_NONAMESPACESCHEMALOCATION_DECL = builtinSchemaGrammar.getAttributeDeclaration(NAME_NSL);
        XSI_SCHEMALOCATION_DECL = builtinSchemaGrammar.getAttributeDeclaration(NAME_SL);
        EMPTY_VECTOR = new ArrayList();
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    protected static class Node {
        private static final int TYPE_LEAF = 0;
        private static final int TYPE_SEQ = 1;
        private static final int TYPE_CHOICE = 2;
        private static final int OCCUR_0 = 0;
        protected static final int OCCUR_1 = 1;
        private static final int OCCUR_0N = 2;
        private static final int OCCUR_1N = 3;
        int type;
        int occurrence;
        Node[] children;
        Object leaf;
        int position;
        BitSet firstPos;
        BitSet lastPos;

        protected Node() {
        }

        BitSet firstPos(int n2) {
            if (this.firstPos == null) {
                this.firstPos = new BitSet(n2);
            } else if (this.firstPos.getLength() != n2) {
                this.firstPos.setLength(n2);
            } else {
                this.firstPos.clearAll();
            }
            this.calcFirstPos(n2);
            return this.firstPos;
        }

        BitSet lastPos(int n2) {
            if (this.lastPos == null) {
                this.lastPos = new BitSet(n2);
            } else if (this.lastPos.getLength() != n2) {
                this.lastPos.setLength(n2);
            }
            this.calcLastPos(n2);
            return this.lastPos;
        }

        private boolean emptiable() {
            if (this.occurrence == 0 || this.occurrence == 2) {
                return true;
            }
            if (this.type == 2) {
                int n2 = this.children.length;
                for (int i = 0; i < n2; ++i) {
                    if (!this.children[i].emptiable()) continue;
                    return true;
                }
            } else if (this.type == 1) {
                int n3 = this.children.length;
                for (int i = 0; i < n3; ++i) {
                    if (this.children[i].emptiable()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void calcFirstPos(int n2) {
            if (this.type == 0) {
                this.firstPos.setBit(this.position);
                return;
            }
            if (this.type == 2) {
                int n3 = this.children.length;
                for (int i = 0; i < n3; ++i) {
                    this.firstPos.setBits(this.children[i].firstPos(n2));
                }
                return;
            }
            this.firstPos.setBits(this.children[0].firstPos(n2));
            int n4 = this.children.length;
            for (int i = 0; i < n4 - 1 && this.children[i].emptiable(); ++i) {
                this.firstPos.setBits(this.children[i + 1].firstPos(n2));
            }
        }

        private void calcLastPos(int n2) {
            if (this.type == 0) {
                this.lastPos.setBit(this.position);
                return;
            }
            if (this.type == 2) {
                int n3 = this.children.length;
                for (int i = 0; i < n3; ++i) {
                    this.lastPos.setBits(this.children[i].lastPos(n2));
                }
                return;
            }
            int n4 = this.children.length;
            this.lastPos.setBits(this.children[n4 - 1].lastPos(n2));
            for (int i = n4 - 1; i > 0 && this.children[i].emptiable(); --i) {
                this.lastPos.setBits(this.children[i - 1].lastPos(n2));
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class ConverterException
    extends Exception {
        public ConverterException(String string2) {
            super(string2);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    protected static final class NodePool {
        private final Stack<Node> nodes = new Stack();

        protected NodePool() {
        }

        private Node allocate() {
            if (this.nodes.empty()) {
                return new Node();
            }
            return this.nodes.pop();
        }

        Node leaf(int n2, Object object2, int n3) {
            Node node2 = this.allocate();
            node2.type = 0;
            node2.occurrence = n2;
            node2.leaf = object2;
            node2.position = n3;
            return node2;
        }

        Node group(boolean bl, int n2, Node[] nodeArray) {
            Node node2 = this.allocate();
            node2.type = bl ? 1 : 2;
            node2.occurrence = n2;
            node2.children = nodeArray;
            return node2;
        }

        void returnNodes(Node node2) {
            if (node2.lastPos != null) {
                node2.lastPos.setLength(0);
            }
            if (node2.firstPos != null) {
                node2.firstPos.setLength(0);
            }
            this.nodes.push(node2);
            if (node2.type != 0) {
                Node[] nodeArray = node2.children;
                int n2 = nodeArray.length;
                for (int i = 0; i < n2; ++i) {
                    this.returnNodes(nodeArray[i]);
                }
            }
        }

        void reset() {
            this.nodes.removeAllElements();
        }
    }
}

