/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.xlxp.internal.s1.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class UCSEncodingSupport
implements EncodingSupport {
    private static final String COPYRIGHT_YEARS = "Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int UTF_16 = 0;
    public static final int UTF_16BE = 1;
    public static final int UTF_16LE = 2;
    public static final int UTF_32BE = 3;
    public static final int UTF_32LE = 4;
    private static final int ENCODINGS_COUNT = 5;
    private static EncodingSupport[] fgSingletons;

    public static EncodingSupport getInstance(int n2) {
        if (n2 < 0 || n2 > 5) {
            return null;
        }
        if (fgSingletons == null) {
            fgSingletons = ArrayAllocator.newObjectArray(EncodingSupport.class, 5);
        } else if (fgSingletons[n2] != null) {
            return fgSingletons[n2];
        }
        switch (n2) {
            case 0: {
                UCSEncodingSupport.fgSingletons[n2] = new UTF16();
                return UCSEncodingSupport.fgSingletons[n2];
            }
            case 1: {
                UCSEncodingSupport.fgSingletons[n2] = new UTF16BE();
                return UCSEncodingSupport.fgSingletons[n2];
            }
            case 2: {
                UCSEncodingSupport.fgSingletons[n2] = new UTF16LE();
                return UCSEncodingSupport.fgSingletons[n2];
            }
            case 3: {
                UCSEncodingSupport.fgSingletons[n2] = new UTF32BE();
                return UCSEncodingSupport.fgSingletons[n2];
            }
            case 4: {
                UCSEncodingSupport.fgSingletons[n2] = new UTF32LE();
                return UCSEncodingSupport.fgSingletons[n2];
            }
        }
        return null;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, ByteStreamDataSource byteStreamDataSource) {
        byteStreamDataSource.setEncodingSupport(this);
        return byteStreamDataSource.load(parsedEntity);
    }

    protected UCSEncodingSupport() {
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF32LE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            int n2;
            Object object2;
            if (!byteStreamDataSource.atEndOfStream() && byteStreamDataSource.readOffset < byteStreamDataSource.readLength && ((object2 = (Object)byteStreamDataSource.fillReadBuffer()) != null || byteStreamDataSource.readOffset == 0 && byteStreamDataSource.atEndOfStream())) {
                dataBuffer.endOffset = 0;
                return object2;
            }
            object2 = dataBuffer.bytes;
            int n3 = dataBuffer.endOffset;
            byte[] byArray = byteStreamDataSource.readBuffer;
            boolean bl = byteStreamDataSource.isXML10;
            int n4 = byteStreamDataSource.readOffset;
            int n5 = 0;
            int n6 = 0;
            while (n5 + 3 < n4 && n6 < n3) {
                int n7;
                int n8;
                n2 = byArray[n5++] & 0xFF;
                int n9 = byArray[n5++] & 0xFF;
                int n10 = byArray[n5++] & 0xFF;
                if ((n8 = byArray[n5++] & 0xFF) == 0 && n10 == 0) {
                    if (n9 == 0 && n2 < 128) {
                        if (n2 != 13) {
                            object2[n6++] = (byte)n2;
                            continue;
                        }
                        if (n5 + 3 < n4) {
                            object2[n6++] = 10;
                            n2 = byArray[n5++] & 0xFF;
                            n9 = byArray[n5++] & 0xFF;
                            n10 = byArray[n5++] & 0xFF;
                            if ((n8 = byArray[n5++] & 0xFF) == 0 && n10 == 0 && n9 == 0 && (n2 == 10 || !bl && n2 == 133)) continue;
                            n5 -= 4;
                            continue;
                        }
                        if (byteStreamDataSource.atEndOfStream()) {
                            object2[n6++] = 10;
                            break;
                        }
                        n5 -= 4;
                        break;
                    }
                    n7 = (n9 << 8) + n2;
                    if (!(bl || n7 != 133 && n7 != 8232)) {
                        object2[n6++] = 10;
                        continue;
                    }
                    if (n7 < 2048) {
                        if (n6 + 1 < n3) {
                            object2[n6++] = (byte)(0xC0 | n7 >> 6);
                            object2[n6++] = (byte)(0x80 | 0x3F & n7);
                            continue;
                        }
                        n5 -= 4;
                        break;
                    }
                    if (n6 + 2 < n3) {
                        object2[n6++] = (byte)(0xE0 | n7 >> 12);
                        object2[n6++] = (byte)(0x80 | 0x3F & n7 >> 6);
                        object2[n6++] = (byte)(0x80 | 0x3F & n7);
                        continue;
                    }
                    n5 -= 4;
                    break;
                }
                if (n6 + 3 < n3) {
                    n7 = (n8 << 24) + (n10 << 16) + (n9 << 8) + n2;
                    object2[n6++] = (byte)(0xF0 | n7 >> 18);
                    object2[n6++] = (byte)(0x80 | 0x3F & n7 >> 12);
                    object2[n6++] = (byte)(0x80 | 0x3F & n7 >> 6);
                    object2[n6++] = (byte)(0x80 | 0x3F & n7);
                    continue;
                }
                n5 -= 4;
                break;
            }
            if (n5 < n4) {
                n2 = n4 - n5;
                if (n2 < 4 && byteStreamDataSource.atEndOfStream()) {
                    return CharConversionError.insufficientInputToDecodeCharacter();
                }
                System.arraycopy(byArray, n5, byArray, 0, n2);
                n5 = n2;
            } else {
                n5 = 0;
            }
            byteStreamDataSource.readOffset = n5;
            dataBuffer.endOffset = n6;
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF32BE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            int n2;
            Object object2;
            if (!byteStreamDataSource.atEndOfStream() && byteStreamDataSource.readOffset < byteStreamDataSource.readLength && ((object2 = (Object)byteStreamDataSource.fillReadBuffer()) != null || byteStreamDataSource.readOffset == 0 && byteStreamDataSource.atEndOfStream())) {
                dataBuffer.endOffset = 0;
                return object2;
            }
            object2 = dataBuffer.bytes;
            int n3 = dataBuffer.endOffset;
            byte[] byArray = byteStreamDataSource.readBuffer;
            boolean bl = byteStreamDataSource.isXML10;
            int n4 = byteStreamDataSource.readOffset;
            int n5 = 0;
            int n6 = 0;
            while (n5 + 3 < n4 && n6 < n3) {
                int n7;
                n2 = byArray[n5++] & 0xFF;
                int n8 = byArray[n5++] & 0xFF;
                int n9 = byArray[n5++] & 0xFF;
                int n10 = byArray[n5++] & 0xFF;
                if (n2 == 0 && n8 == 0) {
                    if (n9 == 0 && n10 < 128) {
                        if (n10 != 13) {
                            object2[n6++] = (byte)n10;
                            continue;
                        }
                        if (n5 + 3 < n4) {
                            object2[n6++] = 10;
                            n2 = byArray[n5++] & 0xFF;
                            n8 = byArray[n5++] & 0xFF;
                            n9 = byArray[n5++] & 0xFF;
                            n10 = byArray[n5++] & 0xFF;
                            if (n2 == 0 && n8 == 0 && n9 == 0 && (n10 == 10 || !bl && n10 == 133)) continue;
                            n5 -= 4;
                            continue;
                        }
                        if (byteStreamDataSource.atEndOfStream()) {
                            object2[n6++] = 10;
                            break;
                        }
                        n5 -= 4;
                        break;
                    }
                    n7 = (n9 << 8) + n10;
                    if (!(bl || n7 != 133 && n7 != 8232)) {
                        object2[n6++] = 10;
                        continue;
                    }
                    if (n7 < 2048) {
                        if (n6 + 1 < n3) {
                            object2[n6++] = (byte)(0xC0 | n7 >> 6);
                            object2[n6++] = (byte)(0x80 | 0x3F & n7);
                            continue;
                        }
                        n5 -= 4;
                        break;
                    }
                    if (n6 + 2 < n3) {
                        object2[n6++] = (byte)(0xE0 | n7 >> 12);
                        object2[n6++] = (byte)(0x80 | 0x3F & n7 >> 6);
                        object2[n6++] = (byte)(0x80 | 0x3F & n7);
                        continue;
                    }
                    n5 -= 4;
                    break;
                }
                if (n6 + 3 < n3) {
                    n7 = (n2 << 24) + (n8 << 16) + (n9 << 8) + n10;
                    object2[n6++] = (byte)(0xF0 | n7 >> 18);
                    object2[n6++] = (byte)(0x80 | 0x3F & n7 >> 12);
                    object2[n6++] = (byte)(0x80 | 0x3F & n7 >> 6);
                    object2[n6++] = (byte)(0x80 | 0x3F & n7);
                    continue;
                }
                n5 -= 4;
                break;
            }
            if (n5 < n4) {
                n2 = n4 - n5;
                if (n2 < 4 && byteStreamDataSource.atEndOfStream()) {
                    return CharConversionError.insufficientInputToDecodeCharacter();
                }
                System.arraycopy(byArray, n5, byArray, 0, n2);
                n5 = n2;
            } else {
                n5 = 0;
            }
            byteStreamDataSource.readOffset = n5;
            dataBuffer.endOffset = n6;
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF16LE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            int n2;
            Object object2;
            if (!byteStreamDataSource.atEndOfStream() && byteStreamDataSource.readOffset < byteStreamDataSource.readLength && ((object2 = (Object)byteStreamDataSource.fillReadBuffer()) != null || byteStreamDataSource.readOffset == 0 && byteStreamDataSource.atEndOfStream())) {
                dataBuffer.endOffset = 0;
                return object2;
            }
            object2 = dataBuffer.bytes;
            int n3 = dataBuffer.endOffset;
            byte[] byArray = byteStreamDataSource.readBuffer;
            boolean bl = byteStreamDataSource.isXML10;
            int n4 = byteStreamDataSource.readOffset;
            int n5 = 0;
            int n6 = 0;
            while (n5 + 1 < n4 && n6 < n3) {
                int n7;
                n2 = byArray[n5++] & 0xFF;
                if ((n7 = byArray[n5++] & 0xFF) == 0 && n2 < 128) {
                    if (n2 != 13) {
                        object2[n6++] = (byte)n2;
                        continue;
                    }
                    if (n5 + 1 < n4) {
                        object2[n6++] = 10;
                        n2 = byArray[n5++] & 0xFF;
                        if ((n7 = byArray[n5++] & 0xFF) == 0 && (n2 == 10 || !bl && n2 == 133)) continue;
                        n5 -= 2;
                        continue;
                    }
                    if (byteStreamDataSource.atEndOfStream()) {
                        object2[n6++] = 10;
                        break;
                    }
                    n5 -= 2;
                    break;
                }
                int n8 = (n7 << 8) + n2;
                if (!(bl || n8 != 133 && n8 != 8232)) {
                    object2[n6++] = 10;
                    continue;
                }
                if (n8 < 2048) {
                    if (n6 + 1 < n3) {
                        object2[n6++] = (byte)(0xC0 | n8 >> 6);
                        object2[n6++] = (byte)(0x80 | 0x3F & n8);
                        continue;
                    }
                    n5 -= 2;
                    break;
                }
                if (n8 < 55296 || n8 >= 57344) {
                    if (n6 + 2 < n3) {
                        object2[n6++] = (byte)(0xE0 | n8 >> 12);
                        object2[n6++] = (byte)(0x80 | 0x3F & n8 >> 6);
                        object2[n6++] = (byte)(0x80 | 0x3F & n8);
                        continue;
                    }
                    n5 -= 2;
                    break;
                }
                if (n8 < 56320) {
                    if (n5 < n4 && n6 + 3 < n3) {
                        int n9;
                        if ((n9 = ((n7 = byArray[n5++] & 0xFF) << 8) + (n2 = byArray[n5++] & 0xFF)) >= 56320 && n9 < 57344) {
                            n8 = 65536 + (n8 - 55296 << 10) + (n9 - 56320);
                            object2[n6++] = (byte)(0xF0 | n8 >> 18);
                            object2[n6++] = (byte)(0x80 | 0x3F & n8 >> 12);
                            object2[n6++] = (byte)(0x80 | 0x3F & n8 >> 6);
                            object2[n6++] = (byte)(0x80 | 0x3F & n8);
                            continue;
                        }
                        return CharConversionError.invalidSecondHalfOfSurrogatePair();
                    }
                    n5 -= 2;
                    break;
                }
                return CharConversionError.invalidFirstHalfOfSurrogatePair();
            }
            if (n5 < n4) {
                n2 = n4 - n5;
                if (n2 < 2 && byteStreamDataSource.atEndOfStream()) {
                    return CharConversionError.insufficientInputToDecodeCharacter();
                }
                System.arraycopy(byArray, n5, byArray, 0, n2);
                n5 = n2;
            } else {
                n5 = 0;
            }
            byteStreamDataSource.readOffset = n5;
            dataBuffer.endOffset = n6;
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF16BE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            int n2;
            Object object2;
            if (!byteStreamDataSource.atEndOfStream() && byteStreamDataSource.readOffset < byteStreamDataSource.readLength && ((object2 = (Object)byteStreamDataSource.fillReadBuffer()) != null || byteStreamDataSource.readOffset == 0 && byteStreamDataSource.atEndOfStream())) {
                dataBuffer.endOffset = 0;
                return object2;
            }
            object2 = dataBuffer.bytes;
            int n3 = dataBuffer.endOffset;
            byte[] byArray = byteStreamDataSource.readBuffer;
            boolean bl = byteStreamDataSource.isXML10;
            int n4 = byteStreamDataSource.readOffset;
            int n5 = 0;
            int n6 = 0;
            while (n5 + 1 < n4 && n6 < n3) {
                n2 = byArray[n5++] & 0xFF;
                int n7 = byArray[n5++] & 0xFF;
                if (n2 == 0 && n7 < 128) {
                    if (n7 != 13) {
                        object2[n6++] = (byte)n7;
                        continue;
                    }
                    if (n5 + 1 < n4) {
                        object2[n6++] = 10;
                        n2 = byArray[n5++] & 0xFF;
                        n7 = byArray[n5++] & 0xFF;
                        if (n2 == 0 && (n7 == 10 || !bl && n7 == 133)) continue;
                        n5 -= 2;
                        continue;
                    }
                    if (byteStreamDataSource.atEndOfStream()) {
                        object2[n6++] = 10;
                        break;
                    }
                    n5 -= 2;
                    break;
                }
                int n8 = (n2 << 8) + n7;
                if (!(bl || n8 != 133 && n8 != 8232)) {
                    object2[n6++] = 10;
                    continue;
                }
                if (n8 < 2048) {
                    if (n6 + 1 < n3) {
                        object2[n6++] = (byte)(0xC0 | n8 >> 6);
                        object2[n6++] = (byte)(0x80 | 0x3F & n8);
                        continue;
                    }
                    n5 -= 2;
                    break;
                }
                if (n8 < 55296 || n8 >= 57344) {
                    if (n6 + 2 < n3) {
                        object2[n6++] = (byte)(0xE0 | n8 >> 12);
                        object2[n6++] = (byte)(0x80 | 0x3F & n8 >> 6);
                        object2[n6++] = (byte)(0x80 | 0x3F & n8);
                        continue;
                    }
                    n5 -= 2;
                    break;
                }
                if (n8 < 56320) {
                    if (n5 < n4 && n6 + 3 < n3) {
                        int n9;
                        if ((n9 = ((n2 = byArray[n5++] & 0xFF) << 8) + (n7 = byArray[n5++] & 0xFF)) >= 56320 && n9 < 57344) {
                            n8 = 65536 + (n8 - 55296 << 10) + (n9 - 56320);
                            object2[n6++] = (byte)(0xF0 | n8 >> 18);
                            object2[n6++] = (byte)(0x80 | 0x3F & n8 >> 12);
                            object2[n6++] = (byte)(0x80 | 0x3F & n8 >> 6);
                            object2[n6++] = (byte)(0x80 | 0x3F & n8);
                            continue;
                        }
                        return CharConversionError.invalidSecondHalfOfSurrogatePair();
                    }
                    n5 -= 2;
                    break;
                }
                return CharConversionError.invalidFirstHalfOfSurrogatePair();
            }
            if (n5 < n4) {
                n2 = n4 - n5;
                if (n2 < 2 && byteStreamDataSource.atEndOfStream()) {
                    return CharConversionError.insufficientInputToDecodeCharacter();
                }
                System.arraycopy(byArray, n5, byArray, 0, n2);
                n5 = n2;
            } else {
                n5 = 0;
            }
            byteStreamDataSource.readOffset = n5;
            dataBuffer.endOffset = n6;
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF16
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            return CharConversionError.inconsistentEncoding();
        }
    }
}

