/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.xlxp.internal.s1.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import java.io.IOException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
abstract class SingleByteEncodingSupport
implements EncodingSupport {
    protected abstract CharConversionError normalizeLineBreaks(DataBuffer var1, int var2, ByteStreamDataSource var3);

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, ByteStreamDataSource byteStreamDataSource) {
        byteStreamDataSource.setEncodingSupport(this);
        byteStreamDataSource.useReadBufferForLoad();
        return byteStreamDataSource.load(parsedEntity);
    }

    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n2 = dataBuffer.endOffset;
        int n3 = byteStreamDataSource.readOffset;
        if (!byteStreamDataSource.atEndOfStream() && n3 < 4) {
            try {
                int n4 = byteStreamDataSource.readFromStream(byArray, n3, n2 - n3);
                if (n4 == -1) {
                    if (n3 == 0) {
                        dataBuffer.endOffset = 0;
                        return null;
                    }
                } else {
                    n3 += n4;
                }
            }
            catch (IOException iOException) {
                byteStreamDataSource.readOffset = 0;
                dataBuffer.endOffset = 0;
                return CharConversionError.runtimeIOError(iOException);
            }
        }
        return this.normalizeLineBreaks(dataBuffer, n3, byteStreamDataSource);
    }

    protected SingleByteEncodingSupport() {
    }
}

