/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import java.io.IOException;
import java.io.InputStream;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class RewindableInputStream
extends InputStream {
    private static final int INITIAL_BYTE_COUNT = 4096;
    private InputStream fInputStream;
    private byte[] fData = ArrayAllocator.newByteArray(4096);
    private int fStartOffset;
    private int fOffset;
    private int fLength;
    private int fMark;

    public void setStream(InputStream inputStream, byte[] byArray, int n2) {
        this.fInputStream = inputStream;
        if (this.fData.length < n2) {
            int n3;
            for (n3 = this.fData.length << 1; n3 < n2; n3 <<= 1) {
            }
            this.fData = ArrayAllocator.replaceByteArray(this.fData, n3);
        }
        System.arraycopy(byArray, 0, this.fData, 0, n2);
        this.fStartOffset = 0;
        this.fOffset = 0;
        this.fLength = n2;
        this.fMark = 0;
    }

    public void setStartOffset(int n2) {
        this.fStartOffset = n2;
    }

    public void rewind() {
        this.fOffset = this.fStartOffset;
    }

    public int read() throws IOException {
        if (this.fOffset < this.fLength) {
            return this.fData[this.fOffset++] & 0xFF;
        }
        if (this.fInputStream == null) {
            return -1;
        }
        return this.fInputStream.read();
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = this.fLength - this.fOffset;
        if (n5 == 0) {
            if (this.fInputStream != null) {
                int n6 = this.fInputStream.read(byArray, n2, n3);
                if (n6 != -1) {
                    return n6;
                }
                this.fInputStream.close();
                this.fInputStream = null;
                return -1;
            }
            return -1;
        }
        if (n3 < n5) {
            if (n3 <= 0) {
                return 0;
            }
            n4 = n3;
        } else {
            n4 = n5;
        }
        if (byArray != null) {
            System.arraycopy(this.fData, this.fOffset, byArray, n2, n4);
        }
        this.fOffset += n4;
        if (n4 == n3 || this.fInputStream == null || this.fInputStream.available() == 0) {
            return n4;
        }
        int n7 = this.fInputStream.read(byArray, n2 += n4, n3 -= n4);
        if (n7 == -1) {
            this.fInputStream.close();
            this.fInputStream = null;
            return n4;
        }
        return n4 + n7;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        int n2 = this.fLength - this.fOffset;
        if (n2 == 0) {
            if (this.fInputStream == null) {
                return 0L;
            }
            return this.fInputStream.skip(l);
        }
        if (l <= (long)n2) {
            this.fOffset = (int)((long)this.fOffset + l);
            return l;
        }
        this.fOffset += n2;
        if (this.fInputStream == null) {
            return n2;
        }
        return this.fInputStream.skip(l -= (long)n2) + (long)n2;
    }

    public int available() throws IOException {
        int n2 = this.fLength - this.fOffset;
        if (n2 == 0) {
            if (this.fInputStream == null) {
                return -1;
            }
            return this.fInputStream.available();
        }
        if (this.fInputStream == null) {
            return n2;
        }
        return this.fInputStream.available() + n2;
    }

    public void mark(int n2) {
        this.fMark = this.fOffset;
    }

    public void reset() {
        this.fOffset = this.fMark;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (this.fInputStream != null) {
            this.fInputStream.close();
            this.fInputStream = null;
        }
    }
}

