/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.xlxp.internal.s1.api.util.encoding.ASCIIEncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EBCDICEncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.Latin1EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.PlatformEncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.UCSEncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.UTF8EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.Windows125xEncodingSupport;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class IANACharset {
    public static final int UNKNOWN = -1;
    public static final int UTF_8 = 0;
    public static final int US_ASCII = 1;
    public static final int ISO_8859_1 = 2;
    public static final int ISO_8859_2 = 3;
    public static final int ISO_8859_3 = 4;
    public static final int ISO_8859_4 = 5;
    public static final int ISO_8859_5 = 6;
    public static final int ISO_8859_6 = 7;
    public static final int ISO_8859_7 = 8;
    public static final int ISO_8859_8 = 9;
    public static final int ISO_8859_9 = 10;
    public static final int ISO_8859_13 = 11;
    public static final int ISO_8859_15 = 12;
    public static final int UTF_16 = 13;
    public static final int UTF_16BE = 14;
    public static final int UTF_16LE = 15;
    public static final int UTF_32BE = 16;
    public static final int UTF_32LE = 17;
    public static final int ISO_2022_JP = 18;
    public static final int SHIFT_JIS = 19;
    public static final int EUC_JP = 20;
    public static final int GBK = 21;
    public static final int GB2312 = 22;
    public static final int GB18030 = 23;
    public static final int BIG5 = 24;
    public static final int EUC_KR = 25;
    public static final int ISO_2022_KR = 26;
    public static final int KOI8_R = 27;
    public static final int ISO_2022_CN = 28;
    public static final int WINDOWS_31J = 29;
    public static final int JIS_C6226_1983 = 30;
    public static final int JIS_X0212_1990 = 31;
    public static final int JIS_X0201 = 32;
    public static final int JIS_C6220_1969_JP = 33;
    public static final int IBM037 = 34;
    public static final int IBM273 = 35;
    public static final int IBM277 = 36;
    public static final int IBM278 = 37;
    public static final int IBM280 = 38;
    public static final int IBM284 = 39;
    public static final int IBM285 = 40;
    public static final int IBM290 = 41;
    public static final int IBM297 = 42;
    public static final int IBM420 = 43;
    public static final int IBM424 = 44;
    public static final int IBM437 = 45;
    public static final int IBM500 = 46;
    public static final int IBM775 = 47;
    public static final int IBM850 = 48;
    public static final int IBM852 = 49;
    public static final int IBM855 = 50;
    public static final int IBM857 = 51;
    public static final int IBM00858 = 52;
    public static final int IBM860 = 53;
    public static final int IBM861 = 54;
    public static final int IBM862 = 55;
    public static final int IBM863 = 56;
    public static final int IBM864 = 57;
    public static final int IBM865 = 58;
    public static final int IBM866 = 59;
    public static final int IBM868 = 60;
    public static final int IBM869 = 61;
    public static final int IBM870 = 62;
    public static final int IBM871 = 63;
    public static final int IBM918 = 64;
    public static final int IBM00924 = 65;
    public static final int IBM1026 = 66;
    public static final int IBM1047 = 67;
    public static final int IBM01140 = 68;
    public static final int IBM01141 = 69;
    public static final int IBM01142 = 70;
    public static final int IBM01143 = 71;
    public static final int IBM01144 = 72;
    public static final int IBM01145 = 73;
    public static final int IBM01146 = 74;
    public static final int IBM01147 = 75;
    public static final int IBM01148 = 76;
    public static final int IBM01149 = 77;
    public static final int WINDOWS_1250 = 78;
    public static final int WINDOWS_1251 = 79;
    public static final int WINDOWS_1252 = 80;
    public static final int WINDOWS_1253 = 81;
    public static final int WINDOWS_1254 = 82;
    public static final int WINDOWS_1255 = 83;
    public static final int WINDOWS_1256 = 84;
    public static final int WINDOWS_1257 = 85;
    public static final int WINDOWS_1258 = 86;
    public static final int TIS_620 = 87;
    private static final String[] fgJavaEncodingNames = new String[]{"UTF-8", "US-ASCII", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-13", "ISO-8859-15", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF-32BE", "UTF-32LE", "ISO-2022-JP", "Shift_JIS", "EUC-JP", "GBK", "GB2312", "GB18030", "Big5", "EUC-KR", "ISO-2022-KR", "KOI8-R", "ISO-2022-CN", "windows-31j", "JIS_C6226-1983", "JIS_X0212-1990", "JIS_X0201", "JIS_C6220-1969-JP", "IBM037", "IBM273", "IBM277", "IBM278", "IBM280", "IBM284", "IBM285", "IBM290", "IBM297", "IBM420", "IBM424", "IBM437", "IBM500", "IBM775", "IBM850", "IBM852", "IBM855", "IBM857", "IBM00858", "IBM860", "IBM861", "IBM862", "IBM863", "IBM864", "IBM865", "IBM866", "IBM868", "IBM869", "IBM870", "IBM871", "IBM918", "IBM00924", "IBM1026", "IBM1047", "IBM01140", "IBM01141", "IBM01142", "IBM01143", "IBM01144", "IBM01145", "IBM01146", "IBM01147", "IBM01148", "IBM01149", "windows-1250", "windows-1251", "windows-1252", "windows-1253", "windows-1254", "windows-1255", "windows-1256", "windows-1257", "windows-1258", "TIS-620"};
    private static final String[] fgCharsetNames = new String[]{"UTF-8", "US-ASCII", "ANSI_X3.4-1968", "ISO-IR-6", "ANSI_X3.4-1986", "ASCII", "ISO646-US", "US", "IBM367", "CP367", "CSASCII", "IBM-367", "ISO-8859-1", "ISO-IR-100", "ISO_8859-1", "LATIN1", "L1", "IBM819", "CP819", "CSISOLATIN1", "IBM-819", "ISO-8859-2", "ISO-IR-101", "ISO_8859-2", "LATIN2", "L2", "CSISOLATIN2", "ISO-8859-3", "ISO-IR-109", "ISO_8859-3", "LATIN3", "L3", "CSISOLATIN3", "ISO-8859-4", "ISO-IR-110", "ISO_8859-4", "LATIN4", "L4", "CSISOLATIN4", "ISO-8859-5", "ISO-IR-144", "ISO_8859-5", "CYRILLIC", "CSISOLATINCYRILLIC", "ISO-8859-6", "ISO-IR-127", "ISO_8859-6", "ECMA-114", "ASMO-708", "ARABIC", "CSISOLATINARABIC", "ISO-8859-7", "ISO-IR-126", "ISO_8859-7", "ELOT_928", "ECMA-118", "GREEK", "GREEK8", "CSISOLATINGREEK", "ISO-8859-8", "ISO-IR-138", "ISO_8859-8", "HEBREW", "CSISOLATINHEBREW", "ISO_8859-8-I", "CSISO88598I", "ISO-8859-8-I", "ISO-8859-9", "ISO-IR-148", "ISO_8859-9", "LATIN5", "L5", "CSISOLATIN5", "ISO-8859-13", "ISO-8859-15", "ISO_8859-15", "LATIN-9", "UTF-16", "UTF-16BE", "ISO-10646-UCS-2", "CSUNICODE", "UTF-16LE", "UTF-32BE", "ISO-10646-UCS-4", "CSUCS4", "UTF-32LE", "ISO-2022-JP", "CSISO2022JP", "JIS", "SHIFT_JIS", "MS_KANJI", "CSSHIFTJIS", "EUC-JP", "EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "CSEUCPKDFMTJAPANESE", "EUCJIS", "GBK", "CP936", "MS936", "WINDOWS-936", "GB2312", "CSGB2312", "GB18030", "BIG5", "CSBIG5", "EUC-KR", "CSEUCKR", "KS_C_5601-1987", "ISO-IR-149", "KS_C_5601-1989", "KSC_5601", "KOREAN", "CSKSC56011987", "KSC5601", "ISO-2022-KR", "CSISO2022KR", "KOI8-R", "CSKOI8R", "ISO-2022-CN", "WINDOWS-31J", "CSWINDOWS31J", "JIS_C6226-1983", "ISO-IR-87", "X0208", "JIS_X0208-1983", "CSISO87JISX0208", "X0208DBIJIS_X0208-1983", "JIS_X0212-1990", "X0212", "ISO-IR-159", "CSISO159JISX02121990", "JIS_X0201", "X0201", "CSHALFWIDTHKATAKANA", "CSISO13JISC6220JP", "JIS_C6220-1969-JP", "JIS_C6220-1969", "ISO-IR-13", "KATAKANA", "X0201-7", "CSISO13JISC6220JP", "IBM037", "CP037", "EBCDIC-CP-US", "EBCDIC-CP-CA", "EBCDIC-CP-WT", "EBCDIC-CP-NL", "CSIBM037", "IBM-37", "IBM273", "CP273", "CSIBM273", "IBM-273", "IBM277", "EBCDIC-CP-DK", "EBCDIC-CP-NO", "CSIBM277", "CP277", "IBM-277", "IBM278", "CP278", "EBCDIC-CP-FI", "EBCDIC-CP-SE", "CSIBM278", "IBM-278", "IBM280", "CP280", "EBCDIC-CP-IT", "CSIBM280", "IBM-280", "IBM284", "CP284", "EBCDIC-CP-ES", "CSIBM284", "IBM-284", "IBM285", "CP285", "EBCDIC-CP-GB", "CSIBM285", "IBM-285", "IBM290", "CP290", "EBCDIC-JP-KANA", "CSIBM290", "IBM-290", "IBM297", "CP297", "EBCDIC-CP-FR", "CSIBM297", "IBM-297", "IBM420", "CP420", "EBCDIC-CP-AR1", "CSIBM420", "IBM-420", "IBM424", "CP424", "EBCDIC-CP-HE", "CSIBM424", "IBM-424", "IBM437", "CP437", "CSPC8CODEPAGE437", "IBM-437", "IBM500", "CP500", "EBCDIC-CP-BE", "EBCDIC-CP-CH", "CSIBM500", "IBM-500", "IBM775", "CP775", "CSPC775BALTIC", "IBM-775", "IBM850", "CP850", "CSPC850MULTILINGUAL", "IBM-850", "IBM852", "CP852", "CSPCP852", "IBM-852", "IBM855", "CP855", "CSIBM855", "IBM-855", "IBM857", "CP857", "CSIBM857", "IBM-857", "IBM00858", "CCSID00858", "CP00858", "IBM858", "CP858", "IBM-858", "IBM860", "CP860", "CSIBM860", "IBM-860", "IBM861", "CP861", "CP-IS", "CSIBM861", "IBM-861", "IBM862", "CP862", "CSPC862LATINHEBREW", "IBM-862", "IBM863", "CP863", "CSIBM863", "IBM-863", "IBM864", "CP864", "CSIBM864", "IBM-864", "IBM865", "CP865", "CSIBM865", "IBM-865", "IBM866", "CP866", "CSIBM866", "IBM-866", "IBM868", "CP868", "CP-AR", "CSIBM868", "IBM-868", "IBM869", "CP869", "CP-GR", "CSIBM869", "IBM-869", "IBM870", "CP870", "EBCDIC-CP-ROECE", "EBCDIC-CP-YU", "CSIBM870", "IBM-870", "IBM871", "CP871", "EBCDIC-CP-IS", "CSIBM871", "IBM-871", "IBM918", "CP918", "EBCDIC-CP-AR2", "CSIBM918", "IBM-918", "IBM00924", "CCSID00924", "CP00924", "EBCDIC-LATIN9--EURO", "IBM924", "CP924", "IBM-924", "IBM1026", "CP1026", "CSIBM1026", "IBM-1026", "IBM1047", "IBM-1047", "IBM01047", "CCSID01047", "CP01047", "CP1047", "IBM01140", "CCSID01140", "CP01140", "IBM-1140", "IBM01141", "CCSID01141", "CP01141", "IBM-1141", "IBM01142", "CCSID01142", "CP01142", "IBM-1142", "IBM01143", "CCSID01143", "CP01143", "IBM-1143", "IBM01144", "CCSID01144", "CP01144", "IBM-1144", "IBM01145", "CCSID01145", "CP01145", "IBM-1145", "IBM01146", "CCSID01146", "CP01146", "IBM-1146", "IBM01147", "CCSID01147", "CP01147", "IBM-1147", "IBM01148", "CCSID01148", "CP01148", "IBM-1148", "IBM01149", "CCSID01149", "CP01149", "IBM-1149", "WINDOWS-1250", "WINDOWS-1251", "WINDOWS-1252", "WINDOWS-1253", "WINDOWS-1254", "WINDOWS-1255", "WINDOWS-1256", "WINDOWS-1257", "WINDOWS-1258", "TIS-620"};
    private static final int[] fgHashCodes = new int[]{2937, 16, 2, 2938, 25, 3, 2939, 31, 4, 2940, 37, 5, 2941, 71, 10, 3313, 7, 1, 105107, 96, 21, 109713, 88, 18, 3729715, 103, 24, 56157639, 247, 55, 67988479, 102, 23, 85005404, 76, 12, 101370348, 64, 9, 121372723, 79, 14, 121372725, 83, 16, 140187811, 5, 1, 143531001, 10, 1, 144161404, 267, 60, 144161632, 272, 61, 144161709, 242, 54, 144165177, 142, 34, 144168213, 150, 35, 144168217, 157, 36, 144168218, 160, 37, 144168248, 166, 38, 144168252, 171, 39, 144168253, 176, 40, 144168286, 181, 41, 144168293, 186, 42, 144169623, 9, 1, 144170908, 191, 43, 144170912, 196, 44, 144170953, 201, 45, 144172276, 205, 46, 144175435, 211, 47, 144176655, 18, 2, 144176798, 215, 48, 144176800, 219, 49, 144176803, 223, 50, 144176805, 227, 51, 144176806, 234, 52, 144176836, 237, 53, 144176837, 241, 54, 144176838, 246, 55, 144176839, 250, 56, 144176840, 254, 57, 144176841, 258, 58, 144176842, 262, 59, 144176844, 266, 60, 144176845, 271, 61, 144176874, 276, 62, 144176875, 282, 63, 144178098, 287, 64, 144178132, 296, 65, 144178172, 97, 21, 151981374, 106, 25, 152646493, 56, 8, 161111872, 133, 32, 164170900, 117, 27, 165194148, 98, 21, 167580436, 220, 49, 181948654, 0, 0, 186199897, 132, 32, 186199904, 123, 30, 186199936, 128, 31, 191330783, 47, 7, 191330787, 55, 8, 203209166, 2, 1, 203209240, 4, 1, 234769869, 78, 14, 234770249, 81, 15, 234873837, 82, 16, 234874217, 85, 17, 238004192, 300, 66, 251897025, 277, 62, 261746613, 66, 9, 278283363, 12, 2, 278283364, 21, 3, 278283365, 27, 4, 278283366, 33, 5, 278283367, 39, 6, 278283368, 44, 7, 278283369, 51, 8, 278283370, 59, 9, 278283371, 67, 10, 283397209, 121, 30, 307899836, 120, 29, 349486598, 58, 8, 366480985, 134, 32, 366480985, 140, 33, 391443059, 43, 6, 394224275, 130, 31, 403891221, 202, 45, 437197360, 139, 33, 447571143, 63, 9, 455634082, 182, 41, 458563975, 118, 28, 458564243, 86, 18, 458564283, 114, 26, 466956258, 138, 33, 471597706, 77, 13, 501248855, 14, 2, 501248856, 23, 3, 501248857, 29, 4, 501248858, 35, 5, 501248859, 41, 6, 501248860, 46, 7, 501248861, 53, 8, 501248862, 61, 9, 501248863, 69, 10, 515597166, 348, 78, 515597167, 349, 79, 515597168, 350, 80, 515597169, 351, 81, 515597170, 352, 82, 515597171, 353, 83, 515597172, 354, 84, 515597173, 355, 85, 515597174, 356, 86, 611206387, 113, 25, 615921725, 91, 19, 722338109, 137, 33, 722338379, 122, 30, 800672705, 126, 30, 805534737, 80, 14, 859086828, 124, 30, 902559341, 48, 7, 919043323, 90, 19, 1029964609, 49, 7, 1148836278, 107, 25, 1148836280, 109, 25, 1180401486, 357, 87, 1183359842, 299, 66, 1183359919, 307, 67, 1190584971, 104, 24, 1191619330, 84, 16, 1224120905, 42, 6, 1247128595, 127, 31, 1256851221, 119, 29, 1256859941, 99, 21, 1281504927, 19, 2, 1281504928, 26, 3, 1281504929, 32, 4, 1281504930, 38, 5, 1281504931, 72, 10, 1300920242, 216, 48, 1315594157, 131, 32, 1331527911, 87, 18, 1331527951, 115, 26, 1353240160, 92, 20, 1353240200, 105, 25, 1353282001, 95, 20, 1390131750, 6, 1, 1471167773, 100, 22, 1488339816, 3, 1, 1505599503, 57, 8, 1517239679, 135, 33, 1548301286, 192, 43, 1548301287, 288, 64, 1557581862, 62, 9, 1595760524, 125, 30, 1598208865, 101, 22, 1607394163, 94, 20, 1631111070, 148, 34, 1631115402, 141, 34, 1631118438, 149, 35, 1631118442, 153, 36, 1631118443, 159, 37, 1631118473, 165, 38, 1631118477, 170, 39, 1631118478, 175, 40, 1631118511, 180, 41, 1631118518, 185, 42, 1631119848, 8, 1, 1631121133, 190, 43, 1631121137, 195, 44, 1631121178, 200, 45, 1631122501, 204, 46, 1631125660, 210, 47, 1631126880, 17, 2, 1631127023, 214, 48, 1631127025, 218, 49, 1631127028, 222, 50, 1631127030, 226, 51, 1631127031, 233, 52, 1631127061, 236, 53, 1631127062, 240, 54, 1631127063, 245, 55, 1631127064, 249, 56, 1631127065, 253, 57, 1631127066, 257, 58, 1631127067, 261, 59, 1631127069, 265, 60, 1631127070, 270, 61, 1631127099, 275, 62, 1631127100, 281, 63, 1631128323, 286, 64, 1631128357, 295, 65, 1644399785, 112, 25, 1662367273, 89, 19, 1679044343, 13, 2, 1679044344, 22, 3, 1679044352, 28, 4, 1679044381, 34, 5, 1679044425, 52, 8, 1679044426, 45, 7, 1679044465, 60, 9, 1679044499, 40, 6, 1679044503, 68, 10, 1679044504, 108, 25, 1679044542, 129, 31, 1682192770, 301, 66, 1682192847, 303, 67, 1682194284, 311, 68, 1682194285, 315, 69, 1682194286, 319, 70, 1682194287, 323, 71, 1682194288, 327, 72, 1682194289, 331, 73, 1682194290, 335, 74, 1682194291, 339, 75, 1682194292, 343, 76, 1682194293, 347, 77, 1688404974, 230, 52, 1688406300, 291, 65, 1688448255, 304, 67, 1688449692, 308, 68, 1688449693, 312, 69, 1688449694, 316, 70, 1688449695, 320, 71, 1688449696, 324, 72, 1688449697, 328, 73, 1688449698, 332, 74, 1688449699, 336, 75, 1688449700, 340, 76, 1688449701, 344, 77, 1720797658, 54, 8, 1728992593, 1, 1, 1738153904, 212, 47, 1758156494, 147, 34, 1758159530, 151, 35, 1758159534, 156, 36, 1758159535, 163, 37, 1758159565, 168, 38, 1758159569, 173, 39, 1758159570, 178, 40, 1758159603, 183, 41, 1758159610, 188, 42, 1758162225, 193, 43, 1758162229, 198, 44, 1758163593, 208, 46, 1758168120, 224, 50, 1758168122, 228, 51, 1758168153, 238, 53, 1758168154, 243, 54, 1758168156, 251, 56, 1758168157, 255, 57, 1758168158, 259, 58, 1758168159, 263, 59, 1758168161, 268, 60, 1758168162, 273, 61, 1758168191, 279, 62, 1758168192, 284, 63, 1758169415, 289, 64, 1816484369, 116, 27, 1816997745, 111, 25, 1823794041, 65, 9, 1838535777, 110, 25, 1850605607, 93, 20, 1852677220, 152, 35, 1852677224, 158, 36, 1852677225, 164, 37, 1852677255, 169, 38, 1852677259, 174, 39, 1852677260, 179, 40, 1852677293, 184, 41, 1852677300, 189, 42, 1852678630, 11, 1, 1852679915, 194, 43, 1852679919, 199, 44, 1852679960, 203, 45, 1852681283, 209, 46, 1852684442, 213, 47, 1852685662, 20, 2, 1852685805, 217, 48, 1852685807, 221, 49, 1852685810, 225, 50, 1852685812, 229, 51, 1852685813, 235, 52, 1852685843, 239, 53, 1852685844, 244, 54, 1852685845, 248, 55, 1852685846, 252, 56, 1852685847, 256, 57, 1852685848, 260, 58, 1852685849, 264, 59, 1852685851, 269, 60, 1852685852, 274, 61, 1852685881, 280, 62, 1852685882, 285, 63, 1852687105, 290, 64, 1852687139, 297, 65, 1852893633, 298, 66, 1852893710, 302, 67, 1867156994, 15, 2, 1867156995, 24, 3, 1867156996, 30, 4, 1867156997, 36, 5, 1867156998, 70, 10, 1867587388, 75, 12, 1878925523, 294, 65, 1946560293, 231, 52, 1946561619, 292, 65, 1946603574, 305, 67, 1946605011, 309, 68, 1946605012, 313, 69, 1946605013, 317, 70, 1946605014, 321, 71, 1946605015, 325, 72, 1946605016, 329, 73, 1946605017, 333, 74, 1946605018, 337, 75, 1946605019, 341, 76, 1946605020, 345, 77, 1955469778, 136, 33, 1984833269, 73, 11, 1984833271, 74, 12, 2015924652, 232, 52, 2015925978, 293, 65, 2015967933, 306, 67, 2015969370, 310, 68, 2015969371, 314, 69, 2015969372, 318, 70, 2015969373, 322, 71, 2015969374, 326, 72, 2015969375, 330, 73, 2015969376, 334, 74, 2015969377, 338, 75, 2015969378, 342, 76, 2015969379, 346, 77, 2067437539, 50, 7, 2075202984, 206, 46, 2075203018, 144, 34, 2075203025, 207, 46, 2075203066, 154, 36, 2075203112, 172, 39, 2075203140, 161, 37, 2075203149, 187, 42, 2075203171, 177, 40, 2075203212, 197, 44, 2075203264, 283, 63, 2075203265, 167, 38, 0x7BB11777, 146, 34, 2075203450, 155, 36, 2075203630, 162, 37, 2075203720, 143, 34, 2075203797, 145, 34, 2075203874, 278, 62};

    public static int getCharsetType(String[] stringArray) {
        int n2 = IANACharset.searchForCharset(stringArray[0]);
        if (n2 != -1) {
            stringArray[0] = fgJavaEncodingNames[n2];
        }
        return n2;
    }

    public static EncodingSupport getEncodingSupport(String[] stringArray) {
        switch (IANACharset.getCharsetType(stringArray)) {
            default: {
                return PlatformEncodingSupport.getInstance();
            }
            case 0: {
                return UTF8EncodingSupport.getInstance();
            }
            case 1: {
                return ASCIIEncodingSupport.getInstance();
            }
            case 2: {
                return Latin1EncodingSupport.getInstance();
            }
            case 3: {
                return PlatformEncodingSupport.getInstance();
            }
            case 4: {
                return PlatformEncodingSupport.getInstance();
            }
            case 5: {
                return PlatformEncodingSupport.getInstance();
            }
            case 6: {
                return PlatformEncodingSupport.getInstance();
            }
            case 7: {
                return PlatformEncodingSupport.getInstance();
            }
            case 8: {
                return PlatformEncodingSupport.getInstance();
            }
            case 9: {
                return PlatformEncodingSupport.getInstance();
            }
            case 10: {
                return PlatformEncodingSupport.getInstance();
            }
            case 11: {
                return PlatformEncodingSupport.getInstance();
            }
            case 12: {
                return PlatformEncodingSupport.getInstance();
            }
            case 13: {
                return UCSEncodingSupport.getInstance(0);
            }
            case 14: {
                return UCSEncodingSupport.getInstance(1);
            }
            case 15: {
                return UCSEncodingSupport.getInstance(2);
            }
            case 16: {
                return UCSEncodingSupport.getInstance(3);
            }
            case 17: {
                return UCSEncodingSupport.getInstance(4);
            }
            case 18: {
                return PlatformEncodingSupport.getInstance();
            }
            case 19: {
                return PlatformEncodingSupport.getInstance();
            }
            case 20: {
                return PlatformEncodingSupport.getInstance();
            }
            case 21: {
                return PlatformEncodingSupport.getInstance();
            }
            case 22: {
                return PlatformEncodingSupport.getInstance();
            }
            case 23: {
                return PlatformEncodingSupport.getInstance();
            }
            case 24: {
                return PlatformEncodingSupport.getInstance();
            }
            case 25: {
                return PlatformEncodingSupport.getInstance();
            }
            case 26: {
                return PlatformEncodingSupport.getInstance();
            }
            case 27: {
                return PlatformEncodingSupport.getInstance();
            }
            case 28: {
                return PlatformEncodingSupport.getInstance();
            }
            case 29: {
                return PlatformEncodingSupport.getInstance();
            }
            case 30: {
                return PlatformEncodingSupport.getInstance();
            }
            case 31: {
                return PlatformEncodingSupport.getInstance();
            }
            case 32: {
                return PlatformEncodingSupport.getInstance();
            }
            case 33: {
                return PlatformEncodingSupport.getInstance();
            }
            case 34: {
                return EBCDICEncodingSupport.getInstance(0);
            }
            case 35: {
                return EBCDICEncodingSupport.getInstance(1);
            }
            case 36: {
                return EBCDICEncodingSupport.getInstance(2);
            }
            case 37: {
                return EBCDICEncodingSupport.getInstance(3);
            }
            case 38: {
                return EBCDICEncodingSupport.getInstance(4);
            }
            case 39: {
                return EBCDICEncodingSupport.getInstance(5);
            }
            case 40: {
                return EBCDICEncodingSupport.getInstance(6);
            }
            case 41: {
                return PlatformEncodingSupport.getInstance();
            }
            case 42: {
                return EBCDICEncodingSupport.getInstance(7);
            }
            case 43: {
                return PlatformEncodingSupport.getInstance();
            }
            case 44: {
                return PlatformEncodingSupport.getInstance();
            }
            case 45: {
                return PlatformEncodingSupport.getInstance();
            }
            case 46: {
                return EBCDICEncodingSupport.getInstance(8);
            }
            case 47: {
                return PlatformEncodingSupport.getInstance();
            }
            case 48: {
                return PlatformEncodingSupport.getInstance();
            }
            case 49: {
                return PlatformEncodingSupport.getInstance();
            }
            case 50: {
                return PlatformEncodingSupport.getInstance();
            }
            case 51: {
                return PlatformEncodingSupport.getInstance();
            }
            case 52: {
                return PlatformEncodingSupport.getInstance();
            }
            case 53: {
                return PlatformEncodingSupport.getInstance();
            }
            case 54: {
                return PlatformEncodingSupport.getInstance();
            }
            case 55: {
                return PlatformEncodingSupport.getInstance();
            }
            case 56: {
                return PlatformEncodingSupport.getInstance();
            }
            case 57: {
                return PlatformEncodingSupport.getInstance();
            }
            case 58: {
                return PlatformEncodingSupport.getInstance();
            }
            case 59: {
                return PlatformEncodingSupport.getInstance();
            }
            case 60: {
                return PlatformEncodingSupport.getInstance();
            }
            case 61: {
                return PlatformEncodingSupport.getInstance();
            }
            case 62: {
                return PlatformEncodingSupport.getInstance();
            }
            case 63: {
                return EBCDICEncodingSupport.getInstance(9);
            }
            case 64: {
                return PlatformEncodingSupport.getInstance();
            }
            case 65: {
                return PlatformEncodingSupport.getInstance();
            }
            case 66: {
                return PlatformEncodingSupport.getInstance();
            }
            case 67: {
                return EBCDICEncodingSupport.getInstance(10);
            }
            case 68: {
                return EBCDICEncodingSupport.getInstance(11);
            }
            case 69: {
                return EBCDICEncodingSupport.getInstance(12);
            }
            case 70: {
                return EBCDICEncodingSupport.getInstance(13);
            }
            case 71: {
                return EBCDICEncodingSupport.getInstance(14);
            }
            case 72: {
                return EBCDICEncodingSupport.getInstance(15);
            }
            case 73: {
                return EBCDICEncodingSupport.getInstance(16);
            }
            case 74: {
                return EBCDICEncodingSupport.getInstance(17);
            }
            case 75: {
                return EBCDICEncodingSupport.getInstance(18);
            }
            case 76: {
                return EBCDICEncodingSupport.getInstance(19);
            }
            case 77: {
                return EBCDICEncodingSupport.getInstance(20);
            }
            case 78: {
                return Windows125xEncodingSupport.getInstance(0);
            }
            case 79: {
                return Windows125xEncodingSupport.getInstance(1);
            }
            case 80: {
                return Windows125xEncodingSupport.getInstance(2);
            }
            case 81: {
                return Windows125xEncodingSupport.getInstance(3);
            }
            case 82: {
                return Windows125xEncodingSupport.getInstance(4);
            }
            case 83: {
                return Windows125xEncodingSupport.getInstance(5);
            }
            case 84: {
                return Windows125xEncodingSupport.getInstance(6);
            }
            case 85: {
                return Windows125xEncodingSupport.getInstance(7);
            }
            case 86: {
                return Windows125xEncodingSupport.getInstance(8);
            }
            case 87: 
        }
        return PlatformEncodingSupport.getInstance();
    }

    public static int hashString(String string2) {
        int n2 = string2.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = n3 >> 24;
            int n5 = string2.charAt(i);
            if (n5 >= 97 && n5 <= 122) {
                n5 = 65 + (n5 - 97);
            }
            n3 += n3 * 37 + n4 + n5;
        }
        return n3 &= Integer.MAX_VALUE;
    }

    private static int searchForCharset(String string2) {
        int n2 = 0;
        int n3 = fgHashCodes.length / 3 - 1;
        int n4 = IANACharset.hashString(string2);
        while (n2 <= n3) {
            int n5 = (n2 + n3) / 2;
            int n6 = fgHashCodes[n5 * 3];
            if (n6 < n4) {
                n2 = n5 + 1;
                continue;
            }
            if (n6 > n4) {
                n3 = n5 - 1;
                continue;
            }
            int n7 = fgHashCodes[n5 * 3 + 1];
            if (!string2.equalsIgnoreCase(fgCharsetNames[n7])) break;
            return fgHashCodes[n5 * 3 + 2];
        }
        return -1;
    }
}

