/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.api.util.DataBufferHelper;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataSource;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.Base64;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class CharacterStreamDataSource
implements DataSource {
    private static final String cn = CharacterStreamDataSource.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(CharacterStreamDataSource.class);
    public int bufferLength;
    public boolean normalizeLineBreaks;
    public boolean isXML10;
    private static final boolean CLEAR_TO_END_OF_BUFFER = false;
    private CharacterStreamDataSource fNextFreeDataSource;
    private DataSourceFactory fSourceFactory;
    private DataBufferFactory fBufferFactory;
    private Reader fReader;
    private char[] fReadBuffer;
    private int fReadOffset;
    private int fReadLimit;
    private int fReadLength;

    public CharacterStreamDataSource(DataSourceFactory dataSourceFactory, DataBufferFactory dataBufferFactory, int n2) {
        this.fSourceFactory = dataSourceFactory;
        this.fBufferFactory = dataBufferFactory;
        this.bufferLength = n2;
        this.fReadLength = n2;
        this.fReadBuffer = ArrayAllocator.newCharArray(this.fReadLength + 1);
    }

    public void setNextFreeDataSource(CharacterStreamDataSource characterStreamDataSource) {
        this.fNextFreeDataSource = characterStreamDataSource;
    }

    public CharacterStreamDataSource getNextFreeDataSource() {
        return this.fNextFreeDataSource;
    }

    public void setCharacterStream(Reader reader) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "setCharacterStream", reader);
        }
        this.fReader = reader;
        this.isXML10 = true;
        this.fReadLimit = 0;
        this.fReadOffset = 0;
    }

    public int readFromReader(char[] cArray, int n2, int n3) throws IOException {
        try {
            int n4 = this.fReader.read(cArray, n2, n3);
            if (n4 == -1) {
                if (LoggerUtil.isFinerLoggable(logger)) {
                    logger.logp(Level.FINER, cn, "readFromReader", "end of reader {0}", this.fReader);
                }
                Reader reader = this.fReader;
                this.fReader = null;
                reader.close();
                return -1;
            }
            if (LoggerUtil.isFinerLoggable(logger)) {
                int n5 = n4 * 2;
                byte[] byArray = ArrayAllocator.newByteArray(n5);
                for (int i = 0; i < n5; i += 2) {
                    char c = cArray[n2++];
                    byArray[i] = (byte)(c >> 8);
                    byArray[i + 1] = (byte)(c & 0xFF);
                }
                String string2 = Base64.encode(byArray);
                Object[] objectArray = new Object[]{this.fReader, string2};
                logger.logp(Level.FINER, cn, "readFromReader", "data {0} {1}", objectArray);
            }
            return n4;
        }
        catch (IOException iOException) {
            if (LoggerUtil.isFinerLoggable(logger)) {
                Object[] objectArray = new Object[]{this.fReader, iOException};
                logger.logp(Level.FINER, cn, "readFromReader", "exception thrown {0} {1}", objectArray);
            }
            this.safeClose();
            throw iOException;
        }
    }

    private int readMoreChars() throws IOException {
        int n2;
        int n3 = this.fReadLength;
        if (this.fReadOffset == n3) {
            this.fReadLength <<= 1;
            this.fReadBuffer = ArrayAllocator.resizeCharArray(this.fReadBuffer, this.fReadLength + 1);
            n3 = this.fReadLength;
        }
        if ((n2 = this.readFromReader(this.fReadBuffer, this.fReadOffset, n3 - this.fReadOffset)) == -1) {
            return -1;
        }
        this.fReadLimit += n2;
        return this.fReadBuffer[this.fReadOffset++];
    }

    public int readChar() throws IOException {
        if (this.fReadOffset < this.fReadLimit) {
            return this.fReadBuffer[this.fReadOffset++];
        }
        return this.readMoreChars();
    }

    public CharConversionError loadFromCharacterStream(ParsedEntity parsedEntity) {
        this.fReadOffset = this.fReadLimit;
        return this.load(parsedEntity);
    }

    public CharConversionError load(ParsedEntity parsedEntity) {
        DataBuffer dataBuffer = this.fBufferFactory.createBuffer(this.bufferLength + 1);
        dataBuffer.endOffset = this.bufferLength;
        parsedEntity.error = this.load(dataBuffer);
        int n2 = dataBuffer.endOffset;
        dataBuffer.bytes[n2] = 0;
        dataBuffer.startOffset = 0;
        if (parsedEntity.isCoordinatesAware) {
            if (parsedEntity.buffer != null) {
                if (parsedEntity.isXML10) {
                    DataBufferHelper.computeCoords10(parsedEntity.buffer, dataBuffer);
                } else {
                    DataBufferHelper.computeCoords11(parsedEntity.buffer, dataBuffer);
                }
            } else {
                dataBuffer.byteOffset = 0;
            }
        }
        if (this.fReader == null && this.fReadOffset == 0) {
            parsedEntity.setValues(dataBuffer, 0, n2, null);
            this.release();
        } else {
            parsedEntity.setValues(dataBuffer, 0, n2, this);
        }
        return parsedEntity.error;
    }

    public void release() {
        this.safeClose();
        this.fSourceFactory.releaseCharacterStreamDataSource(this);
    }

    private void safeClose() {
        if (this.fReader != null) {
            try {
                this.fReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fReader = null;
        }
    }

    private CharConversionError load(DataBuffer dataBuffer) {
        int n2;
        byte[] byArray = dataBuffer.bytes;
        int n3 = dataBuffer.endOffset;
        int n4 = 0;
        int n5 = this.fReadOffset;
        if (this.fReader != null && n5 < this.fReadLength) {
            try {
                n2 = this.readFromReader(this.fReadBuffer, n5, this.fReadLength - n5);
                if (n2 == -1) {
                    if (n5 == 0) {
                        dataBuffer.endOffset = 0;
                        return null;
                    }
                } else {
                    n5 += n2;
                }
            }
            catch (IOException iOException) {
                this.fReadOffset = 0;
                dataBuffer.endOffset = 0;
                return CharConversionError.runtimeIOError(iOException);
            }
        }
        this.fReadOffset = 0;
        while (this.fReadOffset < n5 && n4 < n3) {
            if ((n2 = this.fReadBuffer[this.fReadOffset++]) < 128) {
                if (n2 != 13) {
                    byArray[n4++] = (byte)n2;
                    continue;
                }
                if (this.fReadOffset < n5) {
                    byArray[n4++] = 10;
                    if ((n2 = this.fReadBuffer[this.fReadOffset++]) == 10 || !this.isXML10 && n2 == 133) continue;
                    --this.fReadOffset;
                    continue;
                }
                if (this.fReader == null) {
                    byArray[n4++] = 10;
                    break;
                }
                --this.fReadOffset;
                break;
            }
            if (!(this.isXML10 || n2 != 133 && n2 != 8232)) {
                byArray[n4++] = 10;
                continue;
            }
            if (n2 < 2048) {
                if (n4 + 1 < n3) {
                    byArray[n4++] = (byte)(0xC0 | n2 >> 6);
                    byArray[n4++] = (byte)(0x80 | 0x3F & n2);
                    continue;
                }
                --this.fReadOffset;
                break;
            }
            if (n2 < 55296 || n2 >= 57344) {
                if (n4 + 2 < n3) {
                    byArray[n4++] = (byte)(0xE0 | n2 >> 12);
                    byArray[n4++] = (byte)(0x80 | 0x3F & n2 >> 6);
                    byArray[n4++] = (byte)(0x80 | 0x3F & n2);
                    continue;
                }
                --this.fReadOffset;
                break;
            }
            if (n2 < 56320) {
                if (this.fReadOffset < n5 && n4 + 3 < n3) {
                    char c;
                    if ((c = this.fReadBuffer[this.fReadOffset++]) >= '\udc00' && c < '\ue000') {
                        n2 = 65536 + (n2 - 55296 << 10) + (c - 56320);
                        byArray[n4++] = (byte)(0xF0 | n2 >> 18);
                        byArray[n4++] = (byte)(0x80 | 0x3F & n2 >> 12);
                        byArray[n4++] = (byte)(0x80 | 0x3F & n2 >> 6);
                        byArray[n4++] = (byte)(0x80 | 0x3F & n2);
                        continue;
                    }
                    --this.fReadOffset;
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                --this.fReadOffset;
                break;
            }
            --this.fReadOffset;
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
        }
        if (this.fReadOffset < n5) {
            System.arraycopy(this.fReadBuffer, this.fReadOffset, this.fReadBuffer, 0, n5 -= this.fReadOffset);
            this.fReadOffset = n5;
        } else {
            this.fReadOffset = 0;
        }
        dataBuffer.endOffset = n4;
        return null;
    }
}

