/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.api.util.DataBufferHelper;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.CharacterStreamDataSource;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.RewindableInputStream;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataSource;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ByteStreamDataSource
implements DataSource {
    private static final String cn = ByteStreamDataSource.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(ByteStreamDataSource.class);
    public int bufferLength;
    public byte[] readBuffer;
    public int readOffset;
    public int readLength;
    public boolean normalizeLineBreaks;
    public boolean isXML10;
    private static final boolean CLEAR_TO_END_OF_BUFFER = false;
    private ByteStreamDataSource fNextFreeDataSource;
    private final DataSourceFactory fSourceFactory;
    private final DataBufferFactory fBufferFactory;
    private EncodingSupport fEncodingSupport;
    private InputStream fStream;
    private String fEncodingName;
    private char[] fEncodingBuffer;
    private int fEncodingLength;
    private boolean fUseReadBufferForLoad;
    private int fReadMark;
    private int fReadLimit;

    public ByteStreamDataSource(DataSourceFactory dataSourceFactory, DataBufferFactory dataBufferFactory, int n2) {
        this.fSourceFactory = dataSourceFactory;
        this.fBufferFactory = dataBufferFactory;
        this.bufferLength = n2;
        this.readLength = n2;
        this.readBuffer = ArrayAllocator.newByteArray(this.readLength + 1);
        this.fEncodingBuffer = ArrayAllocator.newCharArray(64);
    }

    public void setNextFreeDataSource(ByteStreamDataSource byteStreamDataSource) {
        this.fNextFreeDataSource = byteStreamDataSource;
    }

    public ByteStreamDataSource getNextFreeDataSource() {
        return this.fNextFreeDataSource;
    }

    public void setByteStream(InputStream inputStream, String string2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            Object[] objectArray = new Object[]{inputStream, string2};
            logger.entering(cn, "setByteStream", objectArray);
        }
        this.fStream = inputStream;
        this.fEncodingName = string2;
        this.isXML10 = true;
        this.fReadLimit = 0;
        this.readOffset = 0;
        this.fReadMark = 0;
        this.fUseReadBufferForLoad = false;
        this.fEncodingLength = 0;
    }

    public void addEncodingChar(char c) {
        if (this.fEncodingLength == this.fEncodingBuffer.length) {
            this.fEncodingBuffer = ArrayAllocator.resizeCharArray(this.fEncodingBuffer, this.fEncodingLength << 1);
        }
        this.fEncodingBuffer[this.fEncodingLength++] = c;
    }

    public boolean saveEncodingChars() {
        if (this.fEncodingLength > 0) {
            if (this.fEncodingName == null) {
                this.fEncodingName = new String(this.fEncodingBuffer, 0, this.fEncodingLength);
            }
            return true;
        }
        return false;
    }

    public void setEncodingName(String string2) {
        this.fEncodingName = string2;
    }

    public String getEncodingName() {
        return this.fEncodingName;
    }

    public void setEncodingSupport(EncodingSupport encodingSupport) {
        this.fEncodingSupport = encodingSupport;
        this.readOffset = this.fReadLimit;
        this.fReadLimit = 0;
    }

    public void useReadBufferForLoad() {
        this.fUseReadBufferForLoad = true;
    }

    public void resetOffsets() {
        this.fReadLimit -= this.readOffset;
        System.arraycopy(this.readBuffer, this.readOffset, this.readBuffer, 0, this.fReadLimit);
        this.readOffset = 0;
    }

    public void mark() {
        this.fReadMark = this.readOffset;
    }

    public void reset() {
        this.readOffset = this.fReadMark;
    }

    public void rewind() {
        this.readOffset = 0;
        this.fReadMark = 0;
    }

    public void unreadByte() {
        --this.readOffset;
    }

    private int readMoreBytes() throws IOException {
        int n2;
        int n3 = this.readLength;
        if (this.readOffset == n3) {
            this.readLength <<= 1;
            this.readBuffer = ArrayAllocator.resizeByteArray(this.readBuffer, this.readLength + 1);
            n3 = this.readLength;
        }
        if ((n2 = this.readFromStream(this.readBuffer, this.readOffset, n3 - this.readOffset)) == -1) {
            return -1;
        }
        this.fReadLimit += n2;
        return this.readBuffer[this.readOffset++] & 0xFF;
    }

    public int readByte() throws IOException {
        if (this.readOffset < this.fReadLimit) {
            return this.readBuffer[this.readOffset++] & 0xFF;
        }
        return this.readMoreBytes();
    }

    public boolean atEndOfStream() {
        return this.fStream == null;
    }

    public int readFromStream(byte[] byArray, int n2, int n3) throws IOException {
        try {
            int n4 = this.fStream.read(byArray, n2, n3);
            if (n4 == -1) {
                if (LoggerUtil.isFinerLoggable(logger)) {
                    logger.logp(Level.FINER, cn, "readFromStream", "end of stream {0}", this.fStream);
                }
                InputStream inputStream = this.fStream;
                this.fStream = null;
                inputStream.close();
                return -1;
            }
            if (LoggerUtil.isFinerLoggable(logger)) {
                byte[] byArray2 = ArrayAllocator.newByteArray(n4);
                System.arraycopy(byArray, n2, byArray2, 0, n4);
                String string2 = Base64.encode(byArray2);
                Object[] objectArray = new Object[]{this.fStream, string2};
                logger.logp(Level.FINER, cn, "readFromStream", "data {0} {1}", objectArray);
            }
            return n4;
        }
        catch (IOException iOException) {
            if (LoggerUtil.isFinerLoggable(logger)) {
                Object[] objectArray = new Object[]{this.fStream, iOException};
                logger.logp(Level.FINER, cn, "readFromStream", "exception thrown {0} {1}", objectArray);
            }
            if (this.fStream != null) {
                try {
                    this.fStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.fStream = null;
            }
            throw iOException;
        }
    }

    public CharConversionError fillReadBuffer() {
        try {
            int n2 = this.readFromStream(this.readBuffer, this.readOffset, this.readLength - this.readOffset);
            if (n2 != -1) {
                this.readOffset += n2;
            }
            return null;
        }
        catch (IOException iOException) {
            this.readOffset = 0;
            return CharConversionError.runtimeIOError(iOException);
        }
    }

    public void copyToReadBuffer(byte[] byArray, int n2, int n3) {
        if (n3 > this.readLength) {
            int n4;
            for (n4 = this.readLength << 1; n3 > n4; n4 <<= 1) {
            }
            this.readLength = n4;
            this.readBuffer = ArrayAllocator.replaceByteArray(this.readBuffer, n4 + 1);
        }
        System.arraycopy(byArray, n2, this.readBuffer, 0, n3);
        this.readOffset = n3;
    }

    public CharConversionError load(ParsedEntity parsedEntity) {
        DataBuffer dataBuffer = this.fBufferFactory.createBuffer(this.bufferLength + 1);
        if (this.fUseReadBufferForLoad) {
            byte[] byArray = dataBuffer.bytes;
            dataBuffer.bytes = this.readBuffer;
            dataBuffer.startOffset = 0;
            dataBuffer.endOffset = this.readLength;
            this.readBuffer = byArray;
            this.readLength = this.readBuffer.length - 1;
            this.fUseReadBufferForLoad = false;
        } else {
            dataBuffer.endOffset = this.bufferLength;
        }
        parsedEntity.error = this.fEncodingSupport.load(this, dataBuffer);
        int n2 = dataBuffer.endOffset;
        dataBuffer.bytes[n2] = 0;
        dataBuffer.startOffset = 0;
        if (parsedEntity.isCoordinatesAware) {
            if (parsedEntity.buffer != null) {
                if (parsedEntity.isXML10) {
                    DataBufferHelper.computeCoords10(parsedEntity.buffer, dataBuffer);
                } else {
                    DataBufferHelper.computeCoords11(parsedEntity.buffer, dataBuffer);
                }
                dataBuffer.byteOffset = parsedEntity.buffer.byteOffset + parsedEntity.buffer.endOffset - parsedEntity.buffer.startOffset;
            } else {
                dataBuffer.byteOffset = 0;
            }
        }
        if (this.fStream == null && this.readOffset == 0) {
            parsedEntity.setValues(dataBuffer, 0, n2, null);
            this.release();
        } else {
            parsedEntity.setValues(dataBuffer, 0, n2, this);
        }
        return parsedEntity.error;
    }

    public void release() {
        if (this.fStream != null) {
            try {
                this.fStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fStream = null;
        }
        this.readOffset = 0;
        this.fEncodingName = null;
        this.fSourceFactory.releaseByteStreamDataSource(this);
    }

    public CharConversionError convertToCharacterStream(ParsedEntity parsedEntity) {
        try {
            RewindableInputStream rewindableInputStream = new RewindableInputStream();
            rewindableInputStream.setStream(this.fStream, this.readBuffer, this.fReadLimit);
            this.fStream = null;
            this.fReadLimit = 0;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)rewindableInputStream, Charset.forName(this.getEncodingName()).newDecoder());
            CharacterStreamDataSource characterStreamDataSource = this.fSourceFactory.allocateCharacterStreamDataSource();
            characterStreamDataSource.setCharacterStream(inputStreamReader);
            characterStreamDataSource.isXML10 = this.isXML10;
            return characterStreamDataSource.load(parsedEntity);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(illegalArgumentException.getMessage());
            unsupportedEncodingException.initCause(illegalArgumentException);
            parsedEntity.error = CharConversionError.runtimeIOError(unsupportedEncodingException);
            return parsedEntity.error;
        }
    }
}

