/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.xlxp.internal.s1.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.SingleByteEncodingSupport;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class ASCIIEncodingSupport
extends SingleByteEncodingSupport {
    private static final EncodingSupport fgSingleton = new ASCIIEncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    private ASCIIEncodingSupport() {
    }

    /*
     * Enabled aggressive block sorting
     */
    protected CharConversionError normalizeLineBreaks(DataBuffer dataBuffer, int n2, ByteStreamDataSource byteStreamDataSource) {
        byte by2;
        byte[] byArray = dataBuffer.bytes;
        int n3 = 0;
        byArray[n2] = 13;
        while ((by2 = byArray[n3]) != 13 && by2 >= 0) {
            ++n3;
        }
        if (n3 == n2) {
            byArray[n2] = 0;
            byteStreamDataSource.readOffset = 0;
            dataBuffer.endOffset = n2;
            return null;
        }
        int n4 = n3;
        while (n3 < n2) {
            if (by2 != 13) {
                dataBuffer.endOffset = n4;
                byteStreamDataSource.readOffset = 0;
                return CharConversionError.unableToConvertOutOfRangeUnicodeCharacter();
            }
            if (++n3 < n2) {
                by2 = byArray[n3];
                if (by2 == 10) {
                    ++n3;
                }
                byArray[n4++] = 10;
                by2 = byArray[n3];
                if (by2 == 13) continue;
            } else {
                if (byteStreamDataSource.atEndOfStream()) {
                    byArray[n4++] = 10;
                    break;
                }
                --n3;
                break;
            }
            if (by2 < 0) continue;
            int n5 = n3++;
            while ((by2 = byArray[n3]) != 13 && by2 >= 0) {
                ++n3;
            }
            if (n5 != n4) {
                System.arraycopy(byArray, n5, byArray, n4, n3 - n5);
            }
            n4 += n3 - n5;
        }
        byArray[n2] = 0;
        dataBuffer.endOffset = n4;
        byteStreamDataSource.readOffset = n2 - n3;
        if (byteStreamDataSource.readOffset > 0) {
            System.arraycopy(byArray, n3, byteStreamDataSource.readBuffer, 0, byteStreamDataSource.readOffset);
            byteStreamDataSource.useReadBufferForLoad();
        }
        return null;
    }
}

