/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLStringBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class ParsedEntityStream
extends InputStream {
    private final XMLString fContent = new XMLString();
    private XMLStringBuffer fStringBuffer;
    private DataBuffer fDataBuffer;
    private int fDataOffset;
    private int fDataLength;
    private int fLastOffset;

    public XMLString skippedContent() {
        return this.fContent;
    }

    public void writeToUTF8Stream(OutputStream outputStream) throws IOException {
        int n2 = this.fContent.length;
        DataBuffer dataBuffer = this.fContent.firstBuffer;
        int n3 = this.fContent.startOffset;
        while (true) {
            int n4 = Math.min(n2, dataBuffer.endOffset - n3);
            outputStream.write(dataBuffer.bytes, n3, n4);
            if (n4 == n2) {
                return;
            }
            n2 -= n4;
            dataBuffer = dataBuffer.next;
            n3 = dataBuffer.startOffset;
        }
    }

    public void writeTo(Writer writer) throws IOException {
        int n2;
        for (n2 = 8; n2 < this.fContent.length; n2 <<= 1) {
        }
        char[][] cArray = ArrayAllocator.newCharArray2(1);
        cArray[0] = ArrayAllocator.newCharArray(n2);
        int[] nArray = ArrayAllocator.newIntArray(1);
        this.fContent.getChars(cArray, nArray);
        writer.write(cArray[0], 0, nArray[0]);
    }

    public String toString() {
        return this.fContent.toString();
    }

    private void prepareForReading() {
        if ((this.fContent.flags & 0xC) != 0) {
            if (this.fStringBuffer == null) {
                this.fStringBuffer = new XMLStringBuffer();
            }
            this.fStringBuffer.addXMLString(this.fContent, this.fContent);
        }
        this.fDataBuffer = this.fContent.firstBuffer;
        this.fDataLength = this.fContent.length;
        this.fDataOffset = this.fContent.startOffset;
        this.fLastOffset = Math.min(this.fDataOffset + this.fDataLength, this.fDataBuffer.endOffset);
    }

    public int available() {
        if (this.fDataBuffer == null) {
            this.prepareForReading();
        }
        return this.fDataLength;
    }

    public int read() {
        if (this.fDataBuffer == null) {
            this.prepareForReading();
        }
        while (true) {
            if (this.fDataOffset < this.fLastOffset) {
                --this.fDataLength;
                return this.fDataBuffer.bytes[this.fDataOffset++] & 0xFF;
            }
            if (this.fDataLength <= 0) break;
            this.fDataBuffer = this.fDataBuffer.next;
            this.fDataOffset = this.fDataBuffer.startOffset;
            this.fLastOffset = Math.min(this.fDataOffset + this.fDataLength, this.fDataBuffer.endOffset);
        }
        return -1;
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        if (this.fDataBuffer == null) {
            this.prepareForReading();
        }
        while (this.fDataLength > 0) {
            int n5 = this.fLastOffset - this.fDataOffset;
            if (n5 > n3) {
                n5 = n3;
            }
            System.arraycopy(this.fDataBuffer.bytes, this.fDataOffset, byArray, n2, n5);
            this.fDataOffset += n5;
            this.fDataLength -= n5;
            n4 += n5;
            if (n5 < n3 && this.fDataLength > 0) {
                n2 += n5;
                n3 -= n5;
                this.fDataBuffer = this.fDataBuffer.next;
                this.fDataOffset = this.fDataBuffer.startOffset;
                this.fLastOffset = Math.min(this.fDataOffset + this.fDataLength, this.fDataBuffer.endOffset);
                continue;
            }
            return n4;
        }
        return n4 > 0 ? n4 : -1;
    }

    public void close() {
        this.fContent.unregister();
        if (this.fStringBuffer != null) {
            this.fStringBuffer.reset(false);
        }
        this.fDataBuffer = null;
    }

    public void reset() throws IOException {
        if (this.fContent.firstBuffer != null) {
            this.prepareForReading();
        } else {
            super.reset();
        }
    }
}

