/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax.serializer;

import com.ibm.xml.xlxp.internal.s1.api.stax.serializer.Encoding;
import com.ibm.xml.xlxp.internal.s1.api.stax.serializer.StAXWriter;
import com.ibm.xml.xlxp.internal.s1.api.stax.serializer.Windows125XEncoding;
import com.ibm.xml.xlxp.internal.s1.api.util.Pool;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.io.IOException;
import java.io.OutputStream;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class Windows125XWriter
extends StAXWriter {
    private static final Pool fPool = new Pool();
    private int[] fEncodableCharacters;
    private int[] fEncodedCharacters;

    public static final Windows125XWriter getInstance() {
        Windows125XWriter windows125XWriter = (Windows125XWriter)fPool.get();
        if (windows125XWriter == null) {
            windows125XWriter = new Windows125XWriter();
            fPool.assignToPool(windows125XWriter);
        }
        return windows125XWriter;
    }

    public void reset(int n2, OutputStream outputStream) {
        super.reset(outputStream);
        switch (n2) {
            case 78: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1250_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1250_ENCODED_CHARACTERS;
                break;
            }
            case 79: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1251_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1251_ENCODED_CHARACTERS;
                break;
            }
            case 80: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1252_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1252_ENCODED_CHARACTERS;
                break;
            }
            case 81: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1253_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1253_ENCODED_CHARACTERS;
                break;
            }
            case 82: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1254_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1254_ENCODED_CHARACTERS;
                break;
            }
            case 83: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1255_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1255_ENCODED_CHARACTERS;
                break;
            }
            case 84: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1256_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1256_ENCODED_CHARACTERS;
                break;
            }
            case 85: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1257_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1257_ENCODED_CHARACTERS;
                break;
            }
            case 86: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1258_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1258_ENCODED_CHARACTERS;
            }
        }
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (this.fNumBytes + n3 < this.fBuffer.length) {
            this.encodeAndWrite(cArray, n2, n3);
        } else {
            this.write0(cArray, n2, n3);
        }
    }

    private void write0(char[] cArray, int n2, int n3) throws IOException {
        this.flushInternal();
        int n4 = n2 + n3;
        while (n2 + this.fBuffer.length < n4) {
            this.encodeAndWrite(cArray, n2, this.fBuffer.length);
            n2 += this.fBuffer.length;
            this.flushInternal();
        }
        this.encodeAndWrite(cArray, n2, n4 - n2);
    }

    public void write(String string2, int n2, int n3) throws IOException {
        if (this.fNumBytes + n3 < this.fBuffer.length) {
            this.encodeAndWrite(string2, n2, n3);
        } else {
            this.write0(string2, n2, n3);
        }
    }

    private void write0(String string2, int n2, int n3) throws IOException {
        this.flushInternal();
        int n4 = n2 + n3;
        while (n2 + this.fBuffer.length < n4) {
            this.encodeAndWrite(string2, n2, this.fBuffer.length);
            n2 += this.fBuffer.length;
            this.flushInternal();
        }
        this.encodeAndWrite(string2, n2, n4 - n2);
    }

    public void write(int n2) throws IOException {
        if (this.fNumBytes == this.fBuffer.length) {
            this.flushInternal();
        }
        int n3 = this.fNumBytes++;
        this.fBuffer[n3] = (byte)(this.fBuffer[n3] + (byte)n2);
    }

    private void encodeAndWrite(char[] cArray, int n2, int n3) throws IOException {
        int n4 = n2 + n3;
        int n5 = this.fNumBytes;
        for (int i = n2; i < n4; ++i) {
            char c = cArray[i];
            if (c <= '\u007f') {
                this.fBuffer[n5++] = (byte)c;
                continue;
            }
            int n6 = Encoding.find(c, this.fEncodableCharacters);
            this.fBuffer[n5++] = (byte)this.fEncodedCharacters[n6];
        }
        this.fNumBytes = n5;
    }

    private void encodeAndWrite(String string2, int n2, int n3) throws IOException {
        int n4 = n2 + n3;
        int n5 = this.fNumBytes;
        for (int i = n2; i < n4; ++i) {
            char c = string2.charAt(i);
            if (c <= '\u007f') {
                this.fBuffer[n5++] = (byte)c;
                continue;
            }
            int n6 = Encoding.find(c, this.fEncodableCharacters);
            this.fBuffer[n5++] = (byte)this.fEncodedCharacters[n6];
        }
        this.fNumBytes = n5;
    }
}

