/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax.serializer;

import com.ibm.xml.xlxp.internal.s1.api.stax.serializer.Encoding;
import com.ibm.xml.xlxp.internal.s1.api.stax.serializer.StAXWriter;
import com.ibm.xml.xlxp.internal.s1.api.util.Pool;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.io.IOException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UTF8Writer
extends StAXWriter {
    private static final Pool fPool = new Pool();

    public static final UTF8Writer getInstance() {
        UTF8Writer uTF8Writer = (UTF8Writer)fPool.get();
        if (uTF8Writer == null) {
            uTF8Writer = new UTF8Writer();
            fPool.assignToPool(uTF8Writer);
        }
        return uTF8Writer;
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (this.fNumBytes + n3 * 3 < this.fBuffer.length) {
            this.encodeAndWrite(cArray, n2, n3);
        } else {
            this.write0(cArray, n2, n3);
        }
    }

    private void write0(char[] cArray, int n2, int n3) throws IOException {
        this.flushInternal();
        int n4 = n2 + n3;
        while (n2 + this.fBuffer.length / 3 < n4) {
            char c = cArray[n2 + this.fBuffer.length / 3 - 1];
            if (c >= '\ud800' && c <= '\udbff') {
                this.encodeAndWrite(cArray, n2, this.fBuffer.length / 3 - 1);
                n2 += this.fBuffer.length / 3 - 1;
            } else {
                this.encodeAndWrite(cArray, n2, this.fBuffer.length / 3);
                n2 += this.fBuffer.length / 3;
            }
            this.flushInternal();
        }
        this.encodeAndWrite(cArray, n2, n4 - n2);
    }

    public void write(String string2, int n2, int n3) throws IOException {
        if (this.fNumBytes + n3 * 3 < this.fBuffer.length) {
            this.encodeAndWrite(string2, n2, n3);
        } else {
            this.write0(string2, n2, n3);
        }
    }

    private void write0(String string2, int n2, int n3) throws IOException {
        this.flushInternal();
        int n4 = n2 + n3;
        while (n2 + this.fBuffer.length / 3 < n4) {
            char c = string2.charAt(n2 + this.fBuffer.length / 3 - 1);
            if (c >= '\ud800' && c <= '\udbff') {
                this.encodeAndWrite(string2, n2, this.fBuffer.length / 3 - 1);
                n2 += this.fBuffer.length / 3 - 1;
            } else {
                this.encodeAndWrite(string2, n2, this.fBuffer.length / 3);
                n2 += this.fBuffer.length / 3;
            }
            this.flushInternal();
        }
        this.encodeAndWrite(string2, n2, n4 - n2);
    }

    public void write(int n2) throws IOException {
        if (this.fNumBytes + 3 >= this.fBuffer.length) {
            this.flushInternal();
        }
        if (n2 <= 127) {
            this.fBuffer[this.fNumBytes++] = (byte)n2;
        } else if (n2 >= 128 && n2 <= 2047) {
            this.fBuffer[this.fNumBytes++] = (byte)(192 + (n2 >> 6));
            this.fBuffer[this.fNumBytes++] = (byte)(128 + (n2 & 0x3F));
        } else {
            this.fBuffer[this.fNumBytes++] = (byte)(224 + (n2 >> 12));
            this.fBuffer[this.fNumBytes++] = (byte)(128 + (n2 >> 6 & 0x3F));
            this.fBuffer[this.fNumBytes++] = (byte)(128 + (n2 & 0x3F));
        }
    }

    private void encodeAndWrite(char[] cArray, int n2, int n3) throws IOException {
        char c;
        int n4;
        int n5 = n2 + n3;
        int n6 = this.fNumBytes;
        for (n4 = n2; n4 < n5 && (c = cArray[n4]) <= '\u007f'; ++n4) {
            this.fBuffer[n6++] = (byte)c;
        }
        if (n4 == n5) {
            this.fNumBytes = n6;
        } else {
            this.encodeAndWrite0(cArray, n4, n5, n6);
        }
    }

    private void encodeAndWrite0(char[] cArray, int n2, int n3, int n4) throws IOException {
        for (int i = n2; i < n3; ++i) {
            char c = cArray[i];
            if (c <= '\u007f') {
                this.fBuffer[n4++] = (byte)c;
                continue;
            }
            if (c >= '\u0080' && c <= '\u07ff') {
                this.fBuffer[n4++] = (byte)(192 + (c >> 6));
                this.fBuffer[n4++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                char c2 = cArray[++i];
                int n5 = Encoding.toCodePoint(c, c2);
                this.fBuffer[n4++] = (byte)(240 + (n5 >> 18 & 0x1F));
                this.fBuffer[n4++] = (byte)(128 + (n5 >> 12 & 0x3F));
                this.fBuffer[n4++] = (byte)(128 + (n5 >> 6 & 0x3F));
                this.fBuffer[n4++] = (byte)(128 + (n5 & 0x3F));
                continue;
            }
            this.fBuffer[n4++] = (byte)(224 + (c >> 12));
            this.fBuffer[n4++] = (byte)(128 + (c >> 6 & 0x3F));
            this.fBuffer[n4++] = (byte)(128 + (c & 0x3F));
        }
        this.fNumBytes = n4;
    }

    private void encodeAndWrite(String string2, int n2, int n3) throws IOException {
        char c;
        int n4;
        int n5 = n2 + n3;
        int n6 = this.fNumBytes;
        for (n4 = n2; n4 < n5 && (c = string2.charAt(n4)) <= '\u007f'; ++n4) {
            this.fBuffer[n6++] = (byte)c;
        }
        if (n4 == n5) {
            this.fNumBytes = n6;
        } else {
            this.encodeAndWrite0(string2, n4, n5, n6);
        }
    }

    private void encodeAndWrite0(String string2, int n2, int n3, int n4) throws IOException {
        for (int i = n2; i < n3; ++i) {
            char c = string2.charAt(i);
            if (c <= '\u007f') {
                this.fBuffer[n4++] = (byte)c;
                continue;
            }
            if (c >= '\u0080' && c <= '\u07ff') {
                this.fBuffer[n4++] = (byte)(192 + (c >> 6));
                this.fBuffer[n4++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                char c2 = string2.charAt(++i);
                int n5 = Encoding.toCodePoint(c, c2);
                this.fBuffer[n4++] = (byte)(240 + (n5 >> 18 & 0x1F));
                this.fBuffer[n4++] = (byte)(128 + (n5 >> 12 & 0x3F));
                this.fBuffer[n4++] = (byte)(128 + (n5 >> 6 & 0x3F));
                this.fBuffer[n4++] = (byte)(128 + (n5 & 0x3F));
                continue;
            }
            this.fBuffer[n4++] = (byte)(224 + (c >> 12));
            this.fBuffer[n4++] = (byte)(128 + (c >> 6 & 0x3F));
            this.fBuffer[n4++] = (byte)(128 + (c & 0x3F));
        }
        this.fNumBytes = n4;
    }

    public static void release(UTF8Writer uTF8Writer) {
        uTF8Writer.reset(null);
        uTF8Writer.release();
    }
}

