/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax.events;

import com.ibm.xml.xlxp.internal.s1.api.stax.XMLStreamWriterImpl;
import com.ibm.xml.xlxp.internal.s1.api.util.ImmutableArrayList;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class XMLEventImpl
implements XMLEvent {
    private final int fEventType;
    private final Location fLocation;
    private static final Location EMPTY_LOCATION = new Location(){

        public int getLineNumber() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public int getCharacterOffset() {
            return -1;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }
    };

    public XMLEventImpl(int n2) {
        this(n2, null);
    }

    public XMLEventImpl(int n2, Location location) {
        this.fEventType = n2;
        this.fLocation = location == null ? EMPTY_LOCATION : new LocationClone(location);
    }

    @Override
    public final int getEventType() {
        return this.fEventType;
    }

    @Override
    public final Location getLocation() {
        return this.fLocation;
    }

    @Override
    public final boolean isStartElement() {
        return this.fEventType == 1;
    }

    @Override
    public final boolean isAttribute() {
        return this.fEventType == 10;
    }

    @Override
    public final boolean isNamespace() {
        return this.fEventType == 13;
    }

    @Override
    public final boolean isEndElement() {
        return this.fEventType == 2;
    }

    @Override
    public final boolean isEntityReference() {
        return this.fEventType == 9;
    }

    @Override
    public final boolean isProcessingInstruction() {
        return this.fEventType == 3;
    }

    @Override
    public final boolean isCharacters() {
        return this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6;
    }

    public final boolean isCData() {
        return this.fEventType == 12;
    }

    public final boolean isIgnorableWhiteSpace() {
        return this.fEventType == 6;
    }

    @Override
    public final boolean isStartDocument() {
        return this.fEventType == 7;
    }

    @Override
    public final boolean isEndDocument() {
        return this.fEventType == 8;
    }

    @Override
    public final StartElement asStartElement() {
        return (StartElement)((Object)this);
    }

    @Override
    public final EndElement asEndElement() {
        return (EndElement)((Object)this);
    }

    @Override
    public final Characters asCharacters() {
        return (Characters)((Object)this);
    }

    @Override
    public final QName getSchemaType() {
        return null;
    }

    @Override
    public abstract void writeAsEncodedUnicode(Writer var1) throws XMLStreamException;

    public static String escape(String string2, int n2) {
        if (string2 == null) {
            return null;
        }
        int n3 = string2.length();
        StringBuilder stringBuilder = null;
        block12: for (int i = 0; i < n3; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '&': {
                    if (n2 == 15) {
                        if (i + 1 < n3 && string2.charAt(i + 1) == '#') {
                            stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&#38;");
                            continue block12;
                        }
                        if (stringBuilder == null) continue block12;
                        stringBuilder.append(c);
                        continue block12;
                    }
                    stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&amp;");
                    continue block12;
                }
                case '<': {
                    if (n2 != 15) {
                        stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&lt;");
                        continue block12;
                    }
                    if (stringBuilder == null) continue block12;
                    stringBuilder.append(c);
                    continue block12;
                }
                case '>': {
                    if (n2 == 4 && i >= 2 && string2.charAt(i - 1) == ']' && string2.charAt(i - 2) == ']') {
                        stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&gt;");
                        continue block12;
                    }
                    if (stringBuilder == null) continue block12;
                    stringBuilder.append(c);
                    continue block12;
                }
                case '\"': {
                    if (n2 == 10 || n2 == 15) {
                        stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&quot;");
                        continue block12;
                    }
                    if (stringBuilder == null) continue block12;
                    stringBuilder.append(c);
                    continue block12;
                }
                case '%': {
                    if (n2 == 15) {
                        stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&#37;");
                        continue block12;
                    }
                    if (stringBuilder == null) continue block12;
                    stringBuilder.append(c);
                    continue block12;
                }
                case '\t': {
                    if (n2 == 10) {
                        stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&#9;");
                        continue block12;
                    }
                    if (stringBuilder == null) continue block12;
                    stringBuilder.append(c);
                    continue block12;
                }
                case '\n': {
                    if (n2 == 10) {
                        stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&#10;");
                        continue block12;
                    }
                    if (stringBuilder == null) continue block12;
                    stringBuilder.append(c);
                    continue block12;
                }
                case '\r': {
                    stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&#13;");
                    continue block12;
                }
                case '\u0085': {
                    stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&#133;");
                    continue block12;
                }
                case '\u2028': {
                    stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&#8232;");
                    continue block12;
                }
                default: {
                    if (c >= '\u0001' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                        stringBuilder = XMLEventImpl.append(stringBuilder, string2, i, "&#");
                        stringBuilder.append(Integer.toString(c));
                        stringBuilder.append(';');
                        continue block12;
                    }
                    if (stringBuilder == null) continue block12;
                    stringBuilder.append(c);
                }
            }
        }
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        return string2;
    }

    private static StringBuilder append(StringBuilder stringBuilder, String string2, int n2, String string3) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2.substring(0, n2));
        }
        stringBuilder.append(string3);
        return stringBuilder;
    }

    public void writeAsEncodedUnicode(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (xMLStreamWriter instanceof XMLStreamWriterImpl) {
            ((XMLStreamWriterImpl)xMLStreamWriter).writeAsEncodedUnicode(this);
        }
    }

    static <E> List<E> iteratorToList(Iterator<E> iterator) {
        if (iterator == null || !iterator.hasNext()) {
            return ImmutableArrayList.emptyList();
        }
        Object[] objectArray = ArrayAllocator.newObjectArray(8);
        int n2 = 0;
        while (iterator.hasNext()) {
            if (n2 == objectArray.length) {
                objectArray = ArrayAllocator.resizeObjectArray(objectArray, n2 * 2);
            }
            objectArray[n2++] = iterator.next();
        }
        return new ImmutableArrayList<Object>(objectArray, n2);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class LocationClone
    implements Location {
        private final int characterOffset;
        private final int columnNumber;
        private final int lineNumber;
        private final String publicId;
        private final String systemId;

        private LocationClone(Location location) {
            this.characterOffset = location.getCharacterOffset();
            this.columnNumber = location.getColumnNumber();
            this.lineNumber = location.getLineNumber();
            this.publicId = location.getPublicId();
            this.systemId = location.getSystemId();
        }

        public int getCharacterOffset() {
            return this.characterOffset;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }
    }
}

