/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax.events;

import com.ibm.xml.xlxp.internal.s1.api.stax.events.XMLEventImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.internal.s1.api.util.ImmutableArrayList;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class NamespaceImpl
extends XMLEventImpl
implements Namespace {
    static List<Namespace> EMPTY_LIST = ImmutableArrayList.emptyList();
    private static final QName DEFAULT_NAMESPACE = new QName("http://www.w3.org/2000/xmlns/", "xmlns", "");
    private final QName fQName;
    private final String fPrefix;
    private final String fNamespaceURI;

    public NamespaceImpl(String string2) {
        this(string2, (Location)null);
    }

    public NamespaceImpl(String string2, Location location) {
        this("", string2, location);
    }

    public NamespaceImpl(String string2, String string3) {
        this(string2, string3, null);
    }

    public NamespaceImpl(String string2, String string3, Location location) {
        super(13, location);
        this.fPrefix = string2 == null ? "" : string2;
        this.fNamespaceURI = string3;
        this.fQName = this.fPrefix.length() > 0 ? new QName("http://www.w3.org/2000/xmlns/", this.fPrefix, "xmlns") : DEFAULT_NAMESPACE;
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public String getNamespaceURI() {
        return this.fNamespaceURI;
    }

    public boolean isDefaultNamespaceDeclaration() {
        return this.fQName == DEFAULT_NAMESPACE;
    }

    public QName getName() {
        return this.fQName;
    }

    public String getValue() {
        return this.fNamespaceURI;
    }

    public String getDTDType() {
        return "CDATA";
    }

    public boolean isSpecified() {
        return true;
    }

    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            writer.write("xmlns");
            if (this.fPrefix.length() > 0) {
                writer.write(58);
                writer.write(this.fPrefix);
            }
            writer.write("=\"");
            writer.write(this.fNamespaceURI);
            writer.write(34);
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }
}

