/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax;

import com.ibm.xml.xlxp.internal.s1.api.stax.XMLOutputFactoryImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.XMLEventImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.NotationDeclaration;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XMLEventWriterImpl
implements XMLEventWriter {
    private XMLStreamWriter fStreamWriter;

    public XMLEventWriterImpl(XMLOutputFactory xMLOutputFactory, XMLStreamWriter xMLStreamWriter) {
        this.fStreamWriter = xMLStreamWriter;
    }

    public void flush() throws XMLStreamException {
        this.fStreamWriter.flush();
    }

    public void close() throws XMLStreamException {
        this.fStreamWriter.close();
        this.fStreamWriter = XMLOutputFactoryImpl.fgClosedStreamWriter;
    }

    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        if (xMLEvent == null) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 32));
        }
        switch (xMLEvent.getEventType()) {
            case 10: {
                this.writeAttribute((Attribute)xMLEvent);
                break;
            }
            case 12: {
                this.writeCData((Characters)xMLEvent);
                break;
            }
            case 4: {
                this.writeCharacters((Characters)xMLEvent);
                break;
            }
            case 5: {
                this.writeComment((Comment)xMLEvent);
                break;
            }
            case 11: {
                this.writeDTD((DTD)xMLEvent);
                break;
            }
            case 8: {
                this.writeEndDocument((EndDocument)xMLEvent);
                break;
            }
            case 2: {
                this.writeEndElement((EndElement)xMLEvent);
                break;
            }
            case 15: {
                this.writeEntityDeclaration((EntityDeclaration)xMLEvent);
                break;
            }
            case 9: {
                this.writeEntityReference((EntityReference)xMLEvent);
                break;
            }
            case 13: {
                this.writeNamespace((Namespace)xMLEvent);
                break;
            }
            case 14: {
                this.writeNotationDeclaration((NotationDeclaration)xMLEvent);
                break;
            }
            case 3: {
                this.writeProcessingInstruction((ProcessingInstruction)xMLEvent);
                break;
            }
            case 6: {
                this.writeSpace((Characters)xMLEvent);
                break;
            }
            case 7: {
                this.writeStartDocument((StartDocument)xMLEvent);
                break;
            }
            case 1: {
                this.writeStartElement((StartElement)xMLEvent);
                break;
            }
            default: {
                if (xMLEvent.getEventType() <= 256) break;
                this.writeExtensionEvent(xMLEvent);
            }
        }
    }

    public void add(XMLEventReader xMLEventReader) throws XMLStreamException {
        if (xMLEventReader == null) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 33));
        }
        while (xMLEventReader.hasNext()) {
            this.add(xMLEventReader.nextEvent());
        }
    }

    public String getPrefix(String string2) throws XMLStreamException {
        return this.fStreamWriter.getPrefix(string2);
    }

    public void setPrefix(String string2, String string3) throws XMLStreamException {
        this.fStreamWriter.setPrefix(string2, string3);
    }

    public void setDefaultNamespace(String string2) throws XMLStreamException {
        this.fStreamWriter.setDefaultNamespace(string2);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.fStreamWriter.setNamespaceContext(namespaceContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.fStreamWriter.getNamespaceContext();
    }

    public void setXMLStreamWriter(XMLStreamWriter xMLStreamWriter) {
        this.fStreamWriter = xMLStreamWriter;
    }

    public XMLStreamWriter getXMLStreamWriter() {
        return this.fStreamWriter;
    }

    protected void writeAttribute(Attribute attribute2) throws XMLStreamException {
        QName qName = attribute2.getName();
        String string2 = qName.getNamespaceURI();
        String string3 = qName.getPrefix();
        String string4 = qName.getLocalPart();
        if (string2 != null) {
            if (string3 != null) {
                this.fStreamWriter.writeAttribute(string3, string2, string4, attribute2.getValue());
            } else {
                this.fStreamWriter.writeAttribute(string2, string4, attribute2.getValue());
            }
        } else {
            this.fStreamWriter.writeAttribute(string4, attribute2.getValue());
        }
    }

    protected void writeCData(Characters characters) throws XMLStreamException {
        this.fStreamWriter.writeCData(characters.getData());
    }

    protected void writeCharacters(Characters characters) throws XMLStreamException {
        this.fStreamWriter.writeCharacters(characters.getData());
    }

    protected void writeComment(Comment comment2) throws XMLStreamException {
        this.fStreamWriter.writeComment(comment2.getText());
    }

    protected void writeDTD(DTD dTD) throws XMLStreamException {
        this.fStreamWriter.writeDTD(dTD.getDocumentTypeDeclaration());
    }

    protected void writeEndDocument(EndDocument endDocument) throws XMLStreamException {
        this.fStreamWriter.writeEndDocument();
    }

    protected void writeEndElement(EndElement endElement) throws XMLStreamException {
        this.fStreamWriter.writeEndElement();
    }

    protected void writeEntityDeclaration(EntityDeclaration entityDeclaration) throws XMLStreamException {
    }

    protected void writeEntityReference(EntityReference entityReference) throws XMLStreamException {
        this.fStreamWriter.writeEntityRef(entityReference.getName());
    }

    protected void writeNamespace(Namespace namespace2) throws XMLStreamException {
        this.fStreamWriter.writeNamespace(namespace2.getPrefix(), namespace2.getNamespaceURI());
    }

    protected void writeNotationDeclaration(NotationDeclaration notationDeclaration) throws XMLStreamException {
    }

    protected void writeProcessingInstruction(ProcessingInstruction processingInstruction) throws XMLStreamException {
        this.fStreamWriter.writeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
    }

    protected void writeSpace(Characters characters) throws XMLStreamException {
        this.fStreamWriter.writeCharacters(characters.getData());
    }

    protected void writeStartDocument(StartDocument startDocument) throws XMLStreamException {
        boolean bl = startDocument.encodingSet();
        String string2 = startDocument.getVersion();
        if (string2 != null) {
            if (bl) {
                this.fStreamWriter.writeStartDocument(startDocument.getCharacterEncodingScheme(), string2);
            } else {
                this.fStreamWriter.writeStartDocument(string2);
            }
        } else {
            this.fStreamWriter.writeStartDocument();
        }
    }

    protected void writeStartElement(StartElement startElement) throws XMLStreamException {
        Object object2;
        QName qName = startElement.getName();
        String string2 = qName.getLocalPart();
        String string3 = qName.getPrefix();
        String string4 = qName.getNamespaceURI();
        if (string4 != null) {
            if (string3 != null) {
                this.fStreamWriter.writeStartElement(string3, string2, string4);
            } else {
                this.fStreamWriter.writeStartElement(string4, string2);
            }
        } else {
            this.fStreamWriter.writeStartElement(string2);
        }
        Iterator<Namespace> iterator = startElement.getNamespaces();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            this.writeNamespace((Namespace)object2);
        }
        object2 = startElement.getAttributes();
        while (object2.hasNext()) {
            Attribute attribute2 = (Attribute)object2.next();
            this.writeAttribute(attribute2);
        }
    }

    protected void writeExtensionEvent(XMLEvent xMLEvent) throws XMLStreamException {
        ((XMLEventImpl)xMLEvent).writeAsEncodedUnicode(this.fStreamWriter);
    }
}

