/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax;

import com.ibm.xml.xlxp.internal.s1.api.stax.JavaXNamespaceContext;
import com.ibm.xml.xlxp.internal.s1.api.stax.XMLInputFactoryImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.XMLStreamReaderBase;
import com.ibm.xml.xlxp.internal.s1.api.stax.XMLStreamReaderImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.XMLStreamReaderProxy;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.AttributeImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.CharactersImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.CommentImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.DTDImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.EndDocumentImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.EndElementImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.EntityReferenceImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.NamespaceImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.ProcessingInstructionImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.StartDocumentImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.StartElementImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.internal.s1.api.util.ImmutableArrayList;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class XMLEventReaderImpl
implements XMLEventReader,
XMLStreamConstants {
    private final XMLInputFactoryImpl fXMLInputFactory;
    private XMLEventAllocator fEventAllocator;
    private XMLStreamReader fStreamReader;
    private XMLEvent fXMLEvent;
    private XMLEvent fPeekedEvent;
    private final JavaXNamespaceContext fNamespaceContext;
    private List<EntityDeclaration> fEntityDeclList;
    private HashMap<String, EntityDeclaration> fEntityDecls;

    XMLEventReaderImpl(XMLInputFactoryImpl xMLInputFactoryImpl, XMLStreamReader xMLStreamReader) throws XMLStreamException {
        this.fXMLInputFactory = xMLInputFactoryImpl;
        this.fNamespaceContext = new JavaXNamespaceContext();
        this.setXMLStreamReader(xMLStreamReader);
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        if (this.fPeekedEvent != null) {
            this.fXMLEvent = this.fPeekedEvent;
            this.fPeekedEvent = null;
            return this.fXMLEvent;
        }
        this.fXMLEvent = this.createNextEvent();
        return this.fXMLEvent;
    }

    public boolean hasNext() {
        if (this.fPeekedEvent != null) {
            return true;
        }
        try {
            return this.fStreamReader.hasNext();
        }
        catch (XMLStreamException xMLStreamException) {
            return false;
        }
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.fPeekedEvent != null) {
            return this.fPeekedEvent;
        }
        if (!this.fStreamReader.hasNext()) {
            return null;
        }
        this.fPeekedEvent = this.createNextEvent();
        return this.fPeekedEvent;
    }

    public String getElementText() throws XMLStreamException {
        if (this.fXMLEvent == null || this.fXMLEvent.getEventType() != 1) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 14));
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            XMLEvent xMLEvent;
            if (this.fPeekedEvent != null) {
                xMLEvent = this.fPeekedEvent;
                this.fPeekedEvent = null;
            } else {
                xMLEvent = this.createNextEvent();
            }
            int n2 = xMLEvent.getEventType();
            if (n2 == 4 || n2 == 12 || n2 == 6) {
                stringBuilder.append(xMLEvent.asCharacters().getData());
                continue;
            }
            if (n2 == 9) {
                String string2;
                EntityDeclaration entityDeclaration = ((EntityReference)xMLEvent).getDeclaration();
                if (entityDeclaration == null || (string2 = entityDeclaration.getReplacementText()) == null) continue;
                stringBuilder.append(string2);
                continue;
            }
            if (n2 == 5 || n2 == 3) continue;
            this.fXMLEvent = xMLEvent;
            if (n2 == 2) {
                return stringBuilder.toString();
            }
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 15));
        }
    }

    public XMLEvent nextTag() throws XMLStreamException {
        int n2;
        if (this.fPeekedEvent != null) {
            n2 = this.fPeekedEvent.getEventType();
            if (n2 == 1 || n2 == 2) {
                this.fXMLEvent = this.fPeekedEvent;
                this.fPeekedEvent = null;
                return this.fXMLEvent;
            }
            if (!(n2 == 7 || n2 == 6 || n2 == 4 && this.fPeekedEvent.asCharacters().isWhiteSpace())) {
                StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 16));
            }
            this.fPeekedEvent = null;
        }
        while (true) {
            if ((n2 = this.fStreamReader.next()) == 2) {
                this.fXMLEvent = this.createEndElementWithNamespaces();
                return this.fXMLEvent;
            }
            if (n2 == 1) {
                this.fXMLEvent = this.createStartElementWithAttributes();
                return this.fXMLEvent;
            }
            if (n2 == 6 || n2 == 4 && this.fStreamReader.isWhiteSpace()) continue;
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 16));
        }
    }

    public Object getProperty(String string2) throws IllegalArgumentException {
        Object object2;
        if (this.fXMLEvent != null && this.fXMLEvent.getEventType() == 11) {
            if ("javax.xml.stream.entities".equals(string2)) {
                return ((DTD)this.fXMLEvent).getEntities();
            }
            if ("javax.xml.stream.notations".equals(string2)) {
                return ((DTD)this.fXMLEvent).getNotations();
            }
        }
        if ((object2 = this.fStreamReader.getProperty(string2)) != null) {
            return object2;
        }
        boolean bl = true;
        if (this.fStreamReader instanceof XMLStreamReaderProxy) {
            XMLStreamReader xMLStreamReader = ((XMLStreamReaderProxy)this.fStreamReader).getReader();
            if (xMLStreamReader instanceof XMLStreamReaderImpl && ((XMLStreamReaderImpl)xMLStreamReader).isPropertySupported(string2)) {
                bl = false;
            } else if (xMLStreamReader instanceof XMLStreamReaderBase && ((XMLStreamReaderBase)xMLStreamReader).isPropertySupported(string2)) {
                bl = false;
            }
        }
        if (bl) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 54, string2));
        }
        return null;
    }

    public void close() throws XMLStreamException {
        this.fStreamReader.close();
        this.fStreamReader = XMLInputFactoryImpl.fgClosedStreamReader;
        this.fXMLEvent = null;
        this.fPeekedEvent = null;
    }

    public void remove() {
        StAXMessageProvider.throwUnsupportedOperationException(StAXMessageProvider.createMessage(null, 34, "remove()"));
    }

    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException xMLStreamException) {
            StAXMessageProvider.throwNoSuchElementException(xMLStreamException.getMessage());
            return null;
        }
    }

    void setXMLStreamReader(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        this.fEventAllocator = this.fXMLInputFactory.getEventAllocator();
        this.fStreamReader = xMLStreamReader;
        this.fNamespaceContext.reset();
        this.fPeekedEvent = this.fEventAllocator != null ? this.fEventAllocator.allocate(this.fStreamReader) : this.createEvent(this.fStreamReader.getEventType());
    }

    private XMLEvent createNextEvent() throws XMLStreamException {
        if (this.fEventAllocator != null) {
            this.fStreamReader.next();
            return this.fEventAllocator.allocate(this.fStreamReader);
        }
        return this.createEvent(this.fStreamReader.next());
    }

    private XMLEvent createEvent(int n2) {
        switch (n2) {
            case 10: {
                return this.createAttribute();
            }
            case 12: {
                return this.createCData();
            }
            case 4: {
                return this.createCharacters();
            }
            case 5: {
                return this.createComment();
            }
            case 11: {
                return this.createDTD();
            }
            case 8: {
                return this.createEndDocument();
            }
            case 2: {
                return this.createEndElementWithNamespaces();
            }
            case 9: {
                return this.createEntityReference();
            }
            case 13: {
                return this.createNamespace();
            }
            case 3: {
                return this.createProcessingInstruction();
            }
            case 6: {
                return this.createSpace();
            }
            case 7: {
                return this.createStartDocument();
            }
            case 1: {
                return this.createStartElementWithAttributes();
            }
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 26, n2));
        return null;
    }

    private XMLEvent createAttribute() {
        QName qName = this.fStreamReader.getAttributeName(0);
        String string2 = this.fStreamReader.getAttributeValue(0);
        String string3 = this.fStreamReader.getAttributeType(0);
        if (string3 == null) {
            string3 = "CDATA";
        }
        boolean bl = this.fStreamReader.isAttributeSpecified(0);
        Location location = this.fStreamReader.getLocation();
        AttributeImpl attributeImpl = new AttributeImpl(qName, string2, string3, bl, location);
        return attributeImpl;
    }

    private XMLEvent createCData() {
        String string2 = this.fStreamReader.getText();
        Location location = this.fStreamReader.getLocation();
        CharactersImpl charactersImpl = new CharactersImpl(string2, 12, location);
        return charactersImpl;
    }

    private XMLEvent createCharacters() {
        String string2 = this.fStreamReader.getText();
        Location location = this.fStreamReader.getLocation();
        CharactersImpl charactersImpl = new CharactersImpl(string2, 4, location);
        return charactersImpl;
    }

    private XMLEvent createComment() {
        String string2 = this.fStreamReader.getText();
        Location location = this.fStreamReader.getLocation();
        CommentImpl commentImpl = new CommentImpl(string2, location);
        return commentImpl;
    }

    private XMLEvent createSpace() {
        String string2 = this.fStreamReader.getText();
        Location location = this.fStreamReader.getLocation();
        CharactersImpl charactersImpl = new CharactersImpl(string2, 6, location);
        return charactersImpl;
    }

    private XMLEvent createNamespace() {
        String string2 = this.fStreamReader.getNamespacePrefix(0);
        String string3 = this.fStreamReader.getNamespaceURI(0);
        Location location = this.fStreamReader.getLocation();
        NamespaceImpl namespaceImpl = new NamespaceImpl(string2, string3, location);
        return namespaceImpl;
    }

    private XMLEvent createDTD() {
        String string2 = (String)this.fStreamReader.getProperty("javax.xml.stream.dtd.declaration");
        Location location = this.fStreamReader.getLocation();
        List list = (List)this.fStreamReader.getProperty("javax.xml.stream.entities");
        List list2 = (List)this.fStreamReader.getProperty("javax.xml.stream.notations");
        DTDImpl dTDImpl = new DTDImpl(string2, list, list2, location);
        this.fEntityDeclList = list.isEmpty() ? null : list;
        return dTDImpl;
    }

    private EntityDeclaration getDeclaration(String string2) {
        if (this.fEntityDecls == null && this.fEntityDeclList != null) {
            Iterator<EntityDeclaration> iterator = this.fEntityDeclList.iterator();
            this.fEntityDecls = new HashMap();
            while (iterator.hasNext()) {
                EntityDeclaration entityDeclaration = iterator.next();
                String string3 = entityDeclaration.getName();
                this.fEntityDecls.put(string3, entityDeclaration);
            }
        }
        return this.fEntityDecls != null ? this.fEntityDecls.get(string2) : null;
    }

    private XMLEvent createEndDocument() {
        Location location = this.fStreamReader.getLocation();
        EndDocumentImpl endDocumentImpl = new EndDocumentImpl(location);
        return endDocumentImpl;
    }

    private XMLEvent createEntityReference() {
        Location location = this.fStreamReader.getLocation();
        String string2 = this.fStreamReader.getLocalName();
        EntityReferenceImpl entityReferenceImpl = new EntityReferenceImpl(string2, this.getDeclaration(string2), location);
        return entityReferenceImpl;
    }

    private XMLEvent createProcessingInstruction() {
        String string2 = this.fStreamReader.getPITarget();
        String string3 = this.fStreamReader.getPIData();
        Location location = this.fStreamReader.getLocation();
        ProcessingInstructionImpl processingInstructionImpl = new ProcessingInstructionImpl(string2, string3, location);
        return processingInstructionImpl;
    }

    private XMLEvent createStartDocument() {
        String string2 = this.fStreamReader.getVersion();
        String string3 = this.fStreamReader.getCharacterEncodingScheme();
        boolean bl = string3 != null;
        boolean bl2 = this.fStreamReader.isStandalone();
        boolean bl3 = this.fStreamReader.standaloneSet();
        Location location = this.fStreamReader.getLocation();
        StartDocumentImpl startDocumentImpl = new StartDocumentImpl(string2, bl, bl2, bl3, string3, location);
        return startDocumentImpl;
    }

    private XMLEvent createStartElementWithAttributes() {
        Object object2;
        int n2;
        Object object3;
        List<Attribute> list;
        QName qName = this.fStreamReader.getName();
        Location location = this.fStreamReader.getLocation();
        int n3 = this.fStreamReader.getAttributeCount();
        if (n3 == 0) {
            list = ImmutableArrayList.emptyList();
        } else {
            object3 = ArrayAllocator.newObjectArray(Attribute.class, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                object3[n2] = new AttributeImpl(new QName(this.fStreamReader.getAttributeNamespace(n2), this.fStreamReader.getAttributeLocalName(n2), this.fStreamReader.getAttributePrefix(n2) == null ? "" : this.fStreamReader.getAttributePrefix(n2)), this.fStreamReader.getAttributeValue(n2), this.fStreamReader.getAttributeType(n2), this.fStreamReader.isAttributeSpecified(n2));
            }
            list = new ImmutableArrayList<Attribute>((E[])object3, n3);
        }
        n2 = this.fStreamReader.getNamespaceCount();
        this.fNamespaceContext.startScope();
        if (n2 == 0) {
            object3 = ImmutableArrayList.emptyList();
        } else {
            object2 = ArrayAllocator.newObjectArray(Namespace.class, n2);
            for (int i = 0; i < n2; ++i) {
                String string2 = this.fStreamReader.getNamespacePrefix(i);
                String string3 = this.fStreamReader.getNamespaceURI(i);
                this.fNamespaceContext.declareNamespace(string2, string3);
                object2[i] = new NamespaceImpl(string2, string3);
            }
            object3 = new ImmutableArrayList<Namespace>((E[])object2, n2);
        }
        object2 = new StartElementImpl(qName, list, (Collection<Namespace>)object3, this.copyNSContext(), location);
        return object2;
    }

    private XMLEvent createEndElementWithNamespaces() {
        Object object2;
        List<Namespace> list;
        QName qName = this.fStreamReader.getName();
        Location location = this.fStreamReader.getLocation();
        this.fNamespaceContext.endScope();
        int n2 = this.fStreamReader.getNamespaceCount();
        if (n2 == 0) {
            list = ImmutableArrayList.emptyList();
        } else {
            object2 = ArrayAllocator.newObjectArray(Namespace.class, n2);
            for (int i = 0; i < n2; ++i) {
                object2[i] = new NamespaceImpl(this.fStreamReader.getNamespacePrefix(i), this.fStreamReader.getNamespaceURI(i));
            }
            list = new ImmutableArrayList<Namespace>((E[])object2, n2);
        }
        object2 = new EndElementImpl(qName, list, location);
        return object2;
    }

    private NamespaceContext copyNSContext() {
        return new JavaXNamespaceContext(this.fNamespaceContext, false);
    }
}

