/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class StAXLogger {
    private static final String COPYRIGHT_YEARS = "Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String cn = StAXLogger.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(StAXLogger.class);
    public static final int GET_PROPERTY = 0;
    public static final int NEXT = 1;
    public static final int REQUIRE = 2;
    public static final int GET_ELEMENT_TEXT = 3;
    public static final int NEXT_TAG = 4;
    public static final int HAS_NEXT = 5;
    public static final int CLOSE = 6;
    public static final int GET_NAMESPACE_URI_STRING = 7;
    public static final int IS_START_ELEMENT = 8;
    public static final int IS_END_ELEMENT = 9;
    public static final int IS_CHARACTERS = 10;
    public static final int IS_WHITESPACE = 11;
    public static final int GET_ATTRIBUTE_VALUE_STRING_STRING = 12;
    public static final int GET_ATTRIBUTE_COUNT = 13;
    public static final int GET_ATTRIBUTE_NAME = 14;
    public static final int GET_ATTRIBUTE_NAMESPACE = 15;
    public static final int GET_ATTRIBUTE_LOCALNAME = 16;
    public static final int GET_ATTRIBUTE_PREFIX = 17;
    public static final int GET_ATTRIBUTE_TYPE = 18;
    public static final int GET_ATTRIBUTE_VALUE_INT = 19;
    public static final int IS_ATTRIBUTE_SPECIFIED = 20;
    public static final int GET_NAMESPACE_COUNT = 21;
    public static final int GET_NAMESPACE_PREFIX = 22;
    public static final int GET_NAMESPACE_URI_INT = 23;
    public static final int GET_EVENT_TYPE = 24;
    public static final int GET_NAMESPACE_CONTEXT = 25;
    public static final int GET_TEXT = 26;
    public static final int GET_TEXT_CHARACTERS = 27;
    public static final int GET_TEXT_CHARACTERS_ARGS = 28;
    public static final int GET_TEXT_START = 29;
    public static final int GET_TEXT_LENGTH = 30;
    public static final int GET_ENCODING = 31;
    public static final int HAS_TEXT = 32;
    public static final int GET_LOCATION = 33;
    public static final int GET_NAME = 34;
    public static final int GET_LOCAL_NAME = 35;
    public static final int HAS_NAME = 36;
    public static final int GET_NAMESPACE_URI = 37;
    public static final int GET_PREFIX = 38;
    public static final int GET_VERSION = 39;
    public static final int IS_STANDALONE = 40;
    public static final int STANDALONE_SET = 41;
    public static final int GET_CHARACTER_ENCODING_SCHEME = 42;
    public static final int GET_PI_TARGET = 43;
    public static final int GET_PI_DATA = 44;
    public static final int WRITE_START_ELEMENT = 101;
    public static final int WRITE_EMPTY_ELEMENT = 102;
    public static final int WRITE_END_ELEMENT = 103;
    public static final int WRITE_START_DOCUMENT = 104;
    public static final int WRITE_END_DOCUMENT = 105;
    public static final int WRITE_ATTRIBUTE = 106;
    public static final int WRITE_NAMESPACE = 107;
    public static final int WRITE_DEFAULT_NAMESPACE = 108;
    public static final int WRITE_PROCESSING_INSTRUCTION = 109;
    public static final int WRITE_CDATA = 110;
    public static final int WRITE_COMMENT = 111;
    public static final int WRITE_DTD = 112;
    public static final int WRITE_ENTITY_REF = 113;
    public static final int WRITE_CHARACTERS = 114;
    public static final int FLUSH = 115;
    public static final int SET_PREFIX = 116;
    public static final int SET_DEFAULT_NAMESPACE = 117;
    public static final int SET_NAMESPACE_CONTEXT = 118;
    private ArrayList<MethodCall> methodCalls = new ArrayList();
    private MethodCall lastCall;

    public static String translateToMethodName(int n2) {
        switch (n2) {
            case 0: {
                return "getProperty";
            }
            case 1: {
                return "next";
            }
            case 2: {
                return "require";
            }
            case 3: {
                return "getElementText";
            }
            case 4: {
                return "nextTag";
            }
            case 5: {
                return "hasNext";
            }
            case 6: {
                return "close";
            }
            case 8: {
                return "isStartElement";
            }
            case 9: {
                return "isEndElement";
            }
            case 10: {
                return "isCharacters";
            }
            case 11: {
                return "isWhitespace";
            }
            case 13: {
                return "getAttributeCount";
            }
            case 14: {
                return "getAttributeName";
            }
            case 15: {
                return "getAttributeNamespace";
            }
            case 16: {
                return "getAttributeLocalname";
            }
            case 17: {
                return "getAttributePrefix";
            }
            case 18: {
                return "getAttributeType";
            }
            case 12: 
            case 19: {
                return "getAttributeValue";
            }
            case 20: {
                return "isAttributeSpecified";
            }
            case 21: {
                return "getNamespaceCount";
            }
            case 22: {
                return "getNamespacePrefix";
            }
            case 24: {
                return "getEventType";
            }
            case 25: {
                return "getNamespaceContext";
            }
            case 26: {
                return "getText";
            }
            case 27: 
            case 28: {
                return "getTextCharacters";
            }
            case 29: {
                return "getTextStart";
            }
            case 30: {
                return "getTextLength";
            }
            case 31: {
                return "getEncoding";
            }
            case 32: {
                return "hasNext";
            }
            case 33: {
                return "getLocation";
            }
            case 34: {
                return "getName";
            }
            case 35: {
                return "getLocalName";
            }
            case 36: {
                return "hasName";
            }
            case 7: 
            case 23: 
            case 37: {
                return "getNamespaceURI";
            }
            case 38: {
                return "getPrefix";
            }
            case 39: {
                return "getVersion";
            }
            case 40: {
                return "isStandalone";
            }
            case 41: {
                return "standaloneSet";
            }
            case 42: {
                return "getCharacterEncodingScheme";
            }
            case 43: {
                return "getPITarget";
            }
            case 44: {
                return "getPIData";
            }
            case 101: {
                return "writeStartElement";
            }
            case 102: {
                return "writeEmptyElement";
            }
            case 103: {
                return "writeEndElement";
            }
            case 104: {
                return "writeStartDocument";
            }
            case 105: {
                return "writeEndDocument";
            }
            case 106: {
                return "writeAttribute";
            }
            case 107: {
                return "writeNamespace";
            }
            case 108: {
                return "writeDefaultNamespace";
            }
            case 109: {
                return "writeProcessingInstruction";
            }
            case 110: {
                return "writeCData";
            }
            case 111: {
                return "writeComment";
            }
            case 112: {
                return "writeDTD";
            }
            case 113: {
                return "writeEnittyRef";
            }
            case 114: {
                return "writeCharacters";
            }
            case 115: {
                return "flush";
            }
            case 116: {
                return "setPrefix";
            }
            case 117: {
                return "setDefaultNamespace";
            }
            case 118: {
                return "setNamespaceContext";
            }
        }
        return null;
    }

    public static String translateToCodeString(int n2) {
        switch (n2) {
            case 0: {
                return "GET_PROPERTY";
            }
            case 1: {
                return "NEXT";
            }
            case 2: {
                return "REQUIRE";
            }
            case 3: {
                return "GET_ELEMENT_TEXT";
            }
            case 4: {
                return "NEXT_TAG";
            }
            case 5: {
                return "HAS_NEXT";
            }
            case 6: {
                return "CLOSE";
            }
            case 7: {
                return "GET_NAMESPACE_URI_STRING";
            }
            case 8: {
                return "IS_START_ELEMENT";
            }
            case 9: {
                return "IS_END_ELEMENT";
            }
            case 10: {
                return "IS_CHARACTERS";
            }
            case 11: {
                return "IS_WHITESPACE";
            }
            case 12: {
                return "GET_ATTRIBUTE_VALUE_STRING_STRING";
            }
            case 13: {
                return "GET_ATTRIBUTE_COUNT";
            }
            case 14: {
                return "GET_ATTRIBUTE_NAME";
            }
            case 15: {
                return "GET_ATTRIBUTE_NAMESPACE";
            }
            case 16: {
                return "GET_ATTRIBUTE_LOCALNAME";
            }
            case 17: {
                return "GET_ATTRIBUTE_PREFIX";
            }
            case 18: {
                return "GET_ATTRIBUTE_TYPE";
            }
            case 19: {
                return "GET_ATTRIBUTE_VALUE_INT";
            }
            case 20: {
                return "IS_ATTRIBUTE_SPECIFIED";
            }
            case 21: {
                return "GET_NAMESPACE_COUNT";
            }
            case 22: {
                return "GET_NAMESPACE_PREFIX";
            }
            case 23: {
                return "GET_NAMESPACE_URI_INT";
            }
            case 24: {
                return "GET_EVENT_TYPE";
            }
            case 25: {
                return "GET_NAMESPACE_CONTEXT";
            }
            case 26: {
                return "GET_TEXT";
            }
            case 27: {
                return "GET_TEXT_CHARACTERS";
            }
            case 28: {
                return "GET_TEXT_CHARACTERS_ARGS";
            }
            case 29: {
                return "GET_TEXT_START";
            }
            case 30: {
                return "GET_TEXT_LENGTH";
            }
            case 31: {
                return "GET_ENCODING";
            }
            case 32: {
                return "HAS_TEXT";
            }
            case 33: {
                return "GET_LOCATION";
            }
            case 34: {
                return "GET_NAME";
            }
            case 35: {
                return "GET_LOCAL_NAME";
            }
            case 36: {
                return "HAS_NAME";
            }
            case 37: {
                return "GET_NAMESPACE_URI";
            }
            case 38: {
                return "GET_PREFIX";
            }
            case 39: {
                return "GET_VERSION";
            }
            case 40: {
                return "IS_STANDALONE";
            }
            case 41: {
                return "STANDALONE_SET";
            }
            case 42: {
                return "GET_CHARACTER_ENCODING_SCHEME";
            }
            case 43: {
                return "GET_PI_TARGET";
            }
            case 44: {
                return "GET_PI_DATA";
            }
            case 101: {
                return "WRITE_START_ELEMENT";
            }
            case 102: {
                return "WRITE_EMPTY_ELEMENT";
            }
            case 103: {
                return "WRITE_END_ELEMENT";
            }
            case 104: {
                return "WRITE_START_DOCUMENT";
            }
            case 105: {
                return "WRITE_END_DOCUMENT";
            }
            case 106: {
                return "WRITE_ATTRIBUTE";
            }
            case 107: {
                return "WRITE_NAMESPACE";
            }
            case 108: {
                return "WRITE_DEFAULT_NAMESPACE";
            }
            case 109: {
                return "WRITE_PROCESSING_INSTRUCTION";
            }
            case 110: {
                return "WRITE_CDATA";
            }
            case 111: {
                return "WRITE_COMMENT";
            }
            case 112: {
                return "WRITE_DTD";
            }
            case 113: {
                return "WRITE_ENTITY_REF";
            }
            case 114: {
                return "WRITE_CHARACTERS";
            }
            case 115: {
                return "FLUSH";
            }
            case 116: {
                return "SET_PREFIX";
            }
            case 117: {
                return "SET_DEFAULT_NAMESPACE";
            }
            case 118: {
                return "SET_NAMESPACE_CONTEXT";
            }
        }
        return null;
    }

    public void log(int n2) {
        this.lastCall = new MethodCall(n2);
        this.methodCalls.add(this.lastCall);
    }

    public void log(int n2, int n3) {
        this.lastCall = new MethodCallInt(n2, n3);
        this.methodCalls.add(this.lastCall);
    }

    public void log(int n2, String string2) {
        this.lastCall = new MethodCallString(n2, string2);
        this.methodCalls.add(this.lastCall);
    }

    public void log(int n2, String string2, String string3) {
        this.lastCall = new MethodCallObjects(n2, new Object[]{string2, string3});
        this.methodCalls.add(this.lastCall);
    }

    public void log(int n2, String string2, String string3, String string4) {
        this.lastCall = new MethodCallObjects(n2, new Object[]{string2, string3, string4});
        this.methodCalls.add(this.lastCall);
    }

    public void log(int n2, Object[] objectArray) {
        this.lastCall = new MethodCallObjects(n2, objectArray);
        this.methodCalls.add(this.lastCall);
    }

    public void logReturn() {
        this.printLastCall();
    }

    public void logReturn(int n2) {
        this.lastCall.addReturn(n2);
        this.printLastCall();
    }

    public void logReturn(boolean bl) {
        this.lastCall.addReturn(bl);
        this.printLastCall();
    }

    public void logReturn(Object object2) {
        this.lastCall.addReturn(object2 == null ? "null" : object2);
        this.printLastCall();
    }

    public void logException(Exception exception) {
        this.printLastCall();
        this.printException(exception);
    }

    private void printLastCall() {
        if (LoggerUtil.isFinestLoggable(logger)) {
            logger.logp(Level.FINEST, cn, "printlastCall", "[" + this.hashCode() + "] " + this.lastCall);
        }
    }

    private void printException(Exception exception) {
        if (LoggerUtil.isFinestLoggable(logger)) {
            logger.logp(Level.FINEST, cn, "printException", "[" + this.hashCode() + "] Exception thrown from previous call: " + exception);
        }
    }

    public void writeReadableProfile(String string2) {
        PrintStream printStream = System.out;
        if (string2 != null) {
            try {
                printStream = new PrintStream(new FileOutputStream(string2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Couldn't open file: " + string2);
            }
        }
        for (int i = 0; i < this.methodCalls.size(); ++i) {
            printStream.println(this.methodCalls.get(i));
        }
    }

    public void writeStAXProfile(String string2) {
        int n2;
        MethodCall methodCall;
        MethodCall methodCall2;
        int n3;
        MethodCall methodCall3;
        int n4;
        PrintStream printStream = System.out;
        if (string2 != null) {
            try {
                printStream = new PrintStream(new FileOutputStream(string2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Couldn't open file: " + string2);
            }
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        printStream.println(this.methodCalls.size());
        for (n4 = 0; n4 < this.methodCalls.size(); ++n4) {
            methodCall3 = this.methodCalls.get(n4);
            printStream.println(methodCall3.fCode);
            if (methodCall3.fReturnVal instanceof String) {
                ++n6;
            }
            if (methodCall3.fReturnVal instanceof Integer) {
                ++n7;
            }
            if (!(methodCall3.fReturnVal instanceof Boolean)) continue;
            ++n5;
        }
        printStream.println(n6);
        for (n4 = 0; n4 < this.methodCalls.size(); ++n4) {
            methodCall3 = this.methodCalls.get(n4);
            if (!(methodCall3.fReturnVal instanceof String)) continue;
            printStream.println(methodCall3.fReturnVal);
        }
        printStream.println(n7);
        for (n4 = 0; n4 < this.methodCalls.size(); ++n4) {
            methodCall3 = this.methodCalls.get(n4);
            if (!(methodCall3.fReturnVal instanceof Integer)) continue;
            printStream.println(methodCall3.fReturnVal);
        }
        printStream.println(n5);
        for (n4 = 0; n4 < this.methodCalls.size(); ++n4) {
            methodCall3 = this.methodCalls.get(n4);
            if (!(methodCall3.fReturnVal instanceof Boolean)) continue;
            printStream.println(methodCall3.fReturnVal);
        }
        n4 = 0;
        for (n3 = 0; n3 < this.methodCalls.size(); ++n3) {
            methodCall2 = this.methodCalls.get(n3);
            if (methodCall2 instanceof MethodCallInt) {
                ++n4;
            }
            if (!(methodCall2 instanceof MethodCallObjects)) continue;
            methodCall = (MethodCallObjects)methodCall2;
            for (n2 = 0; n2 < ((MethodCallObjects)methodCall).fArgs.length; ++n2) {
                if (!(((MethodCallObjects)methodCall).fArgs[n2] instanceof Integer)) continue;
                ++n4;
            }
        }
        printStream.println(n4);
        for (n3 = 0; n3 < this.methodCalls.size(); ++n3) {
            methodCall2 = this.methodCalls.get(n3);
            if (methodCall2 instanceof MethodCallInt) {
                methodCall = (MethodCallInt)methodCall2;
                printStream.println(((MethodCallInt)methodCall).fArg);
            }
            if (!(methodCall2 instanceof MethodCallObjects)) continue;
            methodCall = (MethodCallObjects)methodCall2;
            for (n2 = 0; n2 < ((MethodCallObjects)methodCall).fArgs.length; ++n2) {
                if (!(((MethodCallObjects)methodCall).fArgs[n2] instanceof Integer)) continue;
                printStream.print(((MethodCallObjects)methodCall).fArgs[n2]);
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < this.methodCalls.size(); ++n3) {
            methodCall2 = this.methodCalls.get(n3);
            if (methodCall2 instanceof MethodCallString) {
                ++n4;
            }
            if (!(methodCall2 instanceof MethodCallObjects)) continue;
            methodCall = (MethodCallObjects)methodCall2;
            for (n2 = 0; n2 < ((MethodCallObjects)methodCall).fArgs.length; ++n2) {
                if (!(((MethodCallObjects)methodCall).fArgs[n2] instanceof String)) continue;
                ++n4;
            }
        }
        printStream.println(n4);
        for (n3 = 0; n3 < this.methodCalls.size(); ++n3) {
            methodCall2 = this.methodCalls.get(n3);
            if (methodCall2 instanceof MethodCallString) {
                methodCall = (MethodCallString)methodCall2;
                printStream.println(((MethodCallString)methodCall).fArg);
            }
            if (!(methodCall2 instanceof MethodCallObjects)) continue;
            methodCall = (MethodCallObjects)methodCall2;
            for (n2 = 0; n2 < ((MethodCallObjects)methodCall).fArgs.length; ++n2) {
                if (!(((MethodCallObjects)methodCall).fArgs[n2] instanceof String)) continue;
                printStream.println(((MethodCallObjects)methodCall).fArgs[n2]);
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class MethodCallObjects
    extends MethodCall {
        private Object[] fArgs;

        public MethodCallObjects(int n2, Object[] objectArray) {
            super(n2);
            this.fArgs = objectArray;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (int i = 0; i < this.fArgs.length; ++i) {
                if (!bl) {
                    stringBuilder.append(", ");
                } else {
                    bl = false;
                }
                if (this.fArgs[i] instanceof String) {
                    stringBuilder.append("\"");
                    stringBuilder.append(this.fArgs[i]);
                    stringBuilder.append("\"");
                    continue;
                }
                stringBuilder.append(this.fArgs[i]);
            }
            return StAXLogger.translateToMethodName(this.fCode) + "(" + stringBuilder + ")" + this.returnString();
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class MethodCallString
    extends MethodCall {
        private String fArg;

        public MethodCallString(int n2, String string2) {
            super(n2);
            this.fArg = string2;
        }

        public String toString() {
            return StAXLogger.translateToMethodName(this.fCode) + "(\"" + this.fArg + "\")" + this.returnString();
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class MethodCallInt
    extends MethodCall {
        private int fArg;

        public MethodCallInt(int n2, int n3) {
            super(n2);
            this.fArg = n3;
        }

        public String toString() {
            return StAXLogger.translateToMethodName(this.fCode) + "(" + this.fArg + ")" + this.returnString();
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class MethodCall {
        protected int fCode;
        protected Object fReturnVal;

        public MethodCall(int n2) {
            this.fCode = n2;
        }

        public void addReturn(Object object2) {
            if (this.fReturnVal != null) {
                throw new IllegalStateException("Already have a return value.");
            }
            this.fReturnVal = object2;
        }

        public String toString() {
            return StAXLogger.translateToMethodName(this.fCode) + "()" + this.returnString();
        }

        protected String returnString() {
            if (this.fReturnVal != null) {
                return " : " + this.fReturnVal;
            }
            return "";
        }
    }
}

