/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax;

import com.ibm.xml.xlxp.internal.s1.api.stax.XMLStreamWriterBase;
import com.ibm.xml.xlxp.internal.s1.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
class SAXStreamWriterImpl
extends XMLStreamWriterBase {
    private static final char[] fgEmptyCharArray = ArrayAllocator.checkCharArray(new char[0]);
    protected ContentHandler fCHandler;
    protected LexicalHandler fLHandler;
    protected String[] fCurrentElementArray;
    protected int fCurrentElementDepth;
    protected AttributesImpl fAttributes;
    private HashMap<String, String> fStoredNamespaceDecls = new HashMap();

    public SAXStreamWriterImpl(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean bl) throws XMLStreamException {
        this();
        this.setHandlers(contentHandler, lexicalHandler, bl);
    }

    protected SAXStreamWriterImpl() throws XMLStreamException {
        this.fAttributes = new AttributesImpl();
        this.fCurrentElementArray = ArrayAllocator.newStringArray(24);
    }

    public void setHandlers(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean bl) {
        this.fCHandler = contentHandler;
        this.fLHandler = lexicalHandler;
        this.reset(bl);
    }

    public void setHandlersNoReset(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this.fCHandler = contentHandler;
        this.fLHandler = lexicalHandler;
    }

    private void pushElementContext(String string2, String string3, String string4) {
        int n2 = this.fCurrentElementDepth * 3;
        if (n2 == this.fCurrentElementArray.length) {
            this.fCurrentElementArray = ArrayAllocator.resizeStringArray(this.fCurrentElementArray, n2 << 1);
        }
        this.fCurrentElementArray[n2] = string2;
        this.fCurrentElementArray[n2 + 1] = string3;
        this.fCurrentElementArray[n2 + 2] = string4;
        ++this.fCurrentElementDepth;
    }

    protected void reset(boolean bl) {
        super.reset(bl);
        this.fCurrentElementDepth = 0;
        this.fStoredNamespaceDecls.clear();
    }

    public void writeStartDocument() throws XMLStreamException {
        try {
            if (this.fCHandler != null) {
                this.fCHandler.startDocument();
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeStartDocument(String string2) throws XMLStreamException {
        this.writeStartDocument();
    }

    public void writeStartDocument(String string2, String string3) throws XMLStreamException {
        this.writeStartDocument();
    }

    protected void handleStartElement(String string2, String string3, String string4) throws XMLStreamException {
        String string5 = string2 == "" ? string3 : string2 + ":" + string3;
        this.pushElementContext(string4, string3, string5);
    }

    protected void finishStartElement() throws XMLStreamException {
        try {
            if (this.fCHandler != null) {
                String string2;
                String string3;
                for (Map.Entry<String, String> object22 : this.fStoredNamespaceDecls.entrySet()) {
                    string3 = object22.getKey();
                    string2 = object22.getValue();
                    this.fCHandler.startPrefixMapping(string3, string2);
                }
                this.fStoredNamespaceDecls.clear();
                int n2 = this.fCurrentElementDepth * 3;
                String string4 = this.fCurrentElementArray[n2 - 1];
                string3 = this.fCurrentElementArray[n2 - 2];
                string2 = this.fCurrentElementArray[n2 - 3];
                this.fCHandler.startElement(string2, string3, string4, this.fAttributes);
            }
            this.fAttributes.clear();
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    protected void handleAttribute(String string2, String string3, String string4, String string5) throws XMLStreamException {
        String string6 = string2.equals("") ? string4 : string2 + ":" + string4;
        this.fAttributes.addAttribute(string3, string4, string6, "CDATA", string5);
    }

    protected void handleNamespace(String string2, String string3) throws XMLStreamException {
        this.fStoredNamespaceDecls.put(string2, string3);
    }

    protected boolean atRootContext() {
        return this.fCurrentElementDepth == 0;
    }

    protected void handleEndElement() throws XMLStreamException {
        if (this.atRootContext()) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 39));
        }
        try {
            if (this.fCHandler != null) {
                int n2 = this.fCurrentElementDepth * 3;
                String string2 = this.fCurrentElementArray[n2 - 1];
                String string3 = this.fCurrentElementArray[n2 - 2];
                String string4 = this.fCurrentElementArray[n2 - 3];
                this.fCHandler.endElement(string4, string3, string2);
                for (int i = this.fNamespaceContext.fMappingSize; i > this.fNamespaceContext.fScopes[this.fNamespaceContext.fScope]; i -= 2) {
                    this.fCHandler.endPrefixMapping(this.fNamespaceContext.fMapping[i - 2]);
                }
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
        --this.fCurrentElementDepth;
    }

    public void writeEndDocument() throws XMLStreamException {
        super.writeEndDocument();
        try {
            if (this.fCHandler != null) {
                this.fCHandler.endDocument();
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void close() throws XMLStreamException {
        super.close();
        this.fCHandler = null;
        this.fLHandler = null;
        this.fCurrentElementDepth = 0;
        this.fAttributes.clear();
        this.fPoolableHelper.returnToPool();
    }

    public void writeComment(String string2) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            if (this.fLHandler != null) {
                if (string2 != null) {
                    this.fLHandler.comment(string2.toCharArray(), 0, string2.length());
                } else {
                    this.fLHandler.comment(fgEmptyCharArray, 0, 0);
                }
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeProcessingInstruction(String string2, String string3) throws XMLStreamException {
        this.checkFinishStartElement();
        if (string2 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 49));
        }
        if (string3 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 50));
        }
        try {
            if (this.fCHandler != null) {
                this.fCHandler.processingInstruction(string2, string3);
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeCData(String string2) throws XMLStreamException {
        this.checkFinishStartElement();
        if (string2 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 48));
        }
        try {
            if (this.fLHandler != null) {
                this.fLHandler.startCDATA();
            }
            if (this.fCHandler != null) {
                this.fCHandler.characters(string2.toCharArray(), 0, string2.length());
            }
            if (this.fLHandler != null) {
                this.fLHandler.endCDATA();
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeDTD(String string2) throws XMLStreamException {
        try {
            if (this.fLHandler != null) {
                super.parseDTD(string2);
                if (this.fDTDRoot != null) {
                    this.fLHandler.startDTD(this.fDTDRoot, this.fDTDPubId, this.fDTDSysId);
                    this.fLHandler.endDTD();
                }
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeEntityRef(String string2) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            if (this.fLHandler != null) {
                this.fLHandler.startEntity(string2);
            }
            if (this.fLHandler != null) {
                this.fLHandler.endEntity(string2);
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeCharacters(String string2) throws XMLStreamException {
        this.writeCharacters(string2.toCharArray(), 0, string2.length());
    }

    public void writeCharacters(char[] cArray, int n2, int n3) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            if (this.fCHandler != null) {
                this.fCHandler.characters(cArray, n2, n3);
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }
}

