/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax;

import com.ibm.xml.xlxp.internal.s1.api.stax.XMLStreamWriterBase;
import com.ibm.xml.xlxp.internal.s1.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class DOMStreamWriterImpl
extends XMLStreamWriterBase {
    protected Node fCurrentNode;
    protected Node fRootNode;
    protected Node fNextSibling;
    protected Document fDocumentNode;
    private boolean fIsDOMLevel3;
    private HashMap<String, String> fStoredNamespaceDecls = new HashMap();

    public DOMStreamWriterImpl(Node node2, Node node3, boolean bl) throws XMLStreamException {
        this.setNodes(node2, node3, bl);
    }

    public void setNodes(Node node2, Node node3, boolean bl) throws XMLStreamException {
        if (node2 instanceof Document || node2 instanceof DocumentFragment || node2 instanceof Element) {
            try {
                this.fCurrentNode = this.fRootNode = node2;
                this.fNextSibling = node3;
                this.fDocumentNode = node2 instanceof Document ? (Document)this.fRootNode : this.fCurrentNode.getOwnerDocument();
                this.fIsDOMLevel3 = this.fDocumentNode.getImplementation().hasFeature("Core", "3.0");
            }
            catch (DOMException dOMException) {
                StAXMessageProvider.throwXMLStreamException(dOMException);
            }
        } else {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 38));
        }
        this.fStoredNamespaceDecls.clear();
        this.reset(bl);
    }

    private void addChild(Node node2) {
        if (this.fCurrentNode == this.fRootNode && this.fNextSibling != null) {
            this.fCurrentNode.insertBefore(node2, this.fNextSibling);
        } else {
            this.fCurrentNode.appendChild(node2);
        }
    }

    public void writeStartDocument() throws XMLStreamException {
    }

    public void writeStartDocument(String string2) throws XMLStreamException {
        if (this.fIsDOMLevel3 && this.fRootNode == this.fDocumentNode) {
            try {
                this.fDocumentNode.setXmlVersion(string2);
            }
            catch (DOMException dOMException) {
                StAXMessageProvider.throwXMLStreamException(dOMException);
            }
        }
    }

    public void writeStartDocument(String string2, String string3) throws XMLStreamException {
        this.writeStartDocument(string3);
    }

    protected void handleStartElement(String string2, String string3, String string4) throws XMLStreamException {
        try {
            String string5 = string2 == "" ? string3 : string2 + ":" + string3;
            Element element2 = this.fDocumentNode.createElementNS(string4, string5);
            this.addChild(element2);
            this.fCurrentNode = element2;
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    protected void handleNamespace(String string2, String string3) throws XMLStreamException {
        this.fStoredNamespaceDecls.put(string2, string3);
    }

    protected void finishStartElement() throws XMLStreamException {
        for (Map.Entry<String, String> entry : this.fStoredNamespaceDecls.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            try {
                String string4 = string2 == null || string2.equals("") ? "xmlns" : "xmlns:" + string2;
                Attr attr2 = this.fDocumentNode.createAttributeNS("http://www.w3.org/2000/xmlns/", string4);
                attr2.setValue(string3);
                ((Element)this.fCurrentNode).setAttributeNodeNS(attr2);
            }
            catch (DOMException dOMException) {
                StAXMessageProvider.throwXMLStreamException(dOMException);
            }
        }
        this.fStoredNamespaceDecls.clear();
    }

    protected boolean atRootContext() {
        return this.fCurrentNode == this.fRootNode;
    }

    protected void handleEndElement() throws XMLStreamException {
        if (this.atRootContext()) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 39));
        }
        this.fCurrentNode = this.fCurrentNode.getParentNode();
    }

    public void close() throws XMLStreamException {
        super.close();
        this.fCurrentNode = null;
        this.fDocumentNode = null;
        this.fRootNode = null;
        this.fNextSibling = null;
        this.fPoolableHelper.returnToPool();
    }

    protected void handleAttribute(String string2, String string3, String string4, String string5) throws XMLStreamException {
        try {
            String string6 = string2.equals("") ? string4 : string2 + ":" + string4;
            Attr attr2 = this.fDocumentNode.createAttributeNS(string3, string6);
            attr2.setValue(string5);
            ((Element)this.fCurrentNode).setAttributeNodeNS(attr2);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeComment(String string2) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            Comment comment2 = this.fDocumentNode.createComment(string2);
            this.addChild(comment2);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeProcessingInstruction(String string2, String string3) throws XMLStreamException {
        this.checkFinishStartElement();
        if (string2 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 49));
        }
        if (string3 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 50));
        }
        try {
            ProcessingInstruction processingInstruction = this.fDocumentNode.createProcessingInstruction(string2, string3);
            this.addChild(processingInstruction);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeCData(String string2) throws XMLStreamException {
        this.checkFinishStartElement();
        if (string2 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 48));
        }
        try {
            CDATASection cDATASection = this.fDocumentNode.createCDATASection(string2);
            this.addChild(cDATASection);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeDTD(String string2) throws XMLStreamException {
        if (this.fDocumentNode == this.fRootNode) {
            super.parseDTD(string2);
            if (this.fDTDRoot != null) {
                try {
                    DocumentType documentType = this.fDocumentNode.getImplementation().createDocumentType(this.fDTDRoot, this.fDTDPubId, this.fDTDSysId);
                    DocumentType documentType2 = this.fDocumentNode.getDoctype();
                    if (documentType2 != null) {
                        this.fDocumentNode.replaceChild(documentType, documentType2);
                    } else {
                        this.fDocumentNode.insertBefore(documentType, this.fDocumentNode.getFirstChild());
                    }
                }
                catch (DOMException dOMException) {
                    StAXMessageProvider.throwXMLStreamException(dOMException);
                }
            }
        }
    }

    public void writeEntityRef(String string2) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            EntityReference entityReference = this.fDocumentNode.createEntityReference(string2);
            this.addChild(entityReference);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeCharacters(String string2) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            Text text2 = this.fDocumentNode.createTextNode(string2);
            this.addChild(text2);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeCharacters(char[] cArray, int n2, int n3) throws XMLStreamException {
        this.writeCharacters(new String(cArray, n2, n3));
    }
}

