/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.sax.impl;

import com.ibm.xml.xlxp.internal.s1.api.sax.impl.SAXExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.api.util.SimplePositionHelper;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.msg.MessageProvider;
import com.ibm.xml.xlxp.internal.s1.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.AttrList;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DocumentPosition;
import com.ibm.xml.xlxp.internal.s1.scan.util.NSDeclList;
import com.ibm.xml.xlxp.internal.s1.scan.util.PositionHelper;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class SAX2ParserBase
implements Attributes,
Locator,
XMLReader {
    private static final boolean RETAIN_OBJECTS_ACROSS_RESET = true;
    private static final String SAX2_FEATURES_PREFIX = "http://xml.org/sax/features/";
    protected static final String XLXP_FEATURES_PREFIX = "http://ibm.com/xlxp/features/";
    private static final String SAX2_PROPERTIES_PREFIX = "http://xml.org/sax/properties/";
    protected static final String XLXP_PROPERTIES_PREFIX = "http://ibm.com/xlxp/properties/";
    protected final DataBufferFactory fBufferFactory = new SimpleDataBufferFactory();
    protected final SymbolTable fSymbolTable = new SymbolTable();
    protected final InputSource fInputSource = new InputSource();
    protected ErrorHandler fErrorHandler;
    protected ContentHandler fContentHandler;
    protected LexicalHandler fLexicalHandler;
    protected char[][] fCharBuffer = ArrayAllocator.newCharArray2(1);
    protected int[] fCharBufferOffset;
    protected boolean fValidation;
    protected boolean fNamespaces;
    protected boolean fNamespacePrefixes;
    protected boolean fSeenEnumeration;
    protected XMLString fEnumeration;
    protected boolean fNeedReset;
    protected int fAttrCount;
    protected int fAttrOffset;
    protected NSDeclList fNSDecls;
    protected AttrList fAttrs;
    protected int fElementDepth;
    protected boolean fInElementContent;
    protected String[] fQNameStringStack;
    protected int fQNameStackDepth;
    protected boolean fCalledStartDocument;
    protected String fDocumentVersion;
    protected boolean fIsSupportingLocationCoordinates;
    protected PositionHelper fPositionHelper;
    protected DocumentPosition fDocumentPosition;

    protected abstract CharConversionError parseEvents(InputSource var1);

    protected abstract boolean isStandalone(String var1);

    protected abstract boolean getScanExternalGeneralEntities(String var1);

    protected abstract void setScanExternalGeneralEntities(String var1, boolean var2);

    protected abstract boolean getScanExternalParameterEntities(String var1);

    protected abstract void setScanExternalParameterEntities(String var1, boolean var2);

    protected abstract DeclHandler getDeclHandler();

    protected abstract void setDeclHandler(DeclHandler var1);

    public abstract DTDHandler getDTDHandler();

    public abstract void setDTDHandler(DTDHandler var1);

    public abstract EntityResolver getEntityResolver();

    public abstract void setEntityResolver(EntityResolver var1);

    protected SAX2ParserBase() {
        this.fCharBuffer[0] = ArrayAllocator.newCharArray(256);
        this.fCharBufferOffset = ArrayAllocator.newIntArray(1);
        this.fQNameStringStack = ArrayAllocator.newStringArray(48);
        this.fNamespaces = true;
        this.fDocumentVersion = "1.0";
    }

    protected void reset(boolean bl) {
        this.fElementDepth = 0;
        this.fQNameStackDepth = 0;
        this.fDocumentVersion = "1.0";
        this.fCalledStartDocument = false;
        this.fSymbolTable.reset(bl);
        this.fBufferFactory.reset(bl);
    }

    public void startDocumentEvent(XMLString xMLString) {
        if (xMLString.firstBuffer != null) {
            this.fDocumentVersion = xMLString.toString();
        }
    }

    public void startDTD(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, boolean bl) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startDTD(xMLString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3 == null ? null : xMLString3.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    protected void startPrefixMappings(NSDeclList nSDeclList) {
        int n2 = nSDeclList.nsDeclCount();
        try {
            for (int i = 0; i < n2; ++i) {
                String string2 = nSDeclList.nsDeclPrefix(i);
                String string3 = nSDeclList.nsDeclURI(i);
                this.fContentHandler.startPrefixMapping(string2, string3);
            }
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    protected void endPrefixMappings(NSDeclList nSDeclList) {
        int n2 = nSDeclList.nsDeclCount();
        try {
            for (int i = n2 - 1; i >= 0; --i) {
                String string2 = nSDeclList.nsDeclPrefix(i);
                this.fContentHandler.endPrefixMapping(string2);
            }
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public void startElementEvent(QName qName, NSDeclList nSDeclList, AttrList attrList, XMLString xMLString, boolean bl) {
        this.fNSDecls = nSDeclList;
        this.fAttrs = attrList;
        this.startElementAction(qName, xMLString, bl);
        if (!bl) {
            ++this.fElementDepth;
        }
    }

    protected void startElementAction(QName qName, XMLString xMLString, boolean bl) {
        this.fAttrCount = -1;
        if (this.fContentHandler != null) {
            try {
                this.startPrefixMappings(this.fNSDecls);
                String string2 = qName.nsURI;
                String string3 = qName.localName;
                String string4 = qName.rawName;
                this.fContentHandler.startElement(string2, string3, string4, this);
                if (bl) {
                    if (xMLString != null) {
                        this.characters(xMLString);
                    }
                    this.fContentHandler.endElement(string2, string3, string4);
                    this.endPrefixMappings(this.fNSDecls);
                }
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endElementEvent(QName qName, NSDeclList nSDeclList) {
        --this.fElementDepth;
        if (this.fContentHandler != null) {
            String string2 = qName.nsURI;
            String string3 = qName.localName;
            String string4 = qName.rawName;
            this.fNSDecls = nSDeclList;
            try {
                this.fContentHandler.endElement(string2, string3, string4);
                this.endPrefixMappings(this.fNSDecls);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void characters(XMLString xMLString) {
        if (this.fContentHandler != null) {
            this.fCharBufferOffset[0] = 0;
            xMLString.getChars(this.fCharBuffer, this.fCharBufferOffset);
            try {
                this.fContentHandler.characters(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void cdataSection(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startCDATA();
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        if (this.fContentHandler != null) {
            this.fCharBufferOffset[0] = 0;
            xMLString.getChars(this.fCharBuffer, this.fCharBufferOffset);
            try {
                this.fContentHandler.characters(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endCDATA();
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void whitespace(XMLString xMLString) {
        if (this.fContentHandler != null) {
            this.fCharBufferOffset[0] = 0;
            xMLString.getChars(this.fCharBuffer, this.fCharBufferOffset);
            try {
                this.fContentHandler.ignorableWhitespace(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    private String predefinedEntityToString(int n2) {
        switch (n2) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 38: {
                return "amp";
            }
            case 39: {
                return "apos";
            }
            case 34: {
                return "quot";
            }
        }
        return null;
    }

    public void character(int n2, boolean bl) {
        String string2 = null;
        if (bl && this.fLexicalHandler != null) {
            string2 = this.predefinedEntityToString(n2);
            try {
                this.fLexicalHandler.startEntity(string2);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        if (this.fContentHandler != null) {
            int n3;
            if (n2 < 65536) {
                this.fCharBuffer[0][0] = (char)n2;
                n3 = 1;
            } else {
                int n4 = n2 - 65536;
                this.fCharBuffer[0][0] = (char)(55296 + (n4 >> 10));
                this.fCharBuffer[0][1] = (char)(56320 + (n4 & 0x3FF));
                n3 = 2;
            }
            try {
                this.fContentHandler.characters(this.fCharBuffer[0], 0, n3);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        if (string2 != null) {
            try {
                this.fLexicalHandler.endEntity(string2);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void processingInstruction(XMLString xMLString, XMLString xMLString2) {
        if (this.fContentHandler != null) {
            String string2 = this.fSymbolTable.addSymbol(xMLString);
            try {
                this.fContentHandler.processingInstruction(string2, xMLString2.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public boolean skippedEntity(XMLString xMLString) {
        if (this.fContentHandler != null) {
            try {
                this.fContentHandler.skippedEntity(xMLString.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        return true;
    }

    public void startEntity(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startEntity(xMLString.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endEntity(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endEntity(xMLString.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void comment(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            this.fCharBufferOffset[0] = 0;
            xMLString.getChars(this.fCharBuffer, this.fCharBufferOffset);
            try {
                this.fLexicalHandler.comment(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void reportWarning(String string2, int n2, int n3, XMLString[] xMLStringArray) {
        if (this.fErrorHandler != null) {
            try {
                MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(string2);
                String string3 = messageProvider.createMessage(null, n2, xMLStringArray);
                SAXParseException sAXParseException = new SAXParseException(string3, this);
                this.fErrorHandler.warning(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void reportRecoverableError(String string2, int n2, int n3, XMLString[] xMLStringArray) {
        if (this.fErrorHandler != null) {
            try {
                MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(string2);
                String string3 = messageProvider.createMessage(null, n2, xMLStringArray);
                SAXParseException sAXParseException = new SAXParseException(string3, this);
                this.fErrorHandler.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void reportFatalError(String string2, int n2, int n3, XMLString[] xMLStringArray) {
        try {
            MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(string2);
            String string3 = messageProvider.createMessage(null, n2, xMLStringArray);
            SAXParseException sAXParseException = new SAXParseException(string3, this);
            if (this.fErrorHandler != null) {
                this.fErrorHandler.fatalError(sAXParseException);
            }
            throw sAXParseException;
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    private void calculateAttrCount() {
        this.fAttrOffset = this.fNamespacePrefixes ? this.fNSDecls.nsDeclCount() : 0;
        this.fAttrCount = this.fAttrOffset + this.fAttrs.attributeCount();
    }

    public int getLength() {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        return this.fAttrCount;
    }

    public String getURI(int n2) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n2 >= this.fAttrOffset) {
            if (n2 < this.fAttrCount) {
                return this.fAttrs.attributeName((int)(n2 - this.fAttrOffset)).nsURI;
            }
        } else if (n2 >= 0) {
            return "";
        }
        return null;
    }

    public String getLocalName(int n2) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n2 >= this.fAttrOffset) {
            if (n2 < this.fAttrCount) {
                return this.fAttrs.attributeName((int)(n2 - this.fAttrOffset)).localName;
            }
        } else if (n2 >= 0) {
            return "";
        }
        return null;
    }

    public String getQName(int n2) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n2 >= this.fAttrOffset) {
            if (n2 < this.fAttrCount) {
                return this.fAttrs.attributeName((int)(n2 - this.fAttrOffset)).rawName;
            }
        } else if (n2 >= 0) {
            return this.fNSDecls.nsDeclQName(n2);
        }
        return null;
    }

    public String getType(int n2) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n2 >= this.fAttrOffset) {
            if (n2 < this.fAttrCount) {
                String string2 = this.fAttrs.attributeType(n2 - this.fAttrOffset);
                if (string2 == null) {
                    return "NMTOKEN";
                }
                if (string2.length() == 0) {
                    return "CDATA";
                }
                return string2;
            }
        } else if (n2 >= 0) {
            return "CDATA";
        }
        return null;
    }

    public String getValue(int n2) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n2 >= this.fAttrOffset) {
            if (n2 < this.fAttrCount) {
                return this.fAttrs.attributeValue(n2 -= this.fAttrOffset).toString();
            }
        } else if (n2 >= 0) {
            return this.fNSDecls.nsDeclURI(n2);
        }
        return null;
    }

    public int getIndex(String string2, String string3) {
        int n2;
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if ((n2 = this.fAttrCount - this.fAttrOffset) > 0) {
            for (int i = 0; i < n2; ++i) {
                QName qName = this.fAttrs.attributeName(i);
                if (!string3.equals(qName.localName) || !string2.equals(qName.nsURI)) continue;
                return this.fAttrOffset + i;
            }
        }
        return -1;
    }

    public int getIndex(String string2) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (this.fAttrCount > 0) {
            int n2;
            int n3 = this.fAttrCount - this.fAttrOffset;
            for (n2 = 0; n2 < n3; ++n2) {
                if (!string2.equals(this.fAttrs.attributeName((int)n2).rawName)) continue;
                return this.fAttrOffset + n2;
            }
            for (n2 = 0; n2 < this.fAttrOffset; ++n2) {
                if (!string2.equals(this.fNSDecls.nsDeclQName(n2))) continue;
                return n2;
            }
        }
        return -1;
    }

    public String getType(String string2, String string3) {
        int n2 = this.getIndex(string2, string3);
        return this.getType(n2);
    }

    public String getType(String string2) {
        int n2 = this.getIndex(string2);
        return this.getType(n2);
    }

    public String getValue(String string2, String string3) {
        int n2 = this.getIndex(string2, string3);
        return this.getValue(n2);
    }

    public String getValue(String string2) {
        int n2 = this.getIndex(string2);
        return this.getValue(n2);
    }

    public abstract String getPublicId();

    public abstract String getSystemId();

    public int getLineNumber() {
        if (this.fIsSupportingLocationCoordinates) {
            this.updateCurrentPosition0();
            return this.fDocumentPosition.lineNumber;
        }
        return -1;
    }

    public int getColumnNumber() {
        if (this.fIsSupportingLocationCoordinates) {
            this.updateCurrentPosition0();
            return this.fDocumentPosition.columnNumber;
        }
        return -1;
    }

    private void updateCurrentPosition0() {
        if (this.fPositionHelper == null) {
            this.fPositionHelper = new SimplePositionHelper();
            this.fDocumentPosition = new DocumentPosition();
        }
        this.updateCurrentPosition();
    }

    protected abstract void updateCurrentPosition();

    protected boolean getValidation(String string2) {
        return false;
    }

    protected void setValidation(String string2, boolean bl) throws SAXNotSupportedException {
        if (bl) {
            throw new SAXNotSupportedException(string2);
        }
    }

    protected boolean getResolveDTDURIs(String string2) {
        return true;
    }

    protected void setResolveDTDURIs(String string2, boolean bl) throws SAXNotSupportedException {
        if (!bl) {
            throw new SAXNotSupportedException(string2);
        }
    }

    protected boolean getGrammarCachingEnabled(String string2) {
        return false;
    }

    protected void setGrammarCachingEnabled(String string2, boolean bl) throws SAXNotSupportedException {
        if (bl) {
            throw new SAXNotSupportedException(string2);
        }
    }

    public boolean getFeature(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2.startsWith(SAX2_FEATURES_PREFIX)) {
            String string3 = string2.substring(SAX2_FEATURES_PREFIX.length());
            if (string3.equals("namespaces")) {
                return this.fNamespaces;
            }
            if (string3.equals("namespace-prefixes")) {
                return this.fNamespacePrefixes;
            }
            if (string3.equals("string-interning")) {
                return false;
            }
            if (string3.equals("validation")) {
                return this.getValidation(string2);
            }
            if (string3.equals("external-general-entities")) {
                return this.getScanExternalGeneralEntities(string2);
            }
            if (string3.equals("external-parameter-entities")) {
                return this.getScanExternalParameterEntities(string2);
            }
            if (string3.equals("lexical-handler/parameter-entities")) {
                return false;
            }
            if (string3.equals("is-standalone")) {
                if (this.fCalledStartDocument) {
                    return this.isStandalone(string2);
                }
                throw new SAXNotSupportedException(string2);
            }
            if (string3.equals("resolve-dtd-uris")) {
                return this.getResolveDTDURIs(string2);
            }
            if (string3.equals("unicode-normalization-checking")) {
                return false;
            }
            if (string3.equals("use-attributes2")) {
                return false;
            }
            if (string3.equals("use-locator2")) {
                return false;
            }
            if (string3.equals("use-entity-resolver2")) {
                return false;
            }
            if (string3.equals("xmlns-uris")) {
                return false;
            }
            if (string3.equals("xml-1.1")) {
                return true;
            }
        } else if (string2.startsWith(XLXP_FEATURES_PREFIX)) {
            String string4 = string2.substring(XLXP_FEATURES_PREFIX.length());
            if (string4.equals("validation/grammar-caching-enabled")) {
                return this.getGrammarCachingEnabled(string2);
            }
            if (string4.equals("supporting-location-coordinates")) {
                return this.fIsSupportingLocationCoordinates;
            }
        }
        throw new SAXNotRecognizedException(string2);
    }

    public void setFeature(String string2, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2.startsWith(SAX2_FEATURES_PREFIX)) {
            String string3 = string2.substring(SAX2_FEATURES_PREFIX.length());
            if (string3.equals("namespaces")) {
                this.fNamespaces = bl;
                return;
            }
            if (string3.equals("namespace-prefixes")) {
                this.fNamespacePrefixes = bl;
                return;
            }
            if (string3.equals("string-interning")) {
                if (bl) {
                    throw new SAXNotSupportedException(string2);
                }
                return;
            }
            if (string3.equals("validation")) {
                this.setValidation(string2, bl);
                return;
            }
            if (string3.equals("external-general-entities")) {
                this.setScanExternalGeneralEntities(string2, bl);
                return;
            }
            if (string3.equals("external-parameter-entities")) {
                this.setScanExternalParameterEntities(string2, bl);
                return;
            }
            if (string3.equals("lexical-handler/parameter-entities")) {
                if (bl) {
                    throw new SAXNotSupportedException(string2);
                }
                return;
            }
            if (string3.equals("is-standalone")) {
                throw new SAXNotSupportedException(string2);
            }
            if (string3.equals("resolve-dtd-uris")) {
                this.setResolveDTDURIs(string2, bl);
                return;
            }
            if (string3.equals("unicode-normalization-checking")) {
                if (bl) {
                    throw new SAXNotSupportedException(string2);
                }
                return;
            }
            if (string3.equals("use-attributes2")) {
                throw new SAXNotSupportedException(string2);
            }
            if (string3.equals("use-locator2")) {
                throw new SAXNotSupportedException(string2);
            }
            if (string3.equals("use-entity-resolver2")) {
                throw new SAXNotSupportedException(string2);
            }
            if (string3.equals("xmlns-uris")) {
                if (bl) {
                    throw new SAXNotSupportedException(string2);
                }
                return;
            }
            if (string3.equals("xml-1.1")) {
                throw new SAXNotSupportedException(string2);
            }
        } else if (string2.startsWith(XLXP_FEATURES_PREFIX)) {
            String string4 = string2.substring(XLXP_FEATURES_PREFIX.length());
            if (string4.equals("validation/grammar-caching-enabled")) {
                this.setGrammarCachingEnabled(string2, bl);
                return;
            }
            if (string4.equals("supporting-location-coordinates")) {
                this.fIsSupportingLocationCoordinates = bl;
                return;
            }
        }
        throw new SAXNotRecognizedException(string2);
    }

    public Object getProperty(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String string3 = string2.substring(SAX2_PROPERTIES_PREFIX.length());
            if (string3.equals("dom-node")) {
                throw new SAXNotSupportedException(string2);
            }
            if (string3.equals("xml-string")) {
                throw new SAXNotSupportedException(string2);
            }
            if (string3.equals("lexical-handler")) {
                return this.fLexicalHandler;
            }
            if (string3.equals("declaration-handler")) {
                return this.getDeclHandler();
            }
            if (string3.equals("document-xml-version")) {
                if (this.fCalledStartDocument) {
                    return this.fDocumentVersion;
                }
                throw new SAXNotSupportedException(string2);
            }
        }
        throw new SAXNotRecognizedException(string2);
    }

    public void setProperty(String string2, Object object2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String string3 = string2.substring(SAX2_PROPERTIES_PREFIX.length());
            if (string3.equals("dom-node")) {
                throw new SAXNotSupportedException(string2);
            }
            if (string3.equals("xml-string")) {
                throw new SAXNotSupportedException(string2);
            }
            if (string3.equals("lexical-handler")) {
                try {
                    this.fLexicalHandler = (LexicalHandler)object2;
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string2);
                }
            }
            if (string3.equals("declaration-handler")) {
                try {
                    this.setDeclHandler((DeclHandler)object2);
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string2);
                }
            }
            if (string3.equals("document-xml-version")) {
                throw new SAXNotSupportedException(string2);
            }
        }
        throw new SAXNotRecognizedException(string2);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fContentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    private void parseEntity(InputSource inputSource) throws SAXException, IOException {
        if (this.fNeedReset) {
            this.reset(true);
        }
        this.fNeedReset = true;
        try {
            CharConversionError charConversionError;
            if (this.fContentHandler != null) {
                this.fContentHandler.setDocumentLocator(this);
                this.fCalledStartDocument = true;
                this.fContentHandler.startDocument();
            }
            if ((charConversionError = this.parseEvents(inputSource)) != null) {
                try {
                    SAXParseException sAXParseException = new SAXParseException(charConversionError.formatErrorMessage(), this);
                    if (this.fErrorHandler != null) {
                        this.fErrorHandler.fatalError(sAXParseException);
                    }
                    throw sAXParseException;
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.endDocument();
            }
            this.fCalledStartDocument = false;
        }
        catch (IOExceptionWrapper iOExceptionWrapper) {
            throw iOExceptionWrapper.getIOException();
        }
        catch (SAXExceptionWrapper sAXExceptionWrapper) {
            throw sAXExceptionWrapper.getSAXException();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception.getMessage());
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.fInputSource.setPublicId(inputSource.getPublicId());
        this.fInputSource.setSystemId(inputSource.getSystemId());
        this.fInputSource.setEncoding(inputSource.getEncoding());
        this.fInputSource.setByteStream(inputSource.getByteStream());
        this.fInputSource.setCharacterStream(inputSource.getCharacterStream());
        this.parseEntity(this.fInputSource);
    }

    public void parse(String string2) throws SAXException, IOException {
        this.fInputSource.setSystemId(string2);
        this.fInputSource.setPublicId(null);
        this.fInputSource.setEncoding(null);
        this.fInputSource.setByteStream(null);
        this.fInputSource.setCharacterStream(null);
        this.parseEntity(this.fInputSource);
    }
}

