/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.sax.impl;

import com.ibm.xml.xlxp.internal.s1.api.sax.impl.SAX2ParserCallbacks;
import com.ibm.xml.xlxp.internal.s1.api.sax.impl.SAXExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.DTDScanner;
import com.ibm.xml.xlxp.internal.s1.scan.DocumentScanner;
import com.ibm.xml.xlxp.internal.s1.scan.util.DTDGrammar;
import com.ibm.xml.xlxp.internal.s1.scan.util.EntityDeclPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import org.xml.sax.DTDHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class SAX2DTDScanner
extends DTDScanner {
    private SAX2ParserCallbacks fParser;
    private StringBuilder fEnumeration;
    private boolean fSeenEnumeration;
    private boolean fDuplicateAttDef;
    private DTDHandler fDTDHandler;
    private DeclHandler fDeclHandler;

    public SAX2DTDScanner(DocumentScanner documentScanner, SymbolTable symbolTable, ParsedEntityFactory parsedEntityFactory, SAX2ParserCallbacks sAX2ParserCallbacks) {
        super(documentScanner, symbolTable, parsedEntityFactory);
        this.fParser = sAX2ParserCallbacks;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setDeclHandler(DeclHandler declHandler) {
        this.fDeclHandler = declHandler;
    }

    public DeclHandler getDeclHandler() {
        return this.fDeclHandler;
    }

    protected void nextStateProlog() {
        super.nextStateProlog();
        this.fParser.endDTD();
    }

    public boolean extSubsetPEReference(XMLString xMLString) {
        this.fParser.startPE(xMLString);
        boolean bl = super.extSubsetPEReference(xMLString);
        this.fParser.endPE(xMLString);
        return bl;
    }

    public boolean intSubsetPEReference(XMLString xMLString) {
        this.fParser.startPE(xMLString);
        boolean bl = super.intSubsetPEReference(xMLString);
        this.fParser.endPE(xMLString);
        return bl;
    }

    public boolean scanExternalSubset1() {
        this.fParser.startDTDEntity();
        boolean bl = super.scanExternalSubset1();
        this.fParser.endDTDEntity();
        return bl;
    }

    public boolean skippedExternalSubsetEntity() {
        return this.fParser.skippedExternalSubsetEntity();
    }

    protected void endElementDecl() {
        super.endElementDecl();
        if (this.fDeclHandler != null) {
            try {
                this.fDeclHandler.elementDecl(this.fDeclElementType.rawName, this.fContentModel.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    protected void startAttDef(QName qName, XMLString xMLString) {
        super.startAttDef(qName, xMLString);
        this.fSeenEnumeration = false;
    }

    protected void startEnumerationType() {
        super.startEnumerationType();
        if (this.fEnumeration == null) {
            this.fEnumeration = new StringBuilder();
        } else {
            this.fEnumeration.setLength(0);
        }
        if (this.fDeclAttType != null) {
            this.fEnumeration.append("NOTATION (");
        } else {
            this.fEnumeration.append('(');
        }
    }

    protected void enumerationType(XMLString xMLString) {
        super.enumerationType(xMLString);
        if (this.fSeenEnumeration) {
            this.fEnumeration.append('|');
        } else {
            this.fSeenEnumeration = true;
        }
        this.fEnumeration.append(xMLString.toString());
    }

    protected void endEnumerationType() {
        super.endEnumerationType();
        this.fEnumeration.append(')');
    }

    protected void duplicateAttDef(QName qName, QName qName2) {
        this.fDuplicateAttDef = true;
        super.duplicateAttDef(qName, qName2);
    }

    protected void endAttDef(XMLString xMLString) {
        this.fDuplicateAttDef = false;
        super.endAttDef(xMLString);
        if (!this.fDuplicateAttDef && this.fDeclHandler != null) {
            String string2;
            QName qName = this.fDeclElementType;
            QName qName2 = this.fDeclAttrName;
            if (this.fSeenEnumeration) {
                string2 = this.fEnumeration.toString();
                this.fEnumeration = null;
            } else {
                string2 = this.fDeclAttType.toString();
            }
            DTDGrammar.AttDef attDef = this.fDTDGrammar.lookupAttDef(qName, qName2);
            XMLString xMLString2 = attDef != null ? attDef.attValue : null;
            try {
                this.fDeclHandler.attributeDecl(qName.rawName, qName2.rawName, string2, xMLString == null ? null : xMLString.toString(), xMLString2 == null ? null : xMLString2.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    protected void internalEntityDecl(XMLString xMLString) {
        if (this.fDeclHandler == null) {
            super.internalEntityDecl(xMLString);
        } else {
            EntityDeclPool.EntityDecl entityDecl = this.fEntityManager.lookupEntity(xMLString);
            super.internalEntityDecl(xMLString);
            if (entityDecl == null) {
                try {
                    this.fDeclHandler.internalEntityDecl(xMLString.toString(), this.fInternalEntityValue.toString());
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
        }
    }

    protected void externalEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        if (this.fDeclHandler == null) {
            super.externalEntityDecl(xMLString, xMLString2, xMLString3);
        } else {
            EntityDeclPool.EntityDecl entityDecl = this.fEntityManager.lookupEntity(xMLString);
            super.externalEntityDecl(xMLString, xMLString2, xMLString3);
            if (entityDecl == null) {
                try {
                    this.fDeclHandler.externalEntityDecl(xMLString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3.toString());
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
        }
    }

    protected void unparsedEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, XMLString xMLString4) {
        if (this.fDTDHandler == null) {
            super.unparsedEntityDecl(xMLString, xMLString2, xMLString3, xMLString4);
        } else {
            EntityDeclPool.EntityDecl entityDecl = this.fEntityManager.lookupEntity(xMLString);
            super.unparsedEntityDecl(xMLString, xMLString2, xMLString3, xMLString4);
            if (entityDecl == null) {
                try {
                    this.fDTDHandler.unparsedEntityDecl(xMLString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3.toString(), xMLString4.toString());
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
        }
    }

    protected void internalPEDecl(XMLString xMLString) {
        if (this.fDeclHandler == null) {
            super.internalPEDecl(xMLString);
        } else {
            EntityDeclPool.EntityDecl entityDecl = this.fEntityManager.lookupPE(xMLString);
            super.internalPEDecl(xMLString);
            if (entityDecl == null) {
                try {
                    this.fDeclHandler.internalEntityDecl("%" + xMLString, this.fInternalEntityValue.toString());
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
        }
    }

    protected void externalPEDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        if (this.fDeclHandler == null) {
            super.externalPEDecl(xMLString, xMLString2, xMLString3);
        } else {
            EntityDeclPool.EntityDecl entityDecl = this.fEntityManager.lookupPE(xMLString);
            super.externalPEDecl(xMLString, xMLString2, xMLString3);
            if (entityDecl == null) {
                try {
                    this.fDeclHandler.externalEntityDecl("%" + xMLString, xMLString2 == null ? null : xMLString2.toString(), xMLString3.toString());
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
        }
    }

    protected void notationDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        super.notationDecl(xMLString, xMLString2, xMLString3);
        if (this.fDTDHandler != null) {
            try {
                this.fDTDHandler.notationDecl(xMLString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3 == null ? null : xMLString3.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    protected boolean processingInstructionInDTD(XMLString xMLString, XMLString xMLString2) {
        this.fParser.processingInstructionInDTD(xMLString, xMLString2);
        return super.processingInstructionInDTD(xMLString, xMLString2);
    }

    protected boolean commentInDTD(XMLString xMLString) {
        this.fParser.commentInDTD(xMLString);
        return super.commentInDTD(xMLString);
    }
}

