/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.finiteStateMachine.impl;

import com.ibm.xml.xlxp.finiteStateMachine.ActualTransitionSymbol;
import com.ibm.xml.xlxp.finiteStateMachine.State;
import com.ibm.xml.xlxp.finiteStateMachine.Transition;
import com.ibm.xml.xlxp.finiteStateMachine.impl.FiniteStateMachineImpl;
import com.ibm.xml.xlxp.util.BitSet;
import com.ibm.xml.xlxp.util.Recyclable;
import com.ibm.xml.xlxp.util.SymbolTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class StateImpl
implements State,
Recyclable {
    private BitSet fTransitionGroup;
    protected final FiniteStateMachineImpl fFsm;
    protected int fIndex;
    protected final Set fTransitionSymbols = new TreeSet();
    protected final TreeMap fTransitions = new TreeMap();
    protected boolean fFinalState;
    protected Object fInfo;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected StateImpl(FiniteStateMachineImpl finiteStateMachineImpl, SymbolTable symbolTable) {
        this.fFsm = finiteStateMachineImpl;
        this.fTransitionGroup = symbolTable.newBitSet();
        this.fInfo = null;
    }

    public Object getStateInfo() {
        return this.fInfo;
    }

    public void initialise(BitSet bitSet, int n2, Object object2) {
        bitSet.copyTo(this.fTransitionGroup);
        this.fIndex = n2;
        this.fFinalState = false;
        this.fInfo = object2;
    }

    public void releaseObjects() {
        this.fFsm.fFactory.releaseStateInfo(this.fInfo);
        this.fFsm.releaseTransitions(this.fTransitions.values());
        this.fTransitionSymbols.clear();
        this.fTransitions.clear();
    }

    public Object differentiator() {
        return this.fTransitionGroup;
    }

    public boolean sameTransitions(BitSet bitSet) {
        return this.fTransitionGroup.equals(bitSet);
    }

    public BitSet getWrapperTransitions() {
        return this.fTransitionGroup;
    }

    public void setTransition(ActualTransitionSymbol actualTransitionSymbol, int n2) {
        Transition transition = this.fFsm.createTransition(actualTransitionSymbol, n2);
        this.fTransitions.put(actualTransitionSymbol, transition);
        StateImpl stateImpl = (StateImpl)transition.state();
        stateImpl.setTransitionInSymbol(actualTransitionSymbol);
    }

    public void setTransitionInSymbol(ActualTransitionSymbol actualTransitionSymbol) {
        this.fTransitionSymbols.add(actualTransitionSymbol);
    }

    public void markIsFinalState() {
        this.fFinalState = true;
    }

    public boolean isFinalState() {
        return this.fFinalState;
    }

    public Collection transitions() {
        return this.fTransitions.values();
    }

    public Transition transition(ActualTransitionSymbol actualTransitionSymbol) {
        return (Transition)this.fTransitions.get(actualTransitionSymbol);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.transitions().iterator();
        while (iterator.hasNext()) {
            Transition transition = (Transition)iterator.next();
            ActualTransitionSymbol actualTransitionSymbol = transition.transitionSymbol();
            stringBuffer.append(" (").append(actualTransitionSymbol.toString()).append(", ").append(String.valueOf(((StateImpl)transition.state()).index())).append(")");
        }
        return stringBuffer.toString();
    }

    public int index() {
        return this.fIndex;
    }

    public Collection transitionInSymbols() {
        return this.fTransitionSymbols;
    }
}

