/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.regularExpressions;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.AsciiVector;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Atom;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.AtomImpl;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharAtom;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharIterator;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.PosCharGroupMemberImpl;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.RegularExpressionSymbolTable;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.finiteStateMachine.RegularExpressionFSMActualTransitionSymbol;

public class CharacterRange
extends PosCharGroupMemberImpl {
    private final char fLow;
    private final char fHigh;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CharacterRange(CharAtom charAtom, CharAtom charAtom2, RegularExpressionSymbolTable regularExpressionSymbolTable) {
        this(regularExpressionSymbolTable, charAtom.getChar(), charAtom2.getChar());
    }

    private CharacterRange(CharacterRange characterRange, boolean bl, RegularExpressionSymbolTable regularExpressionSymbolTable) {
        this(regularExpressionSymbolTable, characterRange.low(), characterRange.high());
        if (bl) {
            this.negate();
        }
    }

    protected CharacterRange(RegularExpressionSymbolTable regularExpressionSymbolTable, char c, char c2) {
        super(c < '\u0080' && c2 < '\u0080' ? 4 : 3, c + "-" + c2, regularExpressionSymbolTable);
        this.fLow = c;
        this.fHigh = c2;
        if (this.fLow >= this.fHigh) {
            throw new CompilerError();
        }
    }

    public boolean negate() {
        this.fIrIdentifier = -this.fIrIdentifier;
        return true;
    }

    public Atom optimise(RegularExpressionSymbolTable regularExpressionSymbolTable) {
        return new CharacterRange(this, this.isNegated(), regularExpressionSymbolTable);
    }

    private boolean isNegated() {
        return this.fIrIdentifier < 0;
    }

    public char low() {
        return this.fLow;
    }

    public char high() {
        return this.fHigh;
    }

    public Boolean intersectsWith(RegularExpressionFSMActualTransitionSymbol regularExpressionFSMActualTransitionSymbol) {
        Atom atom2 = (Atom)regularExpressionFSMActualTransitionSymbol;
        return atom2.intersects(this.fLow, this.fHigh) ? AtomImpl.trueAnswer : AtomImpl.falseAnswer;
    }

    public boolean intersects(char c, char c2) {
        return this.isNegated() ^ (c <= c2 && (AtomImpl.inRange(c, this.fLow, this.fHigh) || AtomImpl.inRange(c2, this.fLow, this.fHigh) || AtomImpl.inRange(this.fLow, c, c2) || AtomImpl.inRange(this.fHigh, c, c2)));
    }

    public boolean intersects(char c) {
        return this.isNegated() ^ AtomImpl.inRange(c, this.fLow, this.fHigh);
    }

    public Boolean intersectsDot() {
        return AtomImpl.trueAnswer;
    }

    public Boolean intersectsInverse(Atom atom2) {
        return this.bool(this.isNegated() ^ (atom2.intersects('\u0000', (char)(this.fLow - '\u0001')) || atom2.intersects((char)(this.fHigh + '\u0001'), '\uffff')));
    }

    public boolean intersectsInverse(char c) {
        return this.isNegated() ^ AtomImpl.notInRange(c, this.fLow, this.fHigh);
    }

    public boolean intersectsInverse(char c, char c2) {
        return this.isNegated() ^ (c <= c2 && (c < this.fLow || c2 > this.fHigh));
    }

    public CharIterator iterator() {
        if (this.isNegated()) {
            return null;
        }
        return new CharIterator(){
            private char c;
            {
                this.c = CharacterRange.this.fLow;
            }

            public boolean hasNext() {
                return this.c <= CharacterRange.this.fHigh;
            }

            public char next() {
                char c = this.c;
                this.c = (char)(c + '\u0001');
                return c;
            }
        };
    }

    public CharIterator inverseIterator() {
        throw new CompilerError();
    }

    public AsciiVector toAsciiVector(RegularExpressionSymbolTable regularExpressionSymbolTable) {
        AsciiVector asciiVector = AsciiVector.create(this, regularExpressionSymbolTable);
        if (this.isNegated()) {
            asciiVector.negate();
        }
        return asciiVector;
    }
}

