/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.regularExpressions;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.AsciiVector;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Atom;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.AtomImpl;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharAtom;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharIterator;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Dot;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.PosCharGroupMemberImpl;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.RegularExpressionSymbolTable;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.finiteStateMachine.RegularExpressionFSMActualTransitionSymbol;

public class CharAtomImpl
extends PosCharGroupMemberImpl
implements CharAtom {
    private final char fChar;
    private final Character fCharacter;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CharAtomImpl(char c, RegularExpressionSymbolTable regularExpressionSymbolTable) {
        this(regularExpressionSymbolTable, c);
    }

    protected CharAtomImpl(CharAtomImpl charAtomImpl, boolean bl, RegularExpressionSymbolTable regularExpressionSymbolTable) {
        this(regularExpressionSymbolTable, charAtomImpl.getChar());
        if (bl) {
            this.negate();
        }
    }

    private CharAtomImpl(RegularExpressionSymbolTable regularExpressionSymbolTable, char c) {
        super(c < '\u0080' ? 5 : 6, CharAtomImpl.debugString(c), regularExpressionSymbolTable);
        this.fChar = c;
        this.fCharacter = new Character(this.fChar);
    }

    public Atom optimise(RegularExpressionSymbolTable regularExpressionSymbolTable) {
        return new CharAtomImpl(this, this.isNegated(), regularExpressionSymbolTable);
    }

    private boolean isNegated() {
        return this.fIrIdentifier < 0;
    }

    public char getChar() {
        return this.fChar;
    }

    public boolean negate() {
        this.fIrIdentifier = -this.fIrIdentifier;
        return true;
    }

    public Boolean intersectsWith(RegularExpressionFSMActualTransitionSymbol regularExpressionFSMActualTransitionSymbol) {
        Atom atom2 = (Atom)regularExpressionFSMActualTransitionSymbol;
        return this.bool(this.isNegated() ^ atom2.intersects(this.fCharacter.charValue()));
    }

    public boolean intersects(char c) {
        return this.isNegated() ^ this.fChar == c;
    }

    public boolean intersects(char c, char c2) {
        return this.isNegated() ^ AtomImpl.inRange(this.fChar, c, c2);
    }

    public Boolean intersectsDot() {
        return this.bool(this.isNegated() ^ Dot.intersectsWithChar(this.fChar));
    }

    public Boolean intersectsInverse(Atom atom2) {
        return this.bool(this.isNegated() ^ (atom2.intersects('\u0000', (char)(this.fChar - '\u0001')) || atom2.intersects((char)(this.fChar + '\u0001'), '\uffff')));
    }

    public boolean intersectsInverse(char c) {
        return this.isNegated() ^ this.fChar != c;
    }

    public boolean intersectsInverse(char c, char c2) {
        return this.isNegated() ^ AtomImpl.notInRange(this.fChar, c, c2);
    }

    public CharIterator iterator() {
        if (this.isNegated()) {
            return null;
        }
        return new CharIterator(){
            private boolean b = true;

            public boolean hasNext() {
                return this.b;
            }

            public char next() {
                this.b = false;
                return CharAtomImpl.this.fChar;
            }
        };
    }

    public CharIterator inverseIterator() {
        throw new CompilerError();
    }

    public AsciiVector toAsciiVector(RegularExpressionSymbolTable regularExpressionSymbolTable) {
        AsciiVector asciiVector = AsciiVector.create(this, regularExpressionSymbolTable);
        if (this.isNegated()) {
            asciiVector.negate();
        }
        return asciiVector;
    }

    private static String debugString(char c) {
        char[] cArray = new char[]{c};
        return new String(cArray);
    }
}

