/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.regularExpressions;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Atom;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharAtom;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharAtomImpl;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharIterator;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharacterRange;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.NegateableAtom;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.PosCharGroupMemberImpl;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.RegularExpressionSymbolTable;

public class AsciiVector
extends NegateableAtom {
    protected boolean[] fIncluded;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private AsciiVector(boolean[] blArray, RegularExpressionSymbolTable regularExpressionSymbolTable) {
        super(7, false, "asciiVector", regularExpressionSymbolTable);
        this.fIncluded = blArray;
    }

    private AsciiVector(RegularExpressionSymbolTable regularExpressionSymbolTable) {
        this(new boolean[128], regularExpressionSymbolTable);
        int n2 = 0;
        while (n2 <= 127) {
            this.fIncluded[n2] = false;
            ++n2;
        }
    }

    private AsciiVector(char c, RegularExpressionSymbolTable regularExpressionSymbolTable) {
        this(regularExpressionSymbolTable);
        this.fIncluded[c] = true;
    }

    private AsciiVector(char c, char c2, RegularExpressionSymbolTable regularExpressionSymbolTable) {
        this(regularExpressionSymbolTable);
        char c3 = c;
        while (c3 <= c2) {
            this.fIncluded[c3] = true;
            c3 = (char)(c3 + '\u0001');
        }
    }

    public AsciiVector toAsciiVector(RegularExpressionSymbolTable regularExpressionSymbolTable) {
        return this;
    }

    public static boolean inRange(char c) {
        return c <= '\u007f';
    }

    public Atom optimise(RegularExpressionSymbolTable regularExpressionSymbolTable) {
        return this;
    }

    private void safeSetIncluded(char c) {
        if (!AsciiVector.inRange(c)) {
            throw new CompilerError();
        }
        this.fIncluded[c] = !this.fNegate;
    }

    public boolean setIncluded(char c) {
        if (AsciiVector.inRange(c)) {
            this.safeSetIncluded(c);
            return true;
        }
        return false;
    }

    public void safeRemove(char c) {
        if (!AsciiVector.inRange(c)) {
            throw new CompilerError();
        }
        this.fIncluded[c] = this.fNegate;
    }

    public boolean remove(char c) {
        if (AsciiVector.inRange(c)) {
            this.safeRemove(c);
            return true;
        }
        return false;
    }

    protected boolean intersectsCalculation(char c) {
        return this.fIncluded[c];
    }

    protected boolean intersectsInverseCalculation(char c) {
        return !this.fIncluded[c];
    }

    public CharIterator iterator() {
        return new CharIterator(){
            private char i = '\u0000';
            {
                this.getNext();
            }

            public boolean hasNext() {
                return AsciiVector.inRange(this.i);
            }

            public char next() {
                char c = this.i;
                this.i = (char)(c + '\u0001');
                char c2 = c;
                this.getNext();
                return c2;
            }

            private void getNext() {
                while (AsciiVector.inRange(this.i) && !AsciiVector.this.intersects(this.i)) {
                    this.i = (char)(this.i + '\u0001');
                }
            }
        };
    }

    public void merge(AsciiVector asciiVector) {
        CharIterator charIterator = asciiVector.iterator();
        while (charIterator.hasNext()) {
            this.safeSetIncluded(charIterator.next());
        }
    }

    public Atom vectorRepresentation(RegularExpressionSymbolTable regularExpressionSymbolTable) {
        PosCharGroupMemberImpl posCharGroupMemberImpl;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (AsciiVector.inRange((char)n4)) {
            if (this.fIncluded[n4]) {
                if (n2 == -1) {
                    n2 = n4;
                } else if (n3 == -1) {
                    n3 = n4;
                } else if (n3 == n4 - 1) {
                    ++n3;
                } else {
                    return this;
                }
            }
            n4 = (char)(n4 + '\u0001');
        }
        if (n2 == -1) {
            return null;
        }
        PosCharGroupMemberImpl posCharGroupMemberImpl2 = posCharGroupMemberImpl = n3 == -1 ? new CharAtomImpl((char)n2, regularExpressionSymbolTable) : new CharacterRange(regularExpressionSymbolTable, (char)n2, (char)n3);
        if (this.fNegate) {
            posCharGroupMemberImpl.negate();
        }
        return posCharGroupMemberImpl;
    }

    static AsciiVector create(CharAtom charAtom, RegularExpressionSymbolTable regularExpressionSymbolTable) {
        char c = charAtom.getChar();
        return AsciiVector.inRange(c) ? new AsciiVector(c, regularExpressionSymbolTable) : null;
    }

    static AsciiVector create(CharacterRange characterRange, RegularExpressionSymbolTable regularExpressionSymbolTable) {
        char c = characterRange.high();
        return AsciiVector.inRange(c) ? new AsciiVector(characterRange.low(), c, regularExpressionSymbolTable) : null;
    }

    static AsciiVector createEmptyVector(RegularExpressionSymbolTable regularExpressionSymbolTable) {
        return new AsciiVector(regularExpressionSymbolTable);
    }
}

