/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.ir;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.compiler.IRGenerator;
import com.ibm.xml.xlxp.compiler.impl.Label;
import com.ibm.xml.xlxp.compiler.impl.ir.Goto;
import com.ibm.xml.xlxp.compiler.impl.ir.InstructionBase;

public class InstructionLabel
extends InstructionBase {
    private Label fLabel;
    private int fIndex = 0;
    private boolean fReachedByCodeFlow = false;
    protected Goto fNextGotoInstruction = null;
    protected boolean fNextIsReturn = false;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public InstructionLabel(Label label) {
        if (label == null) {
            throw new CompilerError();
        }
        this.fLabel = label;
    }

    public void generate(IRGenerator iRGenerator) throws Exception {
        if (this.fLabel != null) {
            iRGenerator.labelCode(this.fLabel);
        }
    }

    public Label label() {
        return !this.redirected() ? this.fLabel : null;
    }

    public void setReachedByCodeFlow() {
        this.fReachedByCodeFlow = true;
    }

    public boolean reachedByCodeFlow() {
        return this.fReachedByCodeFlow;
    }

    public boolean redirected() {
        return this.fLabel == null;
    }

    public void redirectTo(Label label) {
        this.fLabel.redirectTo(label);
        this.fLabel = null;
    }

    public void nextIsGoto(Goto goto_) {
        this.fNextGotoInstruction = goto_;
    }

    public Label labelGotoPairTarget() {
        if (!this.redirected() && this.fNextGotoInstruction != null && !this.reachedByCodeFlow()) {
            return this.fNextGotoInstruction.getLabel();
        }
        return null;
    }

    public void setNextIsReturn() {
        this.fNextIsReturn = true;
    }

    public boolean nextIsReturn() {
        return this.fNextIsReturn;
    }
}

