/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.idc;

import com.ibm.xml.xlxp.compiler.impl.idc.XPathAction;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathActualTransitionSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathAttributeInfo;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathAttributeInfoImpl;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathDFA;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathQNameActualTransitionSymbol;
import com.ibm.xml.xlxp.finiteStateMachine.ActualTransitionSymbol;
import com.ibm.xml.xlxp.finiteStateMachine.State;
import com.ibm.xml.xlxp.finiteStateMachine.Transition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class XPathDFAImpl
implements XPathDFA {
    private int fId;
    private int fIdcId;
    private int fSymbolsCount;
    private XPathActualTransitionSymbol[] fSymbols;
    private TreeSet[] fStateAttributes;
    private boolean[] fAllowMoreInput;
    private boolean[] fFinalStates;
    private int[][] fTransTable;
    private int fTransTableSize;
    private int fFinalFieldsStartSize = 0;
    private ArrayList fFieldActions = null;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public XPathDFAImpl(int n2, int n3, List list, List list2) {
        this.fId = n2;
        this.fIdcId = n3;
        this.buildDFA(list, list2);
    }

    public void setId(int n2) {
        this.fId = n2;
    }

    public int id() {
        return this.fId;
    }

    public int idcId() {
        return this.fIdcId;
    }

    public boolean isStateFinal(int n2) {
        if (n2 < this.fTransTableSize) {
            return this.fFinalStates[n2];
        }
        return false;
    }

    public boolean isStateFinalA(int n2) {
        if (n2 < this.fTransTableSize) {
            return this.fStateAttributes[n2] != null;
        }
        return false;
    }

    public boolean allowMoreInput(int n2) {
        if (n2 < this.fTransTableSize) {
            return this.fAllowMoreInput[n2];
        }
        return false;
    }

    public XPathAttributeInfo[] attributes(int n2) {
        if (n2 < this.fTransTableSize && this.fStateAttributes[n2] != null) {
            XPathAttributeInfo[] xPathAttributeInfoArray = new XPathAttributeInfo[this.fStateAttributes[n2].size()];
            Iterator iterator = this.fStateAttributes[n2].iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                XPathActualTransitionSymbol xPathActualTransitionSymbol = (XPathActualTransitionSymbol)iterator.next();
                xPathAttributeInfoArray[n3++] = new XPathAttributeInfoImpl(xPathActualTransitionSymbol.namespace(), xPathActualTransitionSymbol.name(), 0);
            }
            return xPathAttributeInfoArray;
        }
        return null;
    }

    public int transition(int n2, String string2, String string3) {
        if (n2 < this.fTransTableSize) {
            int n3 = 0;
            while (n3 < this.fSymbolsCount) {
                XPathActualTransitionSymbol xPathActualTransitionSymbol = this.fSymbols[n3];
                if (xPathActualTransitionSymbol.allowElement(string2, string3 == null ? "" : string3)) {
                    return this.fTransTable[n2][n3];
                }
                ++n3;
            }
        }
        return 0;
    }

    public void addStartFieldAction(XPathAction xPathAction) {
        if (this.fFieldActions == null) {
            this.fFieldActions = new ArrayList();
        }
        if (xPathAction.isNewStateFinal()) {
            ++this.fFinalFieldsStartSize;
            if (this.fFinalFieldsStartSize <= this.fFieldActions.size()) {
                this.fFieldActions.add(this.fFinalFieldsStartSize - 1, xPathAction);
                return;
            }
        }
        this.fFieldActions.add(xPathAction);
    }

    public int[][] transitionTable() {
        return this.fTransTable;
    }

    public boolean[] allowMoreInput() {
        return this.fAllowMoreInput;
    }

    public List startFieldActions() {
        return this.fFieldActions;
    }

    public int finalFieldsStartSize() {
        return this.fFinalFieldsStartSize;
    }

    public String[] transitionSymbols() {
        int n2 = 0;
        String[] stringArray = new String[this.fSymbolsCount * 2];
        int n3 = 0;
        while (n3 < this.fSymbolsCount) {
            XPathActualTransitionSymbol xPathActualTransitionSymbol = this.fSymbols[n3];
            stringArray[n2++] = xPathActualTransitionSymbol.namespace;
            stringArray[n2++] = xPathActualTransitionSymbol.type == 1 ? xPathActualTransitionSymbol.name : null;
            ++n3;
        }
        return stringArray;
    }

    public XPathAttributeInfo[][] finalAttrDecls() {
        XPathAttributeInfo[][] xPathAttributeInfoArray = new XPathAttributeInfo[this.fTransTableSize][];
        int n2 = 0;
        while (n2 < this.fTransTableSize) {
            xPathAttributeInfoArray[n2] = this.attributes(n2);
            ++n2;
        }
        return xPathAttributeInfoArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t");
        int n2 = 0;
        while (n2 < this.fSymbolsCount) {
            stringBuffer.append(this.fSymbols[n2].toString() + "\t");
            ++n2;
        }
        stringBuffer.append("\n");
        int n3 = 1;
        while (n3 < this.fTransTableSize) {
            stringBuffer.append(n3);
            if (this.isStateFinal(n3) || this.isStateFinalA(n3)) {
                stringBuffer.append("*:\t");
            } else {
                stringBuffer.append(":\t");
            }
            int n4 = 0;
            while (n4 < this.fSymbolsCount) {
                stringBuffer.append(this.fTransTable[n3][n4] + "\t\t");
                ++n4;
            }
            stringBuffer.append("\n");
            ++n3;
        }
        return stringBuffer.toString();
    }

    private void buildDFA(List list, List list2) {
        this.buildSymbolsTable(list2);
        this.createTransitionTable(list.size() + 1);
        this.buildTransitionTable(list);
    }

    private void buildSymbolsTable(List list) {
        this.fSymbolsCount = list.size();
        this.fSymbols = new XPathActualTransitionSymbol[this.fSymbolsCount];
        int n2 = 0;
        while (n2 < this.fSymbolsCount) {
            this.fSymbols[n2] = (XPathActualTransitionSymbol)list.get(n2);
            ++n2;
        }
    }

    private void createTransitionTable(int n2) {
        this.fTransTableSize = n2;
        this.fTransTable = new int[this.fTransTableSize][];
        this.fStateAttributes = new TreeSet[this.fTransTableSize];
        this.fAllowMoreInput = new boolean[this.fTransTableSize];
        this.fFinalStates = new boolean[this.fTransTableSize];
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray = new int[this.fSymbolsCount];
            int n4 = 0;
            while (n4 < this.fSymbolsCount) {
                nArray[n4] = 0;
                ++n4;
            }
            this.fTransTable[n3] = nArray;
            ++n3;
        }
    }

    private void buildTransitionTable(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            State state = (State)iterator.next();
            this.processState(state);
        }
        this.finalizeStateFlags();
    }

    private void processState(State state) {
        Iterator iterator = state.transitions().iterator();
        int n2 = 1 + state.index();
        while (iterator.hasNext()) {
            Transition transition = (Transition)iterator.next();
            ActualTransitionSymbol actualTransitionSymbol = transition.transitionSymbol();
            if (this.isAttributeSymbol(actualTransitionSymbol)) {
                this.addStateAttribute(state.index() + 1, (XPathActualTransitionSymbol)actualTransitionSymbol);
                continue;
            }
            int n3 = this.getSymbolIndex(actualTransitionSymbol);
            this.fTransTable[n2][n3] = transition.state().isFinalState() ? -(1 + transition.state().index()) : 1 + transition.state().index();
            this.fAllowMoreInput[n2] = true;
        }
        if (state.isFinalState()) {
            this.fFinalStates[n2] = true;
        }
    }

    private int getSymbolIndex(Object object2) {
        int n2 = 0;
        while (n2 < this.fSymbolsCount) {
            if (this.fSymbols[n2] == object2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private boolean isAttributeSymbol(ActualTransitionSymbol actualTransitionSymbol) {
        return actualTransitionSymbol instanceof XPathQNameActualTransitionSymbol && ((XPathQNameActualTransitionSymbol)actualTransitionSymbol).isAttribute();
    }

    private void addStateAttribute(int n2, XPathActualTransitionSymbol xPathActualTransitionSymbol) {
        if (this.fStateAttributes[n2] == null) {
            this.fStateAttributes[n2] = new TreeSet();
        }
        if (!this.overlappingAttrSymbol(xPathActualTransitionSymbol, this.fStateAttributes[n2])) {
            if (xPathActualTransitionSymbol.name == null) {
                this.removeOverlappedAttrs(this.fStateAttributes[n2], xPathActualTransitionSymbol);
            }
            this.fStateAttributes[n2].add(xPathActualTransitionSymbol);
        }
    }

    private void removeOverlappedAttrs(TreeSet treeSet, XPathActualTransitionSymbol xPathActualTransitionSymbol) {
        Object[] objectArray = treeSet.toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            XPathActualTransitionSymbol xPathActualTransitionSymbol2 = (XPathActualTransitionSymbol)objectArray[n2];
            if (xPathActualTransitionSymbol.namespace == null || xPathActualTransitionSymbol.namespace.equals(xPathActualTransitionSymbol2.namespace)) {
                treeSet.remove(xPathActualTransitionSymbol2);
            }
            ++n2;
        }
    }

    private boolean overlappingAttrSymbol(XPathActualTransitionSymbol xPathActualTransitionSymbol, TreeSet treeSet) {
        Object[] objectArray = treeSet.toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            XPathActualTransitionSymbol xPathActualTransitionSymbol2 = (XPathActualTransitionSymbol)objectArray[n2];
            if (xPathActualTransitionSymbol2.name == null && (xPathActualTransitionSymbol2.namespace == null || xPathActualTransitionSymbol2.namespace.equals(xPathActualTransitionSymbol.namespace))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void finalizeStateFlags() {
        int n2 = this.fTransTableSize - 1;
        while (n2 >= 1) {
            if (this.isStateReferenced(n2)) break;
            if (this.fTransTableSize > 2) {
                --this.fTransTableSize;
            }
            --n2;
        }
        if (this.fTransTableSize != this.fTransTable.length) {
            this.compressTransitionTable();
        }
    }

    private void compressTransitionTable() {
        int[][] nArrayArray = new int[this.fTransTableSize][];
        boolean[] blArray = new boolean[this.fTransTableSize];
        System.arraycopy(this.fAllowMoreInput, 0, blArray, 0, this.fTransTableSize);
        int n2 = 0;
        while (n2 < this.fTransTableSize) {
            int[] nArray = new int[this.fSymbolsCount];
            System.arraycopy(this.fTransTable[n2], 0, nArray, 0, this.fSymbolsCount);
            nArrayArray[n2] = nArray;
            ++n2;
        }
        this.fTransTable = nArrayArray;
        this.fAllowMoreInput = blArray;
    }

    private boolean isStateReferenced(int n2) {
        int n3 = 1;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < this.fSymbolsCount) {
                if (n2 == Math.abs(this.fTransTable[n3][n4])) {
                    return true;
                }
                ++n4;
            }
            ++n3;
        }
        return false;
    }
}

