/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.idc;

import com.ibm.xml.xlxp.compiler.impl.Attributes;
import com.ibm.xml.xlxp.compiler.impl.Element;
import com.ibm.xml.xlxp.compiler.impl.OwnedAttributes;
import com.ibm.xml.xlxp.compiler.impl.SchemaSymbol;
import com.ibm.xml.xlxp.compiler.impl.SymbolTable;
import com.ibm.xml.xlxp.compiler.impl.TypeSymbol;
import com.ibm.xml.xlxp.compiler.impl.WildcardElement;
import com.ibm.xml.xlxp.compiler.impl.idc.IDCGeneratorInfo;
import com.ibm.xml.xlxp.compiler.impl.idc.IDCSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathAction;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathActionFinalNilSelector;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathActionImpl;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathActionInvalid;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathAttributeInfo;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathAttributeInfoImpl;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathDFA;
import com.ibm.xml.xlxp.compiler.impl.iterators.SymbolIterator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;

public class IDCMatcher {
    private Stack fInfoStack = new Stack();
    private MatcherInfoPool fInfoPool = new MatcherInfoPool();
    private AnnotatedMap fAnnotatedMap = new AnnotatedMap();
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void match(SymbolIterator symbolIterator, SymbolTable symbolTable) {
        this.clear();
        this.startSelectors(symbolIterator);
        this.processInfoStack(symbolTable);
    }

    private void clear() {
        this.fAnnotatedMap.clear();
    }

    private void startSelectors(SymbolIterator symbolIterator) {
        while (symbolIterator.hasNext()) {
            Element element2 = (Element)symbolIterator.next();
            IDCSymbol[] iDCSymbolArray = element2.getIdentityConstraints();
            int n2 = 0;
            while (n2 < iDCSymbolArray.length) {
                this.startSelector(element2, iDCSymbolArray[n2]);
                ++n2;
            }
        }
    }

    private void startSelector(Element element2, IDCSymbol iDCSymbol) {
        XPathDFA xPathDFA = iDCSymbol.getSelector();
        boolean bl = xPathDFA.isStateFinal(1);
        boolean bl2 = xPathDFA.allowMoreInput(1);
        int n2 = bl ? -1 : 1;
        IDCGeneratorInfo iDCGeneratorInfo = this.getIDCGeneratorInfo(element2);
        XPathActionImpl xPathActionImpl = new XPathActionImpl(iDCSymbol, 1, true, xPathDFA.id(), 0, n2, bl, bl2);
        xPathActionImpl.setFieldCount(iDCSymbol.getFieldCount());
        iDCGeneratorInfo.addAction(xPathActionImpl);
        this.addStartFieldActions(xPathDFA, iDCSymbol, element2, bl);
        if (bl2) {
            MatcherInfo matcherInfo = this.fInfoPool.matcherInfo();
            matcherInfo.setValues(element2, iDCSymbol, xPathDFA, n2, n2, -1);
            this.fInfoStack.push(matcherInfo);
        }
        if (bl) {
            this.endSelector(element2, iDCSymbol, xPathActionImpl);
        }
    }

    private void endSelector(Element element2, IDCSymbol iDCSymbol, XPathActionImpl xPathActionImpl) {
        int n2 = iDCSymbol.getFieldCount();
        if (element2.isNullable()) {
            this.getIDCGeneratorInfo(element2).addNilAction(new XPathActionFinalNilSelector(xPathActionImpl));
        }
        int n3 = 0;
        while (n3 < n2) {
            XPathDFA xPathDFA = iDCSymbol.getFieldAt(n3);
            this.startField(element2, iDCSymbol, xPathDFA, n3, xPathActionImpl);
            ++n3;
        }
    }

    private void startField(Element element2, IDCSymbol iDCSymbol, XPathDFA xPathDFA, int n2, XPathActionImpl xPathActionImpl) {
        boolean bl = xPathDFA.allowMoreInput(1);
        boolean bl2 = xPathDFA.isStateFinal(1);
        boolean bl3 = xPathDFA.isStateFinalA(1);
        int n3 = bl2 ? -1 : 1;
        XPathActionImpl xPathActionImpl2 = new XPathActionImpl(iDCSymbol, 1, false, xPathDFA.id(), 0, n3, bl2 || bl3, bl);
        xPathActionImpl2.setFieldIndex(n2);
        xPathActionImpl.addFieldAction(xPathActionImpl2);
        if (bl3) {
            this.setFieldAttributes(element2, xPathActionImpl2, xPathDFA.attributes(1));
        }
        if (bl) {
            MatcherInfo matcherInfo = this.fInfoPool.matcherInfo();
            matcherInfo.setValues(element2, iDCSymbol, xPathDFA, n3, n3, n2);
            this.fInfoStack.push(matcherInfo);
        }
    }

    private XPathAction createStartFieldAction(Element element2, IDCSymbol iDCSymbol, XPathDFA xPathDFA, int n2, boolean bl) {
        boolean bl2 = xPathDFA.allowMoreInput(1);
        boolean bl3 = xPathDFA.isStateFinal(1);
        boolean bl4 = xPathDFA.isStateFinalA(1);
        int n3 = bl3 ? -1 : 1;
        XPathActionImpl xPathActionImpl = new XPathActionImpl(iDCSymbol, 1, false, xPathDFA.id(), 0, n3, bl3 || bl4, bl2);
        xPathActionImpl.setFieldIndex(n2);
        if (bl4) {
            if (bl) {
                this.setFieldAttributes(element2, xPathActionImpl, xPathDFA.attributes(1));
            } else {
                xPathActionImpl.setAttributes(xPathDFA.attributes(1));
            }
        }
        return xPathActionImpl;
    }

    private void addStartFieldActions(XPathDFA xPathDFA, IDCSymbol iDCSymbol, Element element2, boolean bl) {
        int n2 = iDCSymbol.getFieldCount();
        int n3 = 0;
        while (n3 < n2) {
            XPathDFA xPathDFA2 = iDCSymbol.getFieldAt(n3);
            XPathAction xPathAction = this.createStartFieldAction(element2, iDCSymbol, xPathDFA2, n3, bl);
            xPathDFA.addStartFieldAction(xPathAction);
            ++n3;
        }
    }

    private void processInfoStack(SymbolTable symbolTable) {
        while (!this.fInfoStack.isEmpty()) {
            MatcherInfo matcherInfo = (MatcherInfo)this.fInfoStack.pop();
            this.processInfo(matcherInfo, symbolTable);
            this.fInfoPool.returnMatcherInfo(matcherInfo);
        }
    }

    private void processInfo(MatcherInfo matcherInfo, SymbolTable symbolTable) {
        XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)matcherInfo.element.schemaObject();
        TypeSymbol typeSymbol = matcherInfo.element.type();
        XSTypeDefinition xSTypeDefinition = xSElementDeclaration.getTypeDefinition();
        if (xSTypeDefinition.getTypeCategory() == 15) {
            XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition;
            if (xSComplexTypeDefinition.getBaseType() == xSComplexTypeDefinition) {
                this.getIDCGeneratorInfo(matcherInfo.element).addAction(new XPathActionImpl(matcherInfo.idcSymbol, 2, matcherInfo.isSelector(), matcherInfo.xpathDFA.id(), matcherInfo.currentState, 0, false, true));
                return;
            }
            XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
            if (xSParticle != null) {
                this.matchParticle(matcherInfo, xSParticle, symbolTable, matcherInfo.isSelector());
            }
            if (typeSymbol.hasRestrictedDerivedTypes()) {
                this.matchDerivedTypes(matcherInfo, typeSymbol.derivedByRestriction(), symbolTable, matcherInfo.isSelector());
            }
            if (typeSymbol.hasExtendedDerivedTypes()) {
                this.matchDerivedTypes(matcherInfo, typeSymbol.derivedByExtension(), symbolTable, matcherInfo.isSelector());
            }
        }
    }

    private void matchParticle(MatcherInfo matcherInfo, XSParticle xSParticle, SymbolTable symbolTable, boolean bl) {
        XSTerm xSTerm = xSParticle.getTerm();
        if (xSTerm instanceof XSElementDeclaration) {
            Element element2 = (Element)symbolTable.get((XSObject)xSTerm);
            this.matchTermElement(matcherInfo, element2, symbolTable, bl);
            return;
        }
        if (xSTerm instanceof XSWildcard) {
            WildcardElement wildcardElement = (WildcardElement)symbolTable.get((XSObject)xSTerm);
            this.matchTermWildcard(matcherInfo, wildcardElement, symbolTable, bl);
            return;
        }
        if (xSTerm instanceof XSModelGroup) {
            XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
            XSObjectList xSObjectList = xSModelGroup.getParticles();
            int n2 = 0;
            while (n2 < xSObjectList.getLength()) {
                this.matchParticle(matcherInfo, (XSParticle)xSObjectList.item(n2), symbolTable, bl);
                ++n2;
            }
        }
    }

    private void matchTermElement(MatcherInfo matcherInfo, Element element2, SymbolTable symbolTable, boolean bl) {
        this.matchElement(matcherInfo, element2, symbolTable, bl);
        Element[] elementArray = element2.substitutionGroupMembers();
        int n2 = 0;
        while (n2 < elementArray.length) {
            Element element3 = elementArray[n2];
            if (element3 != element2) {
                this.matchElement(matcherInfo, element3, symbolTable, bl);
            }
            ++n2;
        }
    }

    private void matchElement(MatcherInfo matcherInfo, Element element2, SymbolTable symbolTable, boolean bl) {
        Object object2;
        XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)element2.schemaObject();
        int n2 = matcherInfo.xpathDFA.transition(Math.abs(matcherInfo.currentState), xSElementDeclaration.getName(), xSElementDeclaration.getNamespace());
        if (n2 == 0 || this.fAnnotatedMap.contains(element2, matcherInfo.xpathDFA, Math.abs(matcherInfo.currentState))) {
            return;
        }
        this.fAnnotatedMap.put(element2, matcherInfo.xpathDFA, Math.abs(matcherInfo.currentState));
        boolean bl2 = matcherInfo.xpathDFA.isStateFinal(Math.abs(n2));
        boolean bl3 = matcherInfo.xpathDFA.allowMoreInput(Math.abs(n2));
        boolean bl4 = matcherInfo.xpathDFA.isStateFinalA(Math.abs(n2));
        if (bl3) {
            object2 = this.fInfoPool.matcherInfo();
            ((MatcherInfo)object2).setValues(element2, matcherInfo.idcSymbol, matcherInfo.xpathDFA, matcherInfo.currentState, n2, matcherInfo.fieldIndex);
            this.fInfoStack.push(object2);
        }
        object2 = new XPathActionImpl(matcherInfo.idcSymbol, 2, bl, matcherInfo.xpathDFA.id(), matcherInfo.currentState, n2, bl2 || bl4, bl3);
        if (bl) {
            this.getIDCGeneratorInfo(element2).addAction((XPathAction)object2);
            if (bl2) {
                this.endSelector(element2, matcherInfo.idcSymbol, (XPathActionImpl)object2);
            }
            return;
        }
        ((XPathActionImpl)object2).setFieldIndex(matcherInfo.fieldIndex);
        if (bl4) {
            this.setFieldAttributes(element2, (XPathActionImpl)object2, matcherInfo.xpathDFA.attributes(Math.abs(n2)));
        }
        if (element2.isNullable()) {
            Object object3 = object2;
            if (n2 < 0) {
                object3 = new XPathActionInvalid((XPathActionImpl)object2);
                if (matcherInfo.idcSymbol.getCategory() == 1) {
                    this.getIDCGeneratorInfo(element2).addAction((XPathAction)object3);
                } else {
                    this.getIDCGeneratorInfo(element2).addAction((XPathAction)object2);
                }
            } else {
                this.getIDCGeneratorInfo(element2).addAction((XPathAction)object2);
            }
            if (bl2 || bl4) {
                this.getIDCGeneratorInfo(element2).addNilAction((XPathAction)object3);
            }
        } else {
            this.getIDCGeneratorInfo(element2).addAction((XPathAction)object2);
        }
    }

    private void matchDerivedTypes(MatcherInfo matcherInfo, Set set2, SymbolTable symbolTable, boolean bl) {
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            XSComplexTypeDefinition xSComplexTypeDefinition;
            XSParticle xSParticle;
            TypeSymbol typeSymbol = (TypeSymbol)iterator.next();
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)typeSymbol.schemaObject();
            if (xSTypeDefinition.getTypeCategory() != 15 || (xSParticle = (xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition).getParticle()) == null) continue;
            this.matchParticle(matcherInfo, xSParticle, symbolTable, bl);
        }
    }

    private void matchTermWildcard(MatcherInfo matcherInfo, WildcardElement wildcardElement, SymbolTable symbolTable, boolean bl) {
        if (this.fAnnotatedMap.contains(wildcardElement, matcherInfo.xpathDFA, Math.abs(matcherInfo.currentState))) {
            return;
        }
        this.fAnnotatedMap.put(wildcardElement, matcherInfo.xpathDFA, Math.abs(matcherInfo.currentState));
        this.getIDCGeneratorInfo(wildcardElement).addAction(new XPathActionImpl(matcherInfo.idcSymbol, 2, bl, matcherInfo.xpathDFA.id(), matcherInfo.currentState, 0, false, true));
    }

    private IDCGeneratorInfo getIDCGeneratorInfo(Element element2) {
        IDCGeneratorInfo iDCGeneratorInfo = element2.idcGeneratorInfo();
        if (iDCGeneratorInfo == null) {
            iDCGeneratorInfo = new IDCGeneratorInfo(this.getTypeOwnedAttributesSize(element2));
            element2.setIDCGeneratorInfo(iDCGeneratorInfo);
        }
        return iDCGeneratorInfo;
    }

    private IDCGeneratorInfo getIDCGeneratorInfo(WildcardElement wildcardElement) {
        IDCGeneratorInfo iDCGeneratorInfo = wildcardElement.idcGeneratorInfo();
        if (iDCGeneratorInfo == null) {
            iDCGeneratorInfo = new IDCGeneratorInfo(0);
            wildcardElement.setIDCGeneratorInfo(iDCGeneratorInfo);
        }
        return iDCGeneratorInfo;
    }

    private void setFieldAttributes(Element element2, XPathActionImpl xPathActionImpl, XPathAttributeInfo[] xPathAttributeInfoArray) {
        OwnedAttributes ownedAttributes;
        Attributes attributes2 = element2.type().attributes();
        if (attributes2 != null && !(ownedAttributes = attributes2.ownedAttributes()).isEmpty()) {
            int n2 = ownedAttributes.getLength();
            int n3 = 0;
            while (n3 < xPathAttributeInfoArray.length) {
                XPathAttributeInfoImpl xPathAttributeInfoImpl = (XPathAttributeInfoImpl)xPathAttributeInfoArray[n3];
                if (xPathAttributeInfoImpl.name() != null) {
                    int n4 = 0;
                    while (n4 < n2) {
                        String string2;
                        XSAttributeDeclaration xSAttributeDeclaration = ownedAttributes.decl(n4);
                        String string3 = string2 = xSAttributeDeclaration.getNamespace() == null ? "" : xSAttributeDeclaration.getNamespace();
                        if (xPathAttributeInfoImpl.name().equals(xSAttributeDeclaration.getName()) && xPathAttributeInfoImpl.namespace().equals(string2)) {
                            xPathAttributeInfoImpl.setIndex(6 + n4);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
        }
        xPathActionImpl.setAttributes(xPathAttributeInfoArray);
    }

    private int getTypeOwnedAttributesSize(Element element2) {
        OwnedAttributes ownedAttributes;
        Attributes attributes2 = element2.type().attributes();
        if (attributes2 != null && !(ownedAttributes = attributes2.ownedAttributes()).isEmpty()) {
            return 6 + ownedAttributes.getLength();
        }
        return 0;
    }

    private static final class AnnotatedMap {
        private TreeMap fMap = new TreeMap();

        private AnnotatedMap() {
        }

        public void put(SchemaSymbol schemaSymbol, XPathDFA xPathDFA, int n2) {
            ArrayList<int[]> arrayList = (ArrayList<int[]>)this.fMap.get(schemaSymbol);
            if (arrayList == null) {
                arrayList = new ArrayList<int[]>();
                this.fMap.put(schemaSymbol, arrayList);
            }
            int[] nArray = new int[2];
            this.setValue(nArray, xPathDFA, n2);
            arrayList.add(nArray);
        }

        public boolean contains(SchemaSymbol schemaSymbol, XPathDFA xPathDFA, int n2) {
            ArrayList arrayList = (ArrayList)this.fMap.get(schemaSymbol);
            if (arrayList != null) {
                int[] nArray = new int[2];
                Iterator iterator = ((AbstractList)arrayList).iterator();
                this.setValue(nArray, xPathDFA, n2);
                while (iterator.hasNext()) {
                    int[] nArray2 = (int[])iterator.next();
                    if (!this.equals(nArray, nArray2)) continue;
                    return true;
                }
            }
            return false;
        }

        public void clear() {
            this.fMap.clear();
        }

        private void setValue(int[] nArray, XPathDFA xPathDFA, int n2) {
            nArray[0] = xPathDFA.id();
            nArray[1] = n2;
        }

        private boolean equals(int[] nArray, int[] nArray2) {
            return nArray[0] == nArray2[0] && nArray[1] == nArray2[1];
        }
    }

    private static final class MatcherInfoPool {
        private MatcherInfo head;

        private MatcherInfoPool() {
        }

        public MatcherInfo matcherInfo() {
            if (this.head == null) {
                return new MatcherInfo();
            }
            MatcherInfo matcherInfo = this.head;
            this.head = this.head.next;
            return matcherInfo;
        }

        public void returnMatcherInfo(MatcherInfo matcherInfo) {
            matcherInfo.next = this.head;
            this.head = matcherInfo;
        }
    }

    private static final class MatcherInfo {
        public Element element;
        public IDCSymbol idcSymbol;
        public XPathDFA xpathDFA;
        public int oldState;
        public int currentState;
        public int fieldIndex = -1;
        public MatcherInfo next;

        private MatcherInfo() {
        }

        public void setValues(Element element2, IDCSymbol iDCSymbol, XPathDFA xPathDFA, int n2, int n3, int n4) {
            this.element = element2;
            this.idcSymbol = iDCSymbol;
            this.xpathDFA = xPathDFA;
            this.oldState = n2;
            this.currentState = n3;
            this.fieldIndex = n4;
        }

        public boolean isSelector() {
            return this.fieldIndex == -1;
        }
    }
}

