/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.idc;

import com.ibm.xml.xlxp.compiler.impl.CodeGenerator;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathAction;
import java.util.ArrayList;

public class IDCGeneratorInfo {
    private int fTypeOwnedAttrsSize;
    private int fFinalKeyUniqueStartActionsSize;
    private int fFinalMatchActionsSize;
    private int fFinalKeyrefStartActionsSize;
    private ArrayList fKeyrefStartActions;
    private ArrayList fKeyUniqueStartActions;
    private ArrayList fMatchActions;
    private ArrayList fKeyUniqueStartNilActions;
    private ArrayList fKeyrefStartNilActions;
    private ArrayList fMatchNilActions;
    private ArrayList fEndActions;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public IDCGeneratorInfo(int n2) {
        this.fTypeOwnedAttrsSize = n2;
    }

    public void addAction(XPathAction xPathAction) {
        if (xPathAction.action() == 1) {
            this.addStartAction(xPathAction);
        } else {
            this.addMatchAction(xPathAction);
        }
    }

    public void addEndAction(XPathAction xPathAction) {
        if (this.fEndActions == null) {
            this.fEndActions = new ArrayList();
        }
        this.fEndActions.add(xPathAction);
    }

    public void addNilAction(XPathAction xPathAction) {
        if (xPathAction.action() == 1) {
            this.addNilStartAction(xPathAction);
        } else {
            this.addNilMatchAction(xPathAction);
        }
    }

    public void generateStartIDCInstruction(CodeGenerator codeGenerator, boolean bl) {
        if (bl) {
            codeGenerator.startIdentityConstraint(this.fKeyrefStartNilActions, this.fKeyrefStartNilActions.size(), this.fKeyUniqueStartNilActions, this.fKeyUniqueStartNilActions.size(), this.fMatchNilActions, this.fMatchNilActions.size(), this.fTypeOwnedAttrsSize);
        } else {
            codeGenerator.startIdentityConstraint(this.fKeyrefStartActions, this.fFinalKeyrefStartActionsSize, this.fKeyUniqueStartActions, this.fFinalKeyUniqueStartActionsSize, this.fMatchActions, this.fFinalMatchActionsSize, this.fTypeOwnedAttrsSize);
        }
    }

    public void generateEndIDCInstruction(CodeGenerator codeGenerator) {
        codeGenerator.endIdentityConstraint(this.fEndActions);
    }

    public boolean hasActions(boolean bl) {
        if (bl) {
            return this.fKeyUniqueStartNilActions != null || this.fKeyrefStartNilActions != null || this.fMatchNilActions != null;
        }
        return this.fKeyrefStartActions != null || this.fKeyUniqueStartActions != null || this.fMatchActions != null;
    }

    private void addStartAction(XPathAction xPathAction) {
        if (xPathAction.idcCategory() == 2) {
            this.addKeyrefStartAction(xPathAction);
        } else {
            this.addKeyUniqueStartAction(xPathAction);
        }
    }

    private void addKeyUniqueStartAction(XPathAction xPathAction) {
        if (this.fKeyUniqueStartActions == null) {
            this.fKeyUniqueStartActions = new ArrayList();
        }
        if (xPathAction.isNewStateFinal()) {
            ++this.fFinalKeyUniqueStartActionsSize;
            if (this.fFinalKeyUniqueStartActionsSize <= this.fKeyUniqueStartActions.size()) {
                this.fKeyUniqueStartActions.add(this.fFinalKeyUniqueStartActionsSize - 1, xPathAction);
                return;
            }
        }
        this.fKeyUniqueStartActions.add(xPathAction);
    }

    private void addKeyrefStartAction(XPathAction xPathAction) {
        if (this.fKeyrefStartActions == null) {
            this.fKeyrefStartActions = new ArrayList();
        }
        if (xPathAction.isNewStateFinal()) {
            ++this.fFinalKeyrefStartActionsSize;
            if (this.fFinalKeyrefStartActionsSize <= this.fKeyrefStartActions.size()) {
                this.fKeyrefStartActions.add(this.fFinalKeyrefStartActionsSize - 1, xPathAction);
                return;
            }
        }
        this.fKeyrefStartActions.add(xPathAction);
    }

    private void addMatchAction(XPathAction xPathAction) {
        if (this.fMatchActions == null) {
            this.fMatchActions = new ArrayList();
        }
        if (xPathAction.isNewStateFinal()) {
            ++this.fFinalMatchActionsSize;
            if (this.fFinalMatchActionsSize <= this.fMatchActions.size()) {
                this.fMatchActions.add(this.fFinalMatchActionsSize - 1, xPathAction);
                return;
            }
        }
        this.fMatchActions.add(xPathAction);
    }

    private void addNilStartAction(XPathAction xPathAction) {
        if (xPathAction.idcCategory() == 2) {
            this.addNilKeyrefAction(xPathAction);
        } else {
            this.addNilKeyUniqueAction(xPathAction);
        }
    }

    private void addNilKeyrefAction(XPathAction xPathAction) {
        if (this.fKeyrefStartNilActions == null) {
            this.fKeyrefStartNilActions = new ArrayList();
        }
        this.fKeyrefStartNilActions.add(xPathAction);
    }

    private void addNilKeyUniqueAction(XPathAction xPathAction) {
        if (this.fKeyUniqueStartNilActions == null) {
            this.fKeyUniqueStartNilActions = new ArrayList();
        }
        this.fKeyUniqueStartNilActions.add(xPathAction);
    }

    private void addNilMatchAction(XPathAction xPathAction) {
        if (this.fMatchNilActions == null) {
            this.fMatchNilActions = new ArrayList();
        }
        this.fMatchNilActions.add(xPathAction);
    }
}

