/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.finiteStateMachine;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.compiler.impl.CodeGenerator;
import com.ibm.xml.xlxp.compiler.impl.ComplexType;
import com.ibm.xml.xlxp.compiler.impl.Element;
import com.ibm.xml.xlxp.compiler.impl.GeneratorInfo;
import com.ibm.xml.xlxp.compiler.impl.Grammar;
import com.ibm.xml.xlxp.compiler.impl.Label;
import com.ibm.xml.xlxp.compiler.impl.SearchTableImpl;
import com.ibm.xml.xlxp.compiler.impl.ValueInfo;
import com.ibm.xml.xlxp.compiler.impl.WildcardElement;
import com.ibm.xml.xlxp.compiler.impl.WildcardTermInfo;
import com.ibm.xml.xlxp.compiler.impl.finiteStateMachine.ComplexTypeFSM;
import com.ibm.xml.xlxp.compiler.impl.finiteStateMachine.ComplexTypeFSMActualTransitionSymbol;
import com.ibm.xml.xlxp.compiler.impl.finiteStateMachine.ComplexTypeFSMTransitionIterator;
import com.ibm.xml.xlxp.compiler.impl.idc.IDCGeneratorInfo;
import com.ibm.xml.xlxp.compiler.impl.iterators.ExclusiveSetIterator;
import com.ibm.xml.xlxp.compiler.tables.SearchTableInfo;
import com.ibm.xml.xlxp.compiler.tables.Table;
import com.ibm.xml.xlxp.compiler.tables.TableId;
import com.ibm.xml.xlxp.finiteStateMachine.State;
import com.ibm.xml.xlxp.finiteStateMachine.Transition;
import com.ibm.xml.xlxp.util.Recyclable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSWildcard;

final class ComplexTypeFSMStateInfo
implements Recyclable {
    private State fState;
    private final Map fInfo = new TreeMap();
    private TableId fTableId = null;
    private Transition fFlowThroughTransition = null;
    private Label fEndOfTransitionsIn = null;
    private ComplexTypeFSM fFsm = null;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void initialise(State state, Label label, ComplexTypeFSM complexTypeFSM) {
        this.fState = state;
        this.fEndOfTransitionsIn = label;
        this.fFsm = complexTypeFSM;
    }

    public void releaseObjects() {
        this.fInfo.clear();
        this.fTableId = null;
        this.fFlowThroughTransition = null;
        this.fEndOfTransitionsIn = null;
    }

    public void setInfo(CodeGenerator codeGenerator, ComplexType complexType) {
        Grammar grammar = codeGenerator.grammar();
        Iterator iterator = this.fState.transitionInSymbols().iterator();
        while (iterator.hasNext()) {
            ComplexTypeFSMActualTransitionSymbol complexTypeFSMActualTransitionSymbol = (ComplexTypeFSMActualTransitionSymbol)iterator.next();
            Element[] elementArray = complexTypeFSMActualTransitionSymbol.transitionSymbols(grammar);
            int n2 = 0;
            while (n2 < elementArray.length) {
                Element element2 = elementArray[n2];
                GeneratorInfo generatorInfo = element2.createInfo(codeGenerator, complexTypeFSMActualTransitionSymbol.isWildcard() ? (WildcardElement)complexTypeFSMActualTransitionSymbol : null, complexType);
                this.fInfo.put(element2, generatorInfo);
                ++n2;
            }
        }
    }

    public GeneratorInfo info(Element element2) {
        GeneratorInfo generatorInfo = (GeneratorInfo)this.fInfo.get(element2);
        if (generatorInfo == null) {
            throw new CompilerError();
        }
        return generatorInfo;
    }

    public Label xsiWildcardTransitionTarget() {
        return this.fEndOfTransitionsIn;
    }

    public Table createTable(CodeGenerator codeGenerator) {
        Grammar grammar = codeGenerator.grammar();
        if (!this.hasMultipleTransitions(grammar)) {
            return null;
        }
        SearchTableImpl searchTableImpl = new SearchTableImpl(128, codeGenerator);
        this.fTableId = searchTableImpl.tableId();
        Iterator iterator = this.fState.transitions().iterator();
        while (iterator.hasNext()) {
            Transition transition = (Transition)iterator.next();
            ComplexTypeFSMStateInfo complexTypeFSMStateInfo = (ComplexTypeFSMStateInfo)transition.state().getStateInfo();
            ComplexTypeFSMActualTransitionSymbol complexTypeFSMActualTransitionSymbol = (ComplexTypeFSMActualTransitionSymbol)transition.transitionSymbol();
            Element[] elementArray = complexTypeFSMActualTransitionSymbol.transitionSymbols(grammar);
            int n2 = 0;
            while (n2 < elementArray.length) {
                Element element2 = elementArray[n2];
                String string2 = element2.inputText();
                GeneratorInfo generatorInfo = complexTypeFSMStateInfo.info(element2);
                SearchTableInfo searchTableInfo = element2.createSearchTableInfo(codeGenerator, generatorInfo, element2);
                searchTableImpl.addData(string2, searchTableInfo);
                ++n2;
            }
        }
        searchTableImpl.finishTable(codeGenerator);
        return searchTableImpl;
    }

    public void generateInstructions(CodeGenerator codeGenerator, Label label, ComplexType complexType, int n2) {
        Element[] elementArray;
        Object object2;
        boolean bl;
        boolean bl2 = this.generateCodeForTransitionsIntoState(codeGenerator, complexType);
        if (label != null) {
            codeGenerator.generateLabel(label);
            complexType.startComplexTypeExtensionInstructions(codeGenerator);
        }
        codeGenerator.generateLabel(this.fEndOfTransitionsIn);
        Label label2 = this.fState.isFinalState() ? this.fFsm.endOfCodeLabel() : null;
        boolean bl3 = bl = n2 == 0;
        if (this.fTableId != null) {
            List list = this.wildcardInfo(codeGenerator, complexType);
            codeGenerator.getInput(this.fTableId, label2, bl, list);
            if (list != null) {
                this.generateExtensionWildcardInstructions(list, codeGenerator);
            }
            return;
        }
        if (this.fState.transitions().size() == 0) {
            Label label3 = this.fFsm.getEndOfParentLabel();
            if (this.fState.index() != this.fFsm.states().size() - 1) {
                codeGenerator.gotoLabel(label3);
            }
            return;
        }
        Grammar grammar = codeGenerator.grammar();
        Transition transition = null;
        Element element2 = null;
        List list = this.wildcardInfo(codeGenerator, complexType);
        Iterator iterator = this.fState.transitions().iterator();
        while (iterator.hasNext()) {
            transition = (Transition)iterator.next();
            object2 = (ComplexTypeFSMActualTransitionSymbol)transition.transitionSymbol();
            elementArray = object2.transitionSymbols(grammar);
            if (elementArray.length <= 0) continue;
            element2 = elementArray[0];
            break;
        }
        if (element2 != null) {
            object2 = (ComplexTypeFSMStateInfo)transition.state().getStateInfo();
            elementArray = ((ComplexTypeFSMStateInfo)object2).info(element2);
            Label[] labelArray = elementArray.labels();
            boolean bl4 = element2.hasVC();
            boolean bl5 = element2.isFixed();
            int n3 = element2.simpleType();
            ValueInfo valueInfo = element2.constraintValue();
            int[] nArray = element2.vcSafeTypes();
            codeGenerator.getInput(element2, label2, labelArray, bl, bl4, bl5, n3, valueInfo, nArray, list);
            if (list == null && this.fState.index() + 1 == this.fState.index()) {
                ((ComplexTypeFSMStateInfo)object2).setFlowThroughTransition(transition);
                return;
            }
            codeGenerator.gotoLabel(labelArray[0]);
            this.generateExtensionWildcardInstructions(list, codeGenerator);
            return;
        }
        codeGenerator.getInput(list, label2, bl);
        this.generateExtensionWildcardInstructions(list, codeGenerator);
    }

    private List wildcardInfo(CodeGenerator codeGenerator, ComplexType complexType) {
        ArrayList<WildcardTermInfo> arrayList = null;
        Iterator iterator = this.fState.transitions().iterator();
        while (iterator.hasNext()) {
            Transition transition = (Transition)iterator.next();
            ComplexTypeFSMActualTransitionSymbol complexTypeFSMActualTransitionSymbol = (ComplexTypeFSMActualTransitionSymbol)transition.transitionSymbol();
            WildcardTermInfo wildcardTermInfo = complexTypeFSMActualTransitionSymbol.wildcardInfo(arrayList);
            if (wildcardTermInfo == null) continue;
            IDCGeneratorInfo iDCGeneratorInfo = ((WildcardElement)complexTypeFSMActualTransitionSymbol).idcGeneratorInfo();
            Label label = ((ComplexTypeFSMStateInfo)transition.state().getStateInfo()).xsiWildcardTransitionTarget();
            wildcardTermInfo.setTarget(label);
            List list = null;
            Label label2 = null;
            List list2 = null;
            Label label3 = null;
            List list3 = null;
            Label label4 = null;
            List list4 = null;
            Label label5 = null;
            XSWildcard xSWildcard = (XSWildcard)((WildcardElement)complexTypeFSMActualTransitionSymbol).schemaObject();
            if (complexType != null) {
                XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)complexType.schemaObject();
                if (wildcardTermInfo.processingConstraint() != 2) {
                    list = codeGenerator.createStartWildcardInstruction(xSWildcard, false, xSComplexTypeDefinition);
                    if (list != null || iDCGeneratorInfo != null) {
                        label2 = codeGenerator.createLabel();
                    }
                    if ((list2 = codeGenerator.createEndWildcardInstruction(xSWildcard, false, xSComplexTypeDefinition)) != null || iDCGeneratorInfo != null) {
                        label3 = codeGenerator.createLabel();
                    }
                }
                if (wildcardTermInfo.processingConstraint() != 1) {
                    list3 = codeGenerator.createStartWildcardInstruction(xSWildcard, true, xSComplexTypeDefinition);
                    if (list3 != null || iDCGeneratorInfo != null) {
                        label4 = codeGenerator.createLabel();
                    }
                    if ((list4 = codeGenerator.createEndWildcardInstruction(xSWildcard, true, xSComplexTypeDefinition)) != null || iDCGeneratorInfo != null) {
                        label5 = codeGenerator.createLabel();
                    }
                }
            }
            wildcardTermInfo.setExtensionStartWCNotSkippedInfo(list, label2);
            wildcardTermInfo.setExtensionEndWCNotSkippedInfo(list2, label3);
            wildcardTermInfo.setExtensionStartWCSkippedInfo(list3, label4);
            wildcardTermInfo.setExtensionEndWCSkippedInfo(list4, label5);
            wildcardTermInfo.setIDCGeneratorInfo(iDCGeneratorInfo);
            if (arrayList == null) {
                arrayList = new ArrayList<WildcardTermInfo>();
            }
            arrayList.add(wildcardTermInfo);
        }
        return arrayList;
    }

    private void generateExtensionWildcardInstructions(List list, CodeGenerator codeGenerator) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            WildcardTermInfo wildcardTermInfo = (WildcardTermInfo)iterator.next();
            IDCGeneratorInfo iDCGeneratorInfo = wildcardTermInfo.idcGeneratorInfo();
            List list2 = wildcardTermInfo.extensionStartWCNotSkippedInstructions();
            Label label = wildcardTermInfo.extensionStartWCNotSkippedLabel();
            this.generateExtensionStartWildcardSubroutine(list2, label, codeGenerator, iDCGeneratorInfo);
            list2 = wildcardTermInfo.extensionStartWCSkippedInstructions();
            label = wildcardTermInfo.extensionStartWCSkippedLabel();
            this.generateExtensionStartWildcardSubroutine(list2, label, codeGenerator, iDCGeneratorInfo);
            list2 = wildcardTermInfo.extensionEndWCNotSkippedInstructions();
            label = wildcardTermInfo.extensionEndWCNotSkippedLabel();
            this.generateExtensionEndWildcardSubroutine(list2, label, codeGenerator, iDCGeneratorInfo);
            list2 = wildcardTermInfo.extensionEndWCSkippedInstructions();
            label = wildcardTermInfo.extensionEndWCSkippedLabel();
            this.generateExtensionEndWildcardSubroutine(list2, label, codeGenerator, iDCGeneratorInfo);
        }
    }

    private void generateExtensionStartWildcardSubroutine(List list, Label label, CodeGenerator codeGenerator, IDCGeneratorInfo iDCGeneratorInfo) {
        if (label != null) {
            if (label == null) {
                throw new CompilerError();
            }
            codeGenerator.generateLabel(label);
            if (iDCGeneratorInfo != null) {
                iDCGeneratorInfo.generateStartIDCInstruction(codeGenerator, false);
            }
            if (list != null) {
                codeGenerator.genStartWildcardInstruction(list);
            }
            codeGenerator.returnFromSubroutine();
        }
    }

    private void generateExtensionEndWildcardSubroutine(List list, Label label, CodeGenerator codeGenerator, IDCGeneratorInfo iDCGeneratorInfo) {
        if (label != null) {
            if (label == null) {
                throw new CompilerError();
            }
            codeGenerator.generateLabel(label);
            if (iDCGeneratorInfo != null) {
                iDCGeneratorInfo.generateEndIDCInstruction(codeGenerator);
            }
            if (list != null) {
                codeGenerator.genEndWildcardInstruction(list);
            }
            codeGenerator.returnFromSubroutine();
        }
    }

    private boolean generateCodeForTransitionsIntoState(CodeGenerator codeGenerator, ComplexType complexType) {
        Object object2;
        boolean bl = false;
        Element element2 = null;
        if (this.fFlowThroughTransition != null) {
            element2 = this.getFlowThroughElement(codeGenerator.grammar());
            if (element2 == null) {
                throw new CompilerError();
            }
            object2 = (GeneratorInfo)this.fInfo.get(element2);
            object2.generateInlineInstructions(codeGenerator, this.fEndOfTransitionsIn, true);
            bl = true;
        }
        object2 = this.fInfo.entrySet();
        ExclusiveSetIterator exclusiveSetIterator = new ExclusiveSetIterator((Set)object2, element2);
        while (exclusiveSetIterator.hasNext()) {
            GeneratorInfo generatorInfo = (GeneratorInfo)exclusiveSetIterator.value();
            generatorInfo.generateInlineInstructions(codeGenerator, this.fEndOfTransitionsIn, true);
            bl = true;
        }
        return bl;
    }

    public void setFlowThroughTransition(Transition transition) {
        this.fFlowThroughTransition = transition;
    }

    private Element getFlowThroughElement(Grammar grammar) {
        ComplexTypeFSMActualTransitionSymbol complexTypeFSMActualTransitionSymbol = (ComplexTypeFSMActualTransitionSymbol)this.fFlowThroughTransition.transitionSymbol();
        Element[] elementArray = complexTypeFSMActualTransitionSymbol.transitionSymbols(grammar);
        Element element2 = elementArray[0];
        if (elementArray.length > 1) {
            throw new CompilerError();
        }
        return element2;
    }

    private boolean hasMultipleTransitions(Grammar grammar) {
        ComplexTypeFSMTransitionIterator complexTypeFSMTransitionIterator = new ComplexTypeFSMTransitionIterator(this.fState.transitions().iterator(), grammar);
        if (!complexTypeFSMTransitionIterator.hasNext()) {
            return false;
        }
        complexTypeFSMTransitionIterator.next();
        return complexTypeFSMTransitionIterator.hasNext();
    }
}

