/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl;

import com.ibm.xml.xlxp.compiler.impl.Element;
import com.ibm.xml.xlxp.compiler.impl.Grammar;
import com.ibm.xml.xlxp.compiler.impl.SymbolTable;
import com.ibm.xml.xlxp.compiler.impl.WildcardAttributeInfoImpl;
import com.ibm.xml.xlxp.compiler.impl.WildcardInfo;
import com.ibm.xml.xlxp.compiler.impl.WildcardList;
import com.ibm.xml.xlxp.compiler.impl.WildcardTermInfoImpl;
import com.ibm.xml.xlxp.compiler.impl.iterators.SymbolIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.xs.StringList;

public class WildcardListImpl
implements WildcardList {
    private final int[] fNamespaces;
    private final boolean fInclusive;
    private Element[] fSymbols = null;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public WildcardListImpl(StringList stringList, boolean bl, Grammar grammar) {
        this(stringList.getLength(), stringList, bl, grammar);
    }

    protected WildcardListImpl(int n2, StringList stringList, boolean bl, Grammar grammar) {
        this.fNamespaces = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.fNamespaces[n3] = grammar.namespaceId(stringList.item(n3));
            ++n3;
        }
        this.fInclusive = bl;
    }

    public int[] namespaces() {
        return this.fNamespaces;
    }

    public boolean isInclusiveConstraint() {
        return this.fInclusive;
    }

    public Element[] transitionSymbols(Grammar grammar) {
        if (this.fSymbols == null) {
            this.fillList(grammar);
        }
        return this.fSymbols;
    }

    public WildcardInfo wildcardInfo(int n2, boolean bl) {
        if (bl) {
            return new WildcardAttributeInfoImpl(n2, !this.fInclusive, this.fNamespaces);
        }
        return new WildcardTermInfoImpl(n2, !this.fInclusive, this.fNamespaces);
    }

    protected void fillList(Grammar grammar) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        SymbolTable symbolTable = grammar.symbolTable();
        SymbolIterator symbolIterator = symbolTable.globalConcreteElementIterator();
        while (symbolIterator.hasNext()) {
            Element element2 = (Element)symbolIterator.next();
            int n2 = grammar.namespaceId(element2.namespace());
            if (this.fInclusive != this.inNamespaceList(n2)) continue;
            arrayList.add(element2);
        }
        this.fSymbols = arrayList.toArray(new Element[0]);
    }

    private boolean inNamespaceList(int n2) {
        int n3 = 0;
        while (n3 < this.fNamespaces.length) {
            if (this.fNamespaces[n3] == n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public List knownAttributes(Grammar grammar) {
        return grammar.attributesInNamespaces(this.fNamespaces, this.fInclusive);
    }
}

