/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl;

import com.ibm.xml.xlxp.compiler.impl.Grammar;
import com.ibm.xml.xlxp.compiler.impl.NonterminalSymbolImpl;
import com.ibm.xml.xlxp.compiler.impl.SchemaSymbol;
import com.ibm.xml.xlxp.compiler.impl.WildcardAnyImpl;
import com.ibm.xml.xlxp.compiler.impl.WildcardLaxImpl;
import com.ibm.xml.xlxp.compiler.impl.WildcardListImpl;
import com.ibm.xml.xlxp.compiler.impl.WildcardNs;
import com.ibm.xml.xlxp.compiler.impl.WildcardProcess;
import com.ibm.xml.xlxp.compiler.impl.WildcardSkipImpl;
import com.ibm.xml.xlxp.compiler.impl.WildcardStrictImpl;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSWildcard;

public abstract class WildcardImpl
extends NonterminalSymbolImpl
implements SchemaSymbol {
    private static final WildcardProcess LAX = new WildcardLaxImpl();
    private static final WildcardProcess SKIP = new WildcardSkipImpl();
    private static final WildcardProcess STRICT = new WildcardStrictImpl();
    private final XSObject fSchemaObject;
    protected final WildcardNs fNs;
    protected final WildcardProcess fProcess;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected WildcardImpl(XSWildcard xSWildcard, Grammar grammar) {
        super(grammar.symbolTable());
        this.fNs = this.createNsConstraint(xSWildcard, grammar);
        this.fProcess = this.createProcessConstraint(xSWildcard);
        this.fSchemaObject = xSWildcard;
    }

    protected WildcardImpl(Grammar grammar) {
        super(grammar.symbolTable());
        this.fNs = new WildcardAnyImpl();
        this.fProcess = STRICT;
        this.fSchemaObject = null;
    }

    public XSObject schemaObject() {
        return this.fSchemaObject;
    }

    private WildcardNs createNsConstraint(XSWildcard xSWildcard, Grammar grammar) {
        short s = xSWildcard.getConstraintType();
        if (s == 1) {
            return new WildcardAnyImpl();
        }
        StringList stringList = xSWildcard.getNsConstraintList();
        return new WildcardListImpl(stringList, s == 3, grammar);
    }

    private WildcardProcess createProcessConstraint(XSWildcard xSWildcard) {
        short s = xSWildcard.getProcessContents();
        if (s == 3) {
            return LAX;
        }
        if (s == 2) {
            return SKIP;
        }
        return STRICT;
    }
}

