/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.compiler.impl.CodeGenerator;
import com.ibm.xml.xlxp.compiler.impl.Element;
import com.ibm.xml.xlxp.compiler.impl.GeneratorInfo;
import com.ibm.xml.xlxp.compiler.impl.Label;
import com.ibm.xml.xlxp.compiler.impl.TypeSymbol;
import com.ibm.xml.xlxp.compiler.impl.WildcardElement;
import com.ibm.xml.xlxp.compiler.impl.idc.IDCGeneratorInfo;
import java.util.List;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSWildcard;

public class GeneratorInfoImpl
implements GeneratorInfo {
    private final Label[] fLabels;
    private final List fExtensionInstructions;
    private final List fExtensionNilInstructions;
    private final Element fElement;
    private final XSComplexTypeDefinition fType;
    private final XSWildcard fWildcard;
    private final IDCGeneratorInfo fIDCGeneratorInfo;
    private final boolean hasIDCActions;
    private final boolean hasNilIDCActions;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public GeneratorInfoImpl(Element element2, boolean bl, boolean bl2, WildcardElement wildcardElement, TypeSymbol typeSymbol, CodeGenerator codeGenerator) {
        this.fIDCGeneratorInfo = element2.idcGeneratorInfo();
        this.hasIDCActions = this.fIDCGeneratorInfo == null ? false : this.fIDCGeneratorInfo.hasActions(false);
        this.hasNilIDCActions = this.fIDCGeneratorInfo == null ? false : this.fIDCGeneratorInfo.hasActions(true);
        this.fElement = element2;
        this.fType = typeSymbol != null ? (XSComplexTypeDefinition)typeSymbol.schemaObject() : null;
        this.fWildcard = wildcardElement != null ? (XSWildcard)wildcardElement.schemaObject() : null;
        XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)element2.schemaObject();
        this.fExtensionInstructions = codeGenerator.createStartElementInstructions(xSElementDeclaration, false, this.fWildcard, this.fType);
        this.fExtensionNilInstructions = bl ? codeGenerator.createStartElementInstructions(xSElementDeclaration, true, this.fWildcard, this.fType) : null;
        this.fLabels = codeGenerator.createLabels(bl, bl2, this.fExtensionInstructions != null || this.hasIDCActions, this.fExtensionNilInstructions != null || this.hasNilIDCActions);
    }

    public Label[] labels() {
        return this.fLabels;
    }

    public void generateInlineInstructions(CodeGenerator codeGenerator, Label label, boolean bl) {
        if (!bl && label == null) {
            throw new CompilerError();
        }
        codeGenerator.generateLabel(this.fLabels[0]);
        this.fElement.generateInlineInstructions(codeGenerator);
        Label label2 = this.fLabels[1];
        Label label3 = this.fLabels[2];
        Label label4 = this.fLabels[3];
        Label label5 = this.fLabels[4];
        Label label6 = this.fLabels[5];
        boolean bl2 = label2 == null && label3 == null && label4 == null && label5 == null && label6 == null;
        this.returnOrGoto(codeGenerator, label, bl2, bl, false);
        if (label5 != null) {
            codeGenerator.generateLabel(label5);
            if (this.hasIDCActions) {
                this.fIDCGeneratorInfo.generateStartIDCInstruction(codeGenerator, false);
            }
            if (this.fExtensionInstructions != null) {
                codeGenerator.genStartElementInstruction(this.fExtensionInstructions);
            }
            codeGenerator.returnFromSubroutine();
        }
        if (label6 != null) {
            codeGenerator.generateLabel(label6);
            if (this.hasNilIDCActions) {
                this.fIDCGeneratorInfo.generateStartIDCInstruction(codeGenerator, true);
            }
            if (this.fExtensionNilInstructions != null) {
                codeGenerator.genStartElementInstruction(this.fExtensionNilInstructions);
            }
            codeGenerator.returnFromSubroutine();
        }
        if (label2 != null) {
            codeGenerator.generateLabel(label2);
            this.fElement.generateInlineNilInstructions(codeGenerator);
            codeGenerator.readEndOfParent(1);
            bl2 = label3 == null && label4 == null;
            this.returnOrGoto(codeGenerator, label, bl2, bl, true);
        }
        if (label3 != null) {
            codeGenerator.generateLabel(label3);
            this.fElement.generateInlineEmptyTagInstructions(codeGenerator);
            bl2 = label4 == null;
            this.returnOrGoto(codeGenerator, label, bl2, bl, false);
        }
        if (label4 != null) {
            codeGenerator.generateLabel(label4);
            this.fElement.generateInlineNilAndEmptyTagInstructions(codeGenerator);
            this.returnOrGoto(codeGenerator, label, true, bl, false);
        }
    }

    private void returnOrGoto(CodeGenerator codeGenerator, Label label, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            if (this.hasNilIDCActions) {
                this.fIDCGeneratorInfo.generateEndIDCInstruction(codeGenerator);
            }
        } else if (this.hasIDCActions) {
            this.fIDCGeneratorInfo.generateEndIDCInstruction(codeGenerator);
        }
        XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)this.fElement.schemaObject();
        codeGenerator.endElementInstruction(xSElementDeclaration, bl3, this.fWildcard, this.fType);
        if (!bl) {
            this.returnOrGoto(codeGenerator, label);
            return;
        }
        if (bl2) {
            this.returnOrGoto(codeGenerator, label);
        }
    }

    private void returnOrGoto(CodeGenerator codeGenerator, Label label) {
        if (label != null) {
            codeGenerator.gotoLabel(label);
            return;
        }
        codeGenerator.returnFromSubroutine();
    }
}

