/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl;

import com.ibm.xml.xlxp.compiler.impl.CodeGenerator;
import com.ibm.xml.xlxp.compiler.impl.CompilerImpl;
import com.ibm.xml.xlxp.compiler.impl.ContentModelChoice;
import com.ibm.xml.xlxp.compiler.impl.ContentModelLookupTableImpl;
import com.ibm.xml.xlxp.compiler.impl.SimpleTypeSymbol;
import com.ibm.xml.xlxp.compiler.impl.SymbolTable;
import com.ibm.xml.xlxp.compiler.impl.TypeSymbol;
import com.ibm.xml.xlxp.compiler.tables.Table;
import com.ibm.xml.xlxp.compiler.tables.TableId;
import com.ibm.xml.xlxp.util.SymbolImpl;
import java.util.Iterator;
import java.util.Set;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class ContentModelChoiceImpl
extends SymbolImpl
implements ContentModelChoice {
    protected final TypeSymbol fTypeSym;
    protected final XSTypeDefinition fXSType;
    protected final Set[] fDerived = new Set[4];
    protected final Table[] fTables = new Table[4];
    protected final boolean[] fUsed = new boolean[4];
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ContentModelChoiceImpl(TypeSymbol typeSymbol, SimpleTypeSymbol[] simpleTypeSymbolArray, SymbolTable symbolTable) {
        super(symbolTable);
        this.fTypeSym = typeSymbol;
        this.fXSType = (XSTypeDefinition)typeSymbol.schemaObject();
        this.fDerived[0] = CompilerImpl.newSet();
        if (typeSymbol.canBeReferenced()) {
            this.fDerived[0].add(typeSymbol);
        }
        short s = 0;
        XSComplexTypeDefinition xSComplexTypeDefinition = null;
        if (this.fXSType.getTypeCategory() == 15) {
            xSComplexTypeDefinition = (XSComplexTypeDefinition)this.fXSType;
            s = xSComplexTypeDefinition.getProhibitedSubstitutions();
        }
        if (s != 0) {
            this.addTypes(typeSymbol.derivedByRestriction().iterator(), s, this.fDerived[0]);
            this.addTypes(typeSymbol.derivedByExtension().iterator(), s, this.fDerived[0]);
        } else {
            this.addTypes(typeSymbol.derivedByRestriction().iterator());
            this.addTypes(typeSymbol.derivedByExtension().iterator());
        }
        if (simpleTypeSymbolArray == null || (s & 2) != 0) {
            return;
        }
        int n2 = 0;
        while (n2 < simpleTypeSymbolArray.length) {
            SimpleTypeSymbol simpleTypeSymbol = simpleTypeSymbolArray[n2];
            if (simpleTypeSymbol.canBeReferenced()) {
                this.fDerived[0].add(simpleTypeSymbol);
            }
            this.addTypes(simpleTypeSymbol.derivedByRestriction().iterator());
            this.addTypes(simpleTypeSymbol.derivedByExtension().iterator());
            ++n2;
        }
    }

    private void addTypes(Iterator iterator) {
        while (iterator.hasNext()) {
            TypeSymbol typeSymbol = (TypeSymbol)iterator.next();
            if (!typeSymbol.canBeReferenced()) continue;
            this.fDerived[0].add(typeSymbol);
        }
    }

    private void addTypes(Iterator iterator, short s, Set set2) {
        while (iterator.hasNext()) {
            TypeSymbol typeSymbol = (TypeSymbol)iterator.next();
            if (!typeSymbol.canBeReferenced()) continue;
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)typeSymbol.schemaObject();
            while (xSTypeDefinition != this.fXSType) {
                if (xSTypeDefinition.getTypeCategory() == 16) {
                    if ((s & 2) != 0) break;
                    xSTypeDefinition = this.fXSType;
                    break;
                }
                if ((((XSComplexTypeDefinition)xSTypeDefinition).getDerivationMethod() & s) != 0) break;
                xSTypeDefinition = xSTypeDefinition.getBaseType();
            }
            if (xSTypeDefinition != this.fXSType) continue;
            set2.add(typeSymbol);
        }
    }

    public void handleSimpleType(CodeGenerator codeGenerator) {
        codeGenerator.comment("scan simple type based on xsitype value");
    }

    public Iterator subTypes(short s) {
        if (s == 0) {
            return this.fDerived[0].iterator();
        }
        int n2 = s == 1 ? 1 : (s == 2 ? 2 : 3);
        if (this.fDerived[n2] != null) {
            return this.fDerived[n2].iterator();
        }
        this.fDerived[n2] = CompilerImpl.newSet();
        this.addTypes(this.fDerived[0].iterator(), s, this.fDerived[n2]);
        return this.fDerived[n2].iterator();
    }

    public TableId xsiTypes(short s, CodeGenerator codeGenerator) {
        if (s == 0) {
            if (!this.fUsed[0]) {
                this.fUsed[0] = true;
                if (this.fDerived[0].size() > 0) {
                    this.fTables[0] = new ContentModelLookupTableImpl(this.fDerived[0], codeGenerator);
                    codeGenerator.addTable(this.fTables[0]);
                }
            }
            return this.fTables[0] == null ? null : this.fTables[0].tableId();
        }
        int n2 = s == 1 ? 1 : (s == 2 ? 2 : 3);
        if (!this.fUsed[n2]) {
            if (this.fDerived[n2] == null) {
                this.fDerived[n2] = CompilerImpl.newSet();
                this.addTypes(this.fDerived[0].iterator(), s, this.fDerived[n2]);
            }
            this.fUsed[n2] = true;
            if (this.fDerived[0].size() > 0) {
                this.fTables[n2] = new ContentModelLookupTableImpl(this.fDerived[n2], codeGenerator);
                codeGenerator.addTable(this.fTables[n2]);
            }
        }
        return this.fTables[n2] == null ? null : this.fTables[n2].tableId();
    }
}

