/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.compiler.IRGenerator;
import com.ibm.xml.xlxp.compiler.impl.BuildableCompilationUnit;
import com.ibm.xml.xlxp.compiler.impl.Instruction;
import com.ibm.xml.xlxp.compiler.impl.InstructionOrData;
import com.ibm.xml.xlxp.compiler.impl.Label;
import com.ibm.xml.xlxp.compiler.impl.ir.InstructionLabel;
import com.ibm.xml.xlxp.compiler.tables.ExtensionsTable;
import com.ibm.xml.xlxp.compiler.tables.NamespacesTable;
import com.ibm.xml.xlxp.compiler.tables.SimpleTypeTable;
import com.ibm.xml.xlxp.compiler.tables.Table;
import com.ibm.xml.xlxp.compiler.tables.TypeTable;
import com.ibm.xml.xlxp.compiler.tables.XPathDFATable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CompilationUnitImpl
implements BuildableCompilationUnit {
    private ArrayList fInstructionStream = new ArrayList(4096);
    private Instruction[] fOptimisedInstructionStream = null;
    private final List fTableStream = new ArrayList(128);
    private NamespacesTable fNamespaces = null;
    private ExtensionsTable fExtensions = null;
    private TypeTable fTypeTable = null;
    private SimpleTypeTable fSimpleTypeTable = null;
    private XPathDFATable fXPathDFATable = null;
    private int fNumberOfReferableTypes = -1;
    private int fNumberOfUnreferableTypes = -1;
    private final String fParserVersion;
    private final String fParserSettings;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CompilationUnitImpl(String string2, String string3) {
        this.fParserVersion = string2 != null ? string2 : "";
        this.fParserSettings = string3 != null ? string3 : "";
    }

    public String getParserVersionString() {
        return this.fParserVersion;
    }

    public String getParserSettingsString() {
        return this.fParserSettings;
    }

    public NamespacesTable namespaces() {
        return this.fNamespaces;
    }

    public ExtensionsTable extensions() {
        return this.fExtensions;
    }

    public TypeTable typeTable() {
        return this.fTypeTable;
    }

    public SimpleTypeTable simpleTypeTable() {
        return this.fSimpleTypeTable;
    }

    public XPathDFATable xpathDFATable() {
        return this.fXPathDFATable;
    }

    public int numberOfReferableTypes() {
        return this.fNumberOfReferableTypes;
    }

    public int numberOfUnreferableTypes() {
        return this.fNumberOfUnreferableTypes;
    }

    public void generateInstructionStream(IRGenerator iRGenerator) throws Exception {
        int n2 = 0;
        while (n2 < this.fOptimisedInstructionStream.length) {
            this.fOptimisedInstructionStream[n2].generate(iRGenerator);
            ++n2;
        }
    }

    public void generateTableStream(IRGenerator iRGenerator) throws Exception {
        Iterator iterator = this.fTableStream.iterator();
        while (iterator.hasNext()) {
            InstructionOrData instructionOrData = (InstructionOrData)iterator.next();
            instructionOrData.generate(iRGenerator);
        }
    }

    public void addInstruction(Instruction instruction2) {
        this.fInstructionStream.add(instruction2);
    }

    public void addTable(Table table2) {
        this.fTableStream.add(table2);
    }

    public void setNamespaces(NamespacesTable namespacesTable) {
        this.fNamespaces = namespacesTable;
    }

    public void setExtensions(ExtensionsTable extensionsTable) {
        this.fExtensions = extensionsTable;
    }

    public void setTypeTable(TypeTable typeTable) {
        this.fTypeTable = typeTable;
    }

    public void setSimpleTypeTable(SimpleTypeTable simpleTypeTable) {
        this.fSimpleTypeTable = simpleTypeTable;
    }

    public void setNumberOfReferableTypes(int n2) {
        this.fNumberOfReferableTypes = n2;
    }

    public void setNumberOfUnreferableTypes(int n2) {
        this.fNumberOfUnreferableTypes = n2;
    }

    public void setXPathDFATable(XPathDFATable xPathDFATable) {
        this.fXPathDFATable = xPathDFATable;
    }

    public void addInstructions(List list) {
        this.fInstructionStream.addAll(list);
    }

    public void optimise() {
        Instruction instruction2;
        Instruction instruction3;
        Object object2;
        Object object3;
        int n2 = this.fInstructionStream.size();
        boolean bl = true;
        InstructionLabel instructionLabel = null;
        int n3 = 0;
        while (n3 < n2) {
            object3 = (Instruction)this.fInstructionStream.get(n3);
            object2 = object3.label();
            if (object2 != null) {
                instruction3 = (InstructionLabel)object3;
                if (instructionLabel != null) {
                    instructionLabel.redirectTo((Label)object2);
                    this.fInstructionStream.set(n3 - 1, null);
                }
                if (bl) {
                    ((InstructionLabel)instruction3).setReachedByCodeFlow();
                }
                instructionLabel = instruction3;
            } else {
                if (instructionLabel != null) {
                    object3.setPreviousLabel(instructionLabel);
                }
                instructionLabel = null;
                bl = object3.codeFlowsThrough(bl);
            }
            ++n3;
        }
        object3 = null;
        n3 = 0;
        while (n3 < n2) {
            object2 = (Instruction)this.fInstructionStream.get(n3);
            if (object2 != null && object2.label() != null && ((InstructionLabel)(instruction3 = (InstructionLabel)object2)).nextIsReturn()) {
                if (object3 == null) {
                    object3 = ((InstructionLabel)instruction3).label();
                } else {
                    ((InstructionLabel)instruction3).redirectTo((Label)object3);
                    if (!((InstructionLabel)instruction3).reachedByCodeFlow()) {
                        this.fInstructionStream.set(n3, null);
                        this.fInstructionStream.set(n3 + 1, null);
                    }
                }
            }
            ++n3;
        }
        boolean bl2 = false;
        while (!bl2) {
            bl2 = true;
            n3 = 0;
            while (n3 < n2) {
                Label label;
                instruction3 = (Instruction)this.fInstructionStream.get(n3);
                if (instruction3 != null && (label = instruction3.labelGotoPairTarget()) != null) {
                    instruction2 = (InstructionLabel)instruction3;
                    instruction2.redirectTo(label);
                    if (!instruction2.reachedByCodeFlow()) {
                        this.fInstructionStream.set(n3, null);
                        this.fInstructionStream.set(n3 + 1, null);
                    }
                    bl2 = false;
                }
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < n2) {
            instruction3 = (Instruction)this.fInstructionStream.get(n3);
            if (instruction3 != null && instruction3.isGoto()) {
                int n4 = n3 + 1;
                instruction2 = null;
                while (n4 < n2 && instruction2 == null) {
                    instruction2 = (Instruction)this.fInstructionStream.get(n4++);
                }
                if (instruction2 != null && instruction3.gotoLabelPair(instruction2)) {
                    this.fInstructionStream.set(n3, null);
                }
            }
            ++n3;
        }
        int n5 = 0;
        n3 = 0;
        while (n3 < n2) {
            if (this.fInstructionStream.get(n3) != null) {
                ++n5;
            }
            ++n3;
        }
        this.fOptimisedInstructionStream = new Instruction[n5];
        n3 = 0;
        int n6 = 0;
        while (n6 < n5) {
            this.fOptimisedInstructionStream[n6] = (Instruction)this.fInstructionStream.get(n3++);
            if (this.fOptimisedInstructionStream[n6] == null) continue;
            ++n6;
        }
        this.fInstructionStream = null;
    }

    public List getInstructionStream() {
        throw new CompilerError();
    }
}

