/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.compiler.impl.Attributes;
import com.ibm.xml.xlxp.compiler.impl.CodeGenerator;
import com.ibm.xml.xlxp.compiler.impl.Grammar;
import com.ibm.xml.xlxp.compiler.impl.OwnedAttributes;
import com.ibm.xml.xlxp.compiler.impl.OwnedAttributesImpl;
import com.ibm.xml.xlxp.compiler.impl.TypeSpecificAttributeTableImpl;
import com.ibm.xml.xlxp.compiler.impl.TypeSymbol;
import com.ibm.xml.xlxp.compiler.impl.WildcardAttribute;
import com.ibm.xml.xlxp.compiler.impl.WildcardAttributeImpl;
import com.ibm.xml.xlxp.compiler.tables.AttributeTable;
import com.ibm.xml.xlxp.compiler.tables.NameGroup;
import com.ibm.xml.xlxp.compiler.tables.TableId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSWildcard;

public class AttributesImpl
implements Attributes {
    protected final TypeSymbol fOwner;
    protected final OwnedAttributes fOwnedAttributes;
    protected AttributeTable fOwnedAttributesTable = null;
    protected final boolean fOwnerIsAnonymous;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public AttributesImpl(TypeSymbol typeSymbol) {
        this(null, null, typeSymbol);
    }

    public AttributesImpl(XSObjectList xSObjectList, XSWildcard xSWildcard, TypeSymbol typeSymbol, Grammar grammar) {
        this(xSObjectList, xSWildcard == null ? null : new WildcardAttributeImpl(xSWildcard, grammar), typeSymbol);
    }

    protected AttributesImpl(XSObjectList xSObjectList, WildcardAttribute wildcardAttribute, TypeSymbol typeSymbol) {
        this.fOwnedAttributes = new OwnedAttributesImpl(xSObjectList, wildcardAttribute);
        this.fOwner = typeSymbol;
        this.fOwnerIsAnonymous = this.fOwner.xsiTypeName().length() == 0;
    }

    public String ownerTypeXsiValue() {
        return this.fOwner.xsiValue();
    }

    public int ownerTypeNamespace(Grammar grammar) {
        return this.fOwner.namespaceId(grammar);
    }

    public void createAttributeTables(CodeGenerator codeGenerator) {
        Grammar grammar = codeGenerator.grammar();
        if (!this.fOwnedAttributes.isEmpty()) {
            this.fOwnedAttributesTable = new TypeSpecificAttributeTableImpl(codeGenerator, grammar, this.fOwnedAttributes);
            codeGenerator.addTable(this.fOwnedAttributesTable);
        } else {
            this.fOwnedAttributesTable = codeGenerator.ownedXsiAttributeTable(false);
        }
    }

    public OwnedAttributes ownedAttributes() {
        return this.fOwnedAttributes;
    }

    public TableId ownedAttributesTable() {
        return this.fOwnedAttributesTable.tableId();
    }

    public List extensionAttributeList() {
        if (this.fOwner.isAbstract()) {
            throw new CompilerError();
        }
        int n2 = this.fOwnedAttributesTable.numberOfEntries();
        ArrayList arrayList = new ArrayList(n2);
        Iterator iterator = this.fOwnedAttributesTable.infoByNcname().iterator();
        while (iterator.hasNext()) {
            NameGroup nameGroup = (NameGroup)iterator.next();
            Iterator iterator2 = nameGroup.list().iterator();
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
        }
        return arrayList;
    }
}

